/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsext.PcBinding;
import com.ibm.etools.webservice.wsext.ServerServiceConfig;
import com.ibm.etools.webservice.wsext.WsDescExt;
import com.ibm.etools.webservice.wsext.WsExtension;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.BindingChoicesHelper;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.deploy.GetServerNameTask;
import com.ibm.ws.webservices.deploy.MapModulesToServersAccessor;
import com.ibm.ws.webservices.deploy.PortComponentInfo;
import com.ibm.ws.webservices.deploy.WSBindingsFileAccessor;
import com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor;
import com.ibm.ws.webservices.utils.PortInfo;
import com.ibm.ws.webservices.utils.WSDLParser;
import com.ibm.wsspi.webservices.models.WSModels;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class GetServerNameHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(GetServerNameHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask: taskName=" + taskName);
        }
        try {
            return new GetServerNameTask(appController);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.GetServerNameHelper.createTask", "76", this);
            Tr.error(tc, "WSWS0020E", ex);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createTask: Error instantiating task", ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask task) throws AppDeploymentException {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        task.setIsTaskDisabled(true);
        if (task.getTaskData() != null) {
            return;
        }
        Vector<String> dataForTwoDimensionalArray = new Vector<String>();
        String[] columnNames = task.getColumnNames();
        for (i = 0; i < columnNames.length; ++i) {
            dataForTwoDimensionalArray.addElement(columnNames[i]);
        }
        for (i = 0; i < columnNames.length; ++i) {
            dataForTwoDimensionalArray.addElement("");
        }
        String[][] newTaskData = util.buildTaskData(dataForTwoDimensionalArray, columnNames.length);
        task.setTaskData(newTaskData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask:\n" + DeployUtils.taskDataToString(task.getTaskData()));
        }
    }

    public void completeTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask task) throws AppDeploymentException {
        long mode;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if ((mode = task.getAppDeploymentController().getDeploymentMode()) == 65536L || mode == 0x100000L || mode == 0x2000000L || mode == 0x1000000L) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "completeTask: skipping validation for EJB and router module on the client side");
            }
        } else {
            MapModulesToServersAccessor accessor = new MapModulesToServersAccessor(task.getAppDeploymentController());
            accessor.verifyThatAnEJBJARAndItsRouterAreInTheSameServer(appDeploymentInfo, task);
            boolean isWsSecurityEnabled = false;
            Vector ejbJars = appDeploymentInfo.getModuleConfig("JAR_DD");
            Vector wars = appDeploymentInfo.getModuleConfig("WAR_DD");
            Vector combined = new Vector();
            combined.addAll(ejbJars);
            combined.addAll(wars);
            Iterator iter = combined.iterator();
            while (iter.hasNext()) {
                WSDeploymentDescriptorAccessor ddAccessor;
                EObject refObject = (EObject)iter.next();
                HashSet<String> uniqueDirsContainingWSDLFiles = new HashSet<String>();
                String moduleURI = util.formUriString(appDeploymentInfo, refObject);
                String[] pieces = util.separateUriString(moduleURI);
                String moduleName = pieces[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "completeTask: working on module " + moduleURI);
                }
                if ((ddAccessor = new WSDeploymentDescriptorAccessor(refObject, appDeploymentInfo, task)).isModuleWebServiceEnabled(task)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "completeTask: module " + moduleURI + " is Web Service enabled");
                    }
                    String targetModuleName = null;
                    targetModuleName = refObject instanceof WebApp ? moduleName : this.getNameOfRouterWarForEJBModule(appDeploymentInfo, task, wars, refObject);
                    ModuleFile moduleFile = appDeploymentInfo.getModuleFileForDD(refObject);
                    String tmpDirForModule = DeployUtils.createWorkingDirectory(task);
                    BindingChoicesHelper.extractModulesFilesToTmpDir(task, moduleURI, moduleFile, tmpDirForModule);
                    String[] webserviceDescriptionNames = ddAccessor.getWebserviceDescriptionNames();
                    HashMap<String, String> unconnectedPorts = new HashMap<String, String>();
                    HashSet<String> wsdlFiles = new HashSet<String>();
                    if (!isWsSecurityEnabled) {
                        isWsSecurityEnabled = this.checkWsSecurityEnabled(moduleFile, refObject);
                    }
                    boolean foundOneConnPort = false;
                    for (int i = 0; i < webserviceDescriptionNames.length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "completeTask: working on " + moduleName + "'s webserviceDescriptionName " + webserviceDescriptionNames[i]);
                        }
                        String nameOfInputWSDLFile = ddAccessor.getWsdlFileForWebserviceDescriptionName(webserviceDescriptionNames[i]);
                        BindingChoicesHelper.verifyThatWebServicesDescriptionWsdlFileActuallyExistsInModule(task, moduleURI, moduleFile, nameOfInputWSDLFile);
                        WSDLParser theWSDLParser = this.openWSDLParserForWSDLFile(task, moduleURI, tmpDirForModule, nameOfInputWSDLFile);
                        PortComponentInfo[] portComponents = ddAccessor.getPortComponentDataForWebserviceDescriptionElement(webserviceDescriptionNames[i]);
                        if (!wsdlFiles.contains(nameOfInputWSDLFile)) {
                            Vector ports = theWSDLParser.getPortInfos();
                            for (int m = 0; m < ports.size(); ++m) {
                                unconnectedPorts.put(((PortInfo)ports.get((int)m)).port.getName(), nameOfInputWSDLFile);
                            }
                        }
                        wsdlFiles.add(nameOfInputWSDLFile);
                        for (int j = 0; j < portComponents.length; ++j) {
                            PortComponentInfo portComponentInfo = portComponents[j];
                            boolean bl = foundOneConnPort = unconnectedPorts.remove(portComponentInfo.getPortQnameLocalname()) != null || foundOneConnPort;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "completeTask: working on " + moduleName + "." + webserviceDescriptionNames[i] + "'s " + portComponentInfo);
                            }
                            String wsdlNamespace = portComponentInfo.getPortQnameNamespace();
                            String wsdlPortName = portComponentInfo.getPortQnameLocalname();
                            boolean portExists = false;
                            portExists = theWSDLParser.portExists(wsdlNamespace, wsdlPortName);
                            if (portExists) continue;
                            Object[] fillins = new Object[]{moduleURI, nameOfInputWSDLFile, wsdlNamespace, wsdlPortName};
                            String message = MessageFormat.format(util.getMessage(task, "WSWS0007E"), fillins);
                            Tr.error(tc, "WSWS0007E", fillins);
                            throw new AppDeploymentException(message, null);
                        }
                        String oneDotOneDir = null;
                        oneDotOneDir = refObject instanceof WebApp ? "WEB-INF/wsdl" : "META-INF/wsdl";
                        if (nameOfInputWSDLFile.startsWith(oneDotOneDir)) continue;
                        String dirName = tmpDirForModule + File.separator + nameOfInputWSDLFile.replace('/', File.separatorChar);
                        String dir = new File(dirName).getParent();
                        uniqueDirsContainingWSDLFiles.add(dir);
                        Object[] fillins = new Object[]{moduleName, nameOfInputWSDLFile};
                        String message = MessageFormat.format(util.getMessage(task, "WSWS0037W"), fillins);
                        Tr.warning(tc, message);
                    }
                    if (unconnectedPorts.size() > 0) {
                        Iterator it = unconnectedPorts.keySet().iterator();
                        while (it.hasNext()) {
                            String portName = (String)it.next();
                            String wsdlFileName = (String)unconnectedPorts.get(portName);
                            Object[] fillins = new Object[]{moduleName, wsdlFileName, portName};
                            if (foundOneConnPort) {
                                String msg = MessageFormat.format(util.getMessage(task, "WSWS0060W"), fillins);
                                Tr.warning(tc, msg);
                                continue;
                            }
                            String message = MessageFormat.format(util.getMessage(task, "WSWS0034E"), fillins);
                            Tr.error(tc, message);
                            throw new AppDeploymentException(message, null);
                        }
                    }
                    String targetDir = refObject instanceof WebApp ? "WEB-INF/wsdl" : "META-INF/wsdl";
                    Iterator i = uniqueDirsContainingWSDLFiles.iterator();
                    while (i.hasNext()) {
                        String sourceDir = (String)i.next();
                        this.copyColocatedWsdlFilesToModule(moduleName, sourceDir, targetDir, task);
                    }
                    if (!(refObject instanceof WebApp)) {
                        String platformSourceDir = tmpDirForModule + File.separator + "META-INF/wsdl".replace('/', File.separatorChar);
                        this.deepCopyDirToModule(platformSourceDir, "WEB-INF/wsdl", targetModuleName, task);
                    }
                    DeployUtils.deleteWorkingDirectory(tmpDirForModule);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "completeTask: module " + moduleURI + "is Web NOT Service enabled");
            }
        }
    }

    private WSDLParser openWSDLParserForWSDLFile(AppDeploymentTask task, String moduleURI, String tmpDirForModule, String nameOfInputWSDLFile) throws AppDeploymentException {
        int lastBackSlash;
        String contextURI = "file:" + tmpDirForModule + "/";
        WSDLParser theWSDLParser = null;
        int lastForwardSlash = nameOfInputWSDLFile.lastIndexOf(47);
        int lastSlash = lastForwardSlash > (lastBackSlash = nameOfInputWSDLFile.lastIndexOf(92)) ? lastForwardSlash : lastBackSlash;
        String m_contextURI = contextURI;
        String m_nameOfInputWSDLFile = nameOfInputWSDLFile;
        if (lastSlash >= 0 && nameOfInputWSDLFile.length() > lastSlash) {
            String prefix = nameOfInputWSDLFile.substring(0, lastSlash + 1);
            m_nameOfInputWSDLFile = nameOfInputWSDLFile.substring(lastSlash + 1);
            m_contextURI = contextURI + prefix;
        }
        try {
            theWSDLParser = new WSDLParser(m_contextURI, m_nameOfInputWSDLFile);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.GetServerNameHelper.completeTask", "499", this);
            Object[] fillins = new Object[]{nameOfInputWSDLFile, moduleURI, ex};
            String message = MessageFormat.format(util.getMessage(task, "WSWS0006E"), fillins);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "openWSDLParserForWSDLFile: " + message, ex);
            }
            Tr.error(tc, "WSWS0006E", fillins);
            throw new AppDeploymentException(message.toString(), ex);
        }
        return theWSDLParser;
    }

    private String getNameOfRouterWarForEJBModule(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask task, Vector wars, EObject refObject) throws AppDeploymentException {
        String moduleURI = util.formUriString(appDeploymentInfo, refObject);
        String[] pieces = util.separateUriString(moduleURI);
        String EJBmoduleName = pieces[0];
        String warModuleName = null;
        WebApp routerModuleForThisEJB = null;
        String nameOfRouterModuleForThisEJB = null;
        String targetModuleName = null;
        ModuleFile mfile = appDeploymentInfo.getModuleFileForDD(refObject);
        WSBindingsFileAccessor bindingAccessor = new WSBindingsFileAccessor(mfile, task);
        String[] routerModuleNames = bindingAccessor.getRouterModuleNames();
        warModuleName = routerModuleNames[0];
        if (warModuleName != null) {
            Iterator iterator = wars.iterator();
            while (iterator.hasNext()) {
                WebApp element = (WebApp)iterator.next();
                String uri = util.formUriString(appDeploymentInfo, element);
                String[] elements = util.separateUriString(uri);
                String nameOfMoudleBeingTested = elements[0];
                if (!nameOfMoudleBeingTested.equals(warModuleName)) continue;
                routerModuleForThisEJB = element;
                break;
            }
            if (routerModuleForThisEJB == null) {
                Object[] fillins = new Object[]{EJBmoduleName, warModuleName};
                String message = MessageFormat.format(util.getMessage(task, "WSWS0035E"), fillins);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getNameOfRouterWarForEJBModule :getEBJRouterModuleName: " + message);
                }
                Tr.error(tc, "WSWS0035E", fillins);
                throw new AppDeploymentException(message, null);
            }
            String uri = util.formUriString(appDeploymentInfo, routerModuleForThisEJB);
            String[] parts = util.separateUriString(uri);
            targetModuleName = parts[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getNameOfRouterWarForEJBModule: for EJB module " + EJBmoduleName + " the router WAR is " + nameOfRouterModuleForThisEJB);
            }
            return targetModuleName;
        }
        return null;
    }

    private void copyFileToModule(File fileToBeCopied, String targetModuleName, String pathInTargetModule, AppDeploymentTask task) throws AppDeploymentException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copyFileToModule: fileToBecopie=" + fileToBeCopied + " targetModuleName=" + targetModuleName + " pathInTargetModule=" + pathInTargetModule);
        }
        FileInputStream iStream = null;
        try {
            iStream = new FileInputStream(fileToBeCopied);
        }
        catch (FileNotFoundException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.GetServerNameHelper.completeTask", "706", this);
            Object[] fillins = new Object[]{fileToBeCopied, ex};
            String message = MessageFormat.format(util.getMessage(task, "WSWS0015E"), fillins);
            Tr.error(tc, "WSWS0015E", fillins);
            throw new AppDeploymentException(message, ex);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "completeTask: about to save the wsdl file \"" + pathInTargetModule + "\" into module " + targetModuleName);
        }
        task.getAppDeploymentController().saveAsFile(targetModuleName, pathInTargetModule, iStream);
        try {
            iStream.close();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.deploy.GetServerNameHelper.completeTask", "738", this);
            Tr.warning(tc, "WSWS0028W", iStream);
        }
    }

    private void copyColocatedWsdlFilesToModule(String targetModuleName, String sourceDir, String targetDir, AppDeploymentTask task) throws AppDeploymentException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copyColocatedWSDLFilesToModule:  targetModuleName=" + targetModuleName + " sourceDir=" + sourceDir + " targetDir=" + targetDir);
        }
        File[] filesToBeCopied = new File(sourceDir).listFiles(new WsdlXsdFilter());
        for (int i = 0; i < filesToBeCopied.length; ++i) {
            String pathInTargetModule = targetDir + "/" + filesToBeCopied[i].getName();
            this.copyFileToModule(filesToBeCopied[i], targetModuleName, pathInTargetModule, task);
        }
    }

    private void deepCopyDirToModule(String sourceDir, String targetDir, String targetModule, AppDeploymentTask task) throws AppDeploymentException {
        File sourceFile;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deepCopyDirToModule:  sourceDir=" + sourceDir + " targetDir=" + targetDir + " targetModule=" + targetModule);
        }
        if (!(sourceFile = new File(sourceDir)).exists()) {
            return;
        }
        File[] contents = sourceFile.listFiles();
        for (int i = 0; i < contents.length; ++i) {
            String pathInTargetModule = targetDir + "/" + contents[i].getName();
            if (contents[i].isFile()) {
                this.copyFileToModule(contents[i], targetModule, pathInTargetModule, task);
            }
            if (!contents[i].isDirectory()) continue;
            this.deepCopyDirToModule(contents[i].getPath(), pathInTargetModule, targetModule, task);
        }
    }

    private WsExtension loadWebServicesExtXML(LoadStrategy loadStrategy, String xmlFilename) {
        if (loadStrategy.getContainer().containsFile(xmlFilename)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing IBM web services XML ext file: " + xmlFilename);
            }
            try {
                return WSModels.getWSExtension(loadStrategy, xmlFilename);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.deploy.GetServerNameHelper.loadWebServicesExtXML", "899");
            }
        }
        return null;
    }

    private boolean checkWsSecurityEnabled(ModuleFile moduleFile, EObject refObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkWsSecurityEnabled()");
        }
        WsExtension wse = null;
        LoadStrategy loadStrategy = null;
        if (moduleFile != null) {
            loadStrategy = moduleFile.getLoadStrategy();
        }
        String wseFilename = null;
        if (refObject != null) {
            wseFilename = refObject instanceof WebApp ? "WEB-INF/ibm-webservices-ext.xmi" : "META-INF/ibm-webservices-ext.xmi";
        }
        if (loadStrategy != null && wseFilename != null) {
            wse = this.loadWebServicesExtXML(loadStrategy, wseFilename);
        }
        boolean wsSecurityEnabled = false;
        EList wsdescext = null;
        if (wse != null) {
            wsdescext = wse.getWsDescExt();
        }
        if (wsdescext != null && !wsdescext.isEmpty()) {
            int size = wsdescext.size();
            block0: for (int i = 0; i < size && !wsSecurityEnabled; ++i) {
                WsDescExt w = (WsDescExt)wsdescext.get(i);
                EList pcbs = w.getPcBinding();
                if (pcbs == null || pcbs.isEmpty()) continue;
                int pcbsNum = pcbs.size();
                for (int j = 0; j < pcbsNum; ++j) {
                    PcBinding pcb = (PcBinding)pcbs.get(j);
                    ServerServiceConfig ssc = pcb.getServerServiceConfig();
                    if (ssc == null) continue;
                    if (ssc.getSecurityRequestReceiverServiceConfig() != null) {
                        wsSecurityEnabled = true;
                        if (!tc.isDebugEnabled()) continue block0;
                        Tr.debug(tc, "SecurityRequestReceiverServiceConfig found, assuming ws-security is enabled");
                        continue block0;
                    }
                    if (ssc.getSecurityResponseSenderServiceConfig() == null) continue;
                    wsSecurityEnabled = true;
                    if (!tc.isDebugEnabled()) continue block0;
                    Tr.debug(tc, "SecurityResponseSenderServiceConfig found, assuming ws-security is enabled");
                    continue block0;
                }
            }
        }
        if (wsSecurityEnabled) {
            TraceComponent tc2 = Tr.register("com.ibm.ws.webservices.deploy.GetServerNameHelper.checkWsSecurityEnabled", "WebServices", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
            Tr.warning(tc2, "security.wssecurity.appinstall.warning");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkWsSecurityEnabled() returns " + wsSecurityEnabled);
        }
        return wsSecurityEnabled;
    }

    private class WsdlXsdFilter
    implements FilenameFilter {
        private WsdlXsdFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".wsdl") || name.endsWith(".WSDL") || name.endsWith(".xsd") || name.endsWith(".XSD");
        }
    }
}

