/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.webservice.wsext.PcBinding;
import com.ibm.etools.webservice.wsext.ServerServiceConfig;
import com.ibm.etools.webservice.wsext.WsDescExt;
import com.ibm.etools.webservice.wsext.WsExtension;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.webcontainer.component.ComponentUtil;
import com.ibm.ws.webservices.client.ModuleWSDLLocator;
import com.ibm.ws.webservices.component.JAXRPCMetaDataHelper;
import com.ibm.ws.webservices.component.JAXRPCMetaDataWrapper;
import com.ibm.ws.webservices.deploy.MetaDataLoader;
import com.ibm.ws.webservices.deploy.MetaDataLoaderFactory;
import com.ibm.ws.webservices.deploy.ModuleData;
import com.ibm.ws.webservices.deploy.PublishWSDLInfo;
import com.ibm.ws.webservices.deploy.WebserviceDescriptionInfo;
import com.ibm.ws.webservices.deployment.WSDLPostProcessorPluginMgr;
import com.ibm.ws.webservices.engine.utils.WSDLUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.exception.WSDLPostProcessingException;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.multiprotocol.extensions.agnostic.AgnosticAddress;
import com.ibm.ws.webservices.multiprotocol.extensions.ejb.EJBBinding;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import com.ibm.wsspi.webservices.models.WSModels;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.FileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.xml.sax.InputSource;

public class DeployUtils {
    public static final int NO_PORTS = 0;
    public static final int SOAP_PORTS_ONLY = 1;
    public static final int NONSOAP_PORTS_ONLY = 2;
    public static final int MIXED_PORTS = 3;
    public static String APPLICATION_MODULE_DATA = "application.module.data";
    private static TraceComponent tc = Tr.register(DeployUtils.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.deploy.resources.deployMessages");
    private static final String WORKING_DIR_PREFIX = "DeployUtilsTmpDir";
    private static final int COPY_BUFFER_SIZE = 1024;
    private static String workspaceId = Long.toString(System.currentTimeMillis());

    public static String taskDataToString(String[][] taskData) {
        StringBuffer returnString = new StringBuffer();
        if (taskData != null) {
            returnString.append("The taskData is:\n");
            for (int i = 0; i < taskData.length; ++i) {
                for (int j = 0; j < taskData[i].length; ++j) {
                    returnString.append("\t[").append(taskData[i][j]).append("]");
                }
                returnString.append("\n");
            }
        } else {
            returnString.append("The taskData is null.\n");
        }
        return returnString.toString();
    }

    public static String createWorkingDirectory(AppDeploymentTask task) throws AppDeploymentException {
        File workingDir = null;
        String workingDirPath = null;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("PublishWSLDHelper", "temp");
            String parent = tmpFile.getParent();
            workingDir = new File(parent, WORKING_DIR_PREFIX + System.currentTimeMillis());
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException ex) {
                FFDCFilter.processException(ex, "com.ibm.ws.webservices.deploy.DeployUtils.createWorkingDirectory", "119");
            }
            workingDir.mkdirs();
            tmpFile.delete();
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.webservices.deploy.DeployUtils.createWorkingDirectory", "126");
            String message = "WSWS0010E: " + ex.getLocalizedMessage();
            if (task != null) {
                message = MessageFormat.format(util.getMessage(task, "WSWS0010E"), ex);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createWorkingDirectory: " + message);
            }
            Tr.error(tc, "WSWS0010E", ex);
            throw new AppDeploymentException(message, ex);
        }
        finally {
            tmpFile.delete();
        }
        workingDirPath = workingDir.getPath();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createWorkingDirectory: created directory " + workingDirPath);
        }
        return workingDirPath;
    }

    public static void deleteWorkingDirectory(String directoryToClean) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deleteWorkingDirectory: deleting directory " + directoryToClean);
        }
        File[] contents = null;
        File dirToClean = new File(directoryToClean);
        if (directoryToClean == null || dirToClean.getAbsolutePath().indexOf(WORKING_DIR_PREFIX) == -1) {
            return;
        }
        contents = dirToClean.listFiles();
        if (contents == null) {
            return;
        }
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i].isDirectory()) {
                DeployUtils.deleteWorkingDirectory(contents[i].getAbsolutePath());
                contents[i].delete();
            }
            if (!contents[i].isFile()) continue;
            contents[i].delete();
        }
        dirToClean.delete();
    }

    public static EObject convertURIToRefObject(String moduleURI, AppDeploymentInfo appDeploymentInfo) throws AppDeploymentException {
        Vector wars;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertURIToRefObject: moduleURI=" + moduleURI);
        }
        EObject returnValue = null;
        boolean foundIt = false;
        Vector ejbJars = appDeploymentInfo.getModuleConfig("JAR_DD");
        if (ejbJars != null) {
            Iterator iterator = ejbJars.iterator();
            while (iterator.hasNext()) {
                EObject ro = (EObject)iterator.next();
                if (!moduleURI.equals(util.formUriString(appDeploymentInfo, ro))) continue;
                returnValue = ro;
                foundIt = true;
                break;
            }
        }
        if (!foundIt && (wars = appDeploymentInfo.getModuleConfig("WAR_DD")) != null) {
            Iterator iterator = wars.iterator();
            while (iterator.hasNext()) {
                EObject ro = (EObject)iterator.next();
                if (!moduleURI.equals(util.formUriString(appDeploymentInfo, ro))) continue;
                returnValue = ro;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertURIToRefObject: returning refObject=" + returnValue);
        }
        return returnValue;
    }

    public static PublishWSDLInfo getUpdatedWSDLFile(Map moduleDatas, String fileName, String scheme, String host, String port, String contextRoot, String servletPath, boolean includeNonSoapPorts) throws WSDLException {
        String ejbStr;
        ModuleData moduleData;
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        StringBuffer urlStr = new StringBuffer();
        if (port.startsWith("/") || port.length() == 0) {
            urlStr.append(scheme).append("://").append(host).append(port).append("/").append(DeployUtils.trimSlash(contextRoot));
        } else {
            urlStr.append(scheme).append("://").append(host).append(":").append(port).append("/").append(DeployUtils.trimSlash(contextRoot));
        }
        prefixMap.put("http", urlStr.toString());
        if (contextRoot != null && contextRoot.equals("")) {
            contextRoot = "/";
        }
        if ((moduleData = (ModuleData)moduleDatas.get(contextRoot)) == null) {
            String moduleMsg;
            if (contextRoot != null && contextRoot.length() == 0) {
                moduleMsg = "getUpdatedWSDLFile: contextRoot is empty string; moduleData null";
                Tr.warning(tc, "WSWS0039W", moduleMsg);
            } else {
                moduleMsg = "getUpdatedWSDLFile: null contextRoot is invalid; moduleData null";
                Tr.error(tc, "WSWS0020E", moduleMsg);
            }
            throw new WSDLException("INVALID_WSDL", moduleMsg);
        }
        String jmsStr = moduleData.getDefaultJMSPrefix();
        if (jmsStr != null) {
            prefixMap.put("jms", jmsStr);
        }
        if ((ejbStr = moduleData.getDefaultEJBPrefix()) != null) {
            prefixMap.put("ejb", ejbStr);
        }
        String wsdName = DeployUtils.getOwningWebServicesDescription(moduleDatas, contextRoot, servletPath);
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileName);
        }
        catch (FileNotFoundException ex) {
            throw new WSDLException("INVALID_WSDL", ex.getMessage());
        }
        ByteArrayOutputStream wsdlOutputStream = new ByteArrayOutputStream();
        PublishWSDLInfo info = DeployUtils.getUpdatedWSDLFile(fileName, is, prefixMap, moduleData.getMergedQNameToUrlPatternMap(wsdName), moduleData.getMergedQNameToPortComponentNameMap(wsdName), moduleData.getMergedQNameToEJBUrlPrefixMap(wsdName), includeNonSoapPorts, wsdlOutputStream);
        ByteArrayInputStream wsdlInputStream = new ByteArrayInputStream(wsdlOutputStream.toByteArray());
        try {
            info.setWsdlDoc(XMLUtils.newDocument(wsdlInputStream));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.deploy.DeployUtils.getUpdatedWSDLFile", "381", null);
            throw new WSDLException("INVALID_WSDL", e.getMessage());
        }
        return info;
    }

    public static PublishWSDLInfo getUpdatedWSDLFile(String documentBaseURI, InputStream fileStream, Map prefixMap, Map qnameUrlMap, Map qnameToPortComponentNameMap, Map qnameToEJBUrlPrefixMap, boolean includeNonSoapPorts, OutputStream wsdlOutputStream) throws WSDLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUpdatedWSDLFile(-1)", new Object[]{prefixMap, qnameUrlMap, qnameToPortComponentNameMap});
        }
        ServiceProviderManager spm = new ServiceProviderManager(null);
        WSDLFactory factory = spm.getWSDLFactory();
        WSDLReader reader = factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        if (documentBaseURI == null) {
            reader.setFeature("javax.wsdl.importDocuments", false);
        }
        Definition definition = reader.readWSDL(documentBaseURI, new InputSource(fileStream));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getUpdatedWSDLFile(-1), have Definition  " + definition.toString());
        }
        PublishWSDLInfo outputInfo = DeployUtils.getUpdatedWSDLFile(documentBaseURI, definition, prefixMap, qnameUrlMap, qnameToPortComponentNameMap, qnameToEJBUrlPrefixMap, includeNonSoapPorts, factory, wsdlOutputStream, null);
        return outputInfo;
    }

    public static PublishWSDLInfo getUpdatedWSDLFile(String documentBaseURI, Definition definition, Map prefixMap, Map qnameUrlMap, Map qnameToPortComponentNameMap, Map qnameToEJBUrlPrefixMap, boolean includeNonSoapPorts, WSDLFactory factory, OutputStream wsdlOutputStream, Map wsdlPostProcParams) throws WSDLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUpdatedWSDLFile", new Object[]{prefixMap, qnameUrlMap, qnameToPortComponentNameMap});
        }
        PublishWSDLInfo outputInfo = new PublishWSDLInfo();
        String wsdlTargetNameSpace = definition.getTargetNamespace();
        Map services = definition.getServices();
        outputInfo.setHasServiceElement(!services.isEmpty());
        Iterator it0 = services.values().iterator();
        while (it0.hasNext()) {
            Service service = (Service)it0.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getUpdatedWSDLFile, processing service ", service.getQName().toString());
            }
            Map ports = service.getPorts();
            String soapAddress = null;
            String ejbAddress = null;
            Iterator it1 = ports.values().iterator();
            block3: while (it1.hasNext()) {
                String lastPart;
                String firstPart;
                String portComponentName;
                String prefix;
                String prefix2;
                String urlPattern;
                ExtensibilityElement extEl;
                Iterator it2;
                Port p = (Port)it1.next();
                Binding wsdlBinding = p.getBinding();
                String portName = p.getName();
                QName qname = new QName(wsdlTargetNameSpace, portName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getUpdatedWSDLFile, processing port    ", p.getName());
                    Tr.debug(tc, "                               binding ", wsdlBinding.getQName().toString() + " undefined " + wsdlBinding.isUndefined());
                }
                boolean hasJMSSoapAddress = false;
                List peekPortExt = p.getExtensibilityElements();
                Iterator itP = peekPortExt.iterator();
                while (itP.hasNext()) {
                    ExtensibilityElement soapA;
                    ExtensibilityElement extEl2 = (ExtensibilityElement)itP.next();
                    if (extEl2 instanceof SOAPAddress) {
                        soapA = (SOAPAddress)extEl2;
                        if (!soapA.getLocationURI().startsWith("jms")) continue;
                        hasJMSSoapAddress = true;
                        continue;
                    }
                    if (!(extEl2 instanceof SOAP12Address) || !(soapA = (SOAP12Address)extEl2).getLocationURI().startsWith("jms")) continue;
                    hasJMSSoapAddress = true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getUpdatedWSDLFile, after peek, JMS found = " + hasJMSSoapAddress);
                }
                if (wsdlBinding.isUndefined() || hasJMSSoapAddress) {
                    List portExt = p.getExtensibilityElements();
                    it2 = portExt.iterator();
                    while (it2.hasNext()) {
                        extEl = (ExtensibilityElement)it2.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getUpdatedWSDLFile, processing port ExtElement ", extEl.toString() + "  elemType " + extEl.getElementType().toString());
                        }
                        if (extEl instanceof SOAPAddress || extEl instanceof SOAP12Address) {
                            String locationUri;
                            ExtensibilityElement soapA;
                            if (extEl instanceof SOAPAddress) {
                                soapA = (SOAPAddress)extEl;
                                locationUri = soapA.getLocationURI();
                            } else {
                                soapA = (SOAP12Address)extEl;
                                locationUri = soapA.getLocationURI();
                            }
                            outputInfo.setHasSOAPPorts(true);
                            if (locationUri.startsWith("http")) {
                                urlPattern = qnameUrlMap != null ? (String)qnameUrlMap.get(qname) : null;
                                prefix2 = (String)prefixMap.get("http");
                                if (prefix2 == null || urlPattern == null) break;
                                soapAddress = DeployUtils.trimSlash(prefix2) + "/" + DeployUtils.trimSlash(urlPattern);
                                break;
                            }
                            if (!locationUri.startsWith("jms")) break;
                            prefix = (String)prefixMap.get("jms");
                            soapAddress = prefix != null && !"".equals(prefix) ? (qnameToPortComponentNameMap != null ? ((portComponentName = (String)qnameToPortComponentNameMap.get(qname)) != null ? prefix + '&' + "targetService" + '=' + portComponentName : prefix) : prefix) : locationUri;
                            break;
                        }
                        if (!(extEl instanceof AgnosticAddress)) continue;
                        outputInfo.setHasNonSOAPPorts(true);
                        firstPart = (String)qnameToEJBUrlPrefixMap.get(qname);
                        lastPart = (String)prefixMap.get("ejb");
                        lastPart = DeployUtils.stripDelimitersFromFrontOfEJBURLPropertyString(lastPart);
                        lastPart = lastPart.replace('|', '&');
                        ejbAddress = firstPart + '&' + lastPart;
                        break;
                    }
                } else {
                    List bindingExt = wsdlBinding.getExtensibilityElements();
                    it2 = bindingExt.iterator();
                    while (it2.hasNext()) {
                        extEl = (ExtensibilityElement)it2.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getUpdatedWSDLFile, processing binding ExtElement ", extEl.toString() + "  elemType " + extEl.getElementType().toString());
                        }
                        if (extEl instanceof SOAPBinding || extEl instanceof SOAP12Binding) {
                            String transport;
                            ExtensibilityElement soapBinding;
                            if (extEl instanceof SOAPBinding) {
                                soapBinding = (SOAPBinding)extEl;
                                transport = soapBinding.getTransportURI();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "getUpdatedWSDLFile, got a SOAPBinding");
                                }
                            } else {
                                soapBinding = (SOAP12Binding)extEl;
                                transport = soapBinding.getTransportURI();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "getUpdatedWSDLFile, got a SOAP12Binding");
                                }
                            }
                            outputInfo.setHasSOAPPorts(true);
                            if (transport.endsWith("http")) {
                                urlPattern = qnameUrlMap != null ? (String)qnameUrlMap.get(qname) : null;
                                prefix2 = (String)prefixMap.get("http");
                                if (prefix2 == null || urlPattern == null) break;
                                soapAddress = DeployUtils.trimSlash(prefix2) + "/" + DeployUtils.trimSlash(urlPattern);
                                break;
                            }
                            if (!transport.endsWith("jms") || (prefix = (String)prefixMap.get("jms")) == null || "".equals(prefix)) break;
                            soapAddress = qnameToPortComponentNameMap != null ? ((portComponentName = (String)qnameToPortComponentNameMap.get(qname)) != null ? prefix + '&' + "targetService" + '=' + portComponentName : prefix) : prefix;
                            break;
                        }
                        if (!(extEl instanceof EJBBinding)) continue;
                        outputInfo.setHasNonSOAPPorts(true);
                        firstPart = (String)qnameToEJBUrlPrefixMap.get(qname);
                        lastPart = (String)prefixMap.get("ejb");
                        lastPart = DeployUtils.stripDelimitersFromFrontOfEJBURLPropertyString(lastPart);
                        lastPart = lastPart.replace('|', '&');
                        ejbAddress = firstPart + '&' + lastPart;
                        break;
                    }
                }
                Object[] extElements = p.getExtensibilityElements().toArray();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getUpdatedWSDLFile, port extElem count is " + extElements.length);
                }
                for (int i = 0; i < extElements.length; ++i) {
                    ExtensibilityElement addr;
                    if (extElements[i] instanceof SOAPAddress) {
                        addr = (SOAPAddress)extElements[i];
                        if (soapAddress == null) continue block3;
                        addr.setLocationURI(soapAddress);
                        if (!tc.isDebugEnabled()) continue block3;
                        Tr.debug(tc, "getUpdatedWSDLFile, set SOAP to ", soapAddress);
                        continue block3;
                    }
                    if (extElements[i] instanceof SOAP12Address) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getUpdatedWSDLFile, got a SOAP12Address");
                        }
                        addr = (SOAP12Address)extElements[i];
                        if (soapAddress == null) continue block3;
                        addr.setLocationURI(soapAddress);
                        if (!tc.isDebugEnabled()) continue block3;
                        Tr.debug(tc, "getUpdatedWSDLFile, set SOAP1.2 to ", soapAddress);
                        continue block3;
                    }
                    if (extElements[i] instanceof AgnosticAddress) {
                        addr = (AgnosticAddress)extElements[i];
                        if (addr == null || ejbAddress == null) continue block3;
                        ((AgnosticAddress)addr).setLocationURI(ejbAddress);
                        continue block3;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "getUpdatedWSDLFile, port extElem instanceof ? " + extElements[i].toString());
                }
            }
        }
        if (!includeNonSoapPorts) {
            definition = DeployUtils.stripOutNonSoapElements(definition);
        }
        try {
            if (wsdlPostProcParams != null) {
                WSDLPostProcessorPluginMgr wsdlPostProcMgr = WSDLPostProcessorPluginMgr.getInstance();
                wsdlPostProcMgr.runPostProcessWSDL(definition, wsdlPostProcParams);
            }
        }
        catch (WSDLPostProcessingException e) {
            throw new WSDLException("CONFIGURATION_ERROR", e.getMessage());
        }
        WSDLWriter writer = factory.newWSDLWriter();
        writer.writeWSDL(definition, wsdlOutputStream);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUpdatedWSDLFile");
        }
        return outputInfo;
    }

    public static boolean isWebServicesEnabled(EARFile earFile, boolean includeClient) {
        boolean enabled = false;
        List moduleFiles = earFile.getModuleFiles();
        Iterator it = moduleFiles.iterator();
        while (it.hasNext()) {
            JAXRPCMetaDataHelper helper;
            JAXRPCMetaDataWrapper wrapper;
            String wsFilePath;
            ModuleFile mf = (ModuleFile)it.next();
            String string = wsFilePath = mf.isWARFile() ? "WEB-INF/webservices.xml" : "META-INF/webservices.xml";
            if (mf.containsFile(wsFilePath) && (wrapper = (helper = new JAXRPCMetaDataHelper(mf, mf.getArchiveClassLoader())).loadJAXRPCMetaData()) != null && wrapper.containsJAXRPCServices()) {
                enabled = true;
                break;
            }
            if (!includeClient || !mf.containsFile(wsFilePath = mf.isWARFile() ? "WEB-INF/webservicesclient.xml" : "META-INF/webservicesclient.xml")) continue;
            enabled = true;
            break;
        }
        return enabled;
    }

    public static boolean isWebServicesSecurityEnabled(EARFile earFile) {
        boolean enabled = false;
        List moduleFiles = earFile.getModuleFiles();
        WsExtension wse = null;
        LoadStrategy loadStrategy = null;
        Iterator it = moduleFiles.iterator();
        while (it.hasNext()) {
            WsDescExt w;
            String wseFilename;
            ModuleFile mf = (ModuleFile)it.next();
            if (mf == null) continue;
            loadStrategy = mf.getLoadStrategy();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isWebServicesSecurityEnabled: earFile = " + earFile.getName());
                Tr.debug(tc, "isWebServicesSecurityEnabled: moduleFile = " + mf.getName());
            }
            String string = wseFilename = mf.isWARFile() ? "WEB-INF/ibm-webservices-ext.xmi" : "META-INF/ibm-webservices-ext.xmi";
            if (loadStrategy != null && wseFilename != null) {
                wse = DeployUtils.loadWebServicesExtXML(loadStrategy, wseFilename);
            }
            EList wsdescext = null;
            if (wse != null) {
                wsdescext = wse.getWsDescExt();
            }
            if (wsdescext == null || wsdescext.isEmpty()) continue;
            int size = wsdescext.size();
            block1: for (int i = 0; i < size && !enabled && (w = (WsDescExt)wsdescext.get(i)) != null; ++i) {
                EList pcbs = w.getPcBinding();
                if (pcbs == null || pcbs.isEmpty()) continue;
                int pcbsNum = pcbs.size();
                for (int j = 0; j < pcbsNum; ++j) {
                    PcBinding pcb = (PcBinding)pcbs.get(j);
                    ServerServiceConfig ssc = pcb.getServerServiceConfig();
                    if (ssc == null) continue;
                    if (ssc.getSecurityRequestReceiverServiceConfig() != null) {
                        enabled = true;
                        if (!tc.isDebugEnabled()) continue block1;
                        Tr.debug(tc, "SecurityRequestReceiverServiceConfig found, assuming ws-security is enabled");
                        continue block1;
                    }
                    if (ssc.getSecurityResponseSenderServiceConfig() != null) {
                        enabled = true;
                        if (!tc.isDebugEnabled()) continue block1;
                        Tr.debug(tc, "SecurityResponseSenderServiceConfig found, assuming ws-security is enabled");
                        continue block1;
                    }
                    if (ssc.getSecurityRequestConsumerServiceConfig() != null) {
                        enabled = true;
                        if (!tc.isDebugEnabled()) continue block1;
                        Tr.debug(tc, "SecurityRequestConsumerServiceConfig found, assuming ws-security is enabled");
                        continue block1;
                    }
                    if (ssc.getSecurityResponseGeneratorServiceConfig() == null) continue;
                    enabled = true;
                    if (!tc.isDebugEnabled()) continue block1;
                    Tr.debug(tc, "SecurityResponseGeneratorServiceConfig found, assuming ws-security is enabled");
                    continue block1;
                }
            }
        }
        return enabled;
    }

    private static WsExtension loadWebServicesExtXML(LoadStrategy loadStrategy, String xmlFilename) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadWebServicesExtXML: xmlFilename = " + xmlFilename + "  loadStrategy = " + (loadStrategy == null ? "null" : loadStrategy.toString()));
            Tr.debug(tc, "loadWebServicesExtXML: container.toString() " + loadStrategy.getContainer().toString());
            Tr.debug(tc, "loadWebServicesExtXML: container.getLoadStrategy() " + loadStrategy.getContainer().getLoadStrategy().toString());
        }
        if (loadStrategy.getContainer().containsFile(xmlFilename)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing IBM web services XML ext file: " + xmlFilename);
            }
            try {
                return WSModels.getWSExtension(loadStrategy, xmlFilename);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.deploy.DeployUtils.loadWebServicesExtXML", "805");
            }
        }
        return null;
    }

    public static String trimSlash(String in) {
        if (in == null) {
            return in;
        }
        while (in.startsWith("/")) {
            in = in.substring(1);
        }
        while (in.endsWith("/")) {
            in = in.substring(0, in.length() - 1);
        }
        return in;
    }

    public static void publishWSDLFiles(RepositoryContext appDeployContext, String publishDestination, AttributeList moduleWSDLAddresses) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publishWSDLFiles (rsa)");
        }
        ConfigService configService = DeployUtils.getConfigService();
        ConfigScope configScope = configService.createScope(1);
        configScope.set(0, appDeployContext.getParent().getParent().getName());
        configScope.set(1, appDeployContext.getParent().getName() + "/deployments/" + appDeployContext.getName());
        MetaDataLoaderFactory factory = new MetaDataLoaderFactory();
        MetaDataLoader loader = factory.newInstance();
        loader.setRepositoryContext(appDeployContext);
        loader.setConfigScope(configService, configScope);
        loader.setEARFileLocation(null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "publishWSDLFiles got loader " + loader.toString());
        }
        loader.load();
        List moduleDataList = loader.getModuleDataList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "publishWSDLFiles loader list count is " + moduleDataList.size());
        }
        String publishDestinationForExtWSDL = "";
        int indexOfLastSlash = publishDestination.lastIndexOf(File.separator);
        if (indexOfLastSlash == -1) {
            indexOfLastSlash = publishDestination.lastIndexOf(47);
        }
        if (indexOfLastSlash == -1) {
            publishDestinationForExtWSDL = "ExtWSDL_" + publishDestination;
        } else {
            String firstPart = publishDestination.substring(0, indexOfLastSlash + 1);
            String originalLastPart = publishDestination.substring(indexOfLastSlash + 1, publishDestination.length());
            String newLastPart = "ExtWSDL_" + originalLastPart;
            publishDestinationForExtWSDL = firstPart + newLastPart;
        }
        DeployUtils.publishWSDLFiles(moduleDataList, publishDestination, publishDestinationForExtWSDL, moduleWSDLAddresses);
        loader.cleanup();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publishWSDLFiles (rsa)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int publishWSDLFiles(List moduleDataList, String pathNameForNonExtendedWSDL, String pathNameForExtendedWSDL, AttributeList moduleWSDLAddresses) throws Exception {
        boolean hasSOAPPorts;
        boolean hasNonSOAPPorts;
        block63: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "publishWSDLFiles (lssa)");
            }
            File zipFileForExtendedWSDL = null;
            File zipFileForNonExtendedWSDL = null;
            DeflaterOutputStream zipOutputStreamForNonExtendedWSDL = null;
            DeflaterOutputStream zipOutputStreamForExtendedWSDL = null;
            hasNonSOAPPorts = false;
            hasSOAPPorts = false;
            boolean entryAdded = false;
            try {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "moduleWSDLAddresses (from scripting command) is " + (moduleWSDLAddresses == null ? "null" : "size " + moduleWSDLAddresses.size()));
                    }
                    HashMap moduleAddresses = null;
                    if (moduleWSDLAddresses != null) {
                        moduleAddresses = new HashMap();
                        for (int i = 0; i < moduleWSDLAddresses.size(); ++i) {
                            Attribute attr = (Attribute)moduleWSDLAddresses.get(i);
                            String moduleName = attr.getName();
                            AttributeList addresses = (AttributeList)attr.getValue();
                            HashMap<String, Object> transports = new HashMap<String, Object>();
                            for (int j = 0; j < addresses.size(); ++j) {
                                Attribute a = (Attribute)addresses.get(j);
                                String transportName = a.getName();
                                Object transportPrefix = a.getValue();
                                transports.put(transportName, transportPrefix);
                            }
                            moduleAddresses.put(moduleName, transports);
                        }
                    }
                    if ((zipFileForExtendedWSDL = new File(pathNameForExtendedWSDL)) != null && zipFileForExtendedWSDL.exists()) {
                        zipFileForExtendedWSDL.delete();
                    }
                    zipFileForExtendedWSDL.createNewFile();
                    FileOutputStream outputStreamForExtendedWSDL = new FileOutputStream(zipFileForExtendedWSDL);
                    zipOutputStreamForExtendedWSDL = new ZipOutputStream(outputStreamForExtendedWSDL);
                    zipFileForNonExtendedWSDL = new File(pathNameForNonExtendedWSDL);
                    if (zipFileForNonExtendedWSDL != null && zipFileForNonExtendedWSDL.exists()) {
                        zipFileForNonExtendedWSDL.delete();
                    }
                    zipFileForNonExtendedWSDL.createNewFile();
                    FileOutputStream outputStreamForNonExtendedWSDL = new FileOutputStream(zipFileForNonExtendedWSDL);
                    zipOutputStreamForNonExtendedWSDL = new ZipOutputStream(outputStreamForNonExtendedWSDL);
                    HashSet<String> filesAlreadyCopied = new HashSet<String>();
                    ServiceProviderManager spm = new ServiceProviderManager(null);
                    WSDLFactory factory = spm.getWSDLFactory();
                    WSDLPostProcessorPluginMgr wsdlPostProcMgr = WSDLPostProcessorPluginMgr.getInstance();
                    Iterator it = moduleDataList.iterator();
                    while (it.hasNext()) {
                        String wsdlFileName;
                        String applicationName;
                        ModuleData moduleData = (ModuleData)it.next();
                        String origAppName = applicationName = moduleData.getApplicationName();
                        String moduleName = moduleData.getName();
                        String contextRoot = moduleData.getContextRoot();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "publishWSDLFiles starting module appName: " + applicationName + "  module: " + moduleName + "  is JAXRPC " + moduleData.isJAXRPC() + "    is JAXWS " + moduleData.isJAXWS());
                        }
                        String httpPrefix = moduleData.getDefaultPrefix();
                        String jmsPrefix = moduleData.getDefaultJMSPrefix();
                        String ejbSuffix = moduleData.getDefaultEJBPrefix();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "prefixes from ModuleData: http " + httpPrefix + " jms " + jmsPrefix + " ejb " + ejbSuffix);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "moduleAddresses (from scripting command) is " + (moduleAddresses == null ? "null" : "size " + moduleAddresses.size()));
                        }
                        if (moduleAddresses != null) {
                            Map prefixes = (Map)moduleAddresses.get(moduleName);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "module prefixes (from scripting command) is " + (prefixes == null ? "null" : "size " + prefixes.size()));
                            }
                            if (prefixes != null) {
                                String ejbOverride;
                                String jmsOverride;
                                String httpOverride = (String)prefixes.get("http");
                                if (httpOverride != null) {
                                    httpPrefix = httpOverride;
                                }
                                if ((jmsOverride = (String)prefixes.get("jms")) != null) {
                                    jmsPrefix = jmsOverride;
                                }
                                if ((ejbOverride = (String)prefixes.get("ejb")) != null) {
                                    ejbSuffix = ejbOverride;
                                }
                            }
                        }
                        httpPrefix = DeployUtils.trimSlash(httpPrefix) + "/" + DeployUtils.trimSlash(contextRoot);
                        if (!applicationName.endsWith(".ear")) {
                            applicationName = applicationName + ".ear";
                        }
                        String zipEntryNamePrefix = applicationName + "/" + moduleName;
                        List modulesWsdlFiles = moduleData.getModulesWsdlFiles();
                        List modulesWsdlDefinitions = moduleData.getModulesWsdlDefinitions();
                        List webservicesDescriptions = moduleData.getWebservicesDescritions();
                        HashSet<String> nonDuplicateWsdlFileElements = new HashSet<String>();
                        HashSet<String> duplicateWsdlFileElements = new HashSet<String>();
                        Iterator iter6 = webservicesDescriptions.iterator();
                        while (iter6.hasNext()) {
                            WebserviceDescriptionInfo wsdlInfo = (WebserviceDescriptionInfo)iter6.next();
                            wsdlFileName = wsdlInfo.getWsdlFileName();
                            if (!nonDuplicateWsdlFileElements.contains(wsdlFileName)) {
                                nonDuplicateWsdlFileElements.add(wsdlFileName);
                                continue;
                            }
                            String simpleName = new File(wsdlFileName).getName();
                            duplicateWsdlFileElements.add(simpleName);
                        }
                        Iterator iter3 = webservicesDescriptions.iterator();
                        while (iter3.hasNext()) {
                            String wholeWSDLName;
                            WebserviceDescriptionInfo wsdInfo = (WebserviceDescriptionInfo)iter3.next();
                            wsdlFileName = wsdInfo.getWsdlFileName();
                            File f = new File(wsdlFileName);
                            String simpleName = f.getName();
                            Definition thisWebserviceWsdlDefinition = null;
                            FileImpl thisWebserviceDescriptionsWsdlFile = null;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Looking for WSDL Definition object with name: " + simpleName);
                            }
                            if (modulesWsdlDefinitions != null) {
                                Iterator iter8 = modulesWsdlDefinitions.iterator();
                                while (iter8.hasNext()) {
                                    Definition wsdlDefn = (Definition)iter8.next();
                                    String name = wsdlDefn.getTargetNamespace();
                                    if (!name.equals(simpleName)) continue;
                                    thisWebserviceWsdlDefinition = wsdlDefn;
                                }
                            }
                            String dir = null;
                            String name = null;
                            if (thisWebserviceWsdlDefinition == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Couldn't find definition, looking for actual WSDL file.");
                                }
                                Iterator iter4 = modulesWsdlFiles.iterator();
                                while (iter4.hasNext()) {
                                    FileImpl wsdlFile = (FileImpl)iter4.next();
                                    String tempName = wsdlFile.getName();
                                    if (!tempName.equals(simpleName)) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "WSDL file found. Loading as definition.");
                                    }
                                    thisWebserviceDescriptionsWsdlFile = wsdlFile;
                                    dir = thisWebserviceDescriptionsWsdlFile.getDirectoryURI();
                                    name = thisWebserviceDescriptionsWsdlFile.getName();
                                    String tempWSDLName = dir + "/" + name;
                                    ModuleWSDLLocator wsdlLoc = new ModuleWSDLLocator(tempWSDLName, wsdlFile.getInputStream(), wsdlFile.getLoadingContainer().getLoadStrategy());
                                    WSDLReader reader = factory.newWSDLReader();
                                    wsdlPostProcMgr.runRegisterExtensions(reader.getExtensionRegistry());
                                    thisWebserviceWsdlDefinition = reader.readWSDL(wsdlLoc);
                                }
                            }
                            if (thisWebserviceWsdlDefinition == null) {
                                Tr.error(tc, "publishWSDLFiles: thisWebserviceDescriptionsWsdlFile is null for module " + moduleName);
                                continue;
                            }
                            dir = dir != null && dir != "" ? dir : "generatedWSDLDir";
                            name = name != null ? name : thisWebserviceWsdlDefinition.getTargetNamespace();
                            String wsdName = wsdInfo.getWebserviceDescriptionName();
                            if (moduleData.isJAXRPC() && duplicateWsdlFileElements.contains(name)) {
                                name = wsdName + '_' + name;
                            }
                            HashMap<String, String> prefixes = new HashMap<String, String>();
                            prefixes.put("jms", jmsPrefix);
                            prefixes.put("http", httpPrefix);
                            prefixes.put("ejb", ejbSuffix);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "prefixes put to ModuleData: http " + httpPrefix + " jms " + jmsPrefix + " ejb " + ejbSuffix);
                            }
                            if (!filesAlreadyCopied.contains(wholeWSDLName = zipEntryNamePrefix + "/" + dir + "/" + name)) {
                                HashMap<String, Object> wsdlPostProcParams = new HashMap<String, Object>();
                                wsdlPostProcParams.put("APP_NAME_KEY", origAppName);
                                wsdlPostProcParams.put("MODULE_NAME_KEY", moduleName);
                                wsdlPostProcParams.put("SERVICE_NAME_KEY", wsdInfo.getWebserviceDescriptionQName());
                                ZipEntry ze1 = new ZipEntry(wholeWSDLName);
                                ((ZipOutputStream)zipOutputStreamForNonExtendedWSDL).putNextEntry(ze1);
                                ZipEntry ze2 = new ZipEntry(wholeWSDLName);
                                ((ZipOutputStream)zipOutputStreamForExtendedWSDL).putNextEntry(ze2);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "publishWSDLFiles: about to add an outermost WSDL file to the zip file, the file name is " + wholeWSDLName);
                                }
                                PublishWSDLInfo wsdlInfo = DeployUtils.getUpdatedWSDLFile(null, thisWebserviceWsdlDefinition, prefixes, moduleData.getMergedQNameToUrlPatternMap(wsdName), moduleData.getMergedQNameToPortComponentNameMap(wsdName), moduleData.getMergedQNameToEJBUrlPrefixMap(wsdName), false, factory, zipOutputStreamForNonExtendedWSDL, wsdlPostProcParams);
                                hasSOAPPorts = wsdlInfo.hasSOAPPorts() | hasSOAPPorts;
                                PublishWSDLInfo extendedWsdlInfo = DeployUtils.getUpdatedWSDLFile(null, thisWebserviceWsdlDefinition, prefixes, moduleData.getMergedQNameToUrlPatternMap(wsdName), moduleData.getMergedQNameToPortComponentNameMap(wsdName), moduleData.getMergedQNameToEJBUrlPrefixMap(wsdName), true, factory, zipOutputStreamForExtendedWSDL, wsdlPostProcParams);
                                hasNonSOAPPorts = extendedWsdlInfo.hasNonSOAPPorts() | hasNonSOAPPorts;
                                filesAlreadyCopied.add(wholeWSDLName);
                                entryAdded = true;
                                if (thisWebserviceDescriptionsWsdlFile == null) continue;
                                DeployUtils.writeAllWSDLImports(thisWebserviceWsdlDefinition, wholeWSDLName, factory, (ZipOutputStream)zipOutputStreamForNonExtendedWSDL, (ZipOutputStream)zipOutputStreamForExtendedWSDL, filesAlreadyCopied, false);
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "publishWSDLFiles: skipping outermost WSDL file, duplicate file name is " + wholeWSDLName);
                        }
                        Iterator iter5 = modulesWsdlFiles.iterator();
                        while (iter5.hasNext()) {
                            FileImpl wsdlFile = (FileImpl)iter5.next();
                            String dir = wsdlFile.getDirectoryURI();
                            dir = dir != null && dir != "" ? dir : "generatedWSDLDir";
                            String name = wsdlFile.getName();
                            String wholeWSDLName = zipEntryNamePrefix + "/" + dir + "/" + name;
                            if (filesAlreadyCopied.contains(wholeWSDLName)) continue;
                            InputStream is = wsdlFile.getInputStream();
                            ZipEntry ze = new ZipEntry(wholeWSDLName);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "about to add a non-outermost WSDL file to the zip file.  file name is " + wholeWSDLName);
                            }
                            ((ZipOutputStream)zipOutputStreamForNonExtendedWSDL).putNextEntry(ze);
                            ((ZipOutputStream)zipOutputStreamForExtendedWSDL).putNextEntry(ze);
                            filesAlreadyCopied.add(wholeWSDLName);
                            entryAdded = true;
                            byte[] buffer = new byte[1024];
                            int bytesRead = 0;
                            while ((bytesRead = is.read(buffer)) > -1) {
                                ((ZipOutputStream)zipOutputStreamForNonExtendedWSDL).write(buffer, 0, bytesRead);
                                ((ZipOutputStream)zipOutputStreamForExtendedWSDL).write(buffer, 0, bytesRead);
                            }
                            ((ZipOutputStream)zipOutputStreamForNonExtendedWSDL).closeEntry();
                            ((ZipOutputStream)zipOutputStreamForExtendedWSDL).closeEntry();
                        }
                    }
                    Object var51_54 = null;
                }
                catch (Exception ex) {
                    Tr.error(tc, "publishWSDLFiles: Exception caught. ", ex);
                    FFDCFilter.processException(ex, "com.ibm.ws.webservices.deploy.DeployUtils.publishWSDLFiles", "1587");
                    Object var51_55 = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "publishWSDLFiles: finally - entryAdded is " + entryAdded);
                    }
                    if (!entryAdded) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "publishWSDLFiles: Nothing added to zip file");
                        }
                        zipFileForExtendedWSDL = null;
                        zipFileForNonExtendedWSDL = null;
                        zipOutputStreamForNonExtendedWSDL = null;
                        zipOutputStreamForExtendedWSDL = null;
                        throw new Exception(nls.getString("WSWS0047E"));
                    }
                    if (zipOutputStreamForNonExtendedWSDL != null) {
                        zipOutputStreamForNonExtendedWSDL.flush();
                        ((ZipOutputStream)zipOutputStreamForNonExtendedWSDL).close();
                    }
                    if (zipOutputStreamForExtendedWSDL != null) {
                        zipOutputStreamForExtendedWSDL.flush();
                        ((ZipOutputStream)zipOutputStreamForExtendedWSDL).close();
                    }
                    break block63;
                }
            }
            catch (Throwable throwable) {
                Object var51_56 = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "publishWSDLFiles: finally - entryAdded is " + entryAdded);
                }
                if (!entryAdded) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "publishWSDLFiles: Nothing added to zip file");
                    }
                    zipFileForExtendedWSDL = null;
                    zipFileForNonExtendedWSDL = null;
                    zipOutputStreamForNonExtendedWSDL = null;
                    zipOutputStreamForExtendedWSDL = null;
                    throw new Exception(nls.getString("WSWS0047E"));
                }
                if (zipOutputStreamForNonExtendedWSDL != null) {
                    zipOutputStreamForNonExtendedWSDL.flush();
                    ((ZipOutputStream)zipOutputStreamForNonExtendedWSDL).close();
                }
                if (zipOutputStreamForExtendedWSDL != null) {
                    zipOutputStreamForExtendedWSDL.flush();
                    ((ZipOutputStream)zipOutputStreamForExtendedWSDL).close();
                }
                throw throwable;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "publishWSDLFiles: finally - entryAdded is " + entryAdded);
            }
            if (!entryAdded) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "publishWSDLFiles: Nothing added to zip file");
                }
                zipFileForExtendedWSDL = null;
                zipFileForNonExtendedWSDL = null;
                zipOutputStreamForNonExtendedWSDL = null;
                zipOutputStreamForExtendedWSDL = null;
                throw new Exception(nls.getString("WSWS0047E"));
            }
            if (zipOutputStreamForNonExtendedWSDL != null) {
                zipOutputStreamForNonExtendedWSDL.flush();
                ((ZipOutputStream)zipOutputStreamForNonExtendedWSDL).close();
            }
            if (zipOutputStreamForExtendedWSDL != null) {
                zipOutputStreamForExtendedWSDL.flush();
                ((ZipOutputStream)zipOutputStreamForExtendedWSDL).close();
            }
        }
        if (!hasSOAPPorts && !hasNonSOAPPorts) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "publishWSDLFiles: No ports in any published WSDL file");
            }
            return 0;
        }
        if (hasSOAPPorts) {
            if (!hasNonSOAPPorts) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "publishWSDLFiles: Only SOAP ports present in WSDL files");
                }
                return 1;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "publishWSDLFiles: Both SOAP and Non-SOAP ports present in WSDL files");
            }
            return 3;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "publishWSDLFiles: Only Non-SOAP ports present in WSDL files");
        }
        return 2;
    }

    private static void writeAllWSDLImports(Definition definition, String wholeWsdlName, WSDLFactory factory, ZipOutputStream zipOSForNonExtWsdl, ZipOutputStream zipOSForExtWsdl, Set filesAlreadyCopied, boolean writeRootDocument) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeployUtils.writeAllWSDLImports()...", "Root WSDL: " + wholeWsdlName);
        }
        if (writeRootDocument && !filesAlreadyCopied.contains(wholeWsdlName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "about to add a imported WSDL file to the zip file.  file name is " + wholeWsdlName);
            }
            ZipEntry ze1 = new ZipEntry(wholeWsdlName);
            zipOSForNonExtWsdl.putNextEntry(ze1);
            ZipEntry ze2 = new ZipEntry(wholeWsdlName);
            zipOSForExtWsdl.putNextEntry(ze2);
            WSDLWriter writer = factory.newWSDLWriter();
            writer.writeWSDL(definition, zipOSForNonExtWsdl);
            writer.writeWSDL(definition, zipOSForExtWsdl);
            filesAlreadyCopied.add(wholeWsdlName);
        }
        if (definition.getImports() != null) {
            Iterator iter = definition.getImports().values().iterator();
            while (iter.hasNext()) {
                Vector importsVector = (Vector)iter.next();
                Iterator iter2 = importsVector.iterator();
                while (iter2.hasNext()) {
                    Import importWsdl = (Import)iter2.next();
                    if (DeployUtils.isAbsoluteImport(importWsdl.getLocationURI())) continue;
                    String wsdlPath = wholeWsdlName.substring(0, wholeWsdlName.lastIndexOf("/"));
                    wsdlPath = DeployUtils.condenseURI(DeployUtils.trimSlash(wsdlPath), DeployUtils.trimSlash(importWsdl.getLocationURI()));
                    DeployUtils.writeAllWSDLImports(importWsdl.getDefinition(), wsdlPath, factory, zipOSForNonExtWsdl, zipOSForExtWsdl, filesAlreadyCopied, true);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "...DeployUtils.writeAllWSDLImports()");
        }
    }

    private static boolean isAbsoluteImport(String uri) {
        boolean absolute = false;
        if (uri != null) {
            if (uri.indexOf(":/") != -1) {
                absolute = true;
            } else if (uri.indexOf(":\\") != -1) {
                absolute = true;
            }
        }
        return absolute;
    }

    private static String condenseURI(String path, String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeployUtils.trimURI()...");
        }
        if (path == null || name == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "One null value, returning null. Path: " + path + ", Name: " + name);
            }
            return null;
        }
        while (name.startsWith("../")) {
            path = path.substring(0, path.lastIndexOf("/"));
            name = name.substring(3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "...DeployUtils.trimURI()");
        }
        return path + "/" + name;
    }

    public static Definition stripOutNonSoapElements(Definition extendedWsdlDefinition) {
        Map svcs = extendedWsdlDefinition.getServices();
        Iterator iter = svcs.keySet().iterator();
        while (iter.hasNext()) {
            String portName;
            QName serviceName = (QName)iter.next();
            Service service = (Service)svcs.get(serviceName);
            Map ports = service.getPorts();
            ArrayList<String> namesOfPortsWithNonSoapBindings = new ArrayList<String>();
            Iterator i = ports.keySet().iterator();
            while (i.hasNext()) {
                String locationURI;
                portName = (String)i.next();
                Port port = (Port)ports.get(portName);
                Binding binding = port.getBinding();
                boolean foundSoapBinding = false;
                List extensibilityElements = binding.getExtensibilityElements();
                Iterator iter2 = extensibilityElements.iterator();
                while (iter2.hasNext()) {
                    ExtensibilityElement element = (ExtensibilityElement)iter2.next();
                    if (!(element instanceof SOAPBinding) && !(element instanceof SOAP12Binding)) continue;
                    foundSoapBinding = true;
                    break;
                }
                if (!foundSoapBinding && (locationURI = WSDLUtils.getAddressFromPort(port)) != null && ((locationURI = locationURI.toLowerCase()).startsWith("http:") || locationURI.startsWith("https:") || locationURI.startsWith("jms:"))) {
                    foundSoapBinding = true;
                }
                if (foundSoapBinding) continue;
                namesOfPortsWithNonSoapBindings.add(portName);
            }
            Iterator iter2 = namesOfPortsWithNonSoapBindings.iterator();
            while (iter2.hasNext()) {
                portName = (String)iter2.next();
                ports.remove(portName);
            }
        }
        return extendedWsdlDefinition;
    }

    public static String stripDelimitersFromFrontOfEJBURLPropertyString(String propertyString) {
        String delimiters = "&|";
        char[] delimiterChars = delimiters.toCharArray();
        String[] delimiterCharsAsStrings = new String[delimiterChars.length];
        for (int i = 0; i < delimiterChars.length; ++i) {
            delimiterCharsAsStrings[i] = new String(new char[]{delimiterChars[i]});
        }
        boolean startedWithDelimiter = true;
        block1: while (startedWithDelimiter) {
            startedWithDelimiter = false;
            for (int i = 0; i < delimiterCharsAsStrings.length; ++i) {
                if (!propertyString.startsWith(delimiterCharsAsStrings[i])) continue;
                propertyString = propertyString.substring(1);
                startedWithDelimiter = true;
                continue block1;
            }
        }
        return propertyString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Map loadModuleData(String applicationName, String binariesURL) {
        HashMap<String, ModuleData> moduleDatas;
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadModuleData", new Object[]{applicationName, binariesURL});
            }
            MetaDataLoader loader = null;
            moduleDatas = new HashMap<String, ModuleData>();
            ConfigService configService = DeployUtils.getConfigService();
            ConfigScope appDeployConfigScope = configService.createScope(1);
            appDeployConfigScope.set(1, applicationName + ".ear/deployments/" + applicationName);
            MetaDataLoaderFactory factory = new MetaDataLoaderFactory();
            loader = factory.newInstance();
            loader.setConfigScope(configService, appDeployConfigScope);
            loader.setEARFileLocation(binariesURL);
            loader.load();
            List lst = loader.getModuleDataList();
            Iterator it = lst.iterator();
            while (it.hasNext()) {
                ModuleData moduleData = (ModuleData)it.next();
                String contextRoot = moduleData.getContextRoot();
                if (contextRoot == null) continue;
                if ((contextRoot = contextRoot.trim()).endsWith("/")) {
                    contextRoot = contextRoot.substring(0, contextRoot.length() - 1);
                }
                if (!contextRoot.startsWith("/")) {
                    contextRoot = "/" + contextRoot;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "contextRoot = " + contextRoot);
                }
                moduleDatas.put(contextRoot, moduleData);
            }
            Object var12_12 = null;
            try {
                if (loader != null) {
                    loader.cleanup();
                }
                break block20;
            }
            catch (Exception ex2) {
                FFDCFilter.processException(ex2, "com.ibm.ws.webservices.deploy.DeployUtils.loadModuleData", "1385");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to clean up resources", ex2);
                }
                break block20;
            }
            {
                catch (Exception ex) {
                    FFDCFilter.processException(ex, "com.ibm.ws.webservices.deploy.DeployUtils.loadModuleData", "1375");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "can not load the application metadata", ex);
                    }
                    Object var12_13 = null;
                    try {
                        if (loader != null) {
                            loader.cleanup();
                        }
                        break block20;
                    }
                    catch (Exception ex2) {
                        FFDCFilter.processException(ex2, "com.ibm.ws.webservices.deploy.DeployUtils.loadModuleData", "1385");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "unable to clean up resources", ex2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block21: {
                    Object var12_14 = null;
                    try {
                        if (loader != null) {
                            loader.cleanup();
                        }
                    }
                    catch (Exception ex2) {
                        FFDCFilter.processException(ex2, "com.ibm.ws.webservices.deploy.DeployUtils.loadModuleData", "1385");
                        if (!tc.isDebugEnabled()) break block21;
                        Tr.debug(tc, "unable to clean up resources", ex2);
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadModuleData");
        }
        return moduleDatas;
    }

    public static String getOwningWebServicesDescription(Map moduleDatas, String contextRoot, String urlPattern) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOwningWebServicesDescription", new Object[]{contextRoot, urlPattern});
        }
        String wsdName = null;
        ModuleData moduleData = (ModuleData)moduleDatas.get(contextRoot);
        List wsds = moduleData.getWebservicesDescritions();
        Iterator it = wsds.iterator();
        block0: while (it.hasNext()) {
            WebserviceDescriptionInfo wsdi = (WebserviceDescriptionInfo)it.next();
            Collection urls = wsdi.getQNameToUrlPatternMap().values();
            Iterator urlIt = urls.iterator();
            while (urlIt.hasNext()) {
                String url = (String)urlIt.next();
                if (!url.equals(urlPattern)) continue;
                wsdName = wsdi.getWebserviceDescriptionName();
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOwningWebServicesDescription", wsdName);
        }
        return wsdName;
    }

    public static ConfigService getConfigService() {
        ConfigService configService;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating ConfigService from factory.");
        }
        Server server = (Server)ComponentUtil.getService((Object)DeployUtils.class, (Class)Server.class);
        String cellName = null;
        if (server != null && DeployUtils.isNormalServer()) {
            cellName = server.getCellName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using this cell name to create ConfigService instance: " + cellName);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell name null when creating ConfigService instance");
        }
        ConfigRepository repository2 = ConfigRepositoryFactory.getConfigRepository();
        Properties repositoryConfig = repository2.getConfig();
        String rootDir = repositoryConfig.getProperty("was.repository.root");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "rootDir from ConfigRepository " + rootDir);
        }
        if ((configService = ConfigServiceFactory.createConfigService(rootDir, cellName, null, null, null)) == null) {
            throw new IllegalStateException("Couldn't create ConfigService from factory");
        }
        return configService;
    }

    public static boolean isNormalServer() {
        boolean isNormal = true;
        String serverType = AdminServiceFactory.getAdminService().getServerType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverType from AdminService is " + serverType);
        }
        if (serverType != null && serverType.equals("ADMIN_AGENT")) {
            isNormal = false;
        }
        return isNormal;
    }
}

