/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ffdc.Manager;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ClassResolverImpl
implements WsObjectInputStream.ClassResolver {
    private static final Map<String, ClassHolder> _serializableClasses = new HashMap<String, ClassHolder>();

    public Class resolveClass(String className) {
        String componentClassName = this.getComponentClassName(className);
        Class clazz = null;
        ClassHolder item = _serializableClasses.get(componentClassName);
        if (item != null) {
            clazz = item.getClass(className);
        }
        return clazz;
    }

    private String getComponentClassName(String className) {
        if (className.startsWith("[")) {
            int index = className.indexOf("[L") + 2;
            return className.substring(index, className.length() - 1);
        }
        return className;
    }

    static {
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (registry != null) {
            String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".serializable";
            IConfigurationElement[] bundles = registry.getConfigurationElementsFor(epid);
            for (int i = 0; i < bundles.length; ++i) {
                String className;
                Bundle osgiBundle = Platform.getBundle((String)bundles[i].getContributor().getName());
                if (osgiBundle == null || (className = bundles[i].getAttribute("class")) == null || "".equals(className)) continue;
                _serializableClasses.put(className, new ClassHolder(className, osgiBundle));
            }
        }
    }

    private static class ClassHolder {
        private Class _cachedClass;
        private String _className;
        private Bundle _bundle;

        public ClassHolder(String className, Bundle bundle) {
            this._className = className;
            this._bundle = bundle;
        }

        public Class getClass(String className) {
            Class<?> clazz;
            if (this._cachedClass == null) {
                try {
                    this._cachedClass = this._bundle.loadClass(this._className);
                }
                catch (ClassNotFoundException cnfe) {
                    Manager.Ffdc.log(cnfe, this, "com.ibm.ws.util.ClassResolverImpl.resolveClass", "116", this);
                }
            }
            if (this._cachedClass != null) {
                if (!this._className.equals(className)) {
                    int dimensions = 0;
                    while (className.charAt(dimensions) == '[') {
                        ++dimensions;
                    }
                    Object obj = Array.newInstance(this._cachedClass, new int[dimensions]);
                    clazz = obj.getClass();
                } else {
                    clazz = this._cachedClass;
                }
            } else {
                clazz = null;
            }
            return clazz;
        }
    }
}

