/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.uow;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.UOWCallback;
import com.ibm.ws.Transaction.UOWCoordinator;
import java.util.ArrayList;
import java.util.Iterator;

public class UOWCallbackManager {
    private static final TraceComponent tc = Tr.register(UOWCallbackManager.class, "Transaction", null);
    private ArrayList<UOWCallback> _callbacks;

    public void addCallback(UOWCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addCallback", callback);
        }
        if (this._callbacks == null) {
            this._callbacks = new ArrayList();
        }
        this._callbacks.add(callback);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addCallback");
        }
    }

    public void notifyCallbacks(int contextChangeType, UOWCoordinator coord) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyCallbacks", new Object[]{contextChangeType, coord});
        }
        if (this._callbacks != null) {
            Iterator<UOWCallback> callbacks = this._callbacks.iterator();
            while (callbacks.hasNext()) {
                callbacks.next().contextChange(contextChangeType, coord);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyCallbacks");
        }
    }
}

