/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.SSLAdmin;
import com.ibm.ws390.management.ProxyMBeanSupport;
import com.ibm.ws390.management.ServantMBeanInvoker;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class SSLAdminProxy
extends ProxyMBeanSupport {
    private static final TraceComponent tc = Tr.register(SSLAdminProxy.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private final ServantMBeanInvoker _mbeanInvoker;
    private final SSLAdmin _target;

    public SSLAdminProxy() throws Exception {
        this("SSLAdminProxy");
    }

    public SSLAdminProxy(String beanType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", beanType);
        }
        this._mbeanInvoker = this.getInvoker();
        this._target = new SSLAdmin();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", (Object)this);
        }
    }

    public HashMap retrieveSigners(String keyStoreName, String specificAlias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveSigners", new Object[]{keyStoreName, specificAlias});
        }
        Object[] parms = new Object[]{keyStoreName, specificAlias};
        String[] sig = new String[]{"java.lang.String", "java.lang.String"};
        HashMap val = (HashMap)this.getValueFromAnyServant("retrieveSigners", parms, sig);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveSigners", val);
        }
        return val;
    }

    public void temporarilyDisableCertificateAuthentication(Long millisToDisable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "temporarilyDisableCertificateAuthentication", new Object[]{millisToDisable});
        }
        Object[] parms = new Object[]{millisToDisable};
        String[] sig = new String[]{"java.lang.Long"};
        this.getValueFromAnyServant("temporarilyDisableCertificateAuthentication", parms, sig);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "temporarilyDisableCertificateAuthentication");
        }
    }

    public Object[] invokeRemoteKeyStoreCommand(String keyStoreName, String method2, Object[] parms) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeRemoteKeyStoreCommand (Proxy CR)", new Object[]{keyStoreName, method2});
        }
        if (method2.equals("createRemoteKeyring") || keyStoreName.equals("NodeDefaultRootStore") || keyStoreName.equals("DmgrDefaultRootStore") || keyStoreName.equals("NodeRSATokenRootStore") || keyStoreName.equals("DmgrRSATokenRootStore")) {
            Object[] val = null;
            val = this._target.invokeRemoteKeyStoreCommand(keyStoreName, method2, parms);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invokeRemoteKeyStoreCommand - from CR only) ", val);
            }
            return val;
        }
        WSKeyStore keyStore = KeyStoreManager.getInstance().getKeyStore(keyStoreName);
        if (keyStore != null && !new Boolean(keyStore.getProperty("com.ibm.ssl.keyStoreReadOnly")).booleanValue()) {
            Object[] val = null;
            val = this._target.invokeRemoteKeyStoreCommand(keyStoreName, method2, parms);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invokeRemoteKeyStoreCommand - from CR only) ", val);
            }
            return val;
        }
        Object[] MBeanParms = new Object[]{keyStoreName, method2, parms};
        String[] sig = new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.Object;"};
        Object[] val = null;
        val = (Object[])this.getValueFromAnyServant("invokeRemoteKeyStoreCommand", MBeanParms, sig);
        if (method2.substring(0, 3).equals("set") | method2.equals("personalCertificateExtract") | method2.equals("receiveCertificate") | method2.equals("store") | method2.equals("deleteEntry")) {
            val = this._target.invokeRemoteKeyStoreCommand(keyStoreName, method2, parms);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invokeRemoteKeyStoreCommand - from CR only) ", val);
            }
            return val;
        }
        if (val == null || val != null && val.length == 0 || val != null && val[0] == null) {
            val = this._target.invokeRemoteKeyStoreCommand(keyStoreName, method2, parms);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invokeRemoteKeyStoreCommand - from CR only (SR return null) ", val);
            }
            return val;
        }
        if (method2.equals("aliases")) {
            Object[] val2 = this._target.invokeRemoteKeyStoreCommand(keyStoreName, method2, parms);
            if (val2 != null) {
                List<String> aliasListSR = Arrays.asList((String[])val);
                List<String> aliasListCR = Arrays.asList((String[])val2);
                ArrayList<String> newAliasList = new ArrayList<String>();
                Iterator<String> iCR = aliasListCR.iterator();
                Iterator<String> iSR = aliasListSR.iterator();
                while (iSR.hasNext()) {
                    newAliasList.add(iSR.next());
                }
                while (iCR.hasNext()) {
                    String x = iCR.next();
                    if (newAliasList.contains(x)) continue;
                    newAliasList.add(x);
                }
                String[] mergedAliasArray = newAliasList.toArray(new String[newAliasList.size()]);
                Object[] mergedAliases = mergedAliasArray;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invokeRemoteKeyStoreCommand - aliases from both SR/CR", mergedAliases);
                }
                return mergedAliases;
            }
        } else if ((method2.equals("isKeyEntry") || method2.equals("isCertificateEntry") || method2.equals("checkIfSignerAlreadyExists") || method2.equals("containsAliasFromUnManagedKeyStore") || method2.equals("containsAlias")) && !((Boolean)val[0]).booleanValue()) {
            return this._target.invokeRemoteKeyStoreCommand(keyStoreName, method2, parms);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeRemoteKeyStoreCommand - from SR only", val);
        }
        return val;
    }

    public X509Certificate getAdminRSAPropagationCertificate() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminRSAPropagationCertificate");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminRSAPropagationCertificate");
        }
        return this._target.getAdminRSAPropagationCertificate();
    }

    public Certificate[] retrieveSignerFromPort(String host, Integer port, String sslCfgAlias) throws Exception {
        Certificate[] certChain;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveSignerFromPort", new Object[]{host, port, sslCfgAlias});
        }
        if ((certChain = this._target.retrieveSignerFromPort(host, port, sslCfgAlias)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "certChain is null, attempt to obtain from a servant");
            }
            Object[] params = new Object[]{host, port, sslCfgAlias};
            String[] signature = new String[]{"java.lang.String", "java.lang.Integer", "java.lang.String"};
            certChain = (Certificate[])this.getValueFromAnyServant("retrieveSignerFromPort", params, signature);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveSignerFromPort", certChain);
        }
        return certChain;
    }
}

