/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.wsspi.ssl.WSPKIClient;
import com.ibm.wsspi.ssl.WSPKIException;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class QueryCACertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(QueryCACertificate.class, "SSL", "com.ibm.ws.ssl.commands.personalCertificates");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certificateAlias = null;
    private KeyStoreInfo ksInfo = null;
    private CertReqInfo certInfo = null;
    private ObjectName caClientObjName = null;
    private ObjectName keyStoreObjName = null;
    private ObjectName certRefObj = null;

    public QueryCACertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public QueryCACertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName security2 = null;
        Object keyFileName = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            security2 = cs.resolve(session, "Cell=:Security=")[0];
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certificateAlias = (String)this.getParameter(CommandConstants.CERTIFICATE_ALIAS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreScope=" + this.keyStoreScope + " certificateRequestAlias=" + this.certificateAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultScope();
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultScope();
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            if (this.ksInfo.getReadOnly().booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.readonly.keystore.CWPKI0699E", new Object[]{this.keyStoreName}, this.keyStoreName + " is marked as a read only key store.  Unable to perform write operations to the key store file.");
                throw new CommandValidationException(msg);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyStoreName);
            this.keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, this.keyStoreScope);
            queryAttrs.clear();
            this.certRefObj = PersonalCertificateHelper.getCertificateObj(session, cs, security2, this.certificateAlias, this.ksInfo);
            if (this.certRefObj != null) {
                String status;
                ObjectName keyStoreObj = (ObjectName)cs.getAttribute(session, this.certRefObj, CommandConstants.KEY_STORE);
                if (keyStoreObj == null || !keyStoreObj.equals(this.keyStoreObjName)) {
                    this.certRefObj = null;
                }
                if ((status = (String)cs.getAttribute(session, this.certRefObj, CommandConstants.CACERTIFICATE_STATUS)) != null && !status.equals(CommandConstants.PENDING)) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.pending.CWPKI0692E", new Object[]{status}, "Certificate reference is in the \"" + status + "\" state.  The certificate needs to be in the \"PENDING\" state to query the Certificate Authority for a completed certificate.");
                    throw new CommandValidationException(msg);
                }
            }
            if (this.certRefObj == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.no.cert.object.CWPKI0688E", new Object[]{this.certificateAlias, this.keyStoreName, this.keyStoreScope}, "There is no Certificate Authority (CA) reference object for certificate alias\"" + this.certificateAlias + "\" in key store \"" + this.keyStoreName + "\" in management scope \"" + this.keyStoreScope + "\".  One must exist to perform this action.");
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.RequestCACertificate.validate", "%c%", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error processing parameters: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            String msg = null;
            ObjectName caClientObjName = (ObjectName)cs.getAttribute(session, this.certRefObj, "caClient");
            boolean certCreated = this.caCertificateQuery(session, cs, this.certificateAlias, this.ksInfo, caClientObjName, this.certRefObj);
            msg = certCreated ? TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.certComplete.CWPKI0708I", new Object[]{this.certificateAlias}, "Certificate " + this.certificateAlias + " is COMPLETE.") : TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.certComplete.CWPKI0709I", new Object[]{this.certificateAlias}, "Certificate " + this.certificateAlias + " is PENDING.");
            result.setResult(msg);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.QueryCACertificate.validate", "250", this);
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean caCertificateQuery(Session session, ConfigService cs, String alias, KeyStoreInfo ksInfo, ObjectName caClientObj, ObjectName certRefObj) throws Exception {
        boolean certCreated = false;
        X509Certificate certFromConfig = null;
        String password = ksInfo.getPassword();
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(ksInfo);
        byte[] certReqBytes = null;
        X509Certificate[] certs = null;
        String method2 = "containsAlias";
        Object[] parms = new Object[]{alias};
        Object[] exists = wsksr.invokeKeyStoreCommand(method2, parms);
        if (((Boolean)exists[0]).booleanValue()) {
            method2 = "getCertificate";
            parms = new Object[]{alias};
            Object[] certReq = wsksr.invokeKeyStoreCommand(method2, parms);
            String certReqFile = CertificateRequestHelper.isKeyCertReq(certFromConfig, alias);
            if (certReqFile == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.not.cert.request.CWPKI0651E", new Object[]{alias}, "Certificate alias \"" + alias + "\" is not a certificate request.");
                throw new CommandValidationException(msg);
            }
            certReqBytes = this.getCertReqBytes(certReqFile);
            String implClassName = (String)cs.getAttribute(session, caClientObj, CommandConstants.CACLIENT_IMPL_CLASS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Implentation class is " + implClassName);
            }
            HashMap customAttrs = this.getCustomAttrs(cs, session, caClientObj);
            WSPKIClient pkiClient = null;
            try {
                pkiClient = (WSPKIClient)Class.forName(implClassName).newInstance();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.personalCertificates.QueryCertificate", "287", this);
                if (!tc.isDebugEnabled()) throw e;
                Tr.debug(tc, "Exception getting WSPKIClient implementation.", new Object[]{e});
                throw e;
            }
            try {
                if (pkiClient == null) {
                    Class<?> c = Class.forName(implClassName, true, ExtClassLoader.getInstance());
                    pkiClient = (WSPKIClient)c.newInstance();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.personalCertificates.caCertificateQuery", "305", this);
                if (!tc.isDebugEnabled()) throw e;
                Tr.debug(tc, "Exception getting WSPKIClient implementation with ExtClassLoader.", new Object[]{e});
                throw e;
            }
            try {
                pkiClient.init(customAttrs);
                certs = pkiClient.queryCertificate(certReqBytes, customAttrs);
                if (certs[0] == null) return certCreated;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cert returned now set it in the key store.");
                }
                method2 = "getKey";
                parms = new Object[]{alias, password.toCharArray()};
                Object[] key = wsksr.invokeKeyStoreCommand(method2, parms);
                if (key != null) {
                    method2 = "setKeyEntryOverwrite";
                    parms = new Object[]{alias, (Key)key[0], password.toCharArray(), certs};
                    wsksr.invokeKeyStoreCommand(method2, parms);
                    certCreated = true;
                }
                if (!certCreated) return certCreated;
                this.makeCACertObjComplete(cs, session, certRefObj);
                return certCreated;
            }
            catch (WSPKIException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.personalCertificates.queryCertificate", "342", this);
                if (!tc.isDebugEnabled()) throw e;
                Tr.debug(tc, "Exception calling WSPKIClient implementation.", new Object[]{e});
                throw e;
            }
        }
        String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.no.cert.CWPKI0689E", new Object[]{alias}, "Certificate \"" + alias + "\" does not exist.  Unable to query the certificate");
        throw new CommandValidationException(msg);
    }

    private byte[] getCertReqBytes(String certReqFile) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertReqBytes");
        }
        FileInputStream fis = null;
        byte[] certReqBytes = null;
        fis = new FileInputStream(certReqFile);
        certReqBytes = new byte[fis.available()];
        fis.read(certReqBytes);
        CertificationRequest certReq = new CertificationRequest(certReqFile, true);
        certReqBytes = certReq.encode();
        if (fis != null) {
            fis.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertReqBytes");
        }
        return certReqBytes;
    }

    private HashMap getCustomAttrs(ConfigService cs, Session session, ObjectName caClientObj) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomAttrs");
        }
        HashMap<String, String> customAttrs = new HashMap<String, String>();
        AttributeList attributeList = cs.getAttributes(session, caClientObj, new String[]{"properties"}, false);
        if (attributeList != null) {
            List props = (List)((Attribute)attributeList.get(0)).getValue();
            for (ObjectName property : props) {
                String propName = (String)cs.getAttribute(session, property, "name");
                String value = (String)cs.getAttribute(session, property, "value");
                if (propName == null || value == null) continue;
                customAttrs.put(propName, value);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomAttrs");
        }
        return customAttrs;
    }

    private void makeCACertObjComplete(ConfigService cs, Session session, ObjectName certObj) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Modify the caCertificate object.");
        }
        AttributeList attrList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.CACERTIFICATE_STATUS, "COMPLETE");
        cs.setAttributes(session, certObj, attrList);
    }
}

