/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.migrate;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.ws.util.PlatformHelperFactory;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class EnableWritableKeyrings
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(EnableWritableKeyrings.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String keyStoreName = null;
    private String scopeName = null;
    private String controlRegionUser = null;
    private String servantRegionUser = null;
    private String keyringPrefix = "safkeyring://";
    private String keyringPrefixHW = "safkeyringhw://";
    private ObjectName pattern = null;
    private ObjectName matches = null;
    private ObjectName security = null;
    private ConfigService cs = null;
    private Session session = null;
    private CommandHelper commandHelper = null;

    public EnableWritableKeyrings(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public EnableWritableKeyrings(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.cs = ConfigServiceFactory.getConfigService();
        this.session = this.getConfigSession();
        this.commandHelper = new CommandHelper();
        try {
            this.pattern = ConfigServiceHelper.createObjectName(null, "Security");
            this.matches = this.cs.resolve(this.session, "Cell=")[0];
            if (this.matches != null) {
                this.security = this.cs.queryConfigObjects(this.session, this.matches, this.pattern, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.controlRegionUser = (String)this.getParameter(CommandConstants.USER_NAME_CONTROL);
            this.servantRegionUser = (String)this.getParameter(CommandConstants.USER_NAME_SERVANT);
            if (this.keyStoreName != null && this.keyStoreName.length() == 0) {
                this.keyStoreName = null;
            }
            if (this.controlRegionUser != null && this.controlRegionUser.length() == 0) {
                this.controlRegionUser = null;
            }
            if (this.servantRegionUser != null && this.servantRegionUser.length() == 0) {
                this.servantRegionUser = null;
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(this.matches);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            } else if (!ManagementScopeHelper.validScopeName(this.session, this.cs, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(msg);
            }
            if (this.controlRegionUser == null && this.servantRegionUser != null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyring.username.required.CWPKI0721E", new Object[]{CommandConstants.USER_NAME_CONTROL, CommandConstants.USER_NAME_SERVANT}, "Parameter " + CommandConstants.USER_NAME_CONTROL + " and parameter " + CommandConstants.USER_NAME_SERVANT + " must be specified together.");
                throw new CommandValidationException(msg);
            }
            if (this.controlRegionUser != null && this.servantRegionUser == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyring.username.required.CWPKI0721E", new Object[]{CommandConstants.USER_NAME_CONTROL, CommandConstants.USER_NAME_SERVANT}, "Parameter " + CommandConstants.USER_NAME_CONTROL + " and parameter " + CommandConstants.USER_NAME_SERVANT + " must be specified together.");
                throw new CommandValidationException(msg);
            }
            if (this.keyStoreName != null) {
                KeyStoreInfo ksInfo = PersonalCertificateHelper.getKsInfo(this.session, this.cs, this.keyStoreName, this.scopeName);
                String keyStoreType = ksInfo.getType();
                if (!keyStoreType.equals("JCERACFKS") && !keyStoreType.equals("JCECCARACFKS")) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.bad.type.CWPKI0694E", new Object[]{keyStoreType}, "CWPKI0694E: \"" + keyStoreType + "\" is not a valid key store type");
                    throw new CommandValidationException(msg);
                }
                if ((keyStoreType.equals("JCERACFKS") || keyStoreType.equals("JCECCARACFKS")) && !PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.bad.type.CWPKI0694E", new Object[]{keyStoreType}, "CWPKI0694E: \"" + keyStoreType + "\" is not a valid key store type.");
                    throw new CommandValidationException(msg);
                }
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception is" + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            KeyStoreInfo ksInfo = PersonalCertificateHelper.getKsInfo(this.session, this.cs, this.keyStoreName, this.scopeName);
            this.augmentKeyStore(ksInfo, this.controlRegionUser, this.servantRegionUser);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private void augmentKeyStore(KeyStoreInfo ksInfo, String controlRegionUser, String servantRegionUser) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "augmentKeyStore");
        }
        String keyStoreName = ksInfo.getName();
        String keyStoreType = ksInfo.getType();
        String keyStorePassword = ksInfo.getPassword();
        Boolean keyStoreIsFileBased = ksInfo.getFileBased();
        String keyStoreLocation = ksInfo.getLocation();
        String keyStoreProvider = ksInfo.getProvider();
        String keyStoreHostList = ksInfo.getHostList();
        Boolean keyStoreInitAtStartup = ksInfo.getInitializeAtStartup();
        Boolean keyStoreStashFile = ksInfo.getStashFile();
        Boolean keyStoreForAcceleration = ksInfo.getAccelerator();
        String keyStoreCustomProvider = ksInfo.getCustomProvider();
        String scopeNameString = ksInfo.getScopeNameString();
        ObjectName mgmScopeObjName = ksInfo.getScopeName();
        AttributeList attrList = new AttributeList();
        String keyStoreNameCR = null;
        String keyStoreNameSR = null;
        String keyStoreLocationCR = null;
        String keyStoreLocationSR = null;
        String keyStoreDescriptionCR = null;
        String keyStoreDescriptionSR = null;
        boolean create = false;
        if (SSLConfigManager.getInstance().isServerProcess()) {
            create = true;
        }
        if (keyStoreLocation.startsWith(this.keyringPrefixHW)) {
            this.keyringPrefix = this.keyringPrefixHW;
        }
        keyStoreNameCR = keyStoreName + "-CR";
        keyStoreNameSR = keyStoreName + "-SR";
        if (keyStoreLocation.startsWith(this.keyringPrefix + "/")) {
            int end = keyStoreLocation.lastIndexOf("/");
            if (controlRegionUser != null && servantRegionUser != null) {
                keyStoreLocationCR = this.keyringPrefix + controlRegionUser + "/" + keyStoreLocation.substring(end + 1);
                keyStoreLocationSR = this.keyringPrefix + servantRegionUser + "/" + keyStoreLocation.substring(end + 1);
                keyStoreDescriptionCR = TraceNLSHelper.getInstance().getFormattedMessage("keyStoreDescriptionCR", new Object[]{keyStoreName}, "Writable control region keyring for keystore " + keyStoreName);
                keyStoreDescriptionSR = TraceNLSHelper.getInstance().getFormattedMessage("keyStoreDescriptionSR", new Object[]{keyStoreName}, "Writable servant region keyring for keystore " + keyStoreName);
            }
        } else {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyring.uri.invalid.CWPKI0713E", new Object[]{keyStoreLocation}, "The SAF keyring location specified as \"" + keyStoreLocation + "\", is not valid.");
            throw new CommandValidationException(msg);
        }
        if (keyStoreName.endsWith("DefaultRootStore") || keyStoreName.endsWith("RSATokenRootStore") || keyStoreName.endsWith("DefaultSignersStore")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyStore only has single keyring, modify directly");
            }
            if (!ksInfo.getReadOnly().booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keystore.already.modified.CWPKI0727E", new Object[]{keyStoreName}, "CWPKI0727E: Keystore " + keyStoreName + " has already been enabled for writable keyrings.");
                throw new CommandValidationException(msg);
            }
            attrList.clear();
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NAME, keyStoreName);
            ObjectName keyStoreObjName = this.commandHelper.getObjectName(this.cs, this.session, this.security, CommandConstants.KEY_STORES, attrList, this.scopeName);
            attrList.clear();
            attrList.add(new Attribute("location", keyStoreLocationCR));
            attrList.add(new Attribute("readOnly", false));
            this.cs.setAttributes(this.session, keyStoreObjName, attrList);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating writable control and servant region keystore objects");
            }
            attrList.clear();
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NAME, keyStoreNameCR);
            Boolean keyStoreFoundCR = this.commandHelper.exists(this.cs, this.session, this.security, CommandConstants.KEY_STORES, attrList, this.scopeName);
            attrList.clear();
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NAME, keyStoreNameSR);
            Boolean keyStoreFoundSR = this.commandHelper.exists(this.cs, this.session, this.security, CommandConstants.KEY_STORES, attrList, this.scopeName);
            if (keyStoreFoundCR.booleanValue() && keyStoreFoundSR.booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keystore.already.modified.CWPKI0727E", new Object[]{keyStoreName}, "CWPKI0727E: Keystore " + keyStoreName + " has already been enabled as a writable keyring.");
                throw new CommandValidationException(msg);
            }
            try {
                if (!keyStoreFoundCR.booleanValue()) {
                    KeyStoreInfo ksInfoCR = new KeyStoreInfo(keyStoreNameCR, keyStoreLocationCR, keyStorePassword, keyStoreProvider, keyStoreType, keyStoreIsFileBased, keyStoreHostList, scopeNameString, mgmScopeObjName, false, keyStoreInitAtStartup, keyStoreStashFile, keyStoreCustomProvider, null, keyStoreForAcceleration, null, keyStoreDescriptionCR);
                    ksInfoCR.setUsage(keyStoreName);
                    ObjectName objectCreatedCR = KeyStoreHelper.createKeyStoreCmd(this.session, ksInfoCR, false, create);
                    attrList.clear();
                    ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.MANAGEMENT_SCOPE, mgmScopeObjName);
                    this.cs.setAttributes(this.session, objectCreatedCR, attrList);
                    attrList.clear();
                }
            }
            catch (Exception e) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keystore.create.error.CWPKI0730E", new Object[]{keyStoreNameCR, e.getMessage()}, "Error creating keystore " + keyStoreNameCR + ". Extended message: " + e.getMessage());
                throw new Exception(msg);
            }
            try {
                if (!keyStoreFoundSR.booleanValue()) {
                    KeyStoreInfo ksInfoSR = new KeyStoreInfo(keyStoreNameSR, keyStoreLocationSR, keyStorePassword, keyStoreProvider, keyStoreType, keyStoreIsFileBased, keyStoreHostList, scopeNameString, mgmScopeObjName, false, keyStoreInitAtStartup, keyStoreStashFile, keyStoreCustomProvider, null, keyStoreForAcceleration, null, keyStoreDescriptionSR);
                    ksInfoSR.setUsage(keyStoreName);
                    ObjectName objectCreatedSR = KeyStoreHelper.createKeyStoreCmd(this.session, ksInfoSR, false, create);
                    attrList.clear();
                    ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.MANAGEMENT_SCOPE, mgmScopeObjName);
                    this.cs.setAttributes(this.session, objectCreatedSR, attrList);
                    attrList.clear();
                }
            }
            catch (Exception e) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keystore.create.error.CWPKI0730E", new Object[]{keyStoreNameSR, e.getMessage()}, "Error creating keystore " + keyStoreNameSR + ". Extended message: " + e.getMessage());
                throw new Exception(msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "augmentKeyStore");
        }
    }
}

