/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ChangeKeyStorePassword
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ChangeKeyStorePassword.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String keyStoreName = null;
    private String scopeName = null;
    private String keyStorePassword = null;
    private String newKeyStorePassword = null;
    private String newKeyStorePasswordVerify = null;
    ObjectName keyStoreObjName = null;
    KeyStoreInfo ksInfo = null;

    public ChangeKeyStorePassword(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ChangeKeyStorePassword(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName pattern = null;
        ObjectName matches = null;
        ObjectName security2 = null;
        try {
            pattern = ConfigServiceHelper.createObjectName(null, "Security");
            matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.keyStorePassword = (String)this.getParameter(CommandConstants.KEY_STORE_PASSWORD);
            this.newKeyStorePassword = (String)this.getParameter(CommandConstants.NEW_KEY_STORE_PASSWORD);
            this.newKeyStorePasswordVerify = (String)this.getParameter(CommandConstants.NEW_KEY_STORE_PASSWORD_VERIFY);
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
                Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyStoreName);
            this.keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, this.scopeName);
            if (this.keyStoreObjName == null) {
                String msg = this.keyStoreName + " object not found.";
                throw new CommandValidationException(msg);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.scopeName);
            if (this.ksInfo == null) {
                String msg = this.keyStoreName + " object not found.";
                throw new CommandValidationException(msg);
            }
            if (!PersonalCertificateHelper.verifyKeyPassword(this.ksInfo, this.keyStorePassword)) {
                String msg = TraceNLSHelper.getInstance().getString("sl.command.check.key.store.CWPKI0671E", "Key store did not verify.  Make sure the file exists, check the key file type and password.");
                throw new CommandValidationException(msg);
            }
            if (!KeyStoreHelper.passwordVerify(this.newKeyStorePassword, this.newKeyStorePasswordVerify)) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.keyStore.password.not.confirm.CWPKI0619E", "Passwords do not match.");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Password do not match during password conformation.");
                }
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        Object security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            this.changeKSPassword(this.ksInfo, this.newKeyStorePassword);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private void changeKSPassword(KeyStoreInfo info, String newPassword) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeKSPassword");
        }
        Boolean readOnly = info.getReadOnly();
        Boolean isFileBased = info.getFileBased();
        String keyStorePassword = info.getPassword();
        String keyStoreType = info.getType();
        Object tempFileName = null;
        String keyStorePath = info.getLocation();
        String filePath = KeyStoreManager.getInstance().expand(keyStorePath);
        if (readOnly != null && !readOnly.booleanValue() && isFileBased.booleanValue()) {
            if (keyStoreType.equals("CMSKS") || keyStoreType.equals("IBMi5OSKeyStore")) {
                KeyStoreHelper.changePasswordCMS(info, newPassword);
            } else if (keyStoreType.equals("PKCS12")) {
                KeyStoreHelper.changePasswordPKCS12(info, newPassword);
            } else {
                WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
                KeyStoreHelper.changePassword(wsksr, keyStorePassword, newPassword);
            }
            try {
                ConfigService cs = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                ObjectName sec2 = cs.resolve(session, "Cell=:Security=")[0];
                AttributeList attrList = new AttributeList();
                ConfigServiceHelper.setAttributeValue(attrList, "password", newPassword);
                cs.setAttributes(session, this.keyStoreObjName, attrList);
                PersonalCertificateHelper.setWorkspaceUpdated(session, info.getLocation());
                if (info.getStashFile().booleanValue()) {
                    File file;
                    String workSpaceKeyFileName = info.getLocation();
                    String workSpaceStashFileName = null;
                    int index = workSpaceKeyFileName.lastIndexOf(".");
                    workSpaceStashFileName = index != -1 ? workSpaceKeyFileName.substring(0, index + 1) + "sth" : workSpaceKeyFileName + ".sth";
                    if (workSpaceStashFileName != null && (file = new File(workSpaceStashFileName)).isFile() && file.canWrite()) {
                        PersonalCertificateHelper.setWorkspaceUpdated(session, workSpaceStashFileName);
                    }
                }
                AttributeList attrs = cs.getAttributes(session, sec2, new String[]{CommandConstants.KEY_SETS}, false);
                List keySets = (List)((Attribute)attrs.get(0)).getValue();
                for (ObjectName keySet : keySets) {
                    String pwd;
                    ObjectName keyStore = (ObjectName)cs.getAttribute(session, keySet, CommandConstants.KEY_STORE);
                    if (keyStore == null || !keyStore.equals(this.keyStoreObjName) || (pwd = (String)cs.getAttribute(session, keySet, "password")) == null) continue;
                    attrList.clear();
                    ConfigServiceHelper.setAttributeValue(attrList, "password", newPassword);
                    cs.setAttributes(session, keySet, attrList);
                }
                cs.save(session, true);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        } else {
            String msg = TraceNLSHelper.getInstance().getString("sl.command.check.key.store.CWPKI0670E", "Unable to change the key store password.  The key store is either a read only store or it is not a file based key store.");
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeKSPassword");
        }
    }
}

