/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.certificateRequests;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListCertificateRequests
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListCertificateRequests.class, "SSL", "com.ibm.ws.ssl.commands.certificateRequests");
    private String keyStoreName = null;
    private String scopeName = null;

    public ListCertificateRequests(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListCertificateRequests(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(cell);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            }
            result.setResult(this.certificateRequestList(session, cs, this.keyStoreName, this.scopeName));
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    public List certificateRequestList(Session session, ConfigService cs, String keyStore, String scope) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "certificateRequestList");
        }
        KeyStoreInfo keyStoreInfo = null;
        List certList = null;
        try {
            keyStoreInfo = PersonalCertificateHelper.getKsInfo(session, cs, keyStore, scope);
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        try {
            certList = this.getCertificateRequests(keyStoreInfo);
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "certificateRequestList");
        }
        return certList;
    }

    public List getCertificateRequests(KeyStoreInfo keyStoreInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificateRequests");
        }
        ArrayList<AttributeList> certRequests = new ArrayList<AttributeList>();
        AttributeList certAttr = null;
        String certReqFile = null;
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStoreInfo);
        try {
            String method2 = "aliases";
            Object[] parms = null;
            Object[] aliases = wsksr.invokeKeyStoreCommand(method2, parms);
            if (aliases != null) {
                for (int i = 0; i < aliases.length; ++i) {
                    String alias = (String)aliases[i];
                    method2 = "isKeyEntry";
                    parms = new Object[]{alias};
                    Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                    if (!((Boolean)isKeyEntry[0]).booleanValue()) continue;
                    method2 = "getCertificate";
                    parms = new Object[]{alias};
                    Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                    X509Certificate cert = (X509Certificate)certArray[0];
                    certReqFile = CertificateRequestHelper.isKeyCertReq(cert, alias);
                    if (certReqFile == null) continue;
                    certAttr = CertificateRequestHelper.certReqAttrlist(alias, cert, certReqFile);
                    certRequests.add(certAttr);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Alias list from keystore is null.  The server mbean may not be availible.");
            }
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "certificateRequestList");
        }
        return certRequests;
    }
}

