/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSSchedule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.crypto.config.WSScheduler;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import java.util.Date;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateWSSchedule
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateWSSchedule.class, "SSL", "com.ibm.ws.ssl.commands");
    private String wsScheduleName = null;
    private Integer frequency = null;
    private Integer hour = null;
    private Integer minute = null;
    private Integer dayOfWeek = null;
    private Long nextStartDate = null;

    public CreateWSSchedule(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateWSSchedule(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        boolean wsScheduleNameFound = false;
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            Date startDate;
            WSScheduler schedule;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.wsScheduleName = (String)this.getParameter(CommandConstants.NAME);
            this.frequency = (Integer)this.getParameter(CommandConstants.FREQUENCY);
            this.dayOfWeek = (Integer)this.getParameter(CommandConstants.DAY_OF_WEEK);
            this.hour = (Integer)this.getParameter(CommandConstants.HOUR);
            this.minute = (Integer)this.getParameter(CommandConstants.MINUTE);
            this.nextStartDate = (Long)this.getParameter(CommandConstants.NEXT_START_DATE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsScheduleName: " + this.wsScheduleName);
            }
            if (this.frequency < 0) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.scheduler.frequency.range.CWPKI0622E", "Schedule frequency is not a positive integer.");
                throw new CommandValidationException(msg);
            }
            if (this.dayOfWeek != null && (this.dayOfWeek < 1 || this.dayOfWeek > 7)) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.scheduler.dayOfWeek.range.CWPKI0624E", "Day of the week value is out of range.  It should be between 1 and 7.");
                throw new CommandValidationException(msg);
            }
            if (this.minute < 0 || this.minute > 59) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.scheduler.minute.range.CWPKI0623E", "Minute value is out of range.  It should be between 0 and 60.");
                throw new CommandValidationException(msg);
            }
            if (this.hour < 0 || this.hour > 23) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.scheduler.hour.range.CWPKI0625E", "Hour value is out of range.  It should be between 0 and 24.");
                throw new CommandValidationException(msg);
            }
            int day = this.dayOfWeek != null ? this.dayOfWeek : 0;
            if (this.nextStartDate == null) {
                schedule = new WSScheduler(this.frequency, day, this.hour, this.minute);
                startDate = schedule.getNextEventDateFromNow();
                this.nextStartDate = new Long(startDate.getTime());
            } else if (this.nextStartDate >= 0L) {
                schedule = new WSScheduler(this.frequency, day, this.hour, this.minute);
                startDate = null;
                long currentDate = System.currentTimeMillis();
                if (this.nextStartDate < currentDate) {
                    startDate = schedule.getNextEventDateFromNow();
                } else {
                    Date nextDate = new Date(this.nextStartDate);
                    startDate = schedule.getNextEventDateFromDate(nextDate);
                }
                this.nextStartDate = new Long(startDate.getTime());
            } else if (this.nextStartDate < 0L) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.schedule.nextstartdate.CWPKI0660E", "The next start date must be a positive number.");
                throw new CommandValidationException(msg);
            }
            CommandHelper commandHelper = new CommandHelper();
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.wsScheduleName);
            wsScheduleNameFound = commandHelper.exists(cs, session, security2, CommandConstants.WS_SCHEDULES, queryAttrs, null);
            if (wsScheduleNameFound) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.exists.CWPKI0621E=CWPKI0621E", new Object[]{this.wsScheduleName}, this.wsScheduleName + " already exists.");
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.createWSSchedule.validate", "159", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            AttributeList attrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NAME, this.wsScheduleName);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.FREQUENCY, this.frequency);
            if (this.dayOfWeek != null) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.DAY_OF_WEEK, this.dayOfWeek);
            }
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.HOUR, this.hour);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.MINUTE, this.minute);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NEXT_START_DATE, this.nextStartDate);
            ObjectName wsSchedule = cs.createConfigData(session, security2, CommandConstants.WS_SCHEDULES, null, attrList);
            if (wsSchedule != null) {
                result.setResult(wsSchedule);
            }
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

