/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSCertExpMonitor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class GetWSCertExpMonitor
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GetWSCertExpMonitor.class, "SSL", "com.ibm.ws.ssl.commands");
    private String wsCertExpMonitorName = null;

    public GetWSCertExpMonitor(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public GetWSCertExpMonitor(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            String name;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.wsCertExpMonitorName = (String)this.getParameter(CommandConstants.NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsCertExpMonitorName: " + this.wsCertExpMonitorName);
            }
            boolean wsCertExpMonitorNameFound = false;
            AttributeList wsCertExpMonitor = (AttributeList)cs.getAttribute(session, security2, CommandConstants.WS_CERT_EXP_MONITOR);
            if (wsCertExpMonitor != null && this.wsCertExpMonitorName.equals(name = (String)ConfigServiceHelper.getAttributeValue(wsCertExpMonitor, CommandConstants.NAME))) {
                wsCertExpMonitorNameFound = true;
            }
            if (!wsCertExpMonitorNameFound) {
                String msg = "wsCertExpMonitor name not found.";
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.getWSCertExpMonitor.validate", "124");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            AttributeList wsCertExpMonitor;
            String name;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            if (this.wsCertExpMonitorName.equals(name = (String)ConfigServiceHelper.getAttributeValue(wsCertExpMonitor = (AttributeList)cs.getAttribute(session, security2, CommandConstants.WS_CERT_EXP_MONITOR), CommandConstants.NAME))) {
                result.setResult(wsCertExpMonitor);
            }
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

