/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfigGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class GetSSLConfigGroup
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GetSSLConfigGroup.class, "SSL", "com.ibm.ws.ssl.commands");
    private String sslConfigGroupName = null;
    private String direction = null;
    private String scopeName = null;
    private ObjectName sslConfigGroupObjName = null;

    public GetSSLConfigGroup(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public GetSSLConfigGroup(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.sslConfigGroupName = (String)this.getParameter(CommandConstants.NAME);
            this.direction = (String)this.getParameter(CommandConstants.DIRECTION);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslConfigGroupName: " + this.sslConfigGroupName);
                Tr.debug(tc, "direction: " + this.direction);
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
            }
            if (this.direction != null && !this.direction.equalsIgnoreCase("inbound") && !this.direction.equalsIgnoreCase("outbound")) {
                String msg = "Invalid direction value: " + this.direction;
                throw new CommandValidationException(msg);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.sslConfigGroupName);
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.DIRECTION, this.direction);
            this.sslConfigGroupObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.SSL_CONFIG_GROUPS, queryAttrs, this.scopeName);
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.getSSLConfigGroup.validate", "146");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            AttributeList sslConfigGroup = cs.getAttributes(session, this.sslConfigGroupObjName, null, true);
            result.setResult(sslConfigGroup);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

