/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfigGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateSSLConfigGroup
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateSSLConfigGroup.class, "SSL", "com.ibm.ws.ssl.commands");
    private String name = null;
    private String direction = null;
    private String certificateAlias = null;
    private String scopeName = null;
    private String sslConfigAliasName = null;
    private String sslConfigScopeName = null;
    private ObjectName scopeObjName = null;
    private ObjectName sslConfigObjName = null;
    private boolean createMgmScope = false;

    public CreateSSLConfigGroup(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateSSLConfigGroup(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.name = (String)this.getParameter(CommandConstants.NAME);
            this.direction = (String)this.getParameter(CommandConstants.DIRECTION);
            this.certificateAlias = (String)this.getParameter(CommandConstants.CERTIFICATE_ALIAS);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.sslConfigAliasName = (String)this.getParameter(CommandConstants.SSL_CONFIG_ALIAS_NAME);
            this.sslConfigScopeName = (String)this.getParameter(CommandConstants.SSL_CONFIG_SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLConfigGroup: " + this.name);
                Tr.debug(tc, "direction: " + this.direction);
                Tr.debug(tc, "scopeName: " + this.scopeName);
                Tr.debug(tc, "sslConfigScopeName: " + this.sslConfigScopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
            } else if (!ManagementScopeHelper.validScopeName(session, cs, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(msg);
            }
            if (this.sslConfigScopeName == null) {
                this.sslConfigScopeName = commandHelper.defaultCellScope(matches);
            }
            if (this.direction != null && !this.direction.equalsIgnoreCase("inbound") && !this.direction.equalsIgnoreCase("outbound")) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.direction.CWPKI0614E", "Direction is not valid.  Should be inbound or outbound.");
                throw new CommandValidationException(msg);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.name);
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.DIRECTION, this.direction);
            boolean sslConfigGroupNameFound = commandHelper.exists(cs, session, security2, CommandConstants.SSL_CONFIG_GROUPS, queryAttrs, this.scopeName);
            if (sslConfigGroupNameFound) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.SSLConfigGroup.already.exists.CWPKI0615E", new Object[]{this.name, this.direction, this.scopeName}, "SSL configuration group " + this.name + " in direction " + this.direction + " and management scope " + this.scopeName + " already exists.");
                throw new CommandValidationException(msg);
            }
            queryAttrs.clear();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.scopeName);
            boolean mgmScopeNameFound = commandHelper.exists(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
            if (!mgmScopeNameFound) {
                this.createMgmScope = true;
            } else {
                this.scopeObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scopeObjName: " + this.scopeObjName);
                }
            }
            if (this.sslConfigAliasName != null) {
                queryAttrs.clear();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.ALIAS, this.sslConfigAliasName);
                this.sslConfigObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, this.sslConfigScopeName);
                AttributeList attrList = cs.getAttributes(session, this.sslConfigObjName, null, true);
                if (attrList != null) {
                    boolean inScope = commandHelper.withInScope(cs, session, attrList, this.scopeName);
                    if (!inScope) {
                        String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.SSLConfig.config.not.within.scope.CWPKI0616E", new Object[]{this.sslConfigAliasName}, "SSL Configuration " + this.sslConfigAliasName + " is not with in the same management scope as the SSL configuration group.");
                        throw new CommandValidationException(msg);
                    }
                } else {
                    String msg = "Attribute list for SSLConfig is null.";
                    throw new CommandValidationException(msg);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslConfigObjName: " + this.sslConfigObjName);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.createSSLConfigGroup.validate", "216", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            AttributeList attrList = new AttributeList();
            if (this.createMgmScope) {
                ManagementScopeData scopeData = new ManagementScopeData(this.scopeName);
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_NAME, this.scopeName);
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_TYPE, scopeData.getScopeType());
                this.scopeObjName = cs.createConfigData(session, security2, CommandConstants.MANAGEMENT_SCOPES, null, attrList);
                attrList.clear();
            }
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NAME, this.name);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.DIRECTION, this.direction);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.CERTIFICATE_ALIAS, this.certificateAlias);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SSL_CONFIG, this.sslConfigObjName);
            ObjectName sslConfigGroup = cs.createConfigData(session, security2, CommandConstants.SSL_CONFIG_GROUPS, null, attrList);
            if (sslConfigGroup != null) {
                result.setResult(sslConfigGroup);
            }
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

