/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifySSLConfig
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ModifySSLConfig.class, "SSL", "com.ibm.ws.ssl.commands");
    private String aliasName = null;
    private String clientKeyAlias = null;
    private String serverKeyAlias = null;
    private String scopeName = null;
    private Boolean clientAuthentication = null;
    private String securityLevel = null;
    private String enabledCiphers = null;
    private String jsseProvider = null;
    private Boolean clientAuthenticationSupported = null;
    private String sslProtocol = null;
    private String trustManagerObjNames = null;
    private String keyManagerName = null;
    private String keyManagerScopeName = null;
    private String keyStoreName = null;
    private String keyStoreScopeName = null;
    private String trustStoreName = null;
    private String trustStoreScopeName = null;
    private ObjectName sslConfigObjName = null;
    private ObjectName scopeObjName = null;
    private ObjectName trustStoreObjName = null;
    private ObjectName keyStoreObjName = null;
    private ObjectName keyManagerObjName = null;
    private List trustManagerObjNameList = null;
    private String keyFileName = null;
    private String SSLConfigType = "JSSE";
    private Integer timeout = null;

    public ModifySSLConfig(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ModifySSLConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        boolean defaultScope = false;
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.aliasName = (String)this.getParameter(CommandConstants.ALIAS);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.clientKeyAlias = (String)this.getParameter(CommandConstants.CLIENT_KEY_ALIAS);
            this.serverKeyAlias = (String)this.getParameter(CommandConstants.SERVER_KEY_ALIAS);
            this.clientAuthentication = (Boolean)this.getParameter(CommandConstants.CLIENT_AUTHENTICATION);
            this.securityLevel = (String)this.getParameter(CommandConstants.SECURITY_LEVEL);
            this.enabledCiphers = (String)this.getParameter(CommandConstants.ENABLED_CIPHERS);
            this.jsseProvider = (String)this.getParameter(CommandConstants.JSSE_PROVIDER);
            this.clientAuthenticationSupported = (Boolean)this.getParameter(CommandConstants.CLIENT_AUTHENTICATION_SUPPORTED);
            this.sslProtocol = (String)this.getParameter(CommandConstants.SSL_PROTOCOL);
            this.trustManagerObjNames = (String)this.getParameter(CommandConstants.TRUST_MANAGER_OBJECT_NAMES);
            this.trustStoreName = (String)this.getParameter(CommandConstants.TRUST_STORE_NAME);
            this.trustStoreScopeName = (String)this.getParameter(CommandConstants.TRUST_STORE_SCOPE_NAME);
            this.keyManagerName = (String)this.getParameter(CommandConstants.KEY_MANAGER_NAME);
            this.keyManagerScopeName = (String)this.getParameter(CommandConstants.KEY_MANAGER_SCOPE_NAME);
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScopeName = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE_NAME);
            this.keyFileName = (String)this.getParameter(CommandConstants.SSSL_KEY_RING_NAME);
            this.timeout = (Integer)this.getParameter(CommandConstants.SSSL_V3_TIME_OUT);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLConfig aliasName:  " + this.aliasName);
                Tr.debug(tc, "scopeName:            " + this.scopeName);
                Tr.debug(tc, "clientKeyAlias:       " + this.clientKeyAlias);
                Tr.debug(tc, "serverKeyAlias:       " + this.serverKeyAlias);
                Tr.debug(tc, "clientAuthentication: " + this.clientAuthentication);
                Tr.debug(tc, "securityLevel:        " + this.securityLevel);
                Tr.debug(tc, "enabledCiphers:       " + this.enabledCiphers);
                Tr.debug(tc, "jsseProvider:         " + this.jsseProvider);
                Tr.debug(tc, "clientAuthSupported:  " + this.clientAuthenticationSupported);
                Tr.debug(tc, "sslProtocol:          " + this.sslProtocol);
                Tr.debug(tc, "trustManagerObjNames: " + this.trustManagerObjNames);
                Tr.debug(tc, "trustStoreName:       " + this.trustStoreName);
                Tr.debug(tc, "trustStoreScopeName:  " + this.trustStoreScopeName);
                Tr.debug(tc, "keyManagerName:       " + this.keyManagerName);
                Tr.debug(tc, "keyManagerScopeName:  " + this.keyManagerScopeName);
                Tr.debug(tc, "keyStoreName:         " + this.keyStoreName);
                Tr.debug(tc, "keyStoreScopeName:    " + this.keyStoreScopeName);
                Tr.debug(tc, "keyFileName:          " + this.keyFileName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
                defaultScope = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            }
            AttributeList queryAttrs = new AttributeList();
            try {
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.ALIAS, this.aliasName);
                this.sslConfigObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, this.scopeName);
            }
            catch (CommandValidationException e) {
                if (defaultScope) {
                    ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.ALIAS, this.aliasName);
                    this.sslConfigObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, null);
                }
                throw e;
            }
            if (this.sslConfigObjName != null) {
                this.SSLConfigType = (String)cs.getAttribute(session, this.sslConfigObjName, CommandConstants.TYPE);
            }
            if (this.securityLevel != null && !commandHelper.contains(CommandConstants.SSLSecurityLevel, this.securityLevel)) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.securityLevel.CWPKI611E", "SSL security level is not valid.  Should be HIGH, MEDIUM, LOW, or CUSTOM.");
                throw new CommandValidationException(msg);
            }
            if (this.sslProtocol != null && !commandHelper.contains(CommandConstants.SSLProtocol, this.sslProtocol)) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.protocol.CWPKI612E", "SSL protocol is not valid.  Should be SSL_TLS, SSL, SSLv2, SSLv3, TLS, or TLSv1.");
                throw new CommandValidationException(msg);
            }
            if (this.SSLConfigType.equalsIgnoreCase("JSSE")) {
                String msg;
                boolean inScope;
                AttributeList attrList;
                if (this.sslConfigObjName == null) {
                    String msg2 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.aliasName, this.scopeName}, this.aliasName + " does not exist within management scope " + this.scopeName + ".");
                    throw new CommandValidationException(msg2);
                }
                if (this.keyManagerScopeName == null) {
                    this.keyManagerScopeName = commandHelper.defaultCellScope(matches);
                }
                if (this.keyStoreScopeName == null) {
                    this.keyStoreScopeName = commandHelper.defaultCellScope(matches);
                }
                if (this.trustStoreScopeName == null) {
                    this.trustStoreScopeName = commandHelper.defaultCellScope(matches);
                }
                queryAttrs.clear();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.scopeName);
                this.scopeObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
                if (this.trustManagerObjNames != null) {
                    String[] trustManagers = this.trustManagerObjNames.split(":");
                    this.trustManagerObjNameList = new ArrayList();
                    for (int i = 0; i < trustManagers.length; ++i) {
                        ObjectName trustManagerObjName;
                        if (trustManagers[i] == null) continue;
                        String id = trustManagers[i];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "trustManagers[i]: " + trustManagers[i]);
                        }
                        if (trustManagers[i].indexOf("(") != -1 && trustManagers[i].indexOf(")") != -1) {
                            id = trustManagers[i].substring(trustManagers[i].indexOf("(") + 1, trustManagers[i].indexOf(")"));
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "id: " + id);
                            }
                        }
                        if ((trustManagerObjName = commandHelper.getObjectWithinScope(cs, session, "TrustManager", id, this.scopeName)) == null) continue;
                        this.trustManagerObjNameList.add(trustManagerObjName);
                    }
                }
                if (this.keyManagerName != null) {
                    queryAttrs.clear();
                    ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyManagerName);
                    this.keyManagerObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_MANAGERS, queryAttrs, this.keyManagerScopeName);
                    attrList = cs.getAttributes(session, this.keyManagerObjName, null, true);
                    if (attrList != null && !(inScope = commandHelper.withInScope(cs, session, attrList, this.scopeName))) {
                        msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.keyManagerName, this.scopeName}, "Object " + this.keyManagerName + " does not exist within management scope " + this.scopeName);
                        throw new CommandValidationException(msg);
                    }
                }
                if (this.trustStoreName != null) {
                    queryAttrs.clear();
                    ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.trustStoreName);
                    this.trustStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, this.trustStoreScopeName);
                    attrList = cs.getAttributes(session, this.trustStoreObjName, null, true);
                    if (attrList != null && !(inScope = commandHelper.withInScope(cs, session, attrList, this.scopeName))) {
                        msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.trustStoreName, this.scopeName}, "Object " + this.trustStoreName + " does not exist within management scope " + this.scopeName);
                        throw new CommandValidationException(msg);
                    }
                }
                if (this.keyStoreName != null) {
                    queryAttrs.clear();
                    ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyStoreName);
                    this.keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, this.keyStoreScopeName);
                    attrList = cs.getAttributes(session, this.keyStoreObjName, null, true);
                    if (attrList != null && !(inScope = commandHelper.withInScope(cs, session, attrList, this.scopeName))) {
                        msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.keyStoreName, this.scopeName}, "Object " + this.keyStoreName + " does not exist within management scope " + this.scopeName);
                        throw new CommandValidationException(msg);
                    }
                }
                if (this.clientKeyAlias != null && this.clientKeyAlias.length() > 0 || this.serverKeyAlias != null && this.serverKeyAlias.length() > 0) {
                    KeyStore ks = null;
                    if (this.keyStoreObjName != null) {
                        ks = (KeyStore)MOFUtil.convertToEObject((Session)session, (ObjectName)this.keyStoreObjName);
                    } else {
                        AttributeList repertoire = cs.getAttributes(session, this.sslConfigObjName, null, true);
                        AttributeList setting = (AttributeList)ConfigServiceHelper.getAttributeValue(repertoire, CommandConstants.SETTING);
                        ObjectName keyStore = (ObjectName)ConfigServiceHelper.getAttributeValue(setting, CommandConstants.KEY_STORE);
                        ks = (KeyStore)MOFUtil.convertToEObject((Session)session, (ObjectName)keyStore);
                    }
                    if (this.clientKeyAlias != null && this.clientKeyAlias.length() > 0 && !PersonalCertificateHelper.isAliasInKeyStore(this.clientKeyAlias, ks)) {
                        String msg3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{this.clientKeyAlias, ks.getName()}, "Alias " + this.clientKeyAlias + " is not a personal certificate in key store " + ks.getName() + ".");
                        throw new CommandValidationException(msg3);
                    }
                    if (this.serverKeyAlias != null && this.serverKeyAlias.length() > 0 && !PersonalCertificateHelper.isAliasInKeyStore(this.serverKeyAlias, ks)) {
                        String msg4 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{this.serverKeyAlias, ks.getName()}, "Alias " + this.serverKeyAlias + " is not a personal certificate in key store " + ks.getName() + ".");
                        throw new CommandValidationException(msg4);
                    }
                }
            }
            if (this.SSLConfigType.equalsIgnoreCase("SSSL")) {
                String msg;
                if (this.sslConfigObjName == null) {
                    msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0682E", new Object[]{this.aliasName}, this.aliasName + " does not exist.");
                    throw new CommandValidationException(msg);
                }
                if (this.timeout != null && (this.timeout < 1 || this.timeout > 86400)) {
                    msg = TraceNLSHelper.getInstance().getString("ssl.command.timeout.range.CWPKI0683E", "V3 time out range is between 1 and 86400.");
                    throw new CommandValidationException(msg);
                }
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.modifySSLConfig.validate", "311", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        block35: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "beforeStepsExecuted");
            }
            super.beforeStepsExecuted();
            ObjectName security2 = null;
            TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
            if (!result.isSuccessful()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeStepsExecuted");
                }
                return;
            }
            try {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
                ConfigService cs = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                security2 = cs.resolve(session, "Cell=:Security=")[0];
                AttributeList attrList = new AttributeList();
                AttributeList repertoire = cs.getAttributes(session, this.sslConfigObjName, null, true);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "repertoire: " + repertoire);
                }
                if (repertoire.size() <= 0) break block35;
                AttributeList setting = (AttributeList)ConfigServiceHelper.getAttributeValue(repertoire, CommandConstants.SETTING);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting: " + setting);
                }
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(setting), null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matches: " + matches[0]);
                }
                if (matches.length == 1) {
                    attrList.clear();
                    if (this.clientAuthentication != null) {
                        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.CLIENT_AUTHENTICATION, this.clientAuthentication);
                    }
                    if (this.securityLevel != null) {
                        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SECURITY_LEVEL, this.securityLevel);
                    }
                    if (this.clientAuthenticationSupported != null) {
                        ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.CLIENT_AUTHENTICATION_SUPPORTED, this.clientAuthenticationSupported);
                    }
                    if (this.SSLConfigType.equals("JSSE")) {
                        if (this.clientKeyAlias != null) {
                            if (this.clientKeyAlias.length() > 0) {
                                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.CLIENT_KEY_ALIAS, this.clientKeyAlias);
                            } else {
                                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.CLIENT_KEY_ALIAS, null);
                            }
                        }
                        if (this.serverKeyAlias != null) {
                            if (this.serverKeyAlias.length() > 0) {
                                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SERVER_KEY_ALIAS, this.serverKeyAlias);
                            } else {
                                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SERVER_KEY_ALIAS, null);
                            }
                        }
                        if (this.jsseProvider != null) {
                            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.JSSE_PROVIDER, this.jsseProvider);
                        }
                        if (this.sslProtocol != null) {
                            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SSL_PROTOCOL, this.sslProtocol);
                        }
                        if (this.trustManagerObjNameList != null) {
                            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.TRUST_MANAGER, this.trustManagerObjNameList);
                        }
                        if (this.trustStoreObjName != null) {
                            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.TRUST_STORE, this.trustStoreObjName);
                        }
                        if (this.keyManagerObjName != null) {
                            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.KEY_MANAGER, this.keyManagerObjName);
                        }
                        if (this.keyStoreObjName != null) {
                            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.KEY_STORE, this.keyStoreObjName);
                        }
                        if (this.enabledCiphers != null) {
                            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.ENABLED_CIPHERS, this.enabledCiphers);
                        }
                    } else {
                        if (this.keyFileName != null) {
                            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SSSL_KEY_FILE_NAME, this.keyFileName);
                        }
                        if (this.enabledCiphers != null) {
                            String cipherString = SSLConfigManager.getInstance().convertCiphersList(this.enabledCiphers);
                            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.ENABLED_CIPHERS, cipherString);
                        }
                    }
                    cs.setAttributes(session, matches[0], attrList);
                    if (this.SSLConfigType.equals("SSSL") && (this.sslProtocol != null || this.jsseProvider != null || this.timeout != null)) {
                        AttributeList attrs = new AttributeList();
                        ObjectName property2 = null;
                        AttributeList attributeList = cs.getAttributes(session, matches[0], new String[]{"properties"}, false);
                        List props = (List)((Attribute)attributeList.get(0)).getValue();
                        for (ObjectName property2 : props) {
                            String propName = (String)cs.getAttribute(session, property2, "name");
                            if (propName.equals("com.ibm.ssl.contextProvider") && this.jsseProvider != null) {
                                cs.deleteConfigData(session, property2);
                                attrs.clear();
                                attrs.add(new Attribute(CommandConstants.NAME, "com.ibm.ssl.contextProvider"));
                                attrs.add(new Attribute(CommandConstants.VALUE, this.jsseProvider));
                                cs.createConfigData(session, matches[0], CommandConstants.PROPERTIES, null, attrs);
                            }
                            if (propName.equals("com.ibm.ssl.protocol") && this.sslProtocol != null) {
                                cs.deleteConfigData(session, property2);
                                attrs.clear();
                                attrs.add(new Attribute(CommandConstants.NAME, "com.ibm.ssl.protocol"));
                                attrs.add(new Attribute(CommandConstants.VALUE, this.sslProtocol));
                                cs.createConfigData(session, matches[0], CommandConstants.PROPERTIES, null, attrs);
                            }
                            if (!propName.equals("was.com.ibm.ssl.sys.v3.timeout") || this.timeout == null) continue;
                            cs.deleteConfigData(session, property2);
                            attrs.clear();
                            attrs.add(new Attribute(CommandConstants.NAME, "was.com.ibm.ssl.sys.v3.timeout"));
                            attrs.add(new Attribute(CommandConstants.VALUE, this.timeout.toString()));
                            cs.createConfigData(session, matches[0], CommandConstants.PROPERTIES, null, attrs);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting attrList: " + attrList);
                    }
                    break block35;
                }
                throw new InvalidParameterValueException(this.getName(), CommandConstants.SETTING, setting);
            }
            catch (Exception e) {
                result.setException(new CommandException(e, e.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

