/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.ManagementScope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteManagementScope
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteManagementScope.class, "SSL", "com.ibm.ws.ssl.commands");
    private String scopeName = null;
    private ObjectName scopeObjName = null;

    public DeleteManagementScope(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public DeleteManagementScope(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            AttributeList dynamicSSLConfigSelectionRef;
            AttributeList keyManagerRef;
            AttributeList trustManagerRef;
            AttributeList sslConfigGroupRef;
            AttributeList keyStoreRef;
            AttributeList keySetGroupRef;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.scopeName);
            this.scopeObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
            AttributeList referenceList = new AttributeList();
            AttributeList keySetRef = commandHelper.getReference(cs, session, security2, CommandConstants.KEY_SETS, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
            if (keySetRef.size() > 0) {
                referenceList.addAll(keySetRef);
            }
            if ((keySetGroupRef = commandHelper.getReference(cs, session, security2, CommandConstants.KEY_SET_GROUPS, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName)).size() > 0) {
                referenceList.addAll(keySetGroupRef);
            }
            if ((keyStoreRef = commandHelper.getReference(cs, session, security2, CommandConstants.KEY_STORES, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName)).size() > 0) {
                referenceList.addAll(keyStoreRef);
            }
            if ((sslConfigGroupRef = commandHelper.getReference(cs, session, security2, CommandConstants.SSL_CONFIG_GROUPS, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName)).size() > 0) {
                referenceList.addAll(sslConfigGroupRef);
            }
            if ((trustManagerRef = commandHelper.getReference(cs, session, security2, CommandConstants.TRUST_MANAGERS, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName)).size() > 0) {
                referenceList.addAll(trustManagerRef);
            }
            if ((keyManagerRef = commandHelper.getReference(cs, session, security2, CommandConstants.KEY_MANAGERS, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName)).size() > 0) {
                referenceList.addAll(keyManagerRef);
            }
            if ((dynamicSSLConfigSelectionRef = commandHelper.getReference(cs, session, security2, CommandConstants.DYNAMIC_SSL_CONFIG_SELECTIONS, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName)).size() > 0) {
                referenceList.addAll(dynamicSSLConfigSelectionRef);
            }
            if (referenceList.size() > 0) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.management.scope.referenced.CWPKI0637E", new Object[]{referenceList}, "This object is referenced by " + referenceList);
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.deleteManagementScope.validate", "200");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            cs.deleteConfigData(session, this.scopeObjName);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

