/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeyManager;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteKeyManager
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteKeyManager.class, "SSL", "com.ibm.ws.ssl.commands");
    private String keyManagerName = null;
    private String scopeName = null;
    private ObjectName keyManagerObjName = null;

    public DeleteKeyManager(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public DeleteKeyManager(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.keyManagerName = (String)this.getParameter(CommandConstants.NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyManagerName: " + this.keyManagerName);
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyManagerName);
            this.keyManagerObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_MANAGERS, queryAttrs, this.scopeName);
            AttributeList referenceList = new AttributeList();
            List repertoires = (List)cs.getAttribute(session, security2, CommandConstants.REPERTOIRE);
            for (AttributeList repertoire : repertoires) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "repertoire : " + repertoire);
                }
                String aliasName = (String)ConfigServiceHelper.getAttributeValue(repertoire, CommandConstants.ALIAS);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "aliasName : " + aliasName);
                }
                AttributeList setting = (AttributeList)ConfigServiceHelper.getAttributeValue(repertoire, CommandConstants.SETTING);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting attributes : " + setting);
                }
                ObjectName[] itMatches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(setting), null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting object : " + itMatches[0]);
                }
                if (itMatches.length != 1) continue;
                ObjectName keyManagerRef = (ObjectName)ConfigServiceHelper.getAttributeValue(setting, CommandConstants.KEY_MANAGER);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keyManagerRef : " + keyManagerRef);
                }
                if (keyManagerRef == null || !this.keyManagerObjName.equals(keyManagerRef)) continue;
                referenceList.add(new Attribute(CommandConstants.REPERTOIRE, aliasName));
            }
            if (referenceList.size() > 0) {
                String msg = "This object is referenced by " + referenceList;
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.deleteKeyManager.validate", "175", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            cs.deleteConfigData(session, this.keyManagerObjName);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

