/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.CAClients;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import java.util.List;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class DeleteCAClient
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteCAClient.class, "SSL", "com.ibm.ws.ssl.commands");
    private String caClientName = null;
    private String scopeName = null;
    private ObjectName caClientObjName = null;

    public DeleteCAClient(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public DeleteCAClient(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            security2 = cs.resolve(session, "Cell=:Security=")[0];
            this.caClientName = (String)this.getParameter(CommandConstants.CACLIENT_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caClientName: " + this.caClientName);
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultScope();
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.caClientName);
            this.caClientObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.CACLIENTS, queryAttrs, this.scopeName);
            AttributeList referenceList = new AttributeList();
            List caCertificates = (List)cs.getAttribute(session, security2, CommandConstants.CACERTIFICATES);
            for (AttributeList caClient : caCertificates) {
                ObjectName caClientOfCert;
                try {
                    caClientOfCert = (ObjectName)ConfigServiceHelper.getAttributeValue(caClient, CommandConstants.CACLIENT);
                }
                catch (AttributeNotFoundException e) {
                    continue;
                }
                if (!caClientOfCert.equals(this.caClientObjName)) continue;
                ObjectName keyStore = (ObjectName)ConfigServiceHelper.getAttributeValue(caClient, CommandConstants.KEY_STORE);
                String certAlias = (String)ConfigServiceHelper.getAttributeValue(caClient, CommandConstants.ALIAS);
                String keyStoreName = (String)cs.getAttribute(session, keyStore, CommandConstants.NAME);
                String referenceString = "Certificate alias " + certAlias + " in key store " + keyStoreName;
                referenceList.add(referenceString);
            }
            if (referenceList.size() > 0) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.caClient.references.CWPKI0687E", new Object[]{this.caClientName, referenceList}, "The Certificate Authority (CA) client \"" + this.caClientName + "\" is still referenced by: " + referenceList);
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.DeleteCAClient.validate", "%c%", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error processing parameters: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        Object security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            cs.deleteConfigData(session, this.caClientObjName);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

