/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLEngine;

public class SSLChannelData {
    protected static final TraceComponent tc = Tr.register(SSLChannelData.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    public static final String ENCRYPT_BUFFERS_DIRECT = "encryptBuffersDirect";
    public static final String DECRYPT_BUFFERS_DIRECT = "decryptBuffersDirect";
    public static final String SSLSESSION_CACHE_SIZE = "SSLSessionCacheSize";
    public static final String SSLSESSION_TIMEOUT = "SSLSessionTimeout";
    private static final String DEFAULT_ENCRYPT_BUFFERS_DIRECT = "true";
    private static final String DEFAULT_DECRYPT_BUFFERS_DIRECT = "false";
    public static final int DEFAULT_SSLSESSION_CACHE_SIZE = 100;
    public static final int DEFAULT_SSLSESSION_TIMEOUT = 86400;
    public static final String ALIAS_KEY = "alias";
    public static final String KEY_FILE_NAME = "com.ibm.ssl.keyStore";
    public static final String KEY_FILE_PASSWORD = "com.ibm.ssl.keyStorePassword";
    public static final String TRUST_FILE_NAME = "com.ibm.ssl.trustStore";
    public static final String TRUST_FILE_PASSWORD = "com.ibm.ssl.trustStorePassword";
    public static final String SERVER_KEY_ALIAS = "com.ibm.ssl.keyStoreServerAlias";
    public static final String PROTOCOL = "com.ibm.ssl.protocol";
    public static final String SSL_TYPE = "com.ibm.ssl.sslType";
    public static final String KEY_MANAGER = "com.ibm.ssl.keyManager";
    public static final String KEY_STORE_TYPE = "com.ibm.ssl.keyStoreType";
    public static final String KEY_STORE_PROVIDER = "com.ibm.ssl.keyStoreProvider";
    public static final String TRUST_MANAGER = "com.ibm.ssl.trustManager";
    public static final String TRUST_STORE_TYPE = "com.ibm.ssl.trustStoreType";
    public static final String TRUST_STORE_PROVIDER = "com.ibm.ssl.trustStoreProvider";
    public static final String ENABLED_CIPHER_SUITES = "com.ibm.ssl.enabledCipherSuites";
    public static final String CLIENT_AUTH = "com.ibm.ssl.clientAuthentication";
    public static final String SECURITY_LEVEL = "com.ibm.ssl.securityLevel";
    public static final String TOKEN_TYPE = "com.ibm.ssl.tokenType";
    public static final String TOKEN_SLOT = "com.ibm.ssl.tokenSlot";
    public static final String TOKEN_LIBRARY_FILE = "com.ibm.ssl.tokenLibraryFile";
    public static final String TOKEN_PASSWORD = "com.ibm.ssl.tokenPassword";
    public static final String CONTEXT_PROVIDER = "com.ibm.ssl.contextProvider";
    public static final String CLIENT_KEY_ALIAS = "com.ibm.ssl.keyStoreClientAlias";
    private ChannelFramework framework = null;
    private String name = null;
    private boolean encryptBuffersDirect;
    private boolean decryptBuffersDirect;
    private int weight;
    private boolean isInbound;
    private boolean clientAuthentication;
    private Properties properties;
    private int sslSessionCacheSize = 0;
    private int sslSessionTimeout = 0;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSLChannelData: ");
        sb.append(this.name);
        sb.append("\n\tencryptBuffersDirect = ");
        sb.append(this.encryptBuffersDirect);
        sb.append("\n\tdecryptBuffersDirect = ");
        sb.append(this.decryptBuffersDirect);
        sb.append("\n\tweight = ");
        sb.append(this.weight);
        sb.append("\n\tisInbound = ");
        sb.append(this.isInbound);
        sb.append("\n\tclientAuthentication = ");
        sb.append(this.clientAuthentication);
        sb.append("\n\tsession cache size = ");
        sb.append(this.getSSLSessionCacheSize());
        sb.append("\n\tsession timeout = ");
        sb.append(this.getSSLSessionTimeout());
        return sb.toString();
    }

    public SSLChannelData(ChannelData inputData) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor: SSLChannelData");
        }
        this.framework = inputData.getChannelFramework();
        this.name = inputData.getName();
        this.weight = inputData.getDiscriminatorWeight();
        this.isInbound = inputData.isInbound();
        this.properties = new Properties();
        Map inputProperties = inputData.getPropertyBag();
        Iterator keyIter = inputProperties.keySet().iterator();
        String key = null;
        while (keyIter.hasNext()) {
            key = (String)keyIter.next();
            this.properties.put(key, inputProperties.get(key));
        }
        StringBuilder errors = new StringBuilder();
        this.encryptBuffersDirect = this.getBooleanProperty(ENCRYPT_BUFFERS_DIRECT, DEFAULT_ENCRYPT_BUFFERS_DIRECT, errors);
        PlatformHelper osHelper = PlatformHelperFactory.getPlatformHelper();
        if (osHelper.isZOS() && (osHelper.isControlJvm() || osHelper.isClientJvm())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "On Z and either in CR or Client JVM so setting decryptBuffersDirect to true");
            }
            this.decryptBuffersDirect = true;
        } else {
            this.decryptBuffersDirect = this.getBooleanProperty(DECRYPT_BUFFERS_DIRECT, DEFAULT_DECRYPT_BUFFERS_DIRECT, errors);
        }
        this.sslSessionCacheSize = this.getIntProperty(SSLSESSION_CACHE_SIZE, true, 100, errors);
        this.sslSessionTimeout = this.getIntProperty(SSLSESSION_TIMEOUT, true, 86400, errors);
        if (errors.length() != 0) {
            Tr.error(tc, "invalid.security.properties", errors.toString());
            throw new ChannelException("Invalid property values found:\n" + errors.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor: SSLChannelData");
        }
    }

    public ChannelFramework getChannelFramework() {
        return this.framework;
    }

    public String getName() {
        return this.name;
    }

    public boolean getEncryptBuffersDirect() {
        return this.encryptBuffersDirect;
    }

    public boolean getDecryptBuffersDirect() {
        return this.decryptBuffersDirect;
    }

    public void setEncryptBuffersDirect(boolean direct) {
        this.encryptBuffersDirect = direct;
    }

    public void setDecryptBuffersDirect(boolean direct) {
        this.decryptBuffersDirect = direct;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isInbound() {
        return this.isInbound;
    }

    public int getSSLSessionCacheSize() {
        return this.sslSessionCacheSize;
    }

    public int getSSLSessionTimeout() {
        return this.sslSessionTimeout;
    }

    public FlowType getFlowType() {
        return this.isInbound() ? FlowType.INBOUND : FlowType.OUTBOUND;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties newMap) {
        this.properties = newMap;
    }

    public boolean getBooleanProperty(String propertyName) {
        boolean booleanValue = false;
        Object objectValue = this.properties.get(propertyName);
        if (objectValue != null) {
            if (objectValue instanceof Boolean) {
                booleanValue = (Boolean)objectValue;
            } else if (objectValue instanceof String) {
                booleanValue = DEFAULT_ENCRYPT_BUFFERS_DIRECT.equalsIgnoreCase((String)objectValue);
            }
        }
        return booleanValue;
    }

    public String getStringProperty(String propertyName) {
        Object value = this.properties.get(propertyName);
        if (null != value && value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public String[] getEnabledCipherSuites(SSLEngine sslEngine) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getEnabledCipherSuites");
        }
        String[] ciphers = null;
        Object ciphersObject = this.properties.get(ENABLED_CIPHER_SUITES);
        if (null == ciphersObject) {
            String securityLevel = this.properties.getProperty(SECURITY_LEVEL);
            if (null == securityLevel) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Defaulting to HIGH security level");
                }
                securityLevel = "HIGH";
            }
            ciphers = SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel(sslEngine.getSupportedCipherSuites(), securityLevel);
        } else if (ciphersObject instanceof String) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "enabledCipherSuites is a String: " + ciphersObject);
            }
            String ciphersString = (String)ciphersObject;
            ciphers = ciphersString.split("\\s");
        } else if (ciphersObject instanceof String[]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "enabledCipherSuites is a String array");
            }
            ciphers = (String[])ciphersObject;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Invalid object for enabledCipherSuites: " + ciphersObject);
        }
        if ((null == ciphers || 0 == ciphers.length) && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Unable to find any enabled ciphers");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getEnabledCipherSuites");
        }
        return ciphers;
    }

    public void updateChannelData(ChannelData inputData) {
    }

    private boolean getBooleanProperty(String key, String defaultValue, StringBuilder errors) {
        boolean booleanValue = false;
        String stringValue = null;
        boolean valueCorrect = false;
        Object objectValue = this.properties.get(key);
        if (objectValue != null) {
            if (objectValue instanceof Boolean) {
                booleanValue = (Boolean)objectValue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Property " + key + " set to " + booleanValue);
                }
                return booleanValue;
            }
            if (objectValue instanceof String) {
                stringValue = (String)objectValue;
            }
        } else if (defaultValue != null) {
            stringValue = defaultValue;
        } else {
            errors.append(key);
            errors.append(":");
            errors.append(stringValue);
            errors.append(" \n");
            return false;
        }
        if (stringValue != null) {
            if (stringValue.equals(DEFAULT_ENCRYPT_BUFFERS_DIRECT)) {
                booleanValue = true;
                valueCorrect = true;
            } else if (stringValue.equals(DEFAULT_DECRYPT_BUFFERS_DIRECT)) {
                booleanValue = false;
                valueCorrect = true;
            }
        }
        if (valueCorrect) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Property " + key + " set to " + booleanValue);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Property " + key + " has invalid value " + stringValue);
            }
            errors.append(key);
            errors.append(":");
            errors.append(stringValue);
            errors.append(" \n");
        }
        return booleanValue;
    }

    private int getIntProperty(String key, boolean defaultProvided, int defaultValue, StringBuilder errors) {
        block7: {
            String value = this.getStringProperty(key);
            if (null != value) {
                try {
                    int realValue = Integer.parseInt(value);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Property " + key + " set to " + realValue);
                    }
                    return realValue;
                }
                catch (NumberFormatException nfe) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Property " + key + ", format error in [" + value + "]");
                }
            }
        }
        if (!defaultProvided) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Property " + key + " not found.  Error being tallied.");
            }
            errors.append(key);
            errors.append(":null \n");
            return -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Property " + key + " using default " + defaultValue);
        }
        return defaultValue;
    }
}

