/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ws.ssl.channel.impl.SSLChannelData;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;

public class SSLBaseServiceContext {
    private SSLConnectionLink connectionLink = null;
    private WsByteBuffer[] buffers;
    private WsByteBuffer[] defaultBuffers = new WsByteBuffer[1];
    private SSLChannelData config = null;
    private VirtualConnection myVC = null;
    private int myVCHashCode = 0;

    public SSLBaseServiceContext(SSLConnectionLink connLink) {
        this.connectionLink = connLink;
        this.config = connLink.getChannel().getConfig();
        this.myVC = this.connectionLink.getVirtualConnection();
        this.myVCHashCode = this.myVC.hashCode();
    }

    public SSLBaseServiceContext() {
    }

    public TCPConnectionContext getInterface() {
        return this.connectionLink;
    }

    public void clearBuffers() {
        if (this.buffers != null) {
            for (int i = 0; i < this.buffers.length; ++i) {
                if (this.buffers[i] == null) continue;
                this.buffers[i].clear();
            }
        }
    }

    public WsByteBuffer[] getBuffers() {
        return this.buffers;
    }

    public void setBuffers(WsByteBuffer[] bufs) {
        this.buffers = bufs;
    }

    public WsByteBuffer getBuffer() {
        if (this.buffers == null) {
            return null;
        }
        return this.buffers[0];
    }

    public void setBuffer(WsByteBuffer buf) {
        if (buf != null) {
            this.buffers = this.defaultBuffers;
            this.buffers[0] = buf;
        } else {
            this.buffers = null;
        }
    }

    protected SSLConnectionLink getConnLink() {
        return this.connectionLink;
    }

    protected VirtualConnection getVC() {
        return this.myVC;
    }

    protected int getVCHash() {
        return this.myVCHashCode;
    }

    protected SSLChannelData getConfig() {
        return this.config;
    }
}

