/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.template.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.resource.WASResourceImpl;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.template.RefObjectHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.wst.common.internal.emf.utilities.CopyGroup;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;
import org.eclipse.wst.common.internal.emf.utilities.IDUtil;

public class RefObjectHelperImpl
implements RefObjectHelper {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(RefObjectHelperImpl.class);
    static final URI TRANSIENT_RESOURCE_URI = URI.createURI("tempworkarea.xmi");
    protected ResourceSet transientRS = new WASResourceSetImpl();
    protected XMIResource transientResource = new WASResourceImpl(TRANSIENT_RESOURCE_URI);

    public RefObjectHelperImpl() {
        this.transientRS.getResources().add(this.transientResource);
    }

    public EObject clone(EObject source) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clone", new Object[]{source});
        }
        CopyGroup copyGroup = new CopyGroup();
        copyGroup.setPreserveIds(false);
        copyGroup.add(source);
        EtoolsCopyUtility.createCopy(copyGroup);
        List objList = copyGroup.getCopiedRefObjects();
        if (objList.size() > 0) {
            return (EObject)objList.get(0);
        }
        return null;
    }

    public Collection clone(Collection source) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clone", new Object[]{source});
        }
        CopyGroup copyGroup = new CopyGroup();
        copyGroup.setPreserveIds(false);
        Iterator itr = source.iterator();
        while (itr.hasNext()) {
            copyGroup.add((EObject)itr.next());
        }
        EtoolsCopyUtility.createCopy(copyGroup);
        return copyGroup.getCopiedRefObjects();
    }

    public void refreshRefId(EObject refObject) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "refreshRefId", new Object[]{refObject});
        }
        this.refreshIdLocal(refObject);
        Iterator itr = refObject.eContents().iterator();
        while (itr.hasNext()) {
            this.refreshRefId((EObject)itr.next());
        }
    }

    public void replicate(EObject refO, Map changedValues) {
        for (String key : changedValues.keySet()) {
            Object value = changedValues.get(key);
            if (value instanceof List) {
                this.replicate(refO, key, (List)value);
                continue;
            }
            EStructuralFeature feature = refO.eClass().getEStructuralFeature(key);
            this.setFeature(refO, feature, value);
        }
    }

    private void setFeature(EObject refO, EStructuralFeature feature, Object value) {
        if (feature.isMany()) {
            ((EList)refO.eGet(feature)).add(value);
        } else {
            refO.eSet(feature, value);
        }
    }

    private void unsetFeature(EObject refO, EStructuralFeature feature) {
        if (feature.isMany()) {
            ((EList)refO.eGet(feature)).clear();
        } else {
            refO.eUnset(feature);
        }
    }

    private void replicate(EObject parentRefO, String structuralFeatureName, List objectList) {
        EStructuralFeature feature = parentRefO.eClass().getEStructuralFeature(structuralFeatureName);
        this.unsetFeature(parentRefO, feature);
        Collection newObjectList = this.clone(objectList);
        Iterator itr = newObjectList.iterator();
        while (itr.hasNext()) {
            this.setFeature(parentRefO, feature, itr.next());
        }
        this.refreshRefId(parentRefO);
    }

    public void unset(EObject parentRefO, String structuralFeatureName) {
        EStructuralFeature feature = parentRefO.eClass().getEStructuralFeature(structuralFeatureName);
        this.unsetFeature(parentRefO, feature);
    }

    public void set(EObject parentRefO, String structuralFeatureName, Object value) {
        EStructuralFeature feature = parentRefO.eClass().getEStructuralFeature(structuralFeatureName);
        this.setFeature(parentRefO, feature, value);
    }

    public EObject getTemporaryObject(String uriString) {
        URI uri = URI.createURI(uriString);
        return this.transientRS.getEObject(uri, true);
    }

    public String makeTemporary(EObject anObject) {
        this.transientResource.getContents().add(anObject);
        this.refreshRefId(anObject);
        return this.makeHref(anObject);
    }

    public String makeHref(EObject refObject) {
        XMLResource resource = (XMLResource)refObject.eResource();
        StringBuffer buffer = new StringBuffer(resource.getURI().toString());
        buffer.append("#");
        buffer.append(resource.getID(refObject));
        return buffer.toString();
    }

    public String getRefID(EObject refObject) {
        XMLResource resource = (XMLResource)refObject.eResource();
        return resource.getID(refObject);
    }

    private void refreshIdLocal(EObject refObject) {
        IDUtil.assignID(refObject);
    }
}

