/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.WorkSpaceContextState;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFileState;
import com.ibm.ws.sm.workspace.WorkSpacePersistentObject;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMessage;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public final class WorkSpacePersistentObjectImpl
implements WorkSpacePersistentObject,
WorkSpaceMessage,
WorkSpaceConstant {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(WorkSpacePersistentObjectImpl.class);
    private String name;
    private Integer state = WorkSpaceFileState.NONE;
    private Integer oldState = WorkSpaceContextState.NONE;
    private Properties property;

    WorkSpacePersistentObjectImpl(String name) {
        this.name = name;
        this.property = new Properties();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return null;
    }

    public String getURI() {
        return null;
    }

    public Integer getState() {
        return this.state;
    }

    void setState(Integer state) {
        this.state = state;
    }

    Integer getOldState() {
        return this.oldState;
    }

    void setOldState(Integer state) {
        this.oldState = state;
    }

    public String getProperty(String name) {
        return this.property.getProperty(name);
    }

    public Enumeration getPropertyNames() {
        return this.property.propertyNames();
    }

    public void setProperty(String name, String value) {
        this.property.setProperty(name, value);
    }

    public String removeProperty(String name) {
        return (String)this.property.remove(name);
    }

    public String getPersistData() {
        StringBuffer s = new StringBuffer(this.name);
        s.append("[");
        s.append("state");
        s.append("=");
        s.append(this.state);
        Enumeration emu = this.getPropertyNames();
        while (emu.hasMoreElements()) {
            String pName = (String)emu.nextElement();
            s.append("[");
            s.append(pName);
            s.append("=");
            s.append(this.getProperty(pName));
        }
        return s.toString();
    }

    void restore(String value) throws WorkSpaceException {
        StringTokenizer st = new StringTokenizer(value, "[");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf("=");
            if (index == -1) continue;
            String tokenName = token.substring(0, index);
            String tokenValue = "";
            if (index + 1 < token.length()) {
                tokenValue = token.substring(index + 1);
            }
            if (tokenName.equals("state")) {
                int newState = new Integer(tokenValue);
                switch (newState) {
                    case -1: {
                        this.state = WorkSpaceFileState.NONE;
                        break;
                    }
                    case 0: {
                        this.state = WorkSpaceFileState.CLEAN;
                        break;
                    }
                    case 1: {
                        this.state = WorkSpaceFileState.EXTRACTED;
                        break;
                    }
                    case 2: {
                        this.state = WorkSpaceFileState.ADDED;
                        break;
                    }
                    case 3: {
                        this.state = WorkSpaceFileState.UPDATED;
                        break;
                    }
                    case 4: {
                        this.state = WorkSpaceFileState.DELETED;
                    }
                }
                continue;
            }
            this.setProperty(tokenName, tokenValue);
        }
    }
}

