/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceEvent;
import com.ibm.ws.sm.workspace.WorkSpaceJMXEvent;
import com.ibm.ws.sm.workspace.WorkSpaceListener;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.Notification;

public class WorkSpaceManagerMBean
extends RuntimeCollaborator
implements WorkSpaceListener {
    private static final TraceComponent tc = Tr.register(WorkSpaceManagerMBean.class, null, null);
    private Set workspaces = Collections.synchronizedSet(new HashSet());
    protected long notif_num = 0L;
    private static WorkSpaceManagerMBean instance = new WorkSpaceManagerMBean();
    private static boolean active = false;

    private WorkSpaceManagerMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WorkSpaceManagerMBean");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WorkSpaceManagerMBean");
        }
    }

    public Set getWorkSpaces() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkSpaces");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkSpaces", this.workspaces);
        }
        return this.workspaces;
    }

    public static WorkSpaceManagerMBean getInstance() {
        String uuid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if ((uuid = AdminContext.peek()) != null) {
            return WorkSpaceManagerMBean.getInstance(uuid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", instance);
        }
        return instance;
    }

    private static WorkSpaceManagerMBean getInstance(String profileKey) {
        WorkSpaceManagerMBean wsm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance with profile key " + profileKey);
        }
        if ((wsm = (WorkSpaceManagerMBean)AdminSubsystemServiceRegistry.getService(WorkSpaceManagerMBean.class.getName())) == null) {
            wsm = new WorkSpaceManagerMBean();
            AdminSubsystemServiceRegistry.addService(WorkSpaceManagerMBean.class.getName(), wsm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance with profileKey", wsm);
        }
        return wsm;
    }

    public static boolean isActive() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isActive" + active);
        }
        return active;
    }

    public static void setActive(boolean a) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setActive" + a);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setActive");
        }
        active = a;
    }

    public void handle(WorkSpaceEvent event2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle", event2);
        }
        if (event2.getType() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WorkSpace has become invalid");
            }
            WorkSpace space = (WorkSpace)event2.getSource();
            String userName = space.getUserName();
            this.workspaces.remove(userName);
            WorkSpaceJMXEvent jmxEvent = new WorkSpaceJMXEvent(userName, 10);
            Notification notif = new Notification("websphere.workspace.event", this.getObjectName(), this.notif_num++);
            notif.setUserData(jmxEvent);
            this.sendWorkSpaceNotification(notif);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle");
        }
    }

    protected void workSpaceCreated(WorkSpace workspace) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "workSpaceCreated", workspace);
        }
        workspace.addWorkSpaceListener(this);
        String workspaceid = workspace.getUserName();
        this.workspaces.add(workspaceid);
        WorkSpaceJMXEvent jmxEvent = new WorkSpaceJMXEvent(workspaceid, 11);
        Notification notif = new Notification("websphere.workspace.event", this.getObjectName(), this.notif_num++);
        notif.setUserData(jmxEvent);
        this.sendWorkSpaceNotification(notif);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "workSpaceCreated");
        }
    }

    protected void workSpaceRemoved(String workspaceid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "workSpaceRemoved", workspaceid);
        }
        this.workspaces.remove(workspaceid);
        WorkSpaceJMXEvent jmxEvent = new WorkSpaceJMXEvent(workspaceid, 12);
        Notification notif = new Notification("websphere.workspace.event", this.getObjectName(), this.notif_num++);
        notif.setUserData(jmxEvent);
        this.sendWorkSpaceNotification(notif);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "workSpaceRemoved");
        }
    }

    private void sendWorkSpaceNotification(Notification notif) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sendWorkSpaceNotification", notif);
            }
            try {
                super.sendNotification(notif);
            }
            catch (MBeanException exc) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "MBeanException onsendWorkSpaceNotification - ", exc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendWorkSpaceNotification");
        }
    }
}

