/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.ContextUtil;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.impl.FileAccessorUtil;
import com.ibm.ws.sm.workspace.impl.RepositoryContextImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public class ContextUtilImpl
implements ContextUtil {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(ContextUtilImpl.class);

    public RepositoryContext move(RepositoryContext context, RepositoryContext parentContext) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "move context: " + context.getURI() + ", under context: " + parentContext.getURI());
        }
        RepositoryContext newContext = this.copy(context, parentContext, context.getName());
        ((RepositoryContextImpl)context).remove();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "move context returned: " + newContext.getURI());
        }
        return newContext;
    }

    public RepositoryContext rename(RepositoryContext context, String name) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rename context: " + context.getName() + ", to name: " + name);
        }
        RepositoryContext newContext = this.copy(context, context.getParent(), name);
        ((RepositoryContextImpl)context).remove();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rename context returned: " + newContext.getURI());
        }
        return newContext;
    }

    public RepositoryContext copy(RepositoryContext context, RepositoryContext parentContext) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copy context: " + context.getURI() + ", under context: " + parentContext.getURI());
        }
        RepositoryContext newContext = this.copy(context, parentContext, context.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copy context returned: " + newContext.getURI());
        }
        return newContext;
    }

    private RepositoryContext copy(RepositoryContext context, RepositoryContext parentContext, String name) throws WorkSpaceException {
        RepositoryContext newContext = parentContext.create(context.getType(), name);
        List files = context.getAllList(false);
        for (int i = 0; i < files.size(); ++i) {
            this.copyFile(newContext, (WorkSpaceFile)files.get(i));
            newContext.notifyChanged(0, ((WorkSpaceFile)files.get(i)).getName());
        }
        List childContexts = context.getChildren();
        for (int i = 0; i < childContexts.size(); ++i) {
            this.copy((RepositoryContext)childContexts.get(i), newContext);
        }
        return newContext;
    }

    private void copyFile(RepositoryContext context, WorkSpaceFile file) throws WorkSpaceException {
        String inputFileName = file.getURI();
        String outputFileName = context.getURI() + '/' + file.getName();
        try {
            file.getContext().extract(file.getName(), false);
            WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
            FileAccessor fa = ws.getFileAccessor();
            FileAccessorUtil.copyFile(fa, inputFileName, outputFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String inputFileName, String outputFileName) throws IOException {
        boolean needDebug = tc.isDebugEnabled();
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            File inFile = new File(inputFileName);
            if (needDebug) {
                Tr.debug(tc, "Reading " + inputFileName + " size = " + inFile.length());
            }
            in = new FileInputStream(inFile);
            if (needDebug) {
                Tr.debug(tc, "Writing " + outputFileName);
            }
            File outFile = new File(outputFileName);
            out = new FileOutputStream(outFile);
            int len = 0;
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer, 0, 4096)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

