/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.zOS.SAFServiceResult;

public final class SAFServiceMessages {
    private static final TraceComponent tc = Tr.register(SAFServiceResult.class, "Security", "com.ibm.ejs.resources.security");

    private SAFServiceMessages() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public static String getSafServiceMessage(int safRetCode, int returnCode, int reasonCode, String serviceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSafServiceMessage");
        }
        if (serviceName.indexOf("IRRSIA00") == -1 && serviceName.indexOf("IRRSIM00") == -1) {
            return null;
        }
        if (safRetCode == 0) {
            return "SAF call Successful";
        }
        if (safRetCode == 4) {
            return "RACF is not Installed";
        }
        if (safRetCode != 8) {
            return null;
        }
        if (returnCode != 8) {
            return null;
        }
        if (reasonCode == 4) {
            return "Parameter List error occurred in WAS";
        }
        if (reasonCode == 8) {
            return "An internal error occured during RACF Processing";
        }
        if (reasonCode == 12) {
            return "Recovery environment could not be established";
        }
        if (serviceName.indexOf("IRRSIA00") != -1) {
            if (reasonCode == 16) {
                return "User ID is not defined to SAF";
            }
            if (reasonCode == 20) {
                return "Password or Pass Ticket is not valid";
            }
            if (reasonCode == 24) {
                return "Password is expired";
            }
            if (reasonCode == 28) {
                return "User ID is revoked or user access to group is revoked";
            }
            if (reasonCode == 32) {
                return "User is not authorized. Typically the UserID does not have access to the APPL SAF Class";
            }
            if (reasonCode == 36) {
                return "Certificate is not Valid";
            }
        }
        if (serviceName.indexOf("IRRSIM00") != -1) {
            if (reasonCode == 16) {
                return "There is no mapping to a RACF user ID for the kerberos principal provided";
            }
            if (reasonCode == 20) {
                return "Not authorized to use this service";
            }
            if (reasonCode == 24) {
                return "The specified RACF user ID does not exist";
            }
            if (reasonCode == 28) {
                return "Certificate is not valid";
            }
            if (reasonCode == 32) {
                return "Either no RACF user ID is defined for this certificate, or the certificate status is NOTRUST";
            }
        }
        return null;
    }
}

