/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.security.zOS.authz.AccessLevel;
import com.ibm.ws.security.zOS.authz.SAFAuthorizationManager;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;

public final class NativeConfiguration {
    public static final TraceComponent tc = Tr.register(NativeConfiguration.class, "Security", "com.ibm.ejs.resources.security");
    private static final NativeConfiguration _instance = new NativeConfiguration();

    public static NativeConfiguration getConfig() {
        return _instance;
    }

    private NativeConfiguration() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void initializeConfiguration() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeConfiguration");
        }
        PlatformCredentialManager pcm = PlatformCredentialManager.instance();
        PlatformCredential serverCred = pcm.createServerCredential();
        String cellShortName = SecurityObjectLocator.getAdminData().getString("cell.short.name");
        String clusterShortName = SecurityObjectLocator.getAdminData().getString("generic.server.short.name");
        if (this.isControllerJvm()) {
            this.setupTrustedApplications(serverCred, cellShortName, clusterShortName);
            if (this.ntv_isTrustedApplicationsEnabled()) {
                Tr.audit(tc, "security.zos.trusted.apps.enabled");
            } else {
                Tr.audit(tc, "security.zos.trusted.apps.disabled");
            }
            if (SecurityObjectLocator.getSecurityConfig().getSAFProfilePrefix() != null) {
                this.setSAFProfilePrefix(SecurityObjectLocator.getSecurityConfig().getSAFProfilePrefix());
            }
        }
        if (this.isControllerJvm() && this.isThreadIdentityRequested()) {
            this.setupThreadIdentity(serverCred, cellShortName, clusterShortName);
            if (this.isApplicationSyncToThreadEnabled()) {
                Tr.audit(tc, "security.zos.threadid.app.enabled");
            } else if (this.isApplicationSyncToThreadRequested() && !this.isApplicationSyncToThreadEnabled()) {
                Tr.audit(tc, "security.zos.threadid.app.denied");
            }
            if (this.isConnectionManagementThreadIdentityEnabled()) {
                Tr.audit(tc, "security.zos.threadid.connmgmt.enabled");
            } else if (this.isConnectionManagementThreadIdentityRequested() && !this.isConnectionManagementThreadIdentityEnabled()) {
                Tr.audit(tc, "security.zos.threadid.connmgmt.denied");
            }
            if (this.ntv_isSkipSurrogateChecksEnabled()) {
                Tr.audit(tc, "security.zos.threadid.skip.surrogate.enabled");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeConfiguration", this);
        }
    }

    public boolean isConnectionManagementThreadIdentityEnabled() {
        boolean enabled;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isConnectionManagementThreadIdentityEnabled");
        }
        boolean bl = enabled = this.isConnectionManagementThreadIdentityRequested() && this.ntv_isSyncToThreadEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isConnectionManagementThreadIdentityEnabled", new Boolean(enabled));
        }
        return enabled;
    }

    public boolean isApplicationSyncToThreadEnabled() {
        boolean enabled;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isApplicationSyncToThreadEnabled");
        }
        boolean bl = enabled = this.isApplicationSyncToThreadRequested() && this.ntv_isSyncToThreadEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isApplicationSyncToThreadEnabled", new Boolean(enabled));
        }
        return enabled;
    }

    public boolean isMutualAuthCBINDCheckEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMutualAuthCBINDCheckEnabled");
        }
        boolean enabled = this.ntv_isMutualAuthCBINDCheckEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMutualAuthCBINDCheckEnabled", new Boolean(enabled));
        }
        return enabled;
    }

    private boolean isControllerJvm() {
        PlatformHelper ph = PlatformHelperFactory.getPlatformHelper();
        return ph.isControlJvm();
    }

    private void setupTrustedApplications(PlatformCredential cred, String cell, String cluster) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setupTrustedApplications", new Object[]{cred, cell, cluster});
            }
            String resource = "BBO.TRUSTEDAPPS." + cell + "." + cluster;
            String resourceClass = "FACILITY";
            try {
                if (SAFAuthorizationManager.instance().isAuthorized(cred, resourceClass, resource)) {
                    this.setTrustedApplicationsEnabled(true);
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Not setting trusted apps", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupTrustedApplications");
        }
    }

    private boolean setTrustedApplicationsEnabled(boolean enabled) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTrustedApplicationsEnabled", new Boolean(enabled));
        }
        boolean success = this.ntv_setTrustedApplicationsEnabled(enabled);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTrustedApplicationsEnabled", new Boolean(success));
        }
        return success;
    }

    private boolean isThreadIdentityRequested() {
        boolean result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isThreadIdentityRequested");
        }
        boolean appSyncRequested = this.isApplicationSyncToThreadRequested();
        boolean connSyncRequested = this.isConnectionManagementThreadIdentityRequested();
        boolean bl = result = appSyncRequested || connSyncRequested;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isThreadIdentityRequested", new Boolean(result));
        }
        return result;
    }

    private boolean isConnectionManagementThreadIdentityRequested() {
        SecurityObjectLocator.getSecurityConfig("AppSecurity");
        SecurityObjectLocator.getSecurityConfig("Security");
        boolean isConnMgmtEnabled = SecurityObjectLocator.getSecurityConfig().getPropertyBool("was.security.EnableRunAsIdentity");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isConnectionManagementThreadIdentityRequested", new Boolean(isConnMgmtEnabled));
        }
        return isConnMgmtEnabled;
    }

    private boolean isApplicationSyncToThreadRequested() {
        SecurityObjectLocator.getSecurityConfig("AppSecurity");
        SecurityObjectLocator.getSecurityConfig("Security");
        boolean isSyncToThreadEnabled = SecurityObjectLocator.getSecurityConfig().getPropertyBool("was.security.EnableSyncToOSThread");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isApplicationSyncToThreadRequested", new Boolean(isSyncToThreadEnabled));
        }
        return isSyncToThreadEnabled;
    }

    private void setupThreadIdentity(PlatformCredential cred, String cell, String cluster) {
        block9: {
            SAFAuthorizationManager authzMgr;
            String resourceClass;
            String resource;
            block8: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "setupThreadIdentity", new Object[]{cred, cell, cluster});
                }
                resource = "BBO.SYNC." + cell + "." + cluster;
                resourceClass = "FACILITY";
                authzMgr = SAFAuthorizationManager.instance();
                try {
                    if (authzMgr.isAuthorized(cred, resourceClass, resource, AccessLevel.CONTROL)) {
                        this.setSkipSurrogateChecksEnabled(true);
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "Not setting skip surrogate checks", e);
                }
            }
            try {
                if (authzMgr.isAuthorized(cred, resourceClass, resource, AccessLevel.READ)) {
                    this.setSyncToThreadEnabled(true);
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Not setting thread identity enabled", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupThreadIdentity");
        }
    }

    private boolean setSyncToThreadEnabled(boolean enabled) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSyncToThreadEnabled", new Boolean(enabled));
        }
        boolean success = this.ntv_setSyncToThreadEnabled(enabled);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSyncToThreadEnabled", new Boolean(success));
        }
        return success;
    }

    private boolean setSkipSurrogateChecksEnabled(boolean enabled) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSkipSurrogateChecksEnabled", new Boolean(enabled));
        }
        boolean success = this.ntv_setSkipSurrogateChecksEnabled(enabled);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSkipSurrogateChecksEnabled", new Boolean(success));
        }
        return success;
    }

    private boolean setSAFProfilePrefix(String profilePrefix) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSAFProfilePrefix", new String(profilePrefix));
        }
        boolean success = this.ntv_setSAFProfilePrefix(profilePrefix);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSAFProfilePrefix", new Boolean(success));
        }
        return success;
    }

    private native boolean ntv_setTrustedApplicationsEnabled(boolean var1);

    private native boolean ntv_isTrustedApplicationsEnabled();

    private native boolean ntv_setSyncToThreadEnabled(boolean var1);

    private native boolean ntv_isSyncToThreadEnabled();

    private native boolean ntv_setSkipSurrogateChecksEnabled(boolean var1);

    private native boolean ntv_isSkipSurrogateChecksEnabled();

    private native boolean ntv_isMutualAuthCBINDCheckEnabled();

    private native boolean ntv_setSAFProfilePrefix(String var1);
}

