/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.om.security.PortletApplication;
import com.ibm.ws.portletcontainer.om.security.PortletDefinition;
import com.ibm.ws.portletcontainer.om.security.TransportGuarantee;
import com.ibm.ws.portletcontainer.util.PortletModelHelper;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.security.core.AccessContext;
import com.ibm.ws.security.core.PermissionRoleMap;
import com.ibm.ws.security.util.LRUCache;
import com.ibm.ws.security.util.WCCMHelper;
import com.ibm.ws.security.web.WebAccessContext;
import com.ibm.ws.security.web.WebAccessPermission;
import com.ibm.ws.security.web.WebResourceCollectionConstraints;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.webapplication.AuthConstraint;
import org.eclipse.jst.j2ee.webapplication.HTTPMethodType;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.UserDataConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;

public class WebConstraintsTable
extends PermissionRoleMap {
    private static final TraceComponent tc = Tr.register(WebConstraintsTable.class);
    private static String NO_MATCH = "";
    private WebResourceCollectionConstraints[] webConstraintsTable = null;
    private WebApp webApp = null;
    LRUCache userDataConstraintsMap;
    public static final String WEB_HASH_SIZE = "com.ibm.websphere.security.web.hashsize";

    public WebConstraintsTable(WebApp webApp, String appName, DeployedModule webModuleConfig) {
        String hashSize = null;
        hashSize = System.getProperty(WEB_HASH_SIZE);
        this.userDataConstraintsMap = hashSize == null || hashSize == "" || new Integer(hashSize) <= 0 ? new LRUCache(600) : new LRUCache(new Integer(hashSize));
        this.webApp = webApp;
        EList constraints = webApp.getConstraints();
        this.initializeTable(constraints, appName, webModuleConfig);
    }

    protected SecurityRole[] getRequiredRoles(AccessContext ctx, String uriPattern, String methodName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequiredRoles :  " + uriPattern + " " + methodName);
        }
        String currentMatchingURI = NO_MATCH;
        Vector<SecurityRole> currentMatchingRoles = null;
        Vector<SecurityRole> exactMatchingRoles = null;
        Vector<SecurityRole> currentMatchingExtensionUriRoles = null;
        SecurityRole[] currentEmptyReqRoles = null;
        SecurityRole[] currentExtEmptyReqRoles = null;
        String currentMatchingURIForEmptyRole = NO_MATCH;
        for (int i = 0; i < this.webConstraintsTable.length; ++i) {
            int l;
            SecurityRole[] roles;
            WebResourceCollectionConstraints o = this.webConstraintsTable[i];
            String p = o.matches(uriPattern, methodName);
            if (p == null) continue;
            int matchType = WebResourceCollectionConstraints.getMatchType(p);
            if (matchType == WebResourceCollectionConstraints.EXACT_MATCH) {
                roles = o.getRequiredRoles();
                if (roles == PermissionRoleMap.EMPTY_REQUIRED_ROLES) {
                    return roles;
                }
                if (exactMatchingRoles != null) {
                    for (l = 0; l < roles.length; ++l) {
                        if (exactMatchingRoles.contains(roles[l])) continue;
                        exactMatchingRoles.add(roles[l]);
                    }
                    continue;
                }
                exactMatchingRoles = new Vector<SecurityRole>();
                for (l = 0; l < roles.length; ++l) {
                    exactMatchingRoles.add(roles[l]);
                }
                continue;
            }
            if (matchType == WebResourceCollectionConstraints.PATHNAME_MATCH && p.length() == currentMatchingURI.length()) {
                currentMatchingURI = p;
                roles = o.getRequiredRoles();
                if (roles == PermissionRoleMap.EMPTY_REQUIRED_ROLES) {
                    currentEmptyReqRoles = PermissionRoleMap.EMPTY_REQUIRED_ROLES;
                    currentMatchingURIForEmptyRole = p;
                    continue;
                }
                if (currentMatchingURIForEmptyRole.length() >= p.length()) continue;
                if (currentMatchingRoles != null) {
                    for (l = 0; l < roles.length; ++l) {
                        if (currentMatchingRoles.contains(roles[l])) continue;
                        currentMatchingRoles.add(roles[l]);
                    }
                    continue;
                }
                currentMatchingRoles = new Vector();
                for (l = 0; l < roles.length; ++l) {
                    currentMatchingRoles.add(roles[l]);
                }
                continue;
            }
            if (matchType == WebResourceCollectionConstraints.PATHNAME_MATCH && p.length() > currentMatchingURI.length()) {
                currentMatchingURI = p;
                currentMatchingRoles = new Vector<SecurityRole>();
                roles = o.getRequiredRoles();
                if (roles == PermissionRoleMap.EMPTY_REQUIRED_ROLES) {
                    currentEmptyReqRoles = PermissionRoleMap.EMPTY_REQUIRED_ROLES;
                    currentMatchingURIForEmptyRole = p;
                    continue;
                }
                for (l = 0; l < roles.length; ++l) {
                    currentMatchingRoles.add(roles[l]);
                }
                continue;
            }
            if (matchType != WebResourceCollectionConstraints.EXTENSION_MATCH) continue;
            roles = o.getRequiredRoles();
            if (roles == PermissionRoleMap.EMPTY_REQUIRED_ROLES) {
                currentExtEmptyReqRoles = PermissionRoleMap.EMPTY_REQUIRED_ROLES;
                continue;
            }
            if (currentExtEmptyReqRoles != null) continue;
            if (currentMatchingExtensionUriRoles != null) {
                for (l = 0; l < roles.length; ++l) {
                    if (currentMatchingExtensionUriRoles.contains(roles[l])) continue;
                    currentMatchingExtensionUriRoles.add(roles[l]);
                }
                continue;
            }
            currentMatchingExtensionUriRoles = new Vector<SecurityRole>();
            for (l = 0; l < roles.length; ++l) {
                currentMatchingExtensionUriRoles.add(roles[l]);
            }
        }
        SecurityRole[] requiredRoles = PermissionRoleMap.NO_REQUIRED_ROLES;
        if (exactMatchingRoles != null) {
            if (exactMatchingRoles.size() > 0) {
                requiredRoles = exactMatchingRoles.toArray(new SecurityRole[0]);
            }
        } else if (currentEmptyReqRoles != null && currentMatchingURIForEmptyRole.length() >= currentMatchingURI.length()) {
            requiredRoles = PermissionRoleMap.EMPTY_REQUIRED_ROLES;
        } else if (currentMatchingRoles != null) {
            if (currentMatchingRoles.size() > 0) {
                requiredRoles = currentMatchingRoles.toArray(new SecurityRole[0]);
            }
        } else if (currentExtEmptyReqRoles != null) {
            requiredRoles = PermissionRoleMap.EMPTY_REQUIRED_ROLES;
        } else if (currentMatchingExtensionUriRoles != null && currentMatchingExtensionUriRoles.size() > 0) {
            requiredRoles = currentMatchingExtensionUriRoles.toArray(new SecurityRole[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Required roles are");
            if (requiredRoles == PermissionRoleMap.EMPTY_REQUIRED_ROLES) {
                Tr.debug(tc, "EMPTY_REQUIRED_ROLES");
            } else if (requiredRoles == PermissionRoleMap.NO_REQUIRED_ROLES) {
                Tr.debug(tc, "NO_REQUIRED_ROLES");
            } else {
                for (int ii = 0; ii < requiredRoles.length; ++ii) {
                    Tr.debug(tc, requiredRoles[ii].getRoleName());
                }
            }
            Tr.debug(tc, ".");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequiredRoles");
        }
        return requiredRoles;
    }

    public boolean isSSLRequired(WebAccessContext webContext, WebAccessPermission wa) {
        boolean ssl2 = false;
        Boolean sslRequired = (Boolean)this.userDataConstraintsMap.get(wa);
        if (sslRequired == null) {
            ssl2 = this.isSSLRequired(wa.getResourceName(), wa.getMethodName());
            this.userDataConstraintsMap.put(wa, new Boolean(ssl2));
            return ssl2;
        }
        return sslRequired;
    }

    public boolean isSSLRequired(String uriName, String methodName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSSLRequired");
        }
        String currentMatchingURI = NO_MATCH;
        String exactMatchingURI = NO_MATCH;
        int transportGuaranteeExact = 0;
        int transportGuarantee = 0;
        int transportGuaranteeExtension = 0;
        for (int i = 0; i < this.webConstraintsTable.length; ++i) {
            int tg;
            WebResourceCollectionConstraints o = this.webConstraintsTable[i];
            String p = o.matches(uriName, methodName);
            if (p == null) continue;
            int matchType = WebResourceCollectionConstraints.getMatchType(p);
            if (matchType == WebResourceCollectionConstraints.EXACT_MATCH) {
                currentMatchingURI = p;
                transportGuaranteeExact = o.getTransportGuarantee();
                exactMatchingURI = p;
                if (transportGuaranteeExact == 0) continue;
                break;
            }
            if (matchType == WebResourceCollectionConstraints.PATHNAME_MATCH && p.length() == currentMatchingURI.length()) {
                tg = o.getTransportGuarantee();
                if (transportGuarantee == 0) {
                    transportGuarantee = tg;
                }
                currentMatchingURI = p;
                continue;
            }
            if (matchType == WebResourceCollectionConstraints.PATHNAME_MATCH && p.length() > currentMatchingURI.length()) {
                currentMatchingURI = p;
                transportGuarantee = o.getTransportGuarantee();
                continue;
            }
            if (matchType != WebResourceCollectionConstraints.EXTENSION_MATCH) continue;
            tg = o.getTransportGuarantee();
            if (transportGuaranteeExtension != 0) continue;
            transportGuaranteeExtension = tg;
        }
        if (exactMatchingURI != NO_MATCH) {
            transportGuarantee = transportGuaranteeExact;
        } else if (currentMatchingURI == NO_MATCH) {
            transportGuarantee = transportGuaranteeExtension;
        }
        return transportGuarantee != 0;
    }

    public WebResourceCollectionConstraints getConstraints(AccessContext ctx, String uriName, String methodName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConstraints: ", new Object[]{uriName, methodName});
        }
        String currentMatchingURI = NO_MATCH;
        WebResourceCollectionConstraints constraints = null;
        WebResourceCollectionConstraints constraintsExtn = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "webConstraintsTable.length = " + this.webConstraintsTable.length);
        }
        for (int i = 0; i < this.webConstraintsTable.length; ++i) {
            String p;
            WebResourceCollectionConstraints o = this.webConstraintsTable[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "webConstraintsTable.length = " + this.webConstraintsTable.length);
            }
            if ((p = o.matches(uriName, methodName)) == null) continue;
            int matchType = WebResourceCollectionConstraints.getMatchType(p);
            if (matchType == WebResourceCollectionConstraints.EXACT_MATCH) {
                currentMatchingURI = p;
                return o;
            }
            if (matchType == WebResourceCollectionConstraints.PATHNAME_MATCH && p.length() > currentMatchingURI.length()) {
                currentMatchingURI = p;
                constraints = o;
                continue;
            }
            constraintsExtn = o;
        }
        if (constraints != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConstraints not null");
            }
            return constraints;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConstraints");
        }
        return constraintsExtn;
    }

    private void initializeTable(EList constraints, String appName, DeployedModule webModuleConfig) {
        block37: {
            Hashtable ht = new Hashtable();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initializeTable");
            }
            PortletApplication portletApp = PortletModelHelper.getPortletApplication((DeployedObject)webModuleConfig);
            if (tc.isDebugEnabled() && portletApp != null) {
                Tr.debug(tc, "Portlet app: " + portletApp + " exists for app " + appName);
            }
            Vector<WebResourceCollectionConstraints> v = new Vector<WebResourceCollectionConstraints>();
            Iterator itr = constraints.iterator();
            try {
                List pConstraintList;
                while (itr.hasNext()) {
                    SecurityConstraint sc = (SecurityConstraint)itr.next();
                    if (sc != null && tc.isDebugEnabled()) {
                        Tr.debug(tc, "SecurityConstraint: ", new Object[]{sc});
                    }
                    AuthConstraint authC = sc.getAuthConstraint();
                    SecurityRole[] sRole = null;
                    if (authC != null) {
                        EList roles = authC.getRoles();
                        if (roles == null || roles.size() == 0) {
                            sRole = PermissionRoleMap.EMPTY_REQUIRED_ROLES;
                        } else {
                            sRole = new SecurityRole[roles.size()];
                            Iterator roleItr = roles.iterator();
                            int index = 0;
                            while (roleItr.hasNext()) {
                                String sr = (String)roleItr.next();
                                if (sr.equals("*")) {
                                    EList sRoles = this.webApp.getSecurityRoles();
                                    index = 0;
                                    sRole = new SecurityRole[sRoles.size()];
                                    for (SecurityRole s : sRoles) {
                                        sRole[index++] = WCCMHelper.createSecurityRole(s.getRoleName(), s.getRoleName());
                                    }
                                    break;
                                }
                                sRole[index++] = WCCMHelper.createSecurityRole(sr, sr);
                            }
                            if (tc.isDebugEnabled()) {
                                StringBuffer b = new StringBuffer("Number of security roles defined: ");
                                b.append(sRole.length);
                                Tr.debug(tc, b.toString());
                            }
                        }
                    } else {
                        sRole = PermissionRoleMap.NO_REQUIRED_ROLES;
                    }
                    UserDataConstraint dataConstraint = sc.getUserDataConstraint();
                    boolean transportSet = false;
                    int transportGuarantee = 0;
                    if (dataConstraint != null && (transportSet = dataConstraint.isSetTransportGuarantee())) {
                        transportGuarantee = dataConstraint.getTransportGuarantee().getValue();
                    }
                    EList list = sc.getWebResourceCollections();
                    for (WebResourceCollection rc : list) {
                        EList url_list = rc.getUrlPattern();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "appName:" + appName + " WebApp version:" + this.webApp.getVersion());
                        }
                        EList method_list = rc.getHttpMethodString();
                        if (url_list == null) continue;
                        int j = 0;
                        Iterator methodItr = method_list.iterator();
                        String[] method2 = new String[method_list.size()];
                        j = 0;
                        while (methodItr.hasNext()) {
                            String meth = (String)methodItr.next();
                            method2[j++] = meth;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "method=" + meth);
                        }
                        WebResourceCollectionConstraints wrconst = new WebResourceCollectionConstraints(url_list, method2);
                        if (sRole.length > 0 || sRole == PermissionRoleMap.EMPTY_REQUIRED_ROLES) {
                            wrconst.setRequiredRoles(sRole);
                        }
                        if (transportSet) {
                            wrconst.setTransportGuarantee(transportGuarantee);
                        }
                        v.addElement(wrconst);
                        if (portletApp == null) continue;
                        for (int k = 0; k < url_list.size(); ++k) {
                            ht.put(url_list.get(k), wrconst);
                        }
                    }
                }
                int pTransportGuarantee = 0;
                if (portletApp != null && (pConstraintList = portletApp.getSecurityConstraints()) != null) {
                    for (com.ibm.ws.portletcontainer.om.security.SecurityConstraint psc : pConstraintList) {
                        if (psc == null) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SecurityConstraint for Portlet is : ", new Object[]{psc});
                        }
                        com.ibm.ws.portletcontainer.om.security.UserDataConstraint pDataConstraint = psc.getUserDataConstraint();
                        String pUserDataConstraint = null;
                        if (pDataConstraint != null) {
                            TransportGuarantee ptg = pDataConstraint.getTransportGuarantee();
                            pUserDataConstraint = pDataConstraint.getTransportGuarantee().getName();
                            if (pUserDataConstraint.equals("INTEGRAL")) {
                                pTransportGuarantee = 1;
                            } else if (pUserDataConstraint.equals("CONFIDENTIAL")) {
                                pTransportGuarantee = 2;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "transport is set for Portlet is: " + pUserDataConstraint);
                            }
                        }
                        List portletDefinitions = psc.getPortletDefinitions();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "PortletDefinitions are: " + portletDefinitions);
                        }
                        Iterator pUrlItr = portletDefinitions.iterator();
                        boolean k = false;
                        while (pUrlItr.hasNext()) {
                            WebResourceCollectionConstraints pConstraints;
                            PortletDefinition pd = (PortletDefinition)pUrlItr.next();
                            String pUrl = pd.getName();
                            if (!pUrl.endsWith("/*")) {
                                StringBuffer sb = new StringBuffer("/");
                                pUrl = sb.append(pUrl).append("/*").toString();
                            }
                            if ((pConstraints = (WebResourceCollectionConstraints)ht.get(pUrl)) == null) {
                                HTTPMethodType[] allMethod = new HTTPMethodType[]{};
                                ArrayList<String> urlString = new ArrayList<String>();
                                urlString.add(pUrl);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Creating new constriant collection for portlet URI : " + pUrl);
                                }
                                pConstraints = new WebResourceCollectionConstraints(urlString, null);
                                pConstraints.setTransportGuarantee(pTransportGuarantee);
                                v.addElement(pConstraints);
                                continue;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Using existing constriant collection for portlet URI : " + pUrl);
                            }
                            pConstraints.removeUri(pUrl);
                            ArrayList<String> urlString = new ArrayList<String>();
                            urlString.add(pUrl);
                            WebResourceCollectionConstraints newPConstraint = new WebResourceCollectionConstraints(urlString, null);
                            newPConstraint.setRequiredRoles(pConstraints.getRequiredRoles());
                            newPConstraint.setTransportGuarantee(pTransportGuarantee);
                            v.addElement(newPConstraint);
                        }
                    }
                }
                int len = v.size();
                this.webConstraintsTable = new WebResourceCollectionConstraints[len];
                for (int j = 0; j < len; ++j) {
                    this.webConstraintsTable[j] = (WebResourceCollectionConstraints)v.elementAt(j);
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.web.WebConstraintsTable.initializeTable", "339", this);
                if (!tc.isDebugEnabled()) break block37;
                Tr.debug(tc, "Exception message:  " + ex.getMessage(), new Object[]{ex});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeTable");
        }
    }

    public static void main(String[] args) {
        String resName1 = "/finance/account.html";
        String resName2 = "/finance/accountServlet";
        String method2 = "GET";
    }
}

