/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ISecurityLocalObjectBaseL13Impl.DomainInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.websphere.security.WebTrustAssociationUserException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.rsatoken.RSAPropagationManager;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.spnego.TrustAssociationInterceptorImpl;
import com.ibm.ws.security.stat.impl.SecurityAuthenticationModuleImpl;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.ws.security.web.AuthenticationResult;
import com.ibm.ws.security.web.FormLoginInfo;
import com.ibm.ws.security.web.TAIWrapper;
import com.ibm.ws.security.web.TrustAssociationManager;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebCollaborator;
import com.ibm.ws.util.Base64;
import com.ibm.ws.webcontainer.session.IHttpSession;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import com.ibm.wsspi.security.tai.TAIResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;

public class WebAuthenticator {
    private static final TraceComponent tc = Tr.register(WebAuthenticator.class, null, "com.ibm.ejs.resources.security");
    private static WebAuthenticator webAuthInstance = null;
    private static AuthenticationResult AUTHN_FAILED_RESULT = new AuthenticationResult(2, "Authentication Failed");
    public static final String FormUserName = "__WAS_FORM_USERNAME";
    public static final String FormPassword = "__WAS_FORM_PASSWORD";
    private static String authMech = null;
    private static String AUTHORIZATION_ENCODING = "Authorization-Encoding";
    private static String BasicAuthEncoding = System.getProperty("com.ibm.websphere.security.BasicAuthEncoding");
    public static final String INITIAL_URL = "INITIAL_URL";
    public static final String PARAM_NAMES = "PARAM_NAMES";
    public static final String PARAM_VALUES = "PARAM_VALUES";
    private static HashMap cookieStringCache = new HashMap(20);
    private static int MAX_COOKIE_STRING_ENTRIES = 100;
    private static final String POSTPARAM_COOKIE = "WASPostParam";
    private static final String POSTPARAM_FAILED = "NO_PARAMETER";
    private static final String POSTPARAM_URL = "U";
    private static final String POSTPARAM_PARAM = "P";
    private static ContextHandler contextHandler = null;
    private static final String providerName = "WebSphere";
    private static final String componentName = "WAS.security";
    private static AuditService auditService = null;
    private Date auditStartTime = null;
    private Date endTime = null;
    private long cushion;
    private static String className;
    private static String default_realm;
    private static String activeUserRegistry;
    private ConcurrentHashMap auditOutcome = null;
    private TrustAssociationInterceptorImpl spnegoWeb = null;
    private SecurityAuthenticationModuleImpl authModule;
    private String krb5CookieName = "KRB5Token";

    public static WebAuthenticator create(String auth_mech) {
        if (webAuthInstance == null) {
            webAuthInstance = new WebAuthenticator();
            authMech = auth_mech;
        }
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        if (auditService == null && (auditService = ctxMgr.getAuditService()) != null && (contextHandler = auditService.getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String string = "Auditing is enabled, but could not get a handler to the audit context objects.";
        }
        default_realm = ctxMgr.getDefaultRealm();
        return webAuthInstance;
    }

    public static WebAuthenticator getInstance() {
        return webAuthInstance;
    }

    private WebAuthenticator() {
        this.initialize();
        if (StatsFactory.isPMIEnabled()) {
            this.authModule = SecurityAuthenticationModuleImpl.getInstance("Security Authentication");
        }
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        activeUserRegistry = security2.getActiveUserRegistry().getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AuthenticationResult handleTrustAssociation(WebAttributes webAttrs, HttpServletRequest req, HttpServletResponse res, HashMap appContext, boolean firstPass) throws Exception {
        AuthenticationResult authenticationResult;
        long startTime = 0L;
        long endTime = 0L;
        this.auditStartTime = new Date();
        try {
            block53: {
                String[] eventTrailIds;
                String lastTrailId;
                String realm;
                AuthenticationResult result;
                Subject ta_subject;
                String ta_username;
                TAIWrapper ta;
                block51: {
                    if (StatsFactory.isPMIEnabled()) {
                        startTime = System.currentTimeMillis();
                        this.authModule.onTAICount();
                    }
                    ta = null;
                    ta_username = null;
                    ta_subject = null;
                    result = null;
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "handleTrustAssociation");
                    }
                    realm = (String)appContext.get("realm_name");
                    String domain_type = (String)appContext.get("security.domain.type");
                    if (domain_type == null && tc.isDebugEnabled()) {
                        Tr.debug(tc, "warning: handleTrustAssociation has null domain type");
                    }
                    ta = TrustAssociationManager.getInstance().getInterceptor(req, firstPass);
                    lastTrailId = null;
                    eventTrailIds = null;
                    if (auditService != null) {
                        lastTrailId = auditService.getLastTrailId();
                        eventTrailIds = auditService.getEventTrailIds();
                    }
                    if (ta != null) {
                        Object data;
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "TAI [" + ta.getName() + "] is available for this request.");
                        }
                        try {
                            TAIResult taresult = ta.negotiateAndValidateEstablishedTrust(req, res);
                            int status = taresult.getStatus();
                            if (status == 200) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "TAI [" + ta.getName() + "] has been validated successfully.");
                                }
                                ta_subject = taresult.getSubject();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Subject retrieved is [" + ta_subject + "]");
                                }
                                ta_username = taresult.getAuthenticatedPrincipal();
                                if (tc.isEntryEnabled()) {
                                    Tr.debug(tc, "Username retrieved from TAI is [" + ta_username + "]");
                                }
                                break block51;
                            }
                            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "REDIRECT")) {
                                data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                                contextHandler.buildContextObject("SESSION_CONTEXT", (HashMap)data);
                                data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "authnRedirect", req.getMethod(), "web", new Long(0L), null, null, null, null);
                                contextHandler.buildContextObject("ACCESS_CONTEXT", (HashMap)data);
                                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                                contextHandler.buildContextObject("EVENT_CONTEXT", (HashMap)data);
                                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                                contextHandler.buildContextObject("PROPAGATION_CONTEXT", (HashMap)data);
                                data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                                contextHandler.buildContextObject("PROCESS_CONTEXT", (HashMap)data);
                                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                                contextHandler.buildContextObject("REGISTRY_CONTEXT", (HashMap)data);
                                data = DataHelper.buildAuthnData("challengeResponse");
                                contextHandler.buildContextObject("AUTHN_CONTEXT", (HashMap)data);
                                data = DataHelper.buildProviderData(ta.getName(), "providerSuccess");
                                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", (HashMap)data);
                                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "REDIRECT", 23L);
                                try {
                                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                                }
                                catch (ProviderFailureException e) {
                                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                                    String msg = "security.audit.service.sendevent.error";
                                    auditService.processAuditFailure(msg, e);
                                }
                            }
                            data = new AuthenticationResult(5, "Challenge from TrustAssociation Interception: " + ta.getName(), status);
                        }
                        catch (WebTrustAssociationFailedException e) {
                            Object data2;
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", "440", this);
                            Tr.error(tc, "security.web.ta.validationfailed", new Object[]{e});
                            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                                data2 = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                                contextHandler.buildContextObject("SESSION_CONTEXT", (HashMap)data2);
                                data2 = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "authnRedirect", req.getMethod(), "web", new Long(0L), null, null, null, null);
                                contextHandler.buildContextObject("ACCESS_CONTEXT", (HashMap)data2);
                                data2 = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                                contextHandler.buildContextObject("EVENT_CONTEXT", (HashMap)data2);
                                data2 = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                                contextHandler.buildContextObject("PROPAGATION_CONTEXT", (HashMap)data2);
                                data2 = DataHelper.buildProcessData(auditService.getDomain(), realm);
                                contextHandler.buildContextObject("PROCESS_CONTEXT", (HashMap)data2);
                                data2 = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                                contextHandler.buildContextObject("REGISTRY_CONTEXT", (HashMap)data2);
                                data2 = DataHelper.buildAuthnData("challengeResponse");
                                contextHandler.buildContextObject("AUTHN_CONTEXT", (HashMap)data2);
                                data2 = DataHelper.buildProviderData(ta.getName(), "providerSuccess");
                                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", (HashMap)data2);
                                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 24L);
                                try {
                                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                                }
                                catch (ProviderFailureException pfe) {
                                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pfe});
                                    String msg = "security.audit.service.sendevent.error";
                                    auditService.processAuditFailure(msg, pfe);
                                }
                            }
                            data2 = new AuthenticationResult(2, e.getMessage());
                            Object var24_49 = null;
                            if (!StatsFactory.isPMIEnabled()) return data2;
                            endTime = System.currentTimeMillis();
                            this.authModule.onTAITime(endTime - startTime);
                            return data2;
                        }
                        catch (WebTrustAssociationUserException f) {
                            Object data3;
                            FFDCFilter.processException((Throwable)f, "com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", "511", this);
                            Tr.error(tc, "security.web.ta.userex");
                            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "FAILURE")) {
                                data3 = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                                contextHandler.buildContextObject("SESSION_CONTEXT", (HashMap)data3);
                                data3 = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "authnFailure", req.getMethod(), "web", new Long(0L), null, null, null, null);
                                contextHandler.buildContextObject("ACCESS_CONTEXT", (HashMap)data3);
                                data3 = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                                contextHandler.buildContextObject("EVENT_CONTEXT", (HashMap)data3);
                                data3 = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                                contextHandler.buildContextObject("PROPAGATION_CONTEXT", (HashMap)data3);
                                data3 = DataHelper.buildProcessData(auditService.getDomain(), realm);
                                contextHandler.buildContextObject("PROCESS_CONTEXT", (HashMap)data3);
                                data3 = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                                contextHandler.buildContextObject("REGISTRY_CONTEXT", (HashMap)data3);
                                data3 = DataHelper.buildAuthnData("challengeResponse");
                                contextHandler.buildContextObject("AUTHN_CONTEXT", (HashMap)data3);
                                data3 = DataHelper.buildProviderData(ta.getName(), "failure");
                                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", (HashMap)data3);
                                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "FAILURE", 26L);
                                try {
                                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                                }
                                catch (ProviderFailureException e) {
                                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                                    String msg = "security.audit.service.sendevent.error";
                                    auditService.processAuditFailure(msg, e);
                                }
                            }
                            data3 = new AuthenticationResult(2, f.getMessage());
                            Object var24_50 = null;
                            if (!StatsFactory.isPMIEnabled()) return data3;
                            endTime = System.currentTimeMillis();
                            this.authModule.onTAITime(endTime - startTime);
                            return data3;
                        }
                        catch (Exception g) {
                            Object data4;
                            FFDCFilter.processException((Throwable)g, "com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", "590", this);
                            Tr.error(tc, "security.web.ta.genexc", new Object[]{g});
                            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "FAILURE")) {
                                data4 = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                                contextHandler.buildContextObject("SESSION_CONTEXT", (HashMap)data4);
                                data4 = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "authnFailure", req.getMethod(), "web", new Long(0L), null, null, null, null);
                                contextHandler.buildContextObject("ACCESS_CONTEXT", (HashMap)data4);
                                data4 = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                                contextHandler.buildContextObject("EVENT_CONTEXT", (HashMap)data4);
                                data4 = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                                contextHandler.buildContextObject("PROPAGATION_CONTEXT", (HashMap)data4);
                                data4 = DataHelper.buildProcessData(auditService.getDomain(), realm);
                                contextHandler.buildContextObject("PROCESS_CONTEXT", (HashMap)data4);
                                data4 = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                                contextHandler.buildContextObject("REGISTRY_CONTEXT", (HashMap)data4);
                                data4 = DataHelper.buildAuthnData("challengeResponse");
                                contextHandler.buildContextObject("AUTHN_CONTEXT", (HashMap)data4);
                                data4 = DataHelper.buildProviderData(ta.getName(), "providerSuccess");
                                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", (HashMap)data4);
                                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "FAILURE", 26L);
                                try {
                                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                                }
                                catch (ProviderFailureException e) {
                                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                                    String msg = "security.audit.service.sendevent.error";
                                    auditService.processAuditFailure(msg, e);
                                }
                            }
                            data4 = new AuthenticationResult(2, g.getMessage());
                            Object var24_51 = null;
                            if (!StatsFactory.isPMIEnabled()) return data4;
                            endTime = System.currentTimeMillis();
                            this.authModule.onTAITime(endTime - startTime);
                            return data4;
                        }
                        Object var24_48 = null;
                        if (!StatsFactory.isPMIEnabled()) return data;
                        endTime = System.currentTimeMillis();
                        this.authModule.onTAITime(endTime - startTime);
                        return data;
                    }
                    AuthenticationResult g = new AuthenticationResult(6, "TAI isn't available for this request.");
                    Object var24_52 = null;
                    if (!StatsFactory.isPMIEnabled()) return g;
                    endTime = System.currentTimeMillis();
                    this.authModule.onTAITime(endTime - startTime);
                    return g;
                }
                if (ta_username != null) {
                    AuthenticationResult rSubj2;
                    Subject subject;
                    block52: {
                        Object data;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Map credentials for " + ta_username + ".");
                        }
                        subject = null;
                        if (ta_subject == null) break block52;
                        WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(ta_subject);
                        if (wsCred != null && wsCred.isCurrent()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Subject is already authenticated from TAI.");
                            }
                            subject = ta_subject;
                            break block52;
                        }
                        if (wsCred == null || wsCred.isCurrent()) break block52;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Subject from TAI is expired for user: " + ta_username);
                        }
                        result = AUTHN_FAILED_RESULT;
                        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                            data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                            contextHandler.buildContextObject("SESSION_CONTEXT", (HashMap)data);
                            data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "denied", req.getMethod(), "web", new Long(0L), null, null, null, null);
                            contextHandler.buildContextObject("ACCESS_CONTEXT", (HashMap)data);
                            data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                            contextHandler.buildContextObject("EVENT_CONTEXT", (HashMap)data);
                            data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                            contextHandler.buildContextObject("PROPAGATION_CONTEXT", (HashMap)data);
                            data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                            contextHandler.buildContextObject("PROCESS_CONTEXT", (HashMap)data);
                            data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                            contextHandler.buildContextObject("REGISTRY_CONTEXT", (HashMap)data);
                            data = DataHelper.buildAuthnData("challengeResponse");
                            contextHandler.buildContextObject("AUTHN_CONTEXT", (HashMap)data);
                            data = DataHelper.buildProviderData(ta.getName(), "providerSuccess");
                            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", (HashMap)data);
                            this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 25L);
                            try {
                                auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                            }
                            catch (ProviderFailureException e) {
                                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                                String msg = "security.audit.service.sendevent.error";
                                auditService.processAuditFailure(msg, e);
                            }
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "handleTrustAssociation: Subject in TAIResult is expired.");
                        }
                        data = result;
                        Object var24_53 = null;
                        if (!StatsFactory.isPMIEnabled()) return data;
                        endTime = System.currentTimeMillis();
                        this.authModule.onTAITime(endTime - startTime);
                        return data;
                    }
                    try {
                        if (subject == null) {
                            ContextManager contextManager = ContextManagerFactory.getInstance();
                            subject = contextManager.login(realm, ta_username, authMech, req, res, (Map)appContext, ta_subject);
                        }
                        result = new AuthenticationResult(1, subject);
                        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "SUCCESS")) {
                            String rSubj2 = null;
                            if (subject != null) {
                                rSubj2 = ((Principal)subject.getPrincipals().toArray()[0]).getName();
                            }
                            HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                            contextHandler.buildContextObject("SESSION_CONTEXT", data);
                            data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", rSubj2, rSubj2, "authnSuccess", req.getMethod(), "web", new Long(0L), null, null, null, null);
                            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                            data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                            contextHandler.buildContextObject("EVENT_CONTEXT", data);
                            data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                            data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                            data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                            data = DataHelper.buildAuthnData("challengeResponse");
                            contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                            data = DataHelper.buildProviderData(ta.getName(), "providerSuccess");
                            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                            this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 5L);
                            try {
                                auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                            }
                            catch (ProviderFailureException e) {
                                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                                String msg = "security.audit.service.sendevent.error";
                                auditService.processAuditFailure(msg, e);
                            }
                        }
                        WebCollaborator.setPrivateAttributes(req, "AUTH_TYPE", webAttrs.getChallengeType());
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "Mapped credential for TrustAssociation was validated successfully.");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "handleTrustAssociation: OK");
                        }
                        rSubj2 = result;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", "860", this);
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "Error in mapping credential for Trust Association:" + ta_username);
                        }
                        result = AUTHN_FAILED_RESULT;
                        if (auditService == null || !auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) break block53;
                        HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", ta_username, ta_username, "denied", req.getMethod(), "web", new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData("challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData(ta.getName(), "providerSuccess");
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 25L);
                        try {
                            auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pfe});
                            String msg = "security.audit.service.sendevent.error";
                            auditService.processAuditFailure(msg, pfe);
                        }
                    }
                    Object var24_54 = null;
                    if (!StatsFactory.isPMIEnabled()) return rSubj2;
                    endTime = System.currentTimeMillis();
                    this.authModule.onTAITime(endTime - startTime);
                    return rSubj2;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleTrustAssociation: (null user)");
            }
            authenticationResult = null;
            Object var24_55 = null;
        }
        catch (Throwable throwable) {
            Object var24_56 = null;
            if (!StatsFactory.isPMIEnabled()) throw throwable;
            endTime = System.currentTimeMillis();
            this.authModule.onTAITime(endTime - startTime);
            throw throwable;
        }
        if (!StatsFactory.isPMIEnabled()) return authenticationResult;
        endTime = System.currentTimeMillis();
        this.authModule.onTAITime(endTime - startTime);
        return authenticationResult;
    }

    private AuthenticationResult handleSSO(WebAttributes webAttrs, HttpServletRequest req, HttpServletResponse res) {
        String rsaCookieName = "RSAToken";
        String ltpaCookieName = webAttrs.getPreferredLTPACookieName();
        String oldLTPACookieName = webAttrs.getLTPACookieName();
        Cookie[] cookies = req.getCookies();
        AuthenticationResult result = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleSSO");
        }
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        Boolean compliance = security2.getPropertyBool("com.ibm.ws.security.web.logoutOnHTTPSessionExpire");
        boolean comp = compliance;
        String challenge = webAttrs.getChallengeType();
        if (comp && req.getRequestedSessionId() != null && !req.isRequestedSessionIdValid() && challenge.equalsIgnoreCase("FORM")) {
            WebAttributes.createLogoutCookiesStatic(req, res);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleSSO:HTTPSession expired, logging out.");
            }
            return null;
        }
        if (cookies != null) {
            boolean foundRSACookie = false;
            boolean foundKRB5Cookie = false;
            boolean foundPreferredCookie = false;
            boolean foundSecondaryCookie = false;
            for (int i = 0; i < cookies.length; ++i) {
                if (rsaCookieName.equals(cookies[i].getName())) {
                    foundRSACookie = true;
                }
                if (this.krb5CookieName.equals(cookies[i].getName())) {
                    foundKRB5Cookie = true;
                }
                if (ltpaCookieName.equals(cookies[i].getName())) {
                    foundPreferredCookie = true;
                }
                if (!oldLTPACookieName.equals(cookies[i].getName())) continue;
                foundSecondaryCookie = true;
            }
            if (foundRSACookie) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempting rsa cookie validation for: " + rsaCookieName);
                }
                result = this.validateCookie(cookies, rsaCookieName, webAttrs, req, res);
            } else if (foundKRB5Cookie) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempting krb5 cookie validation for: " + this.krb5CookieName);
                }
                result = this.validateCookie(cookies, this.krb5CookieName, webAttrs, req, res);
            } else if (foundPreferredCookie) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempting primary cookie validation for: " + ltpaCookieName);
                }
                result = this.validateCookie(cookies, ltpaCookieName, webAttrs, req, res);
            } else if (foundSecondaryCookie) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempting secondary cookie validation for: " + oldLTPACookieName);
                }
                result = this.validateCookie(cookies, oldLTPACookieName, webAttrs, req, res);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find LTPA cookie(s) in request.");
            }
            if (result != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleSSO: found cookie");
                }
                return result;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleSSO: (null)");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleSSO: no cookies present in the request.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationResult validateCookie(Cookie[] cookies, String ltpaCookieName, WebAttributes webAttrs, HttpServletRequest req, HttpServletResponse res) {
        AuthenticationResult result = null;
        this.auditStartTime = new Date();
        String[] hdrVals = WebAuthenticator.getCookieValues(cookies, ltpaCookieName);
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (auditService != null) {
            lastTrailId = auditService.getLastTrailId();
            eventTrailIds = auditService.getEventTrailIds();
        }
        if (hdrVals != null) {
            String hdrVal = null;
            for (int n = 0; n < hdrVals.length; ++n) {
                hdrVal = hdrVals[n];
                if (hdrVal.length() <= 0) continue;
                byte[] ltpaToken = null;
                try {
                    ltpaToken = (byte[])cookieStringCache.get(hdrVal);
                    if (ltpaToken == null) {
                        ltpaToken = StringUtil.getBytes(Base64Coder.base64Decode(hdrVal));
                        HashMap hashMap = cookieStringCache;
                        synchronized (hashMap) {
                            if (cookieStringCache.size() > MAX_COOKIE_STRING_ENTRIES) {
                                cookieStringCache.clear();
                            }
                            if (ltpaToken != null) {
                                cookieStringCache.put(hdrVal, ltpaToken);
                            }
                        }
                    }
                    if (ltpaCookieName.equals("RSAToken")) {
                        Subject subject = RSAPropagationManager.getInstance().validateRSAPropagationToken(ltpaToken);
                        result = new AuthenticationResult(1, subject);
                    } else if (ltpaCookieName.equals(this.krb5CookieName)) {
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "validate KRB5Token");
                        }
                        result = this.validate(default_realm, ltpaToken, webAttrs, req, res, this.krb5CookieName);
                    } else {
                        result = this.validate(default_realm, ltpaToken, webAttrs, req, res);
                    }
                    if (result.getStatus() != 1) continue;
                    break;
                }
                catch (Exception e) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Exception validating SSO token: ", new Object[]{e});
                    }
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAuthenticator.handleSSO", "1095", this);
                    result = AUTHN_FAILED_RESULT;
                    if (auditService == null || !auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) continue;
                    HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "denied", req.getMethod(), "web", new Long(0L), null, null, null, null);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(auditService.getDomain(), default_realm);
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildAuthnData("challengeResponse");
                    contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                    data = DataHelper.buildProviderData(providerName, "providerSuccess");
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 27L);
                    try {
                        auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        continue;
                    }
                    catch (ProviderFailureException pfe) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pfe});
                        String msg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg, pfe);
                    }
                }
            }
            if (result != null && result.getStatus() == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The LTPA token was valid.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleSSO", "successful ltpa token validation of " + hdrVal);
                }
                WebCollaborator.setPrivateAttributes(req, "AUTH_TYPE", webAttrs.getChallengeType());
                return result;
            }
            return null;
        }
        return null;
    }

    private AuthenticationResult handleCustomLogin(WebAttributes webAttrs, HttpServletRequest req, HttpServletResponse res) {
        AuthenticationResult result = null;
        this.auditStartTime = new Date();
        String realm = default_realm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleCustomLogin");
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "Form based login is configured for the resource");
        }
        StringBuffer URL2 = HttpUtils.getRequestURL(req);
        String URLString = URL2.toString();
        String ctx = req.getContextPath();
        if (ctx.equals("/")) {
            ctx = "";
        }
        int index = URLString.indexOf("//");
        index = URLString.indexOf("/", index + 2);
        int endindex = URLString.length();
        String loginURL = webAttrs.getLoginURL();
        if (!loginURL.startsWith("/")) {
            loginURL = "/" + loginURL;
        }
        loginURL = ctx + loginURL;
        URL2.replace(index, endindex, loginURL);
        loginURL = URL2.toString();
        String reLoginURL = webAttrs.getReloginURL();
        endindex = loginURL.length();
        if (!reLoginURL.startsWith("/")) {
            reLoginURL = "/" + reLoginURL;
        }
        reLoginURL = ctx + reLoginURL;
        URL2.replace(index, endindex, reLoginURL);
        reLoginURL = URL2.toString();
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        String authMechanism = security2.getActiveAuthMechanism().getType();
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (auditService != null) {
            lastTrailId = auditService.getLastTrailId();
            eventTrailIds = auditService.getEventTrailIds();
        }
        HttpSession session = null;
        FormLoginInfo info = null;
        if (authMechanism.equals("SWAM")) {
            session = req.getSession(true);
            info = (FormLoginInfo)((IHttpSession)session).getSecurityInfo();
            if (info != null) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Form based login: Using HTTP Sessions");
                }
                String username = info.getUsername();
                String password = info.getPassword();
                if (username != null && password != null) {
                    int status;
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Form based login: Userid/password present in the session");
                    }
                    if ((status = (result = this.basicAuthenticate(realm, username, password, webAttrs, req, res)).getStatus()) == 2) {
                        result = new AuthenticationResult(4, reLoginURL);
                        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "REDIRECT")) {
                            HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                            contextHandler.buildContextObject("SESSION_CONTEXT", data);
                            data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", username, username, "authnRedirect", req.getMethod(), "web", new Long(0L), null, null, null, null);
                            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                            data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                            contextHandler.buildContextObject("EVENT_CONTEXT", data);
                            data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                            data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                            data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                            data = DataHelper.buildAuthnData("challengeResponse");
                            contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                            data = DataHelper.buildProviderData(providerName, "providerSuccess");
                            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                            this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "REDIRECT", 28L);
                            try {
                                auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                            }
                            catch (ProviderFailureException e) {
                                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                                String msg = "security.audit.service.sendevent.error";
                                auditService.processAuditFailure(msg, e);
                            }
                        }
                    } else {
                        session.removeAttribute("WASReqURL");
                    }
                    WebCollaborator.setPrivateAttributes(req, "AUTH_TYPE", "FORM");
                    if (status != 2) {
                        this.restorePostParams(req, res);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "handleCustomLogin");
                    }
                    return result;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Form based login: No HTTP Session");
            }
        } else {
            result = this.handleSSO(webAttrs, req, res);
            if (result != null) {
                if (result.getStatus() != 2) {
                    this.restorePostParams(req, res);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleCustomLogin");
                }
                return result;
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Form based login: No or Bad ltpa cookie ");
            }
        }
        StringBuffer reqURL = req.getRequestURL();
        if (req.getQueryString() != null) {
            reqURL.append("?");
            reqURL.append(req.getQueryString());
        }
        String storedReq = reqURL.toString();
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "Form based login: Stored original request : " + storedReq);
        }
        result = new AuthenticationResult(4, loginURL);
        this.savePostParams(req, res, result);
        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "REDIRECT")) {
            HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
            contextHandler.buildContextObject("SESSION_CONTEXT", data);
            data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "authnRedirect", req.getMethod(), "web", new Long(0L), null, null, null, null);
            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
            data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
            contextHandler.buildContextObject("EVENT_CONTEXT", data);
            data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
            data = DataHelper.buildProcessData(auditService.getDomain(), realm);
            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
            data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
            data = DataHelper.buildAuthnData("challengeResponse");
            contextHandler.buildContextObject("AUTHN_CONTEXT", data);
            data = DataHelper.buildProviderData(providerName, "providerSuccess");
            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
            this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "REDIRECT", 29L);
            try {
                auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
            }
            catch (ProviderFailureException e) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                String msg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(msg, e);
            }
        }
        if (authMechanism.equals("SWAM")) {
            if (info == null) {
                info = new FormLoginInfo();
            }
            info.setRefererURL(storedReq);
            ((IHttpSession)session).putSecurityInfo((Object)info);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Form based login: Referer URL set  in session " + storedReq);
            }
        } else {
            block40: {
                Boolean fqURL = security2.getPropertyBool("com.ibm.websphere.security.util.fullyQualifiedURL");
                if (fqURL == null || fqURL != null && !fqURL.booleanValue()) {
                    try {
                        URL originalURL = new URL(storedReq);
                        StringBuffer workURL = new StringBuffer();
                        workURL.append(originalURL.getProtocol());
                        workURL.append("://");
                        int port = originalURL.getPort();
                        if (port != -1) {
                            workURL.append(":");
                            workURL.append(port);
                        }
                        storedReq = workURL.toString() + storedReq.substring(index);
                    }
                    catch (MalformedURLException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAuthenticator.handleCustomLogin", "810", this);
                        if (!tc.isDebugEnabled()) break block40;
                        Tr.debug(tc, "Requested URL is malformed. " + storedReq);
                    }
                }
            }
            String origStoredReq = storedReq;
            storedReq = storedReq.replaceAll("%", "%25");
            if (origStoredReq != (storedReq = storedReq.replaceAll(";", "%3B")) && tc.isDebugEnabled()) {
                Tr.debug(tc, "Form based login: changed output storedReq from " + origStoredReq + " to " + storedReq);
            }
            Cookie c = new Cookie("WASReqURL", storedReq);
            c.setPath("/");
            c.setMaxAge(-1);
            result.setCookie(c);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Form based login: Referer URL cookie set " + storedReq);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleCustomLogin", "Redirecting to a login form" + loginURL);
        }
        return result;
    }

    private void savePostParams(HttpServletRequest req, HttpServletResponse res, AuthenticationResult result) {
        block21: {
            String reqURL = req.getRequestURI();
            String reqMethod = req.getMethod();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "savePostParams");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " method : " + reqMethod + " URL:" + reqURL);
            }
            if (!(req instanceof SRTServletRequest)) {
                Tr.exit(tc, "savePostParams-No SRTServletRequest");
                return;
            }
            SRTServletRequest extRequest = (SRTServletRequest)req;
            try {
                HttpSession postparamsession;
                if (!reqMethod.equalsIgnoreCase("post")) break block21;
                SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                HashMap params = extRequest.getInputStreamData();
                int postParamSaveMethod = Integer.valueOf(security2.getProperty("com.ibm.websphere.security.util.postParamSaveMethod"));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prop:" + postParamSaveMethod);
                }
                if (postParamSaveMethod == 0) {
                    Hashtable<String, Object> cookie = new Hashtable<String, Object>();
                    if (params == null) break block21;
                    cookie.put(POSTPARAM_URL, reqURL);
                    cookie.put(POSTPARAM_PARAM, params);
                    String strParam = null;
                    try {
                        ByteArrayOutputStream baOut = new ByteArrayOutputStream();
                        ObjectOutputStream oOut = new ObjectOutputStream(baOut);
                        oOut.writeObject(cookie);
                        byte[] baParam = baOut.toByteArray();
                        int postParamSaveSize = Integer.valueOf(security2.getProperty("com.ibm.websphere.security.util.postParamMaxCookieSize"));
                        if (tc.isDebugEnabled()) {
                            int baParamLen = 0;
                            if (baParam != null) {
                                baParamLen = baParam.length;
                            }
                            Tr.debug(tc, "length:" + baParamLen + "  maximum length:" + postParamSaveSize);
                        }
                        if (baParam != null && baParam.length < postParamSaveSize) {
                            byte[] encParam = Base64Coder.base64Encode(baParam);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "encoded length:" + encParam.length);
                            }
                            strParam = StringUtil.toString(encParam);
                        } else {
                            Tr.warning(tc, "Post parameters are null or too large to store into a cookie.");
                        }
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception storing POST parameters onto a cookie: ", new Object[]{e});
                        }
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAuthenticator.savePostParams", "1692", this);
                    }
                    if (strParam != null) {
                        Cookie paramCookie = new Cookie(POSTPARAM_COOKIE, strParam);
                        paramCookie.setMaxAge(-1);
                        paramCookie.setPath(reqURL);
                        result.setCookie(paramCookie);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "encoded POST parameters: " + strParam);
                    }
                    break block21;
                }
                if (postParamSaveMethod == 1 && (postparamsession = req.getSession(true)) != null && req.getParameterNames() != null) {
                    postparamsession.setAttribute(INITIAL_URL, reqURL);
                    postparamsession.setAttribute(PARAM_NAMES, null);
                    postparamsession.setAttribute(PARAM_VALUES, params);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "URL saved : " + reqURL.toString());
                    }
                }
            }
            catch (IOException exc) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "IO Exception storing POST parameters onto a cookie: ", new Object[]{exc});
                }
                FFDCFilter.processException((Throwable)exc, "com.ibm.ws.security.web.WebAuthenticator.savePostParams", "1722", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "savePostParams");
        }
    }

    private void restorePostParams(HttpServletRequest req, HttpServletResponse res) {
        String reqURL = req.getRequestURI();
        String reqMethod = req.getMethod();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restorePostParams");
        }
        if (!(req instanceof SRTServletRequest)) {
            Tr.exit(tc, "restorePostParams-No SRTServletRequest");
            return;
        }
        SRTServletRequest extRequest = (SRTServletRequest)req;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " method : " + reqMethod + " URL:" + reqURL);
        }
        if (reqMethod.equalsIgnoreCase("get")) {
            HttpSession postparamsession;
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            int postParamSaveMethod = Integer.valueOf(security2.getProperty("com.ibm.websphere.security.util.postParamSaveMethod"));
            if (postParamSaveMethod == 0) {
                byte[] cookieValueBytes = extRequest.getCookieValueAsBytes(POSTPARAM_COOKIE);
                if (cookieValueBytes != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found the cookie, restoring POST parameters: " + new String(cookieValueBytes));
                    }
                    extRequest.setMethod("POST");
                    try {
                        byte[] bParams = Base64Coder.base64Decode(cookieValueBytes);
                        ByteArrayInputStream inParamsStream = new ByteArrayInputStream(bParams);
                        ObjectInputStream inParamsObjStream = new ObjectInputStream(inParamsStream);
                        Hashtable restoredMap = (Hashtable)inParamsObjStream.readObject();
                        if (tc.isDebugEnabled() && restoredMap != null) {
                            Tr.debug(tc, "Original URL:" + restoredMap.get(POSTPARAM_URL));
                        }
                        if (restoredMap != null && restoredMap.get(POSTPARAM_URL).equals(reqURL)) {
                            Map restoredParams = (Map)restoredMap.get(POSTPARAM_PARAM);
                            extRequest.setInputStreamData((HashMap)restoredParams);
                            Tr.debug(tc, "restored POST paramameters");
                        }
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception restoring POST parameters from the cookie: ", new Object[]{e});
                        }
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAuthenticator.restorePostParams", "1778", this);
                    }
                    Cookie paramCookie = new Cookie(POSTPARAM_COOKIE, POSTPARAM_FAILED);
                    paramCookie.setPath(reqURL);
                    paramCookie.setMaxAge(0);
                    res.addCookie(paramCookie);
                }
            } else if (postParamSaveMethod == 1 && (postparamsession = req.getSession(false)) != null) {
                String previousReq = (String)postparamsession.getAttribute(INITIAL_URL);
                if (previousReq != null && previousReq.equals(reqURL)) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found the session, restoring POST parameters.");
                        }
                        extRequest.setMethod("POST");
                        Map paramValues = (Map)postparamsession.getAttribute(PARAM_VALUES);
                        if (paramValues != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Restoring POST paramameters for URL : " + reqURL);
                            }
                            extRequest.setInputStreamData((HashMap)paramValues);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No parameters to restore for URL : " + reqURL);
                        }
                    }
                    catch (IOException exc) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "IOException restoring POST parameters onto a cookie: ", new Object[]{exc});
                        }
                        FFDCFilter.processException((Throwable)exc, "com.ibm.ws.security.web.WebAuthenticator.savePostParams", "1039", this);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Parameters NOT restored. Original URL : " + previousReq + " req. URL : " + reqURL);
                }
                postparamsession.setAttribute(INITIAL_URL, null);
                postparamsession.setAttribute(PARAM_NAMES, null);
                postparamsession.setAttribute(PARAM_VALUES, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restorePostParams");
        }
    }

    private AuthenticationResult handleCertificates(WebAttributes webAttrs, HttpServletRequest req, HttpServletResponse res) throws Exception {
        AuthenticationResult result;
        block39: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleCertificates");
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Challenge type used is CERT.");
            }
            String challengeType = "CLIENT_CERT";
            result = null;
            String realm = default_realm;
            this.auditStartTime = new Date();
            X509Certificate[] certs = null;
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            String authMechanism = security2.getActiveAuthMechanism().getType();
            Boolean authMechCredForwardable = security2.getActiveAuthMechanism().getBoolean("isCredentialForwardable");
            String lastTrailId = null;
            String[] eventTrailIds = null;
            if (auditService != null) {
                lastTrailId = auditService.getLastTrailId();
                eventTrailIds = auditService.getEventTrailIds();
            }
            Subject subject = null;
            try {
                certs = (X509Certificate[])req.getAttribute("javax.net.ssl.peer_certificates");
                if (certs == null) {
                    if (!webAttrs.isDefaultToBasic()) {
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "No certificate provided and default to basic is false.");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "handleCertificates");
                        }
                        return new AuthenticationResult(2, "No Client Certificate Available", null);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "No certificate was provided but defaulting to BASIC.");
                    }
                    challengeType = "BASIC";
                }
                if (challengeType.equalsIgnoreCase("BASIC")) break block39;
                byte[] certBytes = certs[0].getEncoded();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Map credential for this certificate.");
                }
                X509Certificate[] certs_final = certs;
                String web_app_name = webAttrs.getWebAppName();
                String challengeType_final = challengeType;
                String realm_final = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getString("realm");
                try {
                    ContextManager contextManager;
                    HashMap<String, String> appContext = new HashMap<String, String>(4);
                    appContext.put("WebAppName", web_app_name);
                    appContext.put("RedirectURL", null);
                    this.setDomainContext(webAttrs, appContext);
                    realm = (String)appContext.get("realm_name");
                    String thisAuthMech = "system.WEB_INBOUND";
                    if (authMechCredForwardable != null && !authMechCredForwardable.booleanValue()) {
                        thisAuthMech = "system.SWAM";
                    }
                    if ((subject = (contextManager = ContextManagerFactory.getInstance()).login(realm_final, certs_final, thisAuthMech, req, res, appContext)) != null) {
                        result = new AuthenticationResult(1, subject);
                        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "SUCCESS")) {
                            String rSubj = null;
                            if (subject != null) {
                                rSubj = ((Principal)subject.getPrincipals().toArray()[0]).getName();
                            }
                            HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                            contextHandler.buildContextObject("SESSION_CONTEXT", data);
                            data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", rSubj, certs[0].getIssuerDN().getName(), "authnSuccess", req.getMethod(), "web", new Long(0L), null, null, null, null);
                            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                            data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                            contextHandler.buildContextObject("EVENT_CONTEXT", data);
                            data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                            data = DataHelper.buildProcessData(auditService.getDomain(), realm_final);
                            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                            data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                            data = DataHelper.buildAuthnData("challengeResponse");
                            contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                            data = DataHelper.buildProviderData(providerName, "providerSuccess");
                            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                            this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 5L);
                            try {
                                auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                            }
                            catch (ProviderFailureException e) {
                                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                                String msg = "security.audit.service.sendevent.error";
                                auditService.processAuditFailure(msg, e);
                            }
                        }
                    } else {
                        result = AUTHN_FAILED_RESULT;
                        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                            HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                            contextHandler.buildContextObject("SESSION_CONTEXT", data);
                            data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, certs[0].getIssuerDN().getName(), "denied", req.getMethod(), "web", new Long(0L), null, null, null, null);
                            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                            data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                            contextHandler.buildContextObject("EVENT_CONTEXT", data);
                            data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                            data = DataHelper.buildProcessData(auditService.getDomain(), realm_final);
                            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                            data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                            data = DataHelper.buildAuthnData("challengeResponse");
                            contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                            data = DataHelper.buildProviderData(providerName, "providerSuccess");
                            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                            this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 15L);
                            try {
                                auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                            }
                            catch (ProviderFailureException e) {
                                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                                String msg = "security.audit.service.sendevent.error";
                                auditService.processAuditFailure(msg, e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAuthenticator.handleCertificates", "1931", this);
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Credential Mapping for Certificate failed.");
                    }
                    result = AUTHN_FAILED_RESULT;
                    if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                        HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "denied", req.getMethod(), "web", new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData(auditService.getDomain(), realm_final);
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData("challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData(providerName, "providerSuccess");
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 15L);
                        try {
                            auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pfe});
                            String msg = "security.audit.service.sendevent.error";
                            auditService.processAuditFailure(msg, pfe);
                        }
                    }
                    throw e;
                }
                result.clearCookieList();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Storing certificates in the credential");
                }
                ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(certs.length);
                for (int i = 0; i < certs.length; ++i) {
                    certList.add(certs[i]);
                }
                CertificateFactory cfx = CertificateFactory.getInstance("X.509");
                CertPath myCertPath = cfx.generateCertPath(certList);
                Subject mySubject = result.getSubject();
                WSCredential myCred = mySubject.getPublicCredentials(WSCredential.class).iterator().next();
                if (myCred != null) {
                    myCred.set("wssecurity.setAttributForIdentityAssertion", myCertPath);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAuthenticator.handleCertificates", "2035", this);
                if (webAttrs.isDefaultToBasic()) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Exception occurred while processing certificate: " + e.getMessage());
                        Tr.debug(tc, "Defaulting to Basic");
                    }
                    if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                        HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "denied", req.getMethod(), "web", new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData("challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData(providerName, "providerSuccess");
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 15L);
                        try {
                            auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pfe});
                            String msg = "security.audit.service.sendevent.error";
                            auditService.processAuditFailure(msg, pfe);
                        }
                    }
                    challengeType = "BASIC";
                }
                if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                    HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "denied", req.getMethod(), "web", new Long(0L), null, null, null, null);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildAuthnData("challengeResponse");
                    contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                    data = DataHelper.buildProviderData(providerName, "providerSuccess");
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 15L);
                    try {
                        auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                    }
                    catch (ProviderFailureException pfe) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pfe});
                        String msg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg, pfe);
                    }
                }
                throw e;
            }
        }
        WebCollaborator.setPrivateAttributes(req, "AUTH_TYPE", "CLIENT_CERT");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleCertificates");
        }
        return result;
    }

    static final String getHeader(HttpServletRequest req, String key) {
        HttpServletRequest sr = req;
        if (sr instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper w = (HttpServletRequestWrapper)sr;
            sr = (HttpServletRequest)w.getRequest();
            while (sr != null && sr instanceof HttpServletRequestWrapper) {
                sr = (HttpServletRequest)((HttpServletRequestWrapper)sr).getRequest();
            }
        }
        if (sr != null && sr instanceof SRTServletRequest) {
            String header = ((SRTServletRequest)sr).getHeaderDirect(key);
            return header;
        }
        return req.getHeader(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AuthenticationResult handleSpnegoWebAuthentication(WebAttributes webAttrs, HttpServletRequest req, HttpServletResponse res, HashMap appContext) throws Exception {
        String[] eventTrailIds;
        String lastTrailId;
        String ta_username;
        Subject ta_subject;
        Subject subject;
        String realm;
        AuthenticationResult result;
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleSpnegoWebAuthentication");
            }
            result = null;
            realm = default_realm;
            subject = null;
            ta_subject = null;
            ta_username = null;
            lastTrailId = null;
            eventTrailIds = null;
            if (auditService != null) {
                lastTrailId = auditService.getLastTrailId();
                eventTrailIds = auditService.getEventTrailIds();
            }
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            AuthMechanismConfig spnegoAuth = security2.getAuthMechanism("SPNEGO");
            this.spnegoWeb = TrustAssociationInterceptorImpl.getInstance();
            this.spnegoWeb.initialize(spnegoAuth.getSpnegoFilterProps());
            if (!this.spnegoWeb.isTargetInterceptor(req)) {
                if (!tc.isDebugEnabled()) return new AuthenticationResult(6, "SPNEGO Web authentication isn't available for this request.");
                Tr.debug(tc, "SPNEGO Web authentication isn't available for this request.");
                return new AuthenticationResult(6, "SPNEGO Web authentication isn't available for this request.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SPNEGO Web authentication - target is intercepted");
            }
            try {
                TAIResult taresult = this.spnegoWeb.negotiateValidateandEstablishTrust(req, res);
                int status = taresult.getStatus();
                if (status == 200) {
                    ta_subject = taresult.getSubject();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Subject retrieved is [" + ta_subject + "]");
                    }
                    ta_username = taresult.getAuthenticatedPrincipal();
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Username retrieved from the spnego token is [" + ta_username + "]");
                    }
                    break block21;
                }
                if (auditService == null) return new AuthenticationResult(5, "Challenge from TrustAssociation Interception: name ?", status);
                if (!auditService.isEventRequired("SECURITY_AUTHN", "REDIRECT")) return new AuthenticationResult(5, "Challenge from TrustAssociation Interception: name ?", status);
                HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "authnRedirect", req.getMethod(), "web", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildAuthnData("challengeResponse");
                contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                data = DataHelper.buildProviderData("SPNEGO Web authentication", "providerSuccess");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "REDIRECT", 23L);
                try {
                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                    return new AuthenticationResult(5, "Challenge from TrustAssociation Interception: name ?", status);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, e);
                }
                return new AuthenticationResult(5, "Challenge from TrustAssociation Interception: name ?", status);
            }
            catch (WebTrustAssociationFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", "323", this);
                Tr.error(tc, "security.web.ta.validationfailed", new Object[]{e});
                if (auditService == null) return new AuthenticationResult(2, e.getMessage());
                if (!auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) return new AuthenticationResult(2, e.getMessage());
                HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "authnRedirect", req.getMethod(), "web", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildAuthnData("challengeResponse");
                contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                data = DataHelper.buildProviderData("SPNEGO Web authentication", "providerSuccess");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 24L);
                try {
                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                    return new AuthenticationResult(2, e.getMessage());
                }
                catch (ProviderFailureException pfe) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pfe});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, pfe);
                }
                return new AuthenticationResult(2, e.getMessage());
            }
            catch (Exception g) {
                FFDCFilter.processException((Throwable)g, "com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", "356", this);
                Tr.error(tc, "security.web.ta.genexc", new Object[]{g});
                if (auditService == null) return new AuthenticationResult(2, g.getMessage());
                if (!auditService.isEventRequired("SECURITY_AUTHN", "FAILURE")) return new AuthenticationResult(2, g.getMessage());
                HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "authnFailure", req.getMethod(), "web", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildAuthnData("challengeResponse");
                contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                data = DataHelper.buildProviderData("SPNEGO Web authentication", "failure");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "FAILURE", 26L);
                try {
                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                    return new AuthenticationResult(2, g.getMessage());
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, e);
                }
                return new AuthenticationResult(2, g.getMessage());
            }
        }
        if (subject == null) {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            subject = contextManager.login(realm, ta_username, authMech, req, res, (Map)appContext, ta_subject);
        }
        result = new AuthenticationResult(1, subject);
        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "SUCCESS")) {
            String rSubj = null;
            if (subject != null) {
                rSubj = ((Principal)subject.getPrincipals().toArray()[0]).getName();
            }
            HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
            contextHandler.buildContextObject("SESSION_CONTEXT", data);
            data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", rSubj, rSubj, "authnSuccess", req.getMethod(), "web", new Long(0L), null, null, null, null);
            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
            data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
            contextHandler.buildContextObject("EVENT_CONTEXT", data);
            data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
            data = DataHelper.buildProcessData(auditService.getDomain(), realm);
            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
            data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
            data = DataHelper.buildAuthnData("challengeResponse");
            contextHandler.buildContextObject("AUTHN_CONTEXT", data);
            data = DataHelper.buildProviderData("SPNEGO Web authentication", "providerSuccess");
            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
            this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 5L);
            try {
                auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
            }
            catch (ProviderFailureException e) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                String msg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(msg, e);
            }
        }
        if (!tc.isEntryEnabled()) return result;
        Tr.exit(tc, "handleSpnegoWebAuthentication");
        return result;
    }

    private AuthenticationResult handleBasicAuth(WebAttributes webAttrs, HttpServletRequest req, HttpServletResponse res) throws Exception {
        String password;
        int idx;
        String hdrValue;
        String[] eventTrailIds;
        String lastTrailId;
        String realm;
        Cookie cookieToSet;
        AuthenticationResult result;
        block28: {
            boolean decoded;
            byte[] headerBytes;
            block27: {
                String encoding;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "handleBasicAuth");
                }
                result = null;
                this.auditStartTime = new Date();
                cookieToSet = null;
                realm = default_realm;
                lastTrailId = null;
                eventTrailIds = null;
                if (auditService != null) {
                    lastTrailId = auditService.getLastTrailId();
                    eventTrailIds = auditService.getEventTrailIds();
                }
                if ((hdrValue = req.getHeader("Authorization")) == null || !hdrValue.startsWith("Basic ")) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "basic 401");
                    }
                    result = new AuthenticationResult(3, webAttrs.getRealm(), cookieToSet);
                    if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "REDIRECT")) {
                        HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "authnRedirect", req.getMethod(), "web", new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData("challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData(providerName, "providerSuccess");
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "REDIRECT", 28L);
                        try {
                            auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException e) {
                            Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                            String msg = "security.audit.service.sendevent.error";
                            auditService.processAuditFailure(msg, e);
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "handleBasicAuth");
                    }
                    return result;
                }
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Authorization: " + hdrValue);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "BasicAuthEncoding: " + BasicAuthEncoding);
                }
                if ((encoding = req.getHeader(AUTHORIZATION_ENCODING)) == null) {
                    encoding = BasicAuthEncoding;
                }
                headerBytes = Base64.decode((String)hdrValue.substring(6));
                decoded = false;
                if (encoding != null && encoding.length() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Authorization will be decoded using : " + encoding);
                    }
                    try {
                        hdrValue = new String(headerBytes, encoding);
                        decoded = true;
                    }
                    catch (Exception e) {
                        decoded = false;
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAuthenticator.handleBasicAuth", "938", this);
                        if (!tc.isDebugEnabled()) break block27;
                        Tr.debug(tc, "Exception " + e.getMessage() + " using character encoder " + encoding + " switching to system default decoder");
                    }
                }
            }
            if (!decoded) {
                try {
                    hdrValue = new String(headerBytes);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAuthenticator.handleBasicAuth", "2331", this);
                    if (!tc.isDebugEnabled()) break block28;
                    Tr.debug(tc, "Error in using character encoder");
                }
            }
        }
        if ((idx = hdrValue.indexOf(58)) < 0) {
            result = new AuthenticationResult(3, webAttrs.getRealm(), cookieToSet);
            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "REDIRECT")) {
                HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "authnRedirect", req.getMethod(), "web", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildAuthnData("challengeResponse");
                contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                data = DataHelper.buildProviderData(providerName, "providerSuccess");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "REDIRECT", 28L);
                try {
                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, e);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Failed to find username/password info -- Sending 401.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleBasicAuth");
            }
            return result;
        }
        String username = hdrValue.substring(0, idx);
        result = this.basicAuthenticate(realm, username, password = hdrValue.substring(idx + 1), webAttrs, req, res);
        int status = result.getStatus();
        if ((status == 3 || status == 2) && status == 2) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Authentication failed after calling basicAuthenticate");
            }
            result = new AuthenticationResult(3, webAttrs.getRealm(), cookieToSet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleBasicAuth");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthenticationResult authenticate(WebAttributes webAttrs, HttpServletRequest req, HttpServletResponse res) {
        block63: {
            block62: {
                block61: {
                    block59: {
                        block58: {
                            block57: {
                                block56: {
                                    block55: {
                                        startTime = 0L;
                                        endTime = 0L;
                                        taManager = TrustAssociationManager.getInstance();
                                        try {
                                            block54: {
                                                lastTrailId = null;
                                                eventTrailIds = null;
                                                if (WebAuthenticator.auditService != null) {
                                                    lastTrailId = WebAuthenticator.auditService.getLastTrailId();
                                                    eventTrailIds = WebAuthenticator.auditService.getEventTrailIds();
                                                }
                                                this.auditStartTime = new Date();
                                                if (StatsFactory.isPMIEnabled()) {
                                                    startTime = System.currentTimeMillis();
                                                    this.authModule.onWebAuthCount();
                                                }
                                                if (WebAuthenticator.tc.isEntryEnabled()) {
                                                    Tr.entry(WebAuthenticator.tc, "authenticate");
                                                }
                                                result = null;
                                                continueLogin = false;
                                                try {
                                                    security = SecurityObjectLocator.getSecurityConfig();
                                                    authMechCredForwardable = security.getActiveAuthMechanism().getBoolean("isCredentialForwardable");
                                                    setCookie = authMechCredForwardable == true && webAttrs.isSSOEnabled() != false && (webAttrs.isSecureSSO() == false || webAttrs.isSecureSSO() != false && req.getScheme().equalsIgnoreCase("https") != false);
                                                    reply = null;
                                                    challengeType = webAttrs.getChallengeType();
                                                    result = null;
                                                    appContext = new HashMap<String, String>(4);
                                                    if (WebAuthenticator.tc.isDebugEnabled()) {
                                                        Tr.debug(WebAuthenticator.tc, "challengeType = " + challengeType + " Authorization header = " + req.getHeader("Authorization"));
                                                    }
                                                    isAdminApp = false;
                                                    this.setDomainContext(webAttrs, appContext);
                                                    if (((String)appContext.get("security.domain.type")).equals("administration")) {
                                                        isAdminApp = true;
                                                    }
                                                    if (taManager.isTrustAssociationEnabled()) {
                                                        reLoginURL = null;
                                                        if (challengeType.equalsIgnoreCase("FORM")) {
                                                            ctx = req.getContextPath();
                                                            if (ctx.equals("/")) {
                                                                ctx = "";
                                                            }
                                                            if (!(reLoginURL = webAttrs.getReloginURL()).startsWith("/")) {
                                                                reLoginURL = "/" + (String)reLoginURL;
                                                            }
                                                            reLoginURL = ctx + (String)reLoginURL;
                                                            if (WebAuthenticator.tc.isDebugEnabled()) {
                                                                Tr.debug(WebAuthenticator.tc, "Default redirect URL: " + (String)reLoginURL);
                                                            }
                                                        }
                                                        appContext.put("WebAppName", webAttrs.getWebAppName());
                                                        appContext.put("RedirectURL", (String)reLoginURL);
                                                        result = this.handleTrustAssociation(webAttrs, req, res, appContext, true);
                                                        if (result != null && result.getStatus() == 6) {
                                                            continueLogin = true;
                                                            result = null;
                                                        }
                                                    }
                                                    if (result != null) ** GOTO lbl98
                                                    if (authMechCredForwardable.booleanValue() && webAttrs.isSSOEnabled() && (result = this.handleSSO(webAttrs, req, res)) != null) {
                                                        if (result.getStatus() != 2) {
                                                            this.restorePostParams(req, res);
                                                        }
                                                        if (WebAuthenticator.tc.isEntryEnabled()) {
                                                            Tr.exit(WebAuthenticator.tc, "authenticate");
                                                        }
                                                        reLoginURL = result;
                                                    }
                                                    ** GOTO lbl-1000
                                                }
                                                catch (Exception e) {
                                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAuthenticator.authenticate", "2624", this);
                                                    if (WebAuthenticator.tc.isEntryEnabled()) {
                                                        Tr.debug(WebAuthenticator.tc, "Exception occurred: " + e.getMessage());
                                                        Tr.debug(WebAuthenticator.tc, "Authentication failed.");
                                                    }
                                                    result = new AuthenticationResult(2, e.getMessage());
                                                    if (WebAuthenticator.auditService != null && WebAuthenticator.auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                                                        data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                                                        WebAuthenticator.contextHandler.buildContextObject("SESSION_CONTEXT", data);
                                                        data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "denied", req.getMethod(), "web", new Long(0L), null, null, null, null);
                                                        WebAuthenticator.contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                                                        data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                                                        WebAuthenticator.contextHandler.buildContextObject("EVENT_CONTEXT", data);
                                                        data = DataHelper.buildPropagationData(WebAuthenticator.auditService.getFirstCaller(), WebAuthenticator.auditService.getCallerList());
                                                        WebAuthenticator.contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                                                        data = DataHelper.buildProcessData(WebAuthenticator.auditService.getDomain(), WebAuthenticator.auditService.getRealm());
                                                        WebAuthenticator.contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                                                        data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(WebAuthenticator.activeUserRegistry));
                                                        WebAuthenticator.contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                                                        data = DataHelper.buildAuthnData("challengeResponse");
                                                        WebAuthenticator.contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                                                        data = DataHelper.buildProviderData("WebSphere", "providerSuccess");
                                                        WebAuthenticator.contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                                                        this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 15L);
                                                        try {
                                                            WebAuthenticator.auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                                                        }
                                                        catch (ProviderFailureException pfe) {
                                                            Tr.error(WebAuthenticator.tc, "security.audit.service.sendevent.error", new Object[]{pfe});
                                                            msg = "security.audit.service.sendevent.error";
                                                            WebAuthenticator.auditService.processAuditFailure(msg, pfe);
                                                        }
                                                    }
                                                    break block54;
                                                }
                                                var26_24 = null;
                                                break block55;
lbl-1000:
                                                // 1 sources

                                                {
                                                    block64: {
                                                        if (taManager.isTrustAssociationEnabled() && (result = this.handleTrustAssociation(webAttrs, req, res, appContext, false)) != null && result.getStatus() == 6) {
                                                            continueLogin = true;
                                                            result = null;
                                                        }
lbl98:
                                                        // 4 sources

                                                        if (result != null) ** GOTO lbl177
                                                        isSpnegoAuthEnabled = security.getAuthMechanism("SPNEGO").getBoolean("spengoEnabled");
                                                        allowAppAuthMethodFallback = security.getAuthMechanism("SPNEGO").getBoolean("spengoAllowAppAuthMethodFallback");
                                                        if (!isSpnegoAuthEnabled) ** GOTO lbl147
                                                        result = this.handleSpnegoWebAuthentication(webAttrs, req, res, appContext);
                                                        if (result == null || result.getStatus() != 6) break block64;
                                                        if (WebAuthenticator.tc.isDebugEnabled()) {
                                                            Tr.debug(WebAuthenticator.tc, result.getReason());
                                                        }
                                                        continueLogin = true;
                                                        result = null;
                                                        ** GOTO lbl149
                                                    }
                                                    if (result == null || result.getStatus() != 1) ** GOTO lbl-1000
                                                    if (WebAuthenticator.tc.isEntryEnabled()) {
                                                        Tr.exit(WebAuthenticator.tc, "authenticate", "SPNEGO Web authentication was successful, result=" + result);
                                                    }
                                                    var22_33 = result;
                                                }
                                                break block56;
lbl-1000:
                                                // 1 sources

                                                {
                                                    block65: {
                                                        authHeader = req.getHeader("Authorization");
                                                        v0 = firstRequest = authHeader == null;
                                                        if (!firstRequest) ** GOTO lbl-1000
                                                        if (result.getStatus() != 2) ** GOTO lbl-1000
                                                        if (!allowAppAuthMethodFallback) break block65;
                                                        result = null;
                                                        ** GOTO lbl-1000
                                                    }
                                                    if (WebAuthenticator.tc.isDebugEnabled()) {
                                                        Tr.debug(WebAuthenticator.tc, "first request failed, but not allow appAuthMethod fallback");
                                                    }
                                                    var24_36 = result;
                                                }
                                                break block57;
lbl-1000:
                                                // 1 sources

                                                {
                                                    if (WebAuthenticator.tc.isDebugEnabled()) {
                                                        Tr.debug(WebAuthenticator.tc, "No Authorization header found, sending 401 challenge to the client");
                                                    }
                                                    continueLogin = true;
                                                    var24_37 = result;
                                                }
                                                break block58;
lbl-1000:
                                                // 1 sources

                                                {
                                                    block66: {
                                                        if (!allowAppAuthMethodFallback) break block66;
                                                        result = null;
                                                        ** GOTO lbl-1000
                                                    }
                                                    if (WebAuthenticator.tc.isDebugEnabled()) {
                                                        Tr.debug(WebAuthenticator.tc, "second request failed, but not allow appAuthMethod fallback");
                                                    }
                                                    var24_38 = result;
                                                }
                                                break block59;
lbl-1000:
                                                // 2 sources

                                                {
                                                    block67: {
                                                        if (WebAuthenticator.tc.isDebugEnabled()) {
                                                            Tr.debug(WebAuthenticator.tc, "SPNEGO Web authentication allow appAuthMethod fallback");
                                                        }
                                                        break block67;
lbl147:
                                                        // 1 sources

                                                        if (WebAuthenticator.tc.isDebugEnabled()) {
                                                            Tr.debug(WebAuthenticator.tc, "SPNEGO Web authentication is disabled.");
                                                        }
                                                    }
                                                    if (!challengeType.equalsIgnoreCase("FORM")) ** GOTO lbl-1000
                                                    if (taManager.isTrustAssociationEnabled() && !continueLogin) {
                                                        redirectURL = (String)appContext.get("RedirectURL");
                                                        if (redirectURL != null) {
                                                            if (WebAuthenticator.tc.isDebugEnabled()) {
                                                                Tr.debug(WebAuthenticator.tc, "Redirect to the error page: " + (String)redirectURL);
                                                            }
                                                            result = new AuthenticationResult(4, (String)redirectURL);
                                                        } else {
                                                            result = this.handleCustomLogin(webAttrs, req, res);
                                                        }
                                                    } else {
                                                        result = this.handleCustomLogin(webAttrs, req, res);
                                                    }
                                                    if (WebAuthenticator.tc.isEntryEnabled()) {
                                                        Tr.exit(WebAuthenticator.tc, "authenticate");
                                                    }
                                                    redirectURL = result;
                                                }
                                                break block61;
lbl-1000:
                                                // 1 sources

                                                {
                                                    if (!challengeType.equalsIgnoreCase("CLIENT_CERT") || (result = this.handleCertificates(webAttrs, req, res)) == null) ** GOTO lbl-1000
                                                    if (!result.equals(2) && setCookie) {
                                                        cookieList = WebAttributes.createCookies(req, result.getSubject());
                                                        if (cookieList != null) {
                                                            result.setCookieList(cookieList);
                                                        }
                                                    }
                                                    var22_34 = result;
                                                }
                                                break block62;
lbl-1000:
                                                // 1 sources

                                                {
                                                    result = this.handleBasicAuth(webAttrs, req, res);
lbl177:
                                                    // 2 sources

                                                    if (result.getStatus() != 1) break block54;
                                                    WebCollaborator.setPrivateAttributes(req, "AUTH_TYPE", "BASIC");
                                                    if (WebAuthenticator.tc.isEntryEnabled()) {
                                                        Tr.debug(WebAuthenticator.tc, "Successful authentication");
                                                    }
                                                    if (!setCookie) break block54;
                                                    cookieList = WebAttributes.createCookies(req, result.getSubject());
                                                    if (cookieList == null) break block54;
                                                    result.setCookieList(cookieList);
                                                }
                                            }
                                            if (WebAuthenticator.tc.isEntryEnabled()) {
                                                Tr.exit(WebAuthenticator.tc, "authenticate");
                                            }
                                            var13_11 = result;
                                            break block63;
                                        }
                                        catch (Throwable var25_39) {
                                            var26_32 = null;
                                            if (StatsFactory.isPMIEnabled() == false) throw var25_39;
                                            endTime = System.currentTimeMillis();
                                            this.authModule.onWebAuthTime(endTime - startTime);
                                            throw var25_39;
                                        }
                                    }
                                    if (StatsFactory.isPMIEnabled() == false) return reLoginURL;
                                    endTime = System.currentTimeMillis();
                                    this.authModule.onWebAuthTime(endTime - startTime);
                                    return reLoginURL;
                                }
                                var26_25 = null;
                                if (StatsFactory.isPMIEnabled() == false) return var22_33;
                                endTime = System.currentTimeMillis();
                                this.authModule.onWebAuthTime(endTime - startTime);
                                return var22_33;
                            }
                            var26_26 = null;
                            if (StatsFactory.isPMIEnabled() == false) return var24_36;
                            endTime = System.currentTimeMillis();
                            this.authModule.onWebAuthTime(endTime - startTime);
                            return var24_36;
                        }
                        var26_27 = null;
                        if (StatsFactory.isPMIEnabled() == false) return var24_37;
                        endTime = System.currentTimeMillis();
                        this.authModule.onWebAuthTime(endTime - startTime);
                        return var24_37;
                    }
                    var26_28 = null;
                    if (StatsFactory.isPMIEnabled() == false) return var24_38;
                    endTime = System.currentTimeMillis();
                    this.authModule.onWebAuthTime(endTime - startTime);
                    return var24_38;
                }
                var26_29 = null;
                if (StatsFactory.isPMIEnabled() == false) return redirectURL;
                endTime = System.currentTimeMillis();
                this.authModule.onWebAuthTime(endTime - startTime);
                return redirectURL;
            }
            var26_30 = null;
            if (StatsFactory.isPMIEnabled() == false) return var22_34;
            endTime = System.currentTimeMillis();
            this.authModule.onWebAuthTime(endTime - startTime);
            return var22_34;
        }
        var26_31 = null;
        if (StatsFactory.isPMIEnabled() == false) return var13_11;
        endTime = System.currentTimeMillis();
        this.authModule.onWebAuthTime(endTime - startTime);
        return var13_11;
    }

    public static String getCookieValue(Cookie[] cookies, String hdrName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCookieValue", hdrName);
        }
        String retVal = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!hdrName.equals(cookies[i].getName())) continue;
                retVal = cookies[i].getValue();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCookieValue", retVal);
        }
        return retVal;
    }

    public static String[] getCookieValues(Cookie[] cookies, String hdrName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCookieValues", hdrName);
        }
        Vector<String> retValues = new Vector<String>();
        int numMatches = 0;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!hdrName.equals(cookies[i].getName())) continue;
                retValues.add(cookies[i].getValue());
                ++numMatches;
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, cookies[i].getValue());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCookieValues");
        }
        if (retValues.size() > 0) {
            return retValues.toArray(new String[numMatches]);
        }
        return null;
    }

    public AuthenticationResult validate(String realm, byte[] credentialToken, WebAttributes webAttrs, HttpServletRequest req, HttpServletResponse res) {
        return this.validate(realm, credentialToken, webAttrs, req, res, null);
    }

    public AuthenticationResult validate(String realm, byte[] credentialToken, WebAttributes webAttrs, HttpServletRequest req, HttpServletResponse res, String cookieName) {
        AuthenticationResult authResult;
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            authResult = null;
            this.auditStartTime = new Date();
            String lastTrailId = null;
            String[] eventTrailIds = null;
            if (auditService != null) {
                lastTrailId = auditService.getLastTrailId();
                eventTrailIds = auditService.getEventTrailIds();
            }
            try {
                HashMap<String, String> appContext = new HashMap<String, String>(4);
                appContext.put("WebAppName", webAttrs.getWebAppName());
                appContext.put("RedirectURL", null);
                this.setDomainContext(webAttrs, appContext);
                realm = (String)appContext.get("realm_name");
                ContextManager contextManager = ContextManagerFactory.getInstance();
                Subject subject = null;
                if (cookieName != null && cookieName.equals(this.krb5CookieName)) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Kerberos token: " + credentialToken);
                    }
                    subject = contextManager.login(realm, credentialToken, authMech, req, res, appContext, null, "oid:1.2.840.113554.1.2.2");
                } else {
                    subject = contextManager.login(realm, credentialToken, authMech, req, res, appContext, null, "oid:1.3.18.0.2.30.2");
                }
                if (subject == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validate: Subject is null.");
                    }
                    if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                        HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "denied", req.getMethod(), "web", new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData("challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData(providerName, "providerSuccess");
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 27L);
                        try {
                            auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException e) {
                            Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                            String msg = "security.audit.service.sendevent.error";
                            auditService.processAuditFailure(msg, e);
                        }
                    }
                    return AUTHN_FAILED_RESULT;
                }
                authResult = new AuthenticationResult(1, subject);
                WSCredential userCred = SubjectHelper.getWSCredentialFromSubject(subject);
                if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "SUCCESS")) {
                    String rSubj = null;
                    if (subject != null) {
                        rSubj = ((Principal)subject.getPrincipals().toArray()[0]).getName();
                    }
                    HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", rSubj, userCred.getSecurityName(), "authnSuccess", req.getMethod(), "web", new Long(0L), null, null, null, null);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildProcessData(null, realm);
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildAuthnData("challengeResponse");
                    contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                    data = DataHelper.buildProviderData(providerName, "providerSuccess");
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 5L);
                    try {
                        auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                    }
                    catch (ProviderFailureException e) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                        String msg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg, e);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAuthenticator.validate", "2952", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validate", e);
                }
                authResult = new AuthenticationResult(2, e.getMessage());
                if (auditService == null || !auditService.isEventRequired("SECURITY_AUTHN", "DENIED") || contextHandler == null) break block20;
                HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, null, "denied", req.getMethod(), "web", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildAuthnData("challengeResponse");
                contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                data = DataHelper.buildProviderData(providerName, "providerSuccess");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 15L);
                try {
                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                }
                catch (ProviderFailureException pfe) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pfe});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, pfe);
                }
            }
        }
        authResult.realm = realm;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return authResult;
    }

    private void initialize() {
        this.cushion = AuthCache.getInstance().getCushion();
    }

    public AuthenticationResult basicAuthenticate(String realm, String username, String password) {
        return this.basicAuthenticate(realm, username, password, null, null, null);
    }

    public AuthenticationResult basicAuthenticate(String realm, String username, String password, WebAttributes webAttrs, HttpServletRequest req, HttpServletResponse res) {
        AuthenticationResult authResult;
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "basicAuthenticate");
            }
            authResult = null;
            this.auditStartTime = new Date();
            String lastTrailId = null;
            String[] eventTrailIds = null;
            if (auditService != null) {
                lastTrailId = auditService.getLastTrailId();
                eventTrailIds = auditService.getEventTrailIds();
            }
            try {
                Subject subject = null;
                ContextManager contextManager = ContextManagerFactory.getInstance();
                if (webAttrs != null) {
                    HashMap<String, String> appContext = new HashMap<String, String>(4);
                    appContext.put("WebAppName", webAttrs.getWebAppName());
                    appContext.put("RedirectURL", null);
                    String thisAuthMech = "system.WEB_INBOUND";
                    Boolean authMechCredForwardable = SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getBoolean("isCredentialForwardable");
                    if (authMechCredForwardable != null && !authMechCredForwardable.booleanValue()) {
                        thisAuthMech = "system.SWAM";
                    }
                    realm = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getString("realm");
                    subject = contextManager.login(realm, username, password, thisAuthMech, req, res, appContext);
                } else {
                    subject = contextManager.login(DomainInfo.getAppRealm(), username, password, authMech, null, null, null);
                }
                if (subject == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "basicAuthenticate: authentication failed");
                    }
                    if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                        HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, username, "denied", req.getMethod(), "web", new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData("challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData(providerName, "providerSuccess");
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 28L);
                        try {
                            auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException e) {
                            Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                            String msg = "security.audit.service.sendevent.error";
                            auditService.processAuditFailure(msg, e);
                        }
                    }
                    return AUTHN_FAILED_RESULT;
                }
                authResult = new AuthenticationResult(1, subject);
                if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "SUCCESS")) {
                    String rSubj = null;
                    if (subject != null) {
                        rSubj = ((Principal)subject.getPrincipals().toArray()[0]).getName();
                    }
                    HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", rSubj, username, "authnSuccess", req.getMethod(), "web", new Long(0L), null, null, null, null);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildAuthnData("challengeResponse");
                    contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                    data = DataHelper.buildProviderData(providerName, "providerSuccess");
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 5L);
                    try {
                        auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                    }
                    catch (ProviderFailureException e) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                        String msg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg, e);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAuthenticator.basicAuthenticate", "1745", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "basicAuthenticate", e);
                }
                authResult = new AuthenticationResult(2, e.getMessage());
                if (auditService == null || !auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) break block20;
                HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(WebCollaborator.getURI(req), "webAuth", null, username, "denied", req.getMethod(), "web", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildAuthnData("challengeResponse");
                contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                data = DataHelper.buildProviderData(providerName, "providerSuccess");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 15L);
                try {
                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                }
                catch (ProviderFailureException pfe) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pfe});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, pfe);
                }
            }
        }
        authResult.realm = realm;
        authResult.userName = username;
        authResult.passWord = password;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "basicAuthenticate");
        }
        return authResult;
    }

    protected WSCredential setSasBasicAuth(String realm, String username, String password) throws Exception {
        throw new RuntimeException("Not Implemented");
    }

    public Subject getPreferredSubject(Subject invokedSubject, Subject receivedSubject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreferredSubject");
        }
        return invokedSubject != null ? invokedSubject : receivedSubject;
    }

    private boolean isAdminApp(WebAttributes webAttrs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAdminApp");
        }
        boolean adminApp = false;
        adminApp = webAttrs != null ? WSAccessManager.checkIfAdminApp(webAttrs.getWebAppName()) : false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAdminApp", adminApp);
        }
        return adminApp;
    }

    private void setDomainContext(WebAttributes webAttrs, Map appContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDomainContext");
        }
        boolean isAdminApp = WSAccessManager.checkIfAdminApp(webAttrs.getWebAppName());
        String realm = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getString("realm");
        appContext.put("realm_name", realm);
        if (isAdminApp) {
            appContext.put("security.domain.type", "administration");
        } else {
            appContext.put("security.domain.type", "application");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDomainContext", appContext);
        }
    }

    static {
        default_realm = null;
        activeUserRegistry = null;
    }
}

