/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtension;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.SingleSignonConfig;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.net.InetAddress;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.webapplication.FormLoginConfig;
import org.eclipse.jst.j2ee.webapplication.LoginConfig;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class WebAttributes {
    private static final TraceComponent tc = Tr.register(WebAttributes.class, "Security", "com.ibm.ejs.resources.security");
    private static final TraceComponent zOS_tc = Tr.register("WebAttributes.class", "Security", "com.ibm.ejs.resources.ws390Messages");
    public static final String LOCALOS = "LOCALOS";
    public static final String LTPA = "LTPA";
    public static final String UNSUPPORTED = "UNSUPPORTED";
    private static Object lockObject = new Object();
    private static Cookie cookieAttrs;
    private static boolean secureSSO;
    private static boolean setSSODomain;
    private static String loginCookieName;
    private static String cookieSuffix;
    private static final String SSO_COOKIE_SUFFIX = "Token";
    private static String[] ltpaCookieNames;
    private static boolean isSecurityEnabled;
    private static boolean setHttpOnlyFlag;
    private static String authMechanism;
    private static final char CERTIFICATE_FLAG = 'C';
    private static final char COOKIE_FLAG = 'K';
    private static final char AUTHORIZATION_FLAG = 'A';
    private static String[] ssoDomainList;
    private static boolean useURLDomain;
    private static HashMap cookieStringCache;
    private static int MAX_COOKIE_STRING_ENTRIES;
    private boolean isProtected = true;
    private String realm = null;
    private String challengeType;
    private boolean useSSL = false;
    private boolean defaultToBasic = false;
    private String pluginCfg;
    private String loginURL = null;
    private String reloginURL = null;
    private String webAppName = null;
    private boolean _applicationSyncToOSThreadEnabled;
    private static SecurityConfig security;

    public WebAttributes() {
        this.isProtected = false;
    }

    public WebAttributes(WebApp webApp) throws RuntimeException {
        boolean toBasic;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WebAttributes");
        }
        WebAttributes.initializeConfig();
        setHttpOnlyFlag = security.getPropertyBool("com.ibm.ws.security.addHttpOnlyAttributeToCookies", setHttpOnlyFlag);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setHttpOnlyFlag =  " + setHttpOnlyFlag);
        }
        if (toBasic = security.getBoolean("com.ibm.wsspi.security.web.failOverToBasicAuth")) {
            this.defaultToBasic = true;
        }
        this._applicationSyncToOSThreadEnabled = this.getApplicationSyncToOSThread(webApp);
        try {
            LoginConfig loginCfg;
            this.webAppName = webApp.getDisplayName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Webattrs for webApp =  " + this.webAppName);
            }
            if ((loginCfg = webApp.getLoginConfig()) != null) {
                this.realm = loginCfg.getRealmName();
                int auth = loginCfg.getAuthMethod().getValue();
                if (auth == 1) {
                    this.challengeType = "BASIC";
                } else if (auth == 4) {
                    this.challengeType = "CLIENT_CERT";
                } else if (auth == 3) {
                    this.challengeType = "FORM";
                    FormLoginConfig formConfig = loginCfg.getFormLoginConfig();
                    if (formConfig != null) {
                        this.loginURL = formConfig.getFormLoginPage();
                        this.reloginURL = formConfig.getFormErrorPage();
                    }
                } else {
                    this.challengeType = auth == 2 ? "DIGEST" : "BASIC";
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Login Config is not available for webApp " + this.webAppName + " Assuming Basic Authentication");
                }
                this.challengeType = "BASIC";
                this.realm = "Default Realm";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "realm is " + this.realm);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "use SSL is " + new Boolean(this.useSSL));
            }
            boolean bl = this.isProtected = !this.challengeType.equals("none");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "challenge type is " + this.challengeType);
            }
            StringBuffer sb = new StringBuffer(3);
            if (this.challengeType.equals("CLIENT_CERT")) {
                sb.append('C');
            }
            if (this.isSSOEnabled()) {
                sb.append('K');
            }
            if (this.defaultToBasic || this.challengeType.equals("BASIC")) {
                sb.append('A');
            }
            this.pluginCfg = sb.toString();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAttributes.WebAttributes", "167", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "WebAttributes", e);
            }
            Tr.error(tc, "security.webatts.exception", new Object[]{this.webAppName, e});
            throw new RuntimeException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WebAttributes");
        }
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getChallengeType() {
        return this.challengeType;
    }

    public String getAuthMechanism() {
        return security.getActiveAuthMechanism().getType();
    }

    public boolean isSSLEnabled() {
        return this.useSSL;
    }

    public boolean isSSOEnabled() {
        SingleSignonConfig sso = security.getActiveAuthMechanism().getSingleSignon();
        if (sso == null) {
            return false;
        }
        return sso.getBoolean("enabled");
    }

    private static Iterator getSingleSignonTokensFromSubject(final Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSingleSignonTokensFromSubject");
        }
        try {
            ArrayList ssoArrayList = new ArrayList();
            if (subject != null) {
                Set privateCredentials = null;
                Set<SingleSignonToken> publicCredentials = null;
                HashSet<SingleSignonToken> newSet = new HashSet<SingleSignonToken>();
                try {
                    privateCredentials = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return subject.getPrivateCredentials(SingleSignonToken.class);
                        }
                    });
                    if (privateCredentials != null && privateCredentials.size() > 0) {
                        newSet.addAll(privateCredentials);
                    }
                    if ((publicCredentials = subject.getPublicCredentials(SingleSignonToken.class)) != null && publicCredentials.size() > 0) {
                        newSet.addAll(publicCredentials);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSingleSignonTokensFromSubject");
                    }
                    return newSet.iterator();
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.WebAttributes.getSingleSignonToken", "250");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSingleSignonTokensFromSubject", new Object[]{e});
                    }
                    return null;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSingleSignonTokensFromSubject: (null)");
            }
            return null;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.WebAttributes.getDefaultSingleSignonToken", "261");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSingleSignonTokensFromSubject", new Object[]{e});
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCookieToList(HttpServletRequest req, String cookieName, byte[] ssoTokenBytes, ArrayList cookieList, boolean logout) {
        if (ssoTokenBytes != null || logout) {
            Cookie c;
            String cookieString = "";
            if (!logout && (cookieString = (String)cookieStringCache.get(new ByteArray(ssoTokenBytes))) == null) {
                cookieString = Base64Coder.base64Encode(StringUtil.toString(ssoTokenBytes));
                HashMap hashMap = cookieStringCache;
                synchronized (hashMap) {
                    if (cookieStringCache.size() > MAX_COOKIE_STRING_ENTRIES) {
                        cookieStringCache.clear();
                    }
                    if (cookieString != null) {
                        cookieStringCache.put(new ByteArray(ssoTokenBytes), cookieString);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting SSO cookie with name: " + cookieName + " logout " + logout + ", value: " + cookieString);
            }
            if ((c = new Cookie(cookieName, cookieString)) != null) {
                WebAttributes.copyIntoStatic(c, req);
                if (logout) {
                    c.setMaxAge(0);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cookie value: " + c.getValue());
                }
                cookieList.add(c);
            }
        }
    }

    public void createLogoutCookies(HttpServletRequest req, HttpServletResponse res) {
        WebAttributes.createLogoutCookiesStatic(req, res);
    }

    public static void createLogoutCookiesStatic(HttpServletRequest req, HttpServletResponse res) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createLogoutCookiesStatic");
        }
        Cookie[] cookies = req.getCookies();
        String[] ltpaCookeNames = WebAttributes.getAllLTPACookieNamesStatic();
        ArrayList cookieList = new ArrayList();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                try {
                    for (int j = 0; j < ltpaCookeNames.length; ++j) {
                        if (!cookies[i].getName().equals(ltpaCookeNames[j])) continue;
                        WebAttributes.addCookieToList(req, ltpaCookeNames[j], null, cookieList, true);
                    }
                    continue;
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.security.web.WebAttributes.createLogoutCookiesStatic", "319");
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception creating logout cookie.", new Object[]{t});
                }
            }
            cookies = cookieList.toArray(new Cookie[0]);
            for (int n = 0; n < cookies.length; ++n) {
                try {
                    res.addCookie(cookies[n]);
                    continue;
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.security.web.WebAttributes.createLogoutCookiesStatic", "332");
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception adding logout cookie to response.", new Object[]{t});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createLogoutCookiesStatic");
        }
    }

    public static void addCookiesToResponse(List cookieList, HttpServletResponse res) {
        if (cookieList != null) {
            ListIterator iterator = cookieList.listIterator();
            while (iterator.hasNext()) {
                Cookie cookie = (Cookie)iterator.next();
                if (cookie == null) continue;
                if (setHttpOnlyFlag) {
                    StringBuffer headerString = new StringBuffer(cookie.getName());
                    headerString.append("=");
                    headerString.append(cookie.getValue());
                    headerString.append("; ");
                    if (cookie.getPath() != null && cookie.getPath().length() > 0) {
                        headerString.append("path=");
                        headerString.append(cookie.getPath());
                    } else {
                        headerString.append("path=/");
                    }
                    if (cookie.getDomain() != null && cookie.getDomain().length() > 0) {
                        headerString.append("; domain=");
                        headerString.append(cookie.getDomain());
                    }
                    if (cookie.getSecure()) {
                        headerString.append("; secure");
                    }
                    headerString.append("; HttpOnly");
                    if (headerString == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting cookie string into response: Set-Cookie: " + headerString.toString());
                    }
                    res.addHeader("Set-Cookie", headerString.toString());
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting cookie into response.");
                }
                res.addCookie(cookie);
            }
        }
    }

    public static ArrayList createCookies(HttpServletRequest req, Subject subject) {
        return WebAttributes.createCookiesStatic(req, subject);
    }

    public static ArrayList createCookiesStatic(HttpServletRequest req, Subject subject) {
        boolean sso_interop;
        byte[] ssoTokenBytes;
        Iterator ssoTokensFromSubject;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCookiesStatic");
        }
        ArrayList cookieList = new ArrayList();
        SingleSignonToken defaultSSOToken = null;
        WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subject);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Propagation enabled, adding new cookie.");
        }
        if ((ssoTokensFromSubject = WebAttributes.getSingleSignonTokensFromSubject(subject)) != null) {
            while (ssoTokensFromSubject.hasNext()) {
                SingleSignonToken ssoToken = (SingleSignonToken)ssoTokensFromSubject.next();
                if (ssoToken == null) continue;
                ssoTokenBytes = ssoToken.getBytes();
                String name = ssoToken.getName();
                if (name.equals("LtpaToken")) {
                    defaultSSOToken = ssoToken;
                }
                short version = ssoToken.getVersion();
                String cookieName = name + new Short(version).toString();
                WebAttributes.addCookieToList(req, cookieName, ssoTokenBytes, cookieList, false);
            }
        }
        if ((sso_interop = security.getPropertyBool("com.ibm.ws.security.ssoInteropModeEnabled")) || cookieList.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding old cookie.");
            }
            ssoTokenBytes = null;
            String cookieName = WebAttributes.getLTPACookieNameStatic();
            if (cred != null) {
                block12: {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Getting interop token from default SSO token previously found.");
                        }
                        ssoTokenBytes = cred.getCredentialToken();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException(e, "com.ibm.ws.security.web.WebAttributes.createCookiesStatic", "338");
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug(tc, "Exception getting WSCredential token.", new Object[]{e});
                    }
                }
                WebAttributes.addCookieToList(req, cookieName, ssoTokenBytes, cookieList, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCookiesStatic: returning " + cookieList.size() + " cookie(s) to add to response.");
        }
        return cookieList;
    }

    public boolean isSecureSSO() {
        return secureSSO;
    }

    public boolean isDefaultToBasic() {
        return this.defaultToBasic;
    }

    public String getLTPACookieName() {
        return "LtpaToken";
    }

    public static String getLTPACookieNameStatic() {
        return "LtpaToken";
    }

    public String getPreferredLTPACookieName() {
        return "LtpaToken2";
    }

    public String[] getAllLTPACookieNames() {
        return ltpaCookieNames;
    }

    public static String[] getAllLTPACookieNamesStatic() {
        return ltpaCookieNames;
    }

    public String getLoginCookieName() {
        return loginCookieName;
    }

    public String getCookieSuffix() {
        return cookieSuffix;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("webAppName[" + this.webAppName + "]");
        sb.append("\nisProtected[" + this.isProtected() + "]");
        sb.append("\nrealm[" + this.getRealm() + "]");
        sb.append("\nchallengeType[" + this.getChallengeType() + "]");
        sb.append("\nauthMechanism[" + this.getAuthMechanism() + "]");
        sb.append("\nSSLEnabled[" + this.isSSLEnabled() + "]");
        sb.append("\nSSOEnabled[" + this.isSSOEnabled() + "]");
        sb.append("\nsecureSSO[" + this.isSecureSSO() + "]");
        sb.append("\ndefaultToBasic[" + this.isDefaultToBasic() + "]");
        sb.append("\nLTPACookieName[" + this.getLTPACookieName() + "]");
        sb.append("\nloginCookieName[" + this.getLoginCookieName() + "]");
        sb.append("\nCookieSuffix[" + this.getCookieSuffix() + "]");
        return sb.toString();
    }

    public String getLoginURL() {
        return this.loginURL;
    }

    public String getReloginURL() {
        return this.reloginURL;
    }

    public String getWebAppName() {
        return this.webAppName;
    }

    public void copyInto(Cookie c, HttpServletRequest req) {
        WebAttributes.copyIntoStatic(c, req);
    }

    public static void copyIntoStatic(Cookie c, HttpServletRequest req) {
        if (setSSODomain) {
            String domain = WebAttributes.getSSODomain(req);
            if (domain.length() > 0) {
                c.setDomain(WebAttributes.getSSODomain(req));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SSO domain setting is disabled ");
        }
        c.setMaxAge(cookieAttrs.getMaxAge());
        c.setPath(cookieAttrs.getPath());
        c.setSecure(cookieAttrs.getSecure());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeConfig() throws RuntimeException {
        Object object = lockObject;
        synchronized (object) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initializeConfig");
            }
            try {
                isSecurityEnabled = security.getBoolean("enabled");
                boolean am = security.getActiveAuthMechanism().getBoolean("isCredentialForwardable");
                if (am) {
                    SingleSignonConfig sso = security.getActiveAuthMechanism().getSingleSignon();
                    boolean ssoEnabled = false;
                    if (sso != null) {
                        ssoEnabled = sso.getBoolean("enabled");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SSO is " + ssoEnabled);
                    }
                    if (ssoEnabled) {
                        String s = sso.getString("domainName");
                        if (s == null) {
                            s = "";
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SSO Domain is " + s);
                        }
                        cookieAttrs = new Cookie("LtpaToken", null);
                        WebAttributes.setSSODomainList(s);
                        secureSSO = sso.getBoolean("requireSSL");
                        cookieAttrs.setSecure(secureSSO);
                        setSSODomain = sso.getBoolean("security.ltpa.setSSODomain");
                        if (s.length() < 1) {
                            setSSODomain = false;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SSO is secure " + secureSSO);
                        }
                        cookieAttrs.setPath("/");
                        cookieAttrs.setMaxAge(-1);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.web.WebAttributes.initializeConfig", "345");
                Tr.warning(tc, "security.web.config.initerror", new Object[]{e});
                throw new RuntimeException(e.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeConfig");
            }
        }
    }

    private static void setSSODomainList(String ssoDomains) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSSODomainList");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Raw List: '" + ssoDomains + "'");
        }
        if (ssoDomains != null && ssoDomainList == null) {
            StringTokenizer st = new StringTokenizer(ssoDomains, " ;,|");
            Vector<String> v = new Vector<String>();
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.equalsIgnoreCase("UseDomainFromURL")) {
                    useURLDomain = true;
                    continue;
                }
                if (s.length() <= 0) continue;
                if (s.charAt(0) != '.') {
                    s = "." + s;
                }
                v.add(s);
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "Adding domain '" + s + "'");
            }
            ssoDomainList = v.toArray(new String[0]);
        }
        if (tc.isEntryEnabled()) {
            WebAttributes.traceSSODomainParameters();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSSODomainList");
        }
    }

    public static String getSSODomain(HttpServletRequest req) {
        String domain;
        boolean domainMatchFound;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSSODomain");
            }
            if (tc.isEntryEnabled()) {
                WebAttributes.traceSSODomainParameters();
            }
            domainMatchFound = false;
            String s = req.getRequestURL().toString();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "URL: " + s);
            }
            domain = "";
            try {
                String iAddr;
                URL u = new URL(s);
                String host = u.getHost().trim();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Request host: " + host);
                }
                try {
                    iAddr = InetAddress.getByName(host).getHostAddress().trim();
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.web.WebAttributes.WebAttributes", "747");
                    Tr.debug(tc, "Exception in getting IP address for URL host, assuming URL host is not an IP", new Object[]{e});
                    iAddr = "";
                }
                if (tc.isEntryEnabled() && host.equals(iAddr)) {
                    Tr.debug(tc, "URL host is an IP, no SSO domain will be set.");
                }
                if (host.indexOf(".") == -1 || host.equals(iAddr)) break block14;
                domain = host.substring(host.indexOf("."));
                for (int n = 0; n < ssoDomainList.length; ++n) {
                    if (!domain.endsWith(ssoDomainList[n])) continue;
                    domain = ssoDomainList[n];
                    domainMatchFound = true;
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Domain match found: '" + domain + "'");
                    }
                    break;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.web.WebAttributes.WebAttributes", "438");
                Tr.debug(tc, "Unexpected exception getting request host/SSO domain", new Object[]{e});
            }
        }
        if (!domainMatchFound && !useURLDomain) {
            domain = "";
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "SSO Domain is: '" + domain + "'");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSODomain");
        }
        return domain;
    }

    private static void traceSSODomainParameters() {
        if (ssoDomainList.length == 0) {
            Tr.debug(tc, "SSO Domain List is empty");
        } else {
            StringBuffer st = new StringBuffer("SSO Domain List: ");
            for (int n = 0; n < ssoDomainList.length; ++n) {
                st.append(ssoDomainList[n]);
                if (n >= ssoDomainList.length - 1) continue;
                st.append(":");
            }
            Tr.debug(tc, st.toString());
        }
        if (useURLDomain) {
            Tr.debug(tc, "Domain of host in URL will be used for SSO if a parent domain is not found in the list above.");
        } else {
            Tr.debug(tc, "SSO Domain will be set to an empty string if a parent domain is not found in the list above.");
        }
    }

    private boolean getApplicationSyncToOSThread(WebApp _webModuleDD) {
        EList envEntriesList;
        EnvEntry[] envEntries;
        boolean rc = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WebAttributes.getApplicationSyncToOSThread: application = " + _webModuleDD.getDisplayName());
        }
        if ((envEntries = (envEntriesList = _webModuleDD.getEnvEntries()).toArray(new EnvEntry[envEntriesList.size()])) != null) {
            for (int i = 0; i < envEntries.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WebAttributes.getApplicationSyncToOSThread: application(" + _webModuleDD.getDisplayName() + ") environment entry: " + envEntries[i].getName() + " = " + envEntries[i].getValue());
                }
                if (!envEntries[i].getName().equals("com.ibm.websphere.security.SyncToOSThread")) continue;
                Boolean b = Boolean.valueOf(envEntries[i].getValue());
                rc = b;
            }
        }
        if (rc) {
            WSLoginLocalOSExtension localSecurityLoginExt;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebAttributes.getApplicationSyncToOSThread: application = " + _webModuleDD.getDisplayName() + " has requested SyncToOSThread");
            }
            if (!(localSecurityLoginExt = WSLoginLocalOSExtensionFactory.getInstance()).isApplicationSyncToOSThreadEnabled()) {
                Tr.warning(zOS_tc, "BBOJ0084", _webModuleDD.getDisplayName());
                rc = false;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebAttributes.getApplicationSyncToOSThread: SyncToOSThread is enabled in this server");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WebAttributes.getApplicationSyncToOSThread: application = " + _webModuleDD.getDisplayName() + " has not requested SyncToOSThread");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WebAttributes.getApplicationSyncToOSThread: rc = " + rc);
        }
        return rc;
    }

    public boolean isApplicationSyncToOSThreadEnabled() {
        return this._applicationSyncToOSThreadEnabled;
    }

    static {
        setSSODomain = true;
        loginCookieName = null;
        cookieSuffix = null;
        ltpaCookieNames = new String[]{"LtpaToken", "LtpaToken2"};
        setHttpOnlyFlag = false;
        ssoDomainList = null;
        useURLDomain = false;
        cookieStringCache = new HashMap(20);
        MAX_COOKIE_STRING_ENTRIES = 100;
        security = SecurityObjectLocator.getSecurityConfig();
    }
}

