/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.PropagationToken;
import java.security.PrivilegedAction;
import java.util.Enumeration;

public class PropagationTokenImpl
extends AbstractTokenImpl
implements PropagationToken {
    private Token token = null;
    private LTPAServerObject ltpaServer = null;
    private ContextManager contextManager = null;
    private transient int hashCode = 0;
    private transient long changeCounterWhenHashCodeCalculated = 0L;
    private static final TraceComponent tc = Tr.register(PropagationTokenImpl.class, null, "com.ibm.ejs.resources.security");
    private static String factoryClass = null;

    public PropagationTokenImpl() {
        if (factoryClass == null) {
            factoryClass = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.wsspi.security.token.propagationTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "factoryClass:" + factoryClass);
            }
        }
    }

    public void initializeToken(byte[] _propagationToken) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeToken(byte[])", "_propagationToken=" + _propagationToken);
        }
        this.initializeToken(_propagationToken, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeToken(byte[])");
        }
    }

    public void initializeToken(byte[] _propagationToken, boolean refreshIfExpired) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeToken(byte[],boolean)", new Object[]{"_propagationToken=" + _propagationToken, "refreshIfExpired=" + refreshIfExpired});
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing propagation token.");
            }
            this.hashCode = 0;
            this.changeCounterWhenHashCodeCalculated = 0L;
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
            this.token = null;
            if (factoryClass != null) {
                try {
                    this.token = this.ltpaServer.validateToken(_propagationToken, factoryClass, refreshIfExpired);
                }
                catch (Exception e) {
                    Tr.debug(tc, "Exception validating propagation token by using factoryClass.", new Object[]{e});
                }
            }
            if (this.token == null) {
                this.token = this.ltpaServer.validateToken(_propagationToken, refreshIfExpired);
            }
            final Token tokenPriv = this.token;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PropagationTokenImpl.this.setToken(tokenPriv);
                    return null;
                }
            });
        }
        catch (WSLoginFailedException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.PropagationTokenImpl.initializeToken", "58", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
            this.contextManager.setRootException(e);
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.PropagationTokenImpl.initializeToken", "65", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
            this.contextManager.setRootException(e);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeToken(byte[],boolean)");
        }
    }

    public void initializeToken(Token _token) throws WSLoginFailedException {
        this.hashCode = 0;
        this.changeCounterWhenHashCodeCalculated = 0L;
        final Token tokenPriv = this.token = _token;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PropagationTokenImpl.this.setToken(tokenPriv);
                return null;
            }
        });
    }

    public String getUniqueID() {
        String uniqueID = Integer.toString(this.hashCode());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning uniqueID of propagation token: " + uniqueID);
        }
        return uniqueID;
    }

    public int hashCode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hashCode");
        }
        long changeCounter = Long.parseLong(this.getChangeCounter());
        if (this.hashCode == 0 || this.changeCounterWhenHashCodeCalculated != changeCounter) {
            StringBuffer sb = new StringBuffer();
            Enumeration e = this.getAttributeNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String[] attributes = this.getAttributes(key);
                sb.append(key);
                sb.append(": ");
                for (int i = 0; i < attributes.length; ++i) {
                    sb.append(attributes[i] + ",");
                }
                sb.append("|");
            }
            String hashCodeString = sb.toString();
            if (hashCodeString != null) {
                this.hashCode = hashCodeString.hashCode();
                this.changeCounterWhenHashCodeCalculated = Long.parseLong(this.getChangeCounter());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "hashCode calculated, current change counter: " + this.changeCounterWhenHashCodeCalculated);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hashCode -> " + this.hashCode);
        }
        return this.hashCode;
    }

    public byte[] getBytes() {
        if (this.token != null) {
            try {
                return super.getBytes();
            }
            catch (Exception e) {
                Tr.debug(tc, "Exception creating byte[] of propagation token.", new Object[]{e});
                FFDCFilter.processException(e, "com.ibm.ws.security.token.PropagationTokenImpl.getUniqueID", "166");
                return null;
            }
        }
        return null;
    }

    public Object clone() {
        try {
            PropagationTokenImpl newToken = new PropagationTokenImpl();
            this.token = (Token)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return PropagationTokenImpl.this.getToken();
                }
            });
            newToken.initializeToken((Token)this.token.clone());
            return newToken;
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception creating clone of propagation token.", new Object[]{e});
            FFDCFilter.processException(e, "com.ibm.ws.security.ltpa.LTPAToken.clone", "190");
            return null;
        }
    }
}

