/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.wsspi.security.token.KerberosToken;
import java.util.Enumeration;
import java.util.Hashtable;
import org.ietf.jgss.GSSCredential;

public class KerberosTokenImpl
extends AbstractTokenImpl
implements KerberosToken {
    private byte[] tokenBytes = null;
    private GSSCredential gssCredential = null;
    private Hashtable kerberosData = null;
    private String KERBEROS_MECH = "1.2.840.113554.1.2.2";
    private String KERBEROS_OID = "oid:" + this.KERBEROS_MECH;
    private ContextManager contextManager = null;
    private String tokenName = "com.ibm.ws.security.token.KerberosTokenImpl";
    private boolean forwardable = false;
    private boolean isReadOnly = false;
    private short version = 1;
    private static final WebSphereRuntimePermission UPDATE_TOKEN = new WebSphereRuntimePermission("updateToken");
    private static final TraceComponent tc = Tr.register(KerberosTokenImpl.class, null, "com.ibm.ejs.resources.security");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initializeToken(byte[] credToken) throws WSLoginFailedException {
        if (credToken != null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using byte[] to create token for OID: " + this.KERBEROS_OID);
                }
                this.gssCredential = Krb5WSCredentialUtils.validateToken(credToken);
                this.kerberosData = new Hashtable();
                if (this.gssCredential == null || !tc.isDebugEnabled()) return;
                Tr.debug(tc, "GSSCredential initialized");
                return;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.KerberosTokenImpl", "81", this);
                Tr.debug(tc, "Exception validating token.", new Object[]{e});
                this.contextManager.setRootException(e);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        } else {
            WSLoginFailedException e = new WSLoginFailedException("KerberosTokenImpl: Invalid authentication data");
            this.contextManager.setRootException(e);
            throw e;
        }
    }

    public void initializeToken(GSSCredential gssCred) throws WSLoginFailedException {
        try {
            this.gssCredential = gssCred;
            this.kerberosData = new Hashtable();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.KerberosTokenImpl", "107", this);
            this.contextManager.setRootException(e);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        if (this.gssCredential == null) {
            WSLoginFailedException e = new WSLoginFailedException("KerberosTokenImpl: no gssCredential in Subject");
            this.contextManager.setRootException(e);
            throw e;
        }
    }

    public boolean isValid() {
        int life = 0;
        try {
            life = this.gssCredential.getRemainingLifetime();
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception getting expiraion from GSSCredential.", new Object[]{e});
        }
        return life > 0;
    }

    public long getExpiration() {
        int life = -1;
        try {
            life = this.gssCredential.getRemainingLifetime();
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception getting expiraion from GSSCredential.", new Object[]{e});
            return -1L;
        }
        return (long)(life * 1000) + System.currentTimeMillis();
    }

    public boolean isForwardable() {
        return false;
    }

    public String getPrincipal() {
        if (this.gssCredential != null) {
            String princ = null;
            try {
                princ = ((Object)this.gssCredential.getName()).toString();
            }
            catch (Exception e) {
                Tr.debug(tc, "Exception getting principal name from GSSCredential.", new Object[]{e});
            }
            return princ;
        }
        Tr.debug(tc, "GSSCredential is null, cannot get principal.");
        return null;
    }

    public String getUniqueID() {
        return this.getPrincipal();
    }

    public byte[] getBytes() {
        return null;
    }

    public String getName() {
        return this.tokenName;
    }

    public short getVersion() {
        return this.version;
    }

    public boolean isBasicAuth() {
        return false;
    }

    public void setReadOnly() {
        this.isReadOnly = true;
    }

    public String[] getAttributes(String key) {
        String data = (String)this.kerberosData.get(key);
        if (data != null) {
            String[] returnedData = new String[]{data};
            return returnedData;
        }
        return null;
    }

    public String[] addAttribute(String key, String value) {
        String oldvalue;
        SecurityManager sm;
        if ((key.startsWith("com.ibm.wsspi.security") || key.startsWith("com.ibm.websphere.security")) && (sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + UPDATE_TOKEN.toString());
            }
            sm.checkPermission(UPDATE_TOKEN);
        }
        if (!this.isReadOnly && (oldvalue = this.kerberosData.put(key, value)) != null) {
            String[] returnedData = new String[]{oldvalue};
            return returnedData;
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        return this.kerberosData.keys();
    }

    public Object clone() {
        return null;
    }

    public GSSCredential getGSSCredential() {
        return this.gssCredential;
    }
}

