/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wssecurity.platform.websphere.token.KRBTicket;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnTokenFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KRBAuthnTokenImpl
implements KRBAuthnToken,
AuthenticationToken,
KRBTicket {
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    private static final long DEFAULT_TOKEN_CUSHION = 600000L;
    private static final String KRB5_OID = "1.2.840.113554.1.2.2";
    private static MessageDigest md = null;
    private static final TraceComponent tc = Tr.register(KRBAuthnTokenImpl.class, "Security", "com.ibm.ejs.resources.security");
    private static GSSManager gssMgr = null;
    private short version;
    private byte[] tokenBytes;
    private String uniqueId;
    private String kpn;
    private String realm;
    private KerberosTicket tgt;
    private GSSCredential gssCred;
    private Long expiration;
    private String tokenName;
    private boolean isReadOnly;
    private Date renewTill;
    private Hashtable<String, String> kData;
    private boolean isAddressless;
    private boolean isForwardable;
    private boolean isRenewable;

    public KRBAuthnTokenImpl(byte[] inputTokenBytes) {
        this.version = 1;
        this.tokenBytes = null;
        this.uniqueId = null;
        this.kpn = null;
        this.realm = null;
        this.tgt = null;
        this.gssCred = null;
        this.expiration = 0L;
        this.tokenName = "com.ibm.ws.security.token.KRBAuthnTokenImpl";
        this.isReadOnly = false;
        this.renewTill = null;
        this.kData = null;
        this.isAddressless = false;
        this.isForwardable = false;
        this.isRenewable = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBAuthnTokenImpl(TokenBytes)", inputTokenBytes);
        }
        this.tokenBytes = inputTokenBytes;
        if (this.tokenBytes != null) {
            try {
                ByteArrayInputStream bayin = new ByteArrayInputStream(this.tokenBytes);
                ObjectInputStream in = new ObjectInputStream(bayin);
                this.readExternal(in);
                if (this.tgt != null) {
                    this.renewTill = this.tgt.getRenewTill();
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KRBAuthnTokenImpl(TokenBytes) unexpected exception: " + e.getMessage());
                }
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            this.uniqueId = this.getTokenUniqueID();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBAuthnTokenImpl(TokenBytes)", this);
        }
    }

    public KRBAuthnTokenImpl(Map map) {
        int index;
        block13: {
            this.version = 1;
            this.tokenBytes = null;
            this.uniqueId = null;
            this.kpn = null;
            this.realm = null;
            this.tgt = null;
            this.gssCred = null;
            this.expiration = 0L;
            this.tokenName = "com.ibm.ws.security.token.KRBAuthnTokenImpl";
            this.isReadOnly = false;
            this.renewTill = null;
            this.kData = null;
            this.isAddressless = false;
            this.isForwardable = false;
            this.isRenewable = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "KRBAuthnTokenImpl(map)", map);
            }
            this.kpn = (String)map.get(KRBAuthnTokenFactory.PRINCIPAL_NAME);
            this.tgt = (KerberosTicket)map.get(KRBAuthnTokenFactory.KERBEROS_TICKET);
            this.gssCred = (GSSCredential)map.get(KRBAuthnTokenFactory.GSS_CREDENTIAL);
            this.realm = (String)map.get(KRBAuthnTokenFactory.REALM_NAME);
            this.expiration = (Long)map.get(KRBAuthnTokenFactory.EXPIRATION_TIME);
            if (this.tgt != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KRBAuthnTokenImpl(map) TGT: " + this.tgt);
                }
                if (this.kpn == null) {
                    this.kpn = this.tgt.getClient().toString();
                }
                if (!map.containsKey(KRBAuthnTokenFactory.EXPIRATION_TIME)) {
                    this.expiration = this.tgt.getEndTime().getTime();
                }
                this.renewTill = this.tgt.getRenewTill();
                this.isAddressless = this.tgt.getClientAddresses() == null;
                this.isForwardable = this.tgt.isForwardable();
                this.isRenewable = this.tgt.isRenewable();
            } else if (this.gssCred != null) {
                try {
                    if (this.kpn == null) {
                        this.kpn = ((Object)this.gssCred.getName()).toString();
                    }
                    if (!map.containsKey(KRBAuthnTokenFactory.EXPIRATION_TIME)) {
                        this.expiration = this.gssCred.getRemainingLifetime();
                        this.expiration = this.expiration * 1000L + System.currentTimeMillis();
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug(tc, "KRBAuthnTokenImpl(map) unexpected exception", e);
                }
            }
        }
        if (this.realm == null && this.kpn != null && (index = this.kpn.indexOf("@")) != -1) {
            this.realm = this.kpn.substring(index + 1, this.kpn.length());
        }
        this.uniqueId = this.getTokenUniqueID();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBAuthnTokenImpl(map)", this);
        }
    }

    public GSSCredential getGSSCredential() {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getGSSCredential");
            }
            if (this.gssCred == null && this.tgt != null) {
                try {
                    String clientName = this.tgt.getClient().getName();
                    Oid krbOid = new Oid(KRB5_OID);
                    if (clientName != null && clientName.length() > 0) {
                        if (gssMgr == null) {
                            gssMgr = GSSManager.getInstance();
                        }
                        GSSName gssName = gssMgr.createName(clientName, GSSName.NT_USER_NAME, krbOid);
                        this.gssCred = gssMgr.createCredential(gssName.canonicalize(krbOid), 0, krbOid, 1);
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "getGSSCredential unexpected exception", e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGSSCredential", this.gssCred);
        }
        return this.gssCred;
    }

    public boolean isAddressless() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAddressless " + this.isAddressless);
        }
        return this.isAddressless;
    }

    public boolean isRenewable() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRenewable " + this.isRenewable);
        }
        return this.isRenewable;
    }

    public Date getRenewTill() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRenewTill " + this.renewTill);
        }
        return this.renewTill;
    }

    public String getTokenRealm() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenRealm " + this.realm);
        }
        return this.realm;
    }

    public KerberosTicket getKerberosTicket() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKerberosTicket", this.tgt);
        }
        return this.tgt;
    }

    public String[] addTokenAttribute(String key, String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTokenAttribute", new Object[]{key, value});
        }
        if (!this.isReadOnly) {
            String oldvalue;
            if (this.kData == null) {
                this.kData = new Hashtable();
            }
            if ((oldvalue = this.kData.put(key, value)) != null) {
                String[] returnedData = new String[]{oldvalue};
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addTokenAttribute", returnedData);
                }
                return returnedData;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTokenAttribute null");
        }
        return null;
    }

    public Enumeration getTokenAttributeNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenAttributeNames");
        }
        if (this.kData == null) {
            this.kData = new Hashtable();
        }
        Enumeration<String> names = this.kData.keys();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenAttributeNames", names);
        }
        return names;
    }

    public String[] getTokenAttributes(String key) {
        String data;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenAttribute");
        }
        if (this.kData == null) {
            this.kData = new Hashtable();
        }
        if ((data = this.kData.get(key)) != null) {
            String[] returnedData = new String[]{data};
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTokenAttributes", returnedData);
            }
            return returnedData;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenAttributes null");
        }
        return null;
    }

    public byte[] getTokenBytes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenBytes");
        }
        if (this.tokenBytes == null) {
            try {
                ByteArrayOutputStream bayout = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bayout);
                this.writeExternal(out);
                this.tokenBytes = bayout.toByteArray();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getTokenBytes unexpected exception", e);
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenBytes", this.tokenBytes);
        }
        return this.tokenBytes;
    }

    public long getTokenExpiration() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenExpiration " + this.expiration);
        }
        return this.expiration;
    }

    public String getTokenName() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenName " + this.tokenName);
        }
        return this.tokenName;
    }

    public String getTokenPrincipal() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenPrincipal " + this.kpn);
        }
        return this.kpn;
    }

    public String getTokenUniqueID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenUniqueID " + this.uniqueId);
        }
        if (this.uniqueId == null) {
            if (this.tgt != null) {
                block8: {
                    if (md == null) {
                        try {
                            md = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
                        }
                        catch (NoSuchAlgorithmException e) {
                            if (!tc.isDebugEnabled()) break block8;
                            Tr.debug(tc, "getTokenUniqueID unexpected exception", e);
                        }
                    }
                }
                this.uniqueId = md != null ? this.kpn + md.digest(this.tgt.getEncoded()).toString() : this.kpn + ((Object)this.tgt).hashCode();
            } else {
                this.uniqueId = this.kpn;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenUniqueID " + this.uniqueId);
        }
        return this.uniqueId;
    }

    public String getIdentifier() {
        String id = this.getTokenUniqueID();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdentifier " + id);
        }
        return id;
    }

    public short getTokenVersion() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenVersion " + this.version);
        }
        return this.version;
    }

    public boolean isTokenForwardable() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTokenForwardable " + this.isForwardable);
        }
        return this.isForwardable;
    }

    public boolean isTokenValid() {
        long current_time = System.currentTimeMillis();
        long timeRemaining = this.expiration - current_time;
        if (timeRemaining < 0L) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isTokenValid false");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTokenValid true");
        }
        return true;
    }

    public void setTokenReadOnly() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenReadOnly " + this.isReadOnly);
        }
        this.isReadOnly = true;
    }

    public boolean isBasicAuth() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isBasicAuth false");
        }
        return false;
    }

    public String[] addAttribute(String key, String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addAttribute");
        }
        return this.addTokenAttribute(key, value);
    }

    public Enumeration getAttributeNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeNames");
        }
        return this.getTokenAttributeNames();
    }

    public String[] getAttributes(String key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes");
        }
        return this.getTokenAttributes(key);
    }

    public byte[] getBytes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBytes");
        }
        return this.getTokenBytes();
    }

    public long getExpiration() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExpiration " + this.expiration);
        }
        return this.expiration;
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getName " + this.tokenName);
        }
        return this.tokenName;
    }

    public String getPrincipal() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrincipal " + this.kpn);
        }
        return this.kpn;
    }

    public String getUniqueID() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueID " + this.uniqueId);
        }
        return this.uniqueId;
    }

    public short getVersion() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVersion " + this.version);
        }
        return this.version;
    }

    public boolean isForwardable() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isForwardable " + this.isForwardable);
        }
        return this.isForwardable;
    }

    public boolean isValid() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValid ");
        }
        return this.isTokenValid();
    }

    public void setReadOnly() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setReadOnly " + this.isReadOnly);
        }
        this.isReadOnly = true;
    }

    public Object clone() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clone", this);
        }
        KRBAuthnTokenImpl clone = new KRBAuthnTokenImpl(this.getTokenBytes());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clone", clone);
        }
        return clone;
    }

    public synchronized boolean refresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reflesh()");
        }
        boolean ok = false;
        if (this.tgt != null) {
            try {
                this.tgt.refresh();
                this.expiration = this.tgt.getEndTime().getTime();
                ok = true;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TGT reflesh Failed with Exception", e.getMessage());
                }
                Tr.warning(tc, "TGT reflesh failed. The downstream invocation with current TGT may fail.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reflesh()");
        }
        return ok;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readExternal", in);
        }
        this.version = in.readShort();
        this.tokenName = in.readUTF();
        this.kpn = in.readUTF();
        this.uniqueId = in.readUTF();
        this.expiration = in.readLong();
        this.realm = in.readUTF();
        this.isReadOnly = in.readBoolean();
        this.kData = (Hashtable)in.readObject();
        this.tgt = (KerberosTicket)in.readObject();
        if (this.tgt != null) {
            this.isAddressless = this.tgt.getClientAddresses() == null;
            this.isForwardable = this.tgt.isForwardable();
            this.isRenewable = this.tgt.isRenewable();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readExternal");
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeExternal", out);
        }
        out.writeShort(this.version);
        out.writeUTF(this.tokenName);
        out.writeUTF(this.kpn);
        out.writeUTF(this.uniqueId);
        out.writeLong(this.expiration);
        out.writeUTF(this.realm);
        out.writeBoolean(this.isReadOnly);
        out.writeObject(this.kData);
        out.writeObject(this.tgt);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeExternal");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\ntoken name:         " + this.tokenName);
        sb.append("\nversion:            " + this.version);
        sb.append("\nhashCode:           " + this.hashCode());
        sb.append("\nuniqueId:           " + this.uniqueId);
        sb.append("\nkerberos principal: " + this.kpn);
        sb.append("\nrealm:              " + this.realm);
        sb.append("\nexpiration:         " + this.expiration);
        sb.append("\nrenew until:        " + this.renewTill);
        sb.append("\nisReadOnly:         " + this.isReadOnly);
        sb.append("\nisAddressless:      " + this.isAddressless);
        sb.append("\nisForwardable:      " + this.isForwardable);
        sb.append("\nisRenewable:        " + this.isRenewable);
        sb.append("\nattributes:         " + this.kData);
        sb.append("\nKerberosTicket:     " + this.tgt);
        sb.append("\nGSSCredential:      " + this.gssCred);
        return sb.toString();
    }
}

