/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.spnego.ServerConfig;
import com.ibm.ws.security.spnego.ServerCredentialsFactory;
import com.ibm.ws.security.spnego.TAIConfigurationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class ServerCredential {
    private static final Oid KRB5MECHANISMOID;
    private static final Oid SPNEGOMECHOID;
    private GSSManager gssManager;
    private GSSName gssName;
    private GSSCredential gssCred;
    private static final String ME;
    private static final Logger logger;

    public ServerCredential(ServerConfig server) throws GSSException, TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "<constructor>");
        }
        this.initialize(server);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "<constructor>");
        }
    }

    private void initialize(ServerConfig server) throws GSSException, TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "initialize");
        }
        if (server == null) {
            String msg = "Service Provider Name is null.";
            logger.logp(Level.SEVERE, ME, "initialize", "security.spnego.config.error", msg);
            throw new TAIConfigurationException(msg);
        }
        try {
            this.gssManager = ServerCredentialsFactory.getMgr();
            String spn = server.getServerName();
            if (server.getGssNameType() == GSSName.NT_USER_NAME) {
                this.gssName = this.gssManager.createName(spn, GSSName.NT_USER_NAME, KRB5MECHANISMOID);
            } else {
                logger.logp(Level.WARNING, ME, "initialize", "security.spnego.warn.hostbased", spn);
                this.gssName = this.gssManager.createName(spn, GSSName.NT_HOSTBASED_SERVICE);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "initialize", "Created GSSName for " + spn);
            }
            int credType = server.getGssCredType();
            int credLifeTime = server.getGssCredDuration();
            this.gssCred = this.gssManager.createCredential(this.gssName, credLifeTime, SPNEGOMECHOID, credType);
            if (logger.isLoggable(Level.FINER)) {
                String name = this.gssName == null ? "default" : ((Object)this.gssName).toString();
                logger.logp(Level.FINER, ME, "initialize", "Created GSSCredential " + name + " with lifetime of " + credLifeTime + " seconds.");
            }
            this.gssCred.add(this.gssName, credLifeTime, credLifeTime, KRB5MECHANISMOID, credType);
            int lifetimeRemain = this.gssCred.getRemainingLifetime();
            Oid[] mechs = this.gssCred.getMechs();
            int lifetimeAccept = this.gssCred.getRemainingAcceptLifetime(mechs[0]);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "initialize", "Lifetime remaining on credential: " + lifetimeRemain + " secs");
                logger.logp(Level.FINER, ME, "initialize", "Accept lifetime remaining on credential for mechanism " + mechs[0] + ": " + lifetimeAccept + " secs");
            }
        }
        catch (GSSException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.spnego.ServerCredential.initialize", "173", this);
            logger.logp(Level.SEVERE, ME, "initialize", "security.spnego.kerberos.init.failed", new Object[]{e});
            throw e;
        }
        catch (Throwable e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.spnego.ServerCredential.initialize", "178", this);
            logger.logp(Level.SEVERE, ME, "initialize", "security.spnego.kerberos.init.error", new Object[]{e});
            throw new IllegalStateException("ServerCredential.initialize - unexpected exception: " + e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "initialize", this.gssCred.toString());
        }
    }

    public final GSSCredential getGssCred() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getGssCred");
            logger.exiting(ME, "getGssCred", this.gssCred);
        }
        return this.gssCred;
    }

    static {
        ME = ServerCredential.class.getName();
        logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
        Oid temp = null;
        try {
            temp = new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException ex) {
            temp = null;
        }
        KRB5MECHANISMOID = temp;
        try {
            temp = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException ex) {
            temp = null;
        }
        SPNEGOMECHOID = temp;
    }
}

