/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server.lm;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSAuthMechOidCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.SingleSignonConfig;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.server.LTPAConfigException;
import com.ibm.ws.security.token.AuthenticationTokenImpl;
import com.ibm.ws.security.token.AuthorizationTokenImpl;
import com.ibm.ws.security.token.PropagationTokenImpl;
import com.ibm.ws.security.token.SingleSignonTokenImpl;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebAuthenticator;
import com.ibm.wsspi.security.auth.WSSubjectWrapper;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnTokenFactoryFactory;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class wsMapDefaultInboundLoginModule
implements LoginModule {
    private SecurityConfig security = null;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private boolean ssoEnabled = false;
    private AuthenticationToken authToken = null;
    private AuthorizationToken authzToken = null;
    private KRBAuthnToken krbAuthnToken = null;
    private SingleSignonToken ssoToken = null;
    private ArrayList customPublicObjects = new ArrayList();
    private ArrayList customPrivateObjects = new ArrayList();
    private ArrayList customPrincipalObjects = new ArrayList();
    private PropagationToken propagationToken = null;
    private Hashtable credHashTable = null;
    private WSPrincipal principal;
    private WSCredential credential;
    private UserRegistry registry;
    private HttpServletRequest req = null;
    private HttpServletResponse res = null;
    protected boolean debug = false;
    protected boolean cookie = false;
    private boolean throwExceptionForAllPropagationSerializationProblems = false;
    private WSCredentialTokenMapperInterface wsCredMapper = null;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final TraceComponent tc = Tr.register(wsMapDefaultInboundLoginModule.class, null, "com.ibm.ejs.resources.security");
    private boolean foundWSSubjectWrapper = false;

    public wsMapDefaultInboundLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "wsMapDefaultInboundLoginModule()");
            Tr.exit(tc, "wsMapDefaultInboundLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + sharedState.toString() + "\", options = \"" + options.toString() + "\")");
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (contextManager != null) {
            contextManager.clearRootException();
        }
        this.wsCredMapper = WSCredentialTokenMapper.getInstance();
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WebInboundLoginModuleImpl initialized");
        }
        this.cookie = "true".equalsIgnoreCase((String)this.options.get("cookie"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WebInboundLoginModule cookie ON: " + this.cookie);
        }
        this.security = SecurityObjectLocator.getSecurityConfig();
        SingleSignonConfig sso = this.security.getActiveAuthMechanism().getSingleSignon();
        boolean enabled = false;
        if (sso != null) {
            this.ssoEnabled = sso.getBoolean("enabled");
        }
        SecurityConfigObject security2 = SecurityObjectLocator.getSecurityConfigManager().getObject("security");
        String throwExceptionForAllPropagationSerializationProblemsProperty = null;
        if (security2 != null) {
            throwExceptionForAllPropagationSerializationProblemsProperty = security2.getProperties().getProperty("com.ibm.CSI.throwExceptionForAllPropagationSerializationProblems");
            boolean bl = this.throwExceptionForAllPropagationSerializationProblems = throwExceptionForAllPropagationSerializationProblemsProperty != null && (throwExceptionForAllPropagationSerializationProblemsProperty.equalsIgnoreCase("true") || throwExceptionForAllPropagationSerializationProblemsProperty.equalsIgnoreCase("yes"));
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "SSO is enabled for login: " + this.ssoEnabled);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options), generateCookie: " + this.cookie);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean login() throws LoginException {
        block235: {
            block234: {
                block232: {
                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                        Tr.entry(wsMapDefaultInboundLoginModule.tc, "login()");
                    }
                    ltpaServer = null;
                    try {
                        ltpaServer = LTPAServerObject.getLTPAServer();
                    }
                    catch (LTPAConfigException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.initialize", "218", this);
                        if (!this.debug && !wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) break block232;
                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "ERROR: Failed to get the LTPA server object.");
                    }
                }
                contextManager = ContextManagerFactory.getInstance();
                customProperties = (Hashtable)this.sharedState.get("com.ibm.wsspi.security.cred.propertiesObject");
                this.credential = (WSCredential)this.sharedState.get("WSCredential");
                this.principal = (WSPrincipal)this.sharedState.get("WSPrincipal");
                _OID = this.security.getActiveAuthMechanism().getString("OID");
                if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "*** SHARED STATE ***");
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "customProperties = " + customProperties);
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "credential = " + this.credential);
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "principal = " + this.principal);
                }
                if (customProperties == null && !this.isAnyPropagationEnabled()) {
                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                        Tr.exit(wsMapDefaultInboundLoginModule.tc, "login() disabled");
                    }
                    if (!this.ssoEnabled) {
                        this.succeeded = true;
                        return this.succeeded;
                    }
                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                        Tr.exit(wsMapDefaultInboundLoginModule.tc, "ssoEnabled, need to initialize res and req");
                    }
                }
                this.succeeded = false;
                if (this.commitSucceeded) {
                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "The login module is in funny state, cleanup before starting a new login process.");
                    }
                    this.cleanup();
                }
                nameCallback = null;
                passwordCallback = null;
                wsCredTokenCallback = null;
                wsServletRequestCallback = null;
                wsServletResponseCallback = null;
                wsAppContextCallback = null;
                wsTokenHolderCallback = null;
                wsRealmNameCallback = null;
                wsX509CertificateCallback = null;
                wsAuthMechOidCallback = null;
                callbacks = null;
                if (!this.sharedState.containsKey("Callback")) {
                    if (this.callbackHandler == null) {
                        e = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                        contextManager.setRootException(e);
                        throw e;
                    }
                    callbacks = new Callback[10];
                    nameCallback = new NameCallback("Username: ");
                    callbacks[0] = nameCallback;
                    passwordCallback = new PasswordCallback("Password: ", false);
                    callbacks[1] = passwordCallback;
                    wsCredTokenCallback = new WSCredTokenCallbackImpl("Credential Token: ");
                    callbacks[2] = wsCredTokenCallback;
                    wsServletRequestCallback = new WSServletRequestCallback("HttpServletRequest: ");
                    callbacks[3] = wsServletRequestCallback;
                    wsServletResponseCallback = new WSServletResponseCallback("HttpServletResponse: ");
                    callbacks[4] = wsServletResponseCallback;
                    wsAppContextCallback = new WSAppContextCallback("ApplicationContextCallback: ");
                    callbacks[5] = wsAppContextCallback;
                    wsTokenHolderCallback = new WSTokenHolderCallback("Authz Token List: ");
                    callbacks[6] = wsTokenHolderCallback;
                    wsRealmNameCallback = new WSRealmNameCallbackImpl("Realm Name", contextManager.getDefaultRealm());
                    callbacks[7] = wsRealmNameCallback;
                    wsX509CertificateCallback = new WSX509CertificateChainCallback("X509Certificate[]: ");
                    callbacks[8] = wsX509CertificateCallback;
                    wsAuthMechOidCallback = new WSAuthMechOidCallbackImpl("AuthMechOid: ");
                    callbacks[9] = wsAuthMechOidCallback;
                    try {
                        this.callbackHandler.handle(callbacks);
                    }
                    catch (IOException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "399", this);
                        Tr.error(wsMapDefaultInboundLoginModule.tc, "security.jaas.callBackHandlerIOException", new Object[]{this.getClass().getName(), e.toString()});
                        contextManager.setRootException(e);
                        throw new WSLoginFailedException("IOException: " + e.getMessage(), e);
                    }
                    catch (UnsupportedCallbackException uce) {
                        FFDCFilter.processException((Throwable)uce, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "405", this);
                        Tr.error(wsMapDefaultInboundLoginModule.tc, "security.jaas.callBackHandlerException", new Object[]{this.getClass().getName(), uce.getCallback().toString(), uce});
                        contextManager.setRootException(uce);
                        throw new WSLoginFailedException(uce.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + uce.getMessage(), uce);
                    }
                    this.sharedState.put("Callback", callbacks);
                } else {
                    callbacks = (Callback[])this.sharedState.get("Callback");
                    for (i = 0; i < callbacks.length; ++i) {
                        if (callbacks[i] == null) continue;
                        if (callbacks[i] instanceof NameCallback) {
                            nameCallback = (NameCallback)callbacks[i];
                            continue;
                        }
                        if (callbacks[i] instanceof PasswordCallback) {
                            passwordCallback = (PasswordCallback)callbacks[i];
                            continue;
                        }
                        if (callbacks[i] instanceof WSCredTokenCallbackImpl) {
                            wsCredTokenCallback = (WSCredTokenCallbackImpl)callbacks[i];
                            continue;
                        }
                        if (callbacks[i] instanceof WSServletRequestCallback) {
                            wsServletRequestCallback = (WSServletRequestCallback)callbacks[i];
                            continue;
                        }
                        if (callbacks[i] instanceof WSServletResponseCallback) {
                            wsServletResponseCallback = (WSServletResponseCallback)callbacks[i];
                            continue;
                        }
                        if (callbacks[i] instanceof WSAppContextCallback) {
                            wsAppContextCallback = (WSAppContextCallback)callbacks[i];
                            continue;
                        }
                        if (callbacks[i] instanceof WSTokenHolderCallback) {
                            wsTokenHolderCallback = (WSTokenHolderCallback)callbacks[i];
                            continue;
                        }
                        if (callbacks[i] instanceof WSRealmNameCallbackImpl) {
                            wsRealmNameCallback = (WSRealmNameCallbackImpl)callbacks[i];
                            continue;
                        }
                        if (callbacks[i] instanceof WSX509CertificateChainCallback) {
                            wsX509CertificateCallback = (WSX509CertificateChainCallback)callbacks[i];
                            continue;
                        }
                        if (callbacks[i] instanceof WSAuthMechOidCallbackImpl) {
                            wsAuthMechOidCallback = (WSAuthMechOidCallbackImpl)callbacks[i];
                            continue;
                        }
                        if (!this.debug && !wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) continue;
                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "The following callback was ignored: " + callbacks[i].getClass().getName());
                    }
                }
                refreshIfExpired = false;
                if (callbacks[5] instanceof WSAppContextCallback) {
                    props = ((WSAppContextCallback)callbacks[5]).getContext();
                    refreshIfExpired = this.checkForRefreshIfExpired(props, this.options);
                } else if (wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "login", "WSAppContextCallback is not available, expired tokens will not be refreshed for asynch logins.");
                }
                uid = null;
                realm = null;
                authMechOid = null;
                password = null;
                credToken = null;
                authzTokenList = null;
                isHTTPRequest = false;
                certChain = null;
                if (nameCallback != null) {
                    uid = nameCallback.getName();
                }
                if (wsRealmNameCallback != null) {
                    realm = wsRealmNameCallback.getRealmName();
                }
                if (wsAuthMechOidCallback != null) {
                    authMechOid = wsAuthMechOidCallback.getAuthMechOid();
                }
                if (passwordCallback != null && (tmp = passwordCallback.getPassword()) != null && tmp.length != 0) {
                    password = new char[tmp.length];
                    System.arraycopy(tmp, 0, password, 0, tmp.length);
                }
                if (wsCredTokenCallback != null && (tmpCred = wsCredTokenCallback.getCredToken()) != null) {
                    credToken = CredentialsHelper.copyCredToken(tmpCred);
                }
                if (wsTokenHolderCallback != null) {
                    authzTokenList = wsTokenHolderCallback.getTokenHolderList();
                }
                if (wsServletRequestCallback != null) {
                    v0 = isHTTPRequest = wsServletRequestCallback.getHttpServletRequest() != null;
                }
                if (wsX509CertificateCallback != null) {
                    certChain = wsX509CertificateCallback.getX509CertificateChain();
                }
                _gssCred = SubjectHelper.getGSSCredentialFromSubject(this.subject);
                _kTicket = SubjectHelper.getKerberosTicketFromSubject(this.subject);
                if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "*** CALLBACKS ***");
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "uid = " + uid);
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "realm = " + realm);
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "cred token = " + credToken);
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "X509 cert chain = " + certChain);
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "authz token list = " + authzTokenList);
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "kTicket = " + _kTicket);
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "gssCred = " + _gssCred);
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "custom properties = " + customProperties);
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "isHTTPRequest = " + isHTTPRequest);
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "authMechOid = " + authMechOid);
                }
                if (this.cookie) {
                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "cookie: ON - init res.");
                    }
                    if (wsServletRequestCallback != null) {
                        this.req = wsServletRequestCallback.getHttpServletRequest();
                    }
                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "req = ", this.req);
                    }
                    if (wsServletResponseCallback != null) {
                        this.res = wsServletResponseCallback.getHttpServletResponse();
                    }
                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "res = ", this.res);
                    }
                }
                if (customProperties == null && !this.isAnyPropagationEnabled()) {
                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                        Tr.exit(wsMapDefaultInboundLoginModule.tc, "req and res initialized");
                    }
                    this.succeeded = true;
                    return this.succeeded;
                }
                try {
                    if (uid == null || uid.length() == 0) {
                        final_subject = this.subject;
                        this.foundWSSubjectWrapper = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                Iterator<WSSubjectWrapper> creds = final_subject.getPrivateCredentials(WSSubjectWrapper.class).iterator();
                                if (creds != null && creds.hasNext()) {
                                    return Boolean.TRUE;
                                }
                                return Boolean.FALSE;
                            }
                        });
                    }
                    if (customProperties == null && authzTokenList == null && (certChain != null || uid != null || credToken != null || _gssCred != null || _kTicket != null) || certChain == null && uid == null && !this.foundWSSubjectWrapper && credToken == null && _gssCred == null) {
                        cred = (WSCredential)this.sharedState.get("WSCredential");
                        if (cred != null) {
                            if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                Tr.debug(wsMapDefaultInboundLoginModule.tc, "Mapping WSCredential to SAP tokens.");
                            }
                            if (this.isAnyPropagationEnabled()) {
                                if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "Mapping authz token from WSCredential.");
                                }
                                if (_gssCred == null || _gssCred != null && !OID.compareOIDs(_OID, "oid:1.2.840.113554.1.2.2")) {
                                    this.authToken = this.wsCredMapper.createAuthTokenFromWSCredential(cred);
                                }
                                this.authzToken = this.wsCredMapper.createAuthzTokenFromWSCredential(cred);
                                if (this.authToken != null) {
                                    this.sharedState.put("com.ibm.wsspi.security.token.wsAuthenticationToken", this.authToken);
                                }
                                if (this.authzToken == null) {
                                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "Cannot map WSCredential to auth and authz tokens for SAP.");
                                    }
                                    e = new WSLoginFailedException("Cannot map WSCredential to auth and authz tokens for SAP.");
                                    contextManager.setRootException(e);
                                    throw e;
                                }
                                this.sharedState.put("com.ibm.wsspi.security.token.wsAuthorizationToken", this.authzToken);
                                if (this.ssoEnabled && this.ssoToken == null) {
                                    this.ssoToken = this.wsCredMapper.createSSOTokenAndSetAttributes(cred, _gssCred != null || _kTicket != null);
                                    this.sharedState.put("com.ibm.wsspi.security.token.wsSingleSignonToken", this.ssoToken);
                                }
                            }
                            this.succeeded = true;
                            if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                                Tr.exit(wsMapDefaultInboundLoginModule.tc, "initial login()");
                            }
                            return this.succeeded;
                        }
                        e = new WSLoginFailedException("Invalid authentication data.");
                        contextManager.setRootException(e);
                        throw e;
                    }
                }
                catch (WSLoginFailedException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "632", this);
                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                        Tr.exit(wsMapDefaultInboundLoginModule.tc, "Exception creating SAP tokens from WSCredential.", new Object[]{e.toString()});
                    }
                    throw e;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "637", this);
                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                        Tr.exit(wsMapDefaultInboundLoginModule.tc, "Exception creating SAP tokens from WSCredential.", new Object[]{e.toString()});
                    }
                    throw new WSLoginFailedException(e.getMessage(), e);
                }
                if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "Successfully gathered attribute information");
                }
                mapUid = null;
                if (customProperties != null) {
                    mapUid = (String)customProperties.get("com.ibm.wsspi.security.cred.userId");
                }
                if (customProperties != null && customProperties.get("com.ibm.wsspi.security.cred.uniqueId") != null && this.credential == null) {
                    sm = System.getSecurityManager();
                    if (sm != null) {
                        if (wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                            Tr.debug(wsMapDefaultInboundLoginModule.tc, "Performing Java 2 Security Permission Check ...");
                            Tr.debug(wsMapDefaultInboundLoginModule.tc, "Expecting : " + wsMapDefaultInboundLoginModule.MAP_CREDENTIAL.toString());
                        }
                        sm.checkPermission(wsMapDefaultInboundLoginModule.MAP_CREDENTIAL);
                    }
                    try {
                        cacheKey = customProperties.get("com.ibm.wsspi.security.cred.cacheKey");
                        if (cacheKey != null && cacheKey instanceof String && ((String)cacheKey).equals("")) {
                            if (wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                Tr.debug(wsMapDefaultInboundLoginModule.tc, "Cache Key value is null string. Ignore it.");
                            }
                            cacheKey = null;
                        }
                        if (cacheKey != null && (cacheSubject = (cache = AuthCache.getInstance()).getSubject(cacheKey)) != null) {
                            if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                Tr.debug(wsMapDefaultInboundLoginModule.tc, "Found hashtable cacheKey in Subject cache.");
                            }
                            try {
                                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                                        for (Object publicObject : cacheSubject.getPublicCredentials()) {
                                            if (publicObject == null || wsMapDefaultInboundLoginModule.this.subject.getPublicCredentials().contains(publicObject)) continue;
                                            if (publicObject instanceof Hashtable) {
                                                if (((Hashtable)publicObject).get("com.ibm.wsspi.security.cred.uniqueId") == null && ((Hashtable)publicObject).get("com.ibm.wsspi.security.cred.userId") == null) {
                                                    wsMapDefaultInboundLoginModule.this.subject.getPublicCredentials().add(publicObject);
                                                }
                                            } else {
                                                if (wsMapDefaultInboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Adding public object to Subject: " + publicObject);
                                                }
                                                wsMapDefaultInboundLoginModule.this.subject.getPublicCredentials().add(publicObject);
                                            }
                                            if (!(publicObject instanceof WSCredential)) continue;
                                            wsMapDefaultInboundLoginModule.this.sharedState.put("WSCredential", publicObject);
                                        }
                                        for (Object privateObject : cacheSubject.getPrivateCredentials()) {
                                            if (privateObject == null || wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().contains(privateObject)) continue;
                                            if (privateObject instanceof Hashtable) {
                                                if (((Hashtable)privateObject).get("com.ibm.wsspi.security.cred.uniqueId") != null || ((Hashtable)privateObject).get("com.ibm.wsspi.security.cred.userId") != null) continue;
                                                wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().add(privateObject);
                                                continue;
                                            }
                                            if (wsMapDefaultInboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Adding private object to Subject: " + privateObject);
                                            }
                                            wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().add(privateObject);
                                        }
                                        for (Principal principalObject : cacheSubject.getPrincipals()) {
                                            if (principalObject == null || wsMapDefaultInboundLoginModule.this.subject.getPrincipals().contains(principalObject)) continue;
                                            if (wsMapDefaultInboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Adding principal object to Subject: " + principalObject);
                                            }
                                            wsMapDefaultInboundLoginModule.this.subject.getPrincipals().add(principalObject);
                                            if (!(principalObject instanceof WSPrincipal)) continue;
                                            wsMapDefaultInboundLoginModule.this.sharedState.put("WSPrincipal", principalObject);
                                        }
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException e) {
                                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "765", this);
                                contextManager.setRootException(e.getException());
                                throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
                            }
                            this.commitSucceeded = true;
                            this.succeeded = true;
                            if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                                Tr.exit(wsMapDefaultInboundLoginModule.tc, "login()");
                            }
                            return this.succeeded;
                        }
                        try {
                            customPropertiesPriv = customProperties;
                            this.credential = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws WSLoginFailedException {
                                    return wsMapDefaultInboundLoginModule.this.wsCredMapper.createWSCredentialFromProperties(customPropertiesPriv);
                                }
                            });
                        }
                        catch (PrivilegedActionException e) {
                            FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "789", this);
                            contextManager.setRootException(e.getException());
                            if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                Tr.debug(wsMapDefaultInboundLoginModule.tc, "Exception occurred during properties login: ", new Object[]{e.getException().toString()});
                            }
                            throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
                        }
                        if (this.credential != null) {
                            this.sharedState.put("WSCredential", this.credential);
                        }
                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                            Tr.debug(wsMapDefaultInboundLoginModule.tc, "WSCredential contains: " + this.credential);
                        }
                        this.principal = contextManager.createPrincipal(this.credential);
                        if (this.principal != null) {
                            this.sharedState.put("WSPrincipal", this.principal);
                        }
                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                            Tr.debug(wsMapDefaultInboundLoginModule.tc, "WSPrincipal contains: " + this.principal);
                        }
                        this.authzToken = this.wsCredMapper.createAuthzTokenFromWSCredential(this.credential);
                        this.authToken = this.wsCredMapper.createAuthTokenFromWSCredential(this.credential);
                        if (!this.ssoEnabled || this.ssoToken != null) ** GOTO lbl624
                        this.ssoToken = this.wsCredMapper.createSSOTokenAndSetAttributes(this.credential, _gssCred != null || _kTicket != null);
                    }
                    catch (WSLoginFailedException e) {
                        contextManager.setRootException(e);
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "814", this);
                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                            Tr.exit(wsMapDefaultInboundLoginModule.tc, "Exception creating SAP tokens.", new Object[]{e.toString()});
                        }
                        throw e;
                    }
                    catch (Exception e) {
                        contextManager.setRootException(e);
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "820", this);
                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                            Tr.exit(wsMapDefaultInboundLoginModule.tc, "Exception creating SAP tokens.", new Object[]{e.toString()});
                        }
                        throw new WSLoginFailedException(e.getMessage(), e);
                    }
                } else if (mapUid != null && this.credential != null) {
                    try {
                        mapCredential = null;
                        if (contextManager != null && this.registry == null) {
                            this.registry = contextManager.getRegistry(contextManager.getDefaultRealm());
                        }
                        this.credential = this.registry.createCredential(mapUid);
                        if (this.credential != null) {
                            this.sharedState.put("WSCredential", this.credential);
                        }
                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                            Tr.debug(wsMapDefaultInboundLoginModule.tc, "WSCredential contains: " + this.credential);
                        }
                        this.principal = contextManager.createPrincipal(this.credential);
                        if (this.principal != null) {
                            this.sharedState.put("WSPrincipal", this.principal);
                        }
                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                            Tr.debug(wsMapDefaultInboundLoginModule.tc, "WSPrincipal contains: " + this.principal);
                        }
                        this.authzToken = this.wsCredMapper.createAuthzTokenFromWSCredential(this.credential);
                        this.authToken = this.wsCredMapper.createAuthTokenFromWSCredential(this.credential);
                        if (!this.ssoEnabled || this.ssoToken != null) ** GOTO lbl624
                        this.ssoToken = this.wsCredMapper.createSSOTokenAndSetAttributes(this.credential, _gssCred != null || _kTicket != null);
                    }
                    catch (WSLoginFailedException e) {
                        contextManager.setRootException(e);
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "856", this);
                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                            Tr.exit(wsMapDefaultInboundLoginModule.tc, "Exception creating SAP tokens.", new Object[]{e.toString()});
                        }
                        throw e;
                    }
                    catch (Exception e) {
                        contextManager.setRootException(e);
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "863", this);
                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                            Tr.exit(wsMapDefaultInboundLoginModule.tc, "Exception creating SAP tokens.", new Object[]{e.toString()});
                        }
                        throw new WSLoginFailedException(e.getMessage(), e);
                    }
                } else if (this.isAnyPropagationEnabled() && authzTokenList != null && (certChain != null || credToken != null || uid != null || _gssCred != null)) {
                    block233: {
                        if (credToken == null && (uid != null || certChain != null) && (sm = System.getSecurityManager()) != null) {
                            if (wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                Tr.debug(wsMapDefaultInboundLoginModule.tc, "Performing Java 2 Security Permission Check ...");
                                Tr.debug(wsMapDefaultInboundLoginModule.tc, "Expecting : " + wsMapDefaultInboundLoginModule.MAP_CREDENTIAL.toString());
                            }
                            sm.checkPermission(wsMapDefaultInboundLoginModule.MAP_CREDENTIAL);
                        }
                        accessId = null;
                        try {
                            if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                Tr.debug(wsMapDefaultInboundLoginModule.tc, "Creating authentication token.");
                            }
                            if (this.credential == null) {
                                this.authToken = new AuthenticationTokenImpl();
                                if (isHTTPRequest && credToken != null) {
                                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "Creating authentication token from SSO token.");
                                    }
                                    ssoLtpaToken = ltpaServer.validateToken(credToken);
                                    tokenAccessID = ssoLtpaToken.getAttributes("u");
                                    authLtpaToken = null;
                                    if (tokenAccessID != null && tokenAccessID[0] != null) {
                                        tokenFactoryString = this.security.getProperty("com.ibm.wsspi.security.token.authenticationTokenFactory");
                                        authLtpaToken = ltpaServer.createLTPAToken(tokenAccessID[0], tokenFactoryString);
                                        ltpaServer.realmsMatch(authLtpaToken);
                                        ((AuthenticationTokenImpl)this.authToken).initializeToken("oid:1.3.18.0.2.30.2", authLtpaToken);
                                    }
                                } else if (credToken != null) {
                                    effectAuthMechOid = null;
                                    effectAuthMechOid = authMechOid != null ? authMechOid : _OID;
                                    ((AuthenticationTokenImpl)this.authToken).initializeToken(this.subject, effectAuthMechOid, credToken, refreshIfExpired);
                                } else if (_gssCred != null && !OID.compareOIDs(_OID, "oid:1.2.840.113554.1.2.2")) {
                                    ((AuthenticationTokenImpl)this.authToken).initializeToken(this.subject, _OID, _gssCred);
                                } else if (uid != null || certChain != null) {
                                    if (certChain != null) {
                                        cert_chain_final = certChain;
                                        action = new PrivilegedExceptionAction(){

                                            public Object run() throws Exception {
                                                if (wsMapDefaultInboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Mapping X509Certificate[] to uid.");
                                                }
                                                return CSIUtil.getInstance().parseCert(cert_chain_final);
                                            }
                                        };
                                        try {
                                            uid = (String)contextManager.runAsSystem(action);
                                        }
                                        catch (PrivilegedActionException e) {
                                            FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.ltpa.wsMapDefaultInboundLoginModule.login", "969", this);
                                            if (wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                                Tr.debug(wsMapDefaultInboundLoginModule.tc, "Exception parsing client certificate.", new Object[]{e.getException()});
                                            }
                                            throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
                                        }
                                    }
                                    ((AuthenticationTokenImpl)this.authToken).initializeToken(this.subject, _OID, uid);
                                } else {
                                    throw new WSLoginFailedException("Not enough information to authenticate.");
                                }
                                accessId = this.authToken.getPrincipal();
                                if (this.authToken != null && !this.authToken.isValid()) {
                                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "Authentication token is invalid.");
                                    }
                                    e = new WSLoginFailedException("Authentication token is not valid.");
                                    contextManager.setRootException(e);
                                    throw e;
                                }
                                break block233;
                            }
                            try {
                                accessId = this.credential.getAccessId();
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "998", this);
                                if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                                    Tr.exit(wsMapDefaultInboundLoginModule.tc, "Exception getting accessID from WSCredential.", new Object[]{e.toString()});
                                }
                                throw new WSLoginFailedException(e.getMessage(), e);
                            }
                        }
                        catch (WSLoginFailedException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1006", this);
                            if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                                Tr.exit(wsMapDefaultInboundLoginModule.tc, "Exception occurred initializing authentication token.", new Object[]{e.toString()});
                            }
                            throw e;
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1011", this);
                            if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                                Tr.exit(wsMapDefaultInboundLoginModule.tc, "Exception occurred getting Credential OID.", new Object[]{e.toString()});
                            }
                            contextManager.setRootException(e);
                            throw new WSLoginFailedException(e.getMessage(), e);
                        }
                    }
                    try {
                        if (authzTokenList != null) {
                            if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                Tr.debug(wsMapDefaultInboundLoginModule.tc, "Handling authorization token(s).");
                            }
                            for (i = 0; i < authzTokenList.size(); ++i) {
                                tokenHolder = (TokenHolder)authzTokenList.get(i);
                                if (tokenHolder.getName().equals("com.ibm.ws.security.token.AuthorizationTokenImpl")) {
                                    this.authzToken = new AuthorizationTokenImpl();
                                    ((AuthorizationTokenImpl)this.authzToken).initializeToken(tokenHolder.getBytes(), refreshIfExpired);
                                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "Processing authz token with name: " + this.authzToken.getName());
                                    }
                                    if (this.authzToken.getPrincipal().endsWith(accessId)) continue;
                                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "Realms don't match so creating a new default AuthorizationToken.");
                                    }
                                    if (this.credential == null) {
                                        try {
                                            if (contextManager != null && this.registry == null) {
                                                this.registry = contextManager.getRegistry(contextManager.getDefaultRealm());
                                            }
                                            if (this.security.getActiveUserRegistry().getBoolean("com.ibm.websphere.security.registry.UseTAM") && !RegistryUtil.checkValidUserifTAM(uid, this.registry)) {
                                                throw new WSLoginFailedException("User is not valid in Access Manager");
                                            }
                                            internalServerId = SecurityObjectLocator.getAdminData().getString("com.ibm.ws.security.internalServerId");
                                            if (internalServerId != null && contextManager.isInternalServerId(this.authzToken.getPrincipal())) {
                                                if (wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "Internal server id is being used: " + this.authzToken.getPrincipal() + " .");
                                                }
                                                this.credential = contextManager.getServerCredential();
                                                if (wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "Got credential from ContextManager: " + this.credential);
                                                }
                                            } else {
                                                mapCred = null;
                                                if ("KRB5".equalsIgnoreCase(SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getType()) && uid == null) {
                                                    if (wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "Creating a registry credential using the access id: " + accessId);
                                                    }
                                                    mapCred = this.registry.createCredential(accessId);
                                                }
                                                mapCred = this.registry.createCredential(uid);
                                                this.credential = ltpaServer.createLTPAToken(mapCred);
                                            }
                                        }
                                        catch (TokenCreationFailedException e) {
                                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1074", this);
                                            Tr.debug(wsMapDefaultInboundLoginModule.tc, "Using uid to mapCredential");
                                            contextManager.setRootException(e);
                                            throw new WSLoginFailedException(e.getMessage(), e);
                                        }
                                        catch (Exception e) {
                                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1080", this);
                                            contextManager.setRootException(e);
                                            throw new WSLoginFailedException(e.getMessage(), e);
                                        }
                                    }
                                    if (this.credential == null) continue;
                                    this.authzToken = this.wsCredMapper.createAuthzTokenFromWSCredential(this.credential);
                                    continue;
                                }
                                if (tokenHolder.getName().equals("LtpaToken")) {
                                    this.ssoToken = new SingleSignonTokenImpl();
                                    ((SingleSignonTokenImpl)this.ssoToken).initializeToken(tokenHolder.getBytes(), refreshIfExpired);
                                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "Processing SSO token with name: " + this.ssoToken.getName());
                                    }
                                    if (this.ssoToken.getPrincipal().endsWith(accessId)) continue;
                                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "accessId is " + accessId);
                                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "ssoToken principal is " + this.ssoToken.getPrincipal());
                                    }
                                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "Realms don't match so creating a new default SSO token.");
                                    }
                                    if (this.credential == null) {
                                        if (contextManager != null && this.registry == null) {
                                            this.registry = contextManager.getRegistry(contextManager.getDefaultRealm());
                                        }
                                        try {
                                            if (this.security.getActiveUserRegistry().getBoolean("com.ibm.websphere.security.registry.UseTAM") && !RegistryUtil.checkValidUserifTAM(uid, this.registry)) {
                                                throw new WSLoginFailedException("User is not valid in Access Manager");
                                            }
                                            internalServerId = SecurityObjectLocator.getAdminData().getString("com.ibm.ws.security.internalServerId");
                                            if (internalServerId != null && contextManager.isInternalServerId(this.ssoToken.getPrincipal())) {
                                                if (wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "Internal server id is being used: " + internalServerId + ".");
                                                }
                                                this.credential = contextManager.getServerCredential();
                                                if (wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "Got credential from ContextManager: " + this.credential);
                                                }
                                            } else {
                                                mapCred = null;
                                                if ("KRB5".equalsIgnoreCase(SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getType()) && uid == null) {
                                                    if (wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "Creating a registry credential using the access id: " + accessId);
                                                    }
                                                    mapCred = this.registry.createCredential(accessId);
                                                } else {
                                                    mapCred = this.registry.createCredential(uid);
                                                }
                                                this.credential = ltpaServer.createLTPAToken(mapCred);
                                            }
                                        }
                                        catch (TokenCreationFailedException e) {
                                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1147", this);
                                            Tr.debug(wsMapDefaultInboundLoginModule.tc, "Using uid to mapCredential");
                                            contextManager.setRootException(e);
                                            throw new WSLoginFailedException(e.getMessage(), e);
                                        }
                                        catch (Exception e) {
                                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1153", this);
                                            contextManager.setRootException(e);
                                            throw new WSLoginFailedException(e.getMessage(), e);
                                        }
                                    }
                                    if (this.credential == null) continue;
                                    this.ssoToken = this.wsCredMapper.createSSOTokenAndSetAttributes(this.credential, _gssCred != null || _kTicket != null);
                                    continue;
                                }
                                if (tokenHolder.getName().equals("WSCREDHASH")) {
                                    credHash = tokenHolder.getBytes();
                                    try {
                                        this.credHashTable = (Hashtable)WSOpaqueTokenHelper.deserialize(credHash);
                                        if (!this.debug && !wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) continue;
                                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "Successfully deserialized the WSCredential hashtable.");
                                        continue;
                                    }
                                    catch (Exception e) {
                                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1174", this);
                                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                            Tr.debug(wsMapDefaultInboundLoginModule.tc, "Exception deserializing WSCredential hashtable.", new Object[]{e.toString()});
                                        }
                                        if (!this.throwExceptionForAllPropagationSerializationProblems) continue;
                                        if (e instanceof WSLoginFailedException) {
                                            throw (WSLoginFailedException)e;
                                        }
                                        throw new WSLoginFailedException(e.getMessage(), e);
                                    }
                                }
                                if (tokenHolder.getName().equals("com.ibm.ws.security.token.PropagationTokenImpl")) {
                                    this.propagationToken = new PropagationTokenImpl();
                                    ((PropagationTokenImpl)this.propagationToken).initializeToken(tokenHolder.getBytes(), refreshIfExpired);
                                    oldPropagationToken = contextManager.getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
                                    if (oldPropagationToken != null) {
                                        try {
                                            attributeNames = oldPropagationToken.getAttributeNames();
                                            while (attributeNames.hasMoreElements()) {
                                                key = (String)attributeNames.nextElement();
                                                if (key.equals("com.ibm.wsspi.security.propagation.callers") || key.equals("com.ibm.wsspi.security.propagation.hosts")) continue;
                                                value = oldPropagationToken.getAttributes(key);
                                                for (j = 0; j < value.length; ++j) {
                                                    this.propagationToken.addAttribute(key, value[j]);
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1212", this);
                                        }
                                    }
                                    try {
                                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                            Tr.debug(wsMapDefaultInboundLoginModule.tc, "Processing propagation token with name: " + this.propagationToken.getName());
                                        }
                                        propagationTokenPriv = this.propagationToken;
                                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                            public Object run() throws WSSecurityException {
                                                contextManager.setPropagationToken(propagationTokenPriv.getName() + ":" + propagationTokenPriv.getVersion(), propagationTokenPriv);
                                                return null;
                                            }
                                        });
                                        continue;
                                    }
                                    catch (PrivilegedActionException e) {
                                        FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1229", this);
                                        contextManager.setRootException(e.getException());
                                        throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
                                    }
                                }
                                if (tokenHolder.getName().equals(KRBAuthnToken.WSSECURITY_KRBAUTHNTOKEN_NAME)) {
                                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "Process KRBAuthnToken");
                                    }
                                    this.krbAuthnToken = KRBAuthnTokenFactoryFactory.getFactory().createToken(tokenHolder.getBytes());
                                    if (this.krbAuthnToken.isTokenValid()) continue;
                                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "KRBAuthnToken token is invalid.");
                                    }
                                    e = new WSLoginFailedException("KRBAuthnToken token is not valid.");
                                    contextManager.setRootException(e);
                                    throw e;
                                }
                                if (!tokenHolder.getName().equals("CUSTOM_PUBLIC") && !tokenHolder.getName().equals("CUSTOM_PRIVATE") && !tokenHolder.getName().equals("CUSTOM_PRINCIPAL") && !tokenHolder.getName().endsWith(" (1)") && !tokenHolder.getName().endsWith(" (2)") && !tokenHolder.getName().endsWith(" (3)")) continue;
                                try {
                                    customObject = WSOpaqueTokenHelper.deserialize(tokenHolder.getBytes());
                                    if (tokenHolder.getName().equals("CUSTOM_PUBLIC") || tokenHolder.getName().endsWith(" (1)")) {
                                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                            Tr.debug(wsMapDefaultInboundLoginModule.tc, "Successfully deserialized a custom public object: " + customObject);
                                        }
                                        this.customPublicObjects.add(customObject);
                                        continue;
                                    }
                                    if (tokenHolder.getName().equals("CUSTOM_PRIVATE") || tokenHolder.getName().endsWith(" (2)")) {
                                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                            Tr.debug(wsMapDefaultInboundLoginModule.tc, "Successfully deserialized a custom private object: " + customObject);
                                        }
                                        this.customPrivateObjects.add(customObject);
                                        continue;
                                    }
                                    if (tokenHolder.getName().equals("CUSTOM_PRINCIPAL") || tokenHolder.getName().endsWith(" (3)")) {
                                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                            Tr.debug(wsMapDefaultInboundLoginModule.tc, "Successfully deserialized a custom principal object: " + customObject);
                                        }
                                        this.customPrincipalObjects.add(customObject);
                                        continue;
                                    }
                                    if (!this.debug && !wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) continue;
                                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "Warning:  The following token name is not getting added to the Subject: " + tokenHolder.getName());
                                    continue;
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1277", this);
                                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "Exception deserializing custom objects.", new Object[]{e.toString()});
                                    }
                                    if (!this.throwExceptionForAllPropagationSerializationProblems) continue;
                                    if (e instanceof WSLoginFailedException) {
                                        throw (WSLoginFailedException)e;
                                    }
                                    throw new WSLoginFailedException(e.getMessage(), e);
                                }
                            }
                            try {
                                customPublicObjectsPriv = this.customPublicObjects.toArray();
                                customPrivateObjectsPriv = this.customPrivateObjects.toArray();
                                customPrincipalObjectsPriv = this.customPrincipalObjects.toArray();
                                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() throws WSLoginFailedException {
                                        int i;
                                        if (customPublicObjectsPriv != null) {
                                            for (i = 0; i < customPublicObjectsPriv.length; ++i) {
                                                if (customPublicObjectsPriv[i] == null || wsMapDefaultInboundLoginModule.this.subject.getPublicCredentials().contains(customPublicObjectsPriv[i])) continue;
                                                wsMapDefaultInboundLoginModule.this.subject.getPublicCredentials().add(customPublicObjectsPriv[i]);
                                            }
                                        }
                                        if (customPrivateObjectsPriv != null) {
                                            for (i = 0; i < customPrivateObjectsPriv.length; ++i) {
                                                if (customPrivateObjectsPriv[i] == null || wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().contains(customPrivateObjectsPriv[i])) continue;
                                                wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().add(customPrivateObjectsPriv[i]);
                                            }
                                        }
                                        if (customPrincipalObjectsPriv != null) {
                                            for (i = 0; i < customPrincipalObjectsPriv.length; ++i) {
                                                if (customPrincipalObjectsPriv[i] == null || wsMapDefaultInboundLoginModule.this.subject.getPrincipals().contains(customPrincipalObjectsPriv[i])) continue;
                                                wsMapDefaultInboundLoginModule.this.subject.getPrincipals().add((Principal)customPrincipalObjectsPriv[i]);
                                            }
                                        }
                                        return null;
                                    }
                                });
                                break block234;
                            }
                            catch (PrivilegedActionException e) {
                                ex = null;
                                ex = e.getException() instanceof WSLoginFailedException != false ? (WSLoginFailedException)e.getException() : new WSLoginFailedException(e.getException().getMessage(), e.getException());
                                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1336", this);
                                contextManager.setRootException(ex);
                                throw ex;
                            }
                        }
                        e = new WSLoginFailedException("No authorization tokens exist.");
                        contextManager.setRootException(e);
                        throw e;
                    }
                    catch (WSLoginFailedException e) {
                        contextManager.setRootException(e);
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1350", this);
                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                            Tr.exit(wsMapDefaultInboundLoginModule.tc, "Exception creating SAP tokens from token holder list.", new Object[]{e.toString()});
                        }
                        throw e;
                    }
                    catch (Exception e) {
                        contextManager.setRootException(e);
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1356", this);
                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                            Tr.exit(wsMapDefaultInboundLoginModule.tc, "Exception creating SAP tokens from token holder list.", new Object[]{e.toString()});
                        }
                        throw new WSLoginFailedException(e.getMessage(), e);
                    }
                }
            }
            try {
                if ((this.credential != null || this.authToken != null) && this.authzToken == null) {
                    if (this.credential != null) {
                        this.authzToken = this.wsCredMapper.createAuthzTokenFromWSCredential(this.credential);
                        this.authToken = this.wsCredMapper.createAuthTokenFromWSCredential(this.credential);
                        if (this.ssoEnabled && this.ssoToken == null) {
                            this.ssoToken = this.wsCredMapper.createSSOTokenAndSetAttributes(this.credential, _gssCred != null || _kTicket != null);
                        }
                    } else {
                        if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                            Tr.debug(wsMapDefaultInboundLoginModule.tc, "Using credential token for authentication");
                        }
                        try {
                            this.credential = ltpaServer.validate(this.authToken.getBytes());
                            if (this.credential != null) {
                                this.sharedState.put("WSCredential", this.credential);
                                if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "WSCredential contains: " + this.credential);
                                }
                                this.principal = contextManager.createPrincipal(this.credential);
                                this.sharedState.put("WSPrincipal", this.principal);
                                if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "WSPrincipal contains: " + this.principal);
                                }
                            }
                        }
                        catch (WSLoginFailedException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "1391", this);
                            contextManager.setRootException(e);
                            throw e;
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "1396", this);
                            contextManager.setRootException(e);
                            throw new WSLoginFailedException(e.getMessage(), e);
                        }
                        this.authzToken = this.wsCredMapper.createAuthzTokenFromWSCredential(this.credential);
                        if (this.ssoEnabled && this.ssoToken == null) {
                            this.ssoToken = this.wsCredMapper.createSSOTokenAndSetAttributes(this.credential, _gssCred != null || _kTicket != null);
                        }
                    }
                }
                if (this.authzToken == null || this.credential != null && this.principal != null) break block235;
                if (this.credential == null && credToken != null) {
                    this.credential = this.wsCredMapper.createWSCredentialFromTokens(credToken, this.authzToken);
                } else if (this.credential == null && uid != null && this.authToken != null) {
                    this.credential = this.wsCredMapper.createWSCredentialFromTokens(this.authToken.getBytes(), this.authzToken);
                }
                this.sharedState.put("WSCredential", this.credential);
                if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "WSCredential contains: " + this.credential);
                }
                this.principal = contextManager.createPrincipal(this.credential);
                this.sharedState.put("WSPrincipal", this.principal);
                if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(wsMapDefaultInboundLoginModule.tc, "WSPrincipal contains: " + this.principal);
                }
                if (this.credHashTable != null) {
                    if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(wsMapDefaultInboundLoginModule.tc, "Setting hashtable into the WSCredential.");
                    }
                    try {
                        credHashTablePriv = this.credHashTable;
                        credentialPriv = this.credential;
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                                ((WSCredentialImpl)credentialPriv).setTable(credHashTablePriv);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1443", this);
                        contextManager.setRootException(e.getException());
                        throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
                    }
                }
                if (this.ssoEnabled && this.ssoToken == null) {
                    this.ssoToken = this.wsCredMapper.createSSOTokenAndSetAttributes(this.credential, _gssCred != null || _kTicket != null);
                }
            }
            catch (WSLoginFailedException e) {
                contextManager.setRootException(e);
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1456", this);
                if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                    Tr.exit(wsMapDefaultInboundLoginModule.tc, "Exception creating SAP tokens.", new Object[]{e.toString()});
                }
                throw e;
            }
            catch (Exception e) {
                contextManager.setRootException(e);
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "1462", this);
                if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
                    Tr.exit(wsMapDefaultInboundLoginModule.tc, "Exception creating SAP tokens.", new Object[]{e.toString()});
                }
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        }
        if (this.authToken != null) {
            this.sharedState.put("com.ibm.wsspi.security.token.wsAuthenticationToken", this.authToken);
        }
        if (this.authzToken != null) {
            this.sharedState.put("com.ibm.wsspi.security.token.wsAuthorizationToken", this.authzToken);
        }
        if (this.ssoToken != null) {
            this.sharedState.put("com.ibm.wsspi.security.token.wsSingleSignonToken", this.ssoToken);
        }
        if (this.krbAuthnToken != null) {
            this.sharedState.put("com.ibm.wsspi.security.token.wsKRBAuthnToken", this.krbAuthnToken);
            if (this.debug || wsMapDefaultInboundLoginModule.tc.isDebugEnabled()) {
                Tr.debug(wsMapDefaultInboundLoginModule.tc, "Added krbAuthnToken to shared state under: com.ibm.wsspi.security.token.wsKRBAuthnToken");
            }
        }
        this.succeeded = true;
        if (this.debug || wsMapDefaultInboundLoginModule.tc.isEntryEnabled()) {
            Tr.exit(wsMapDefaultInboundLoginModule.tc, "login()");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        Hashtable customProperties = (Hashtable)this.sharedState.get("com.ibm.wsspi.security.cred.propertiesObject");
        if (!this.isAnyPropagationEnabled() && customProperties == null) {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "commit() disabled");
            }
            if (!this.commitSucceeded) {
                Tr.debug(tc, "Shared state contains: " + this.sharedState.keySet());
                this.setCookieIfEnabled();
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            this.commitSucceeded = true;
            return this.commitSucceeded;
        }
        boolean bRet = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not commit because of authentication failed.");
            }
            bRet = false;
        } else {
            if (!this.commitSucceeded) {
                Tr.debug(tc, "shared state contains: " + this.sharedState.keySet());
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    try {
                        Hashtable customPropertiesPriv = customProperties;
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws WSLoginFailedException {
                                String uniqueID;
                                String[] hashed_uid;
                                AuthorizationToken authzTokenTemp = (AuthorizationToken)wsMapDefaultInboundLoginModule.this.sharedState.get("com.ibm.wsspi.security.token.wsAuthorizationToken");
                                if (authzTokenTemp != null) {
                                    wsMapDefaultInboundLoginModule.this.authzToken = authzTokenTemp;
                                }
                                if (wsMapDefaultInboundLoginModule.this.authToken == null && (wsMapDefaultInboundLoginModule.this.debug || tc.isDebugEnabled())) {
                                    Tr.debug(tc, "wsMapDefaultInboundLoginModule: authenticationToken is null in commit (phase 2) stage");
                                }
                                if (wsMapDefaultInboundLoginModule.this.authzToken == null) {
                                    if (wsMapDefaultInboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                        Tr.debug(tc, "wsMapDefaultInboundLoginModule: authorizationToken is null in commit (phase 2) stage");
                                    }
                                    throw new WSLoginFailedException("wsMapDefaultInboundLoginModule: authorizationToken is null in commit (phase 2) stage");
                                }
                                KRBAuthnToken krbAuthnTokenTemp = (KRBAuthnToken)wsMapDefaultInboundLoginModule.this.sharedState.get("com.ibm.wsspi.security.token.wsKRBAuthnToken");
                                if (krbAuthnTokenTemp != null) {
                                    if (wsMapDefaultInboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                        Tr.debug(tc, "wsMapDefaultInboundLoginModule: found KRBAuthnToken in sharedState");
                                    }
                                    wsMapDefaultInboundLoginModule.this.krbAuthnToken = krbAuthnTokenTemp;
                                }
                                if (wsMapDefaultInboundLoginModule.this.ssoEnabled) {
                                    SingleSignonToken ssoTokenTemp = (SingleSignonToken)wsMapDefaultInboundLoginModule.this.sharedState.get("com.ibm.wsspi.security.token.wsSingleSignonToken");
                                    if (ssoTokenTemp != null) {
                                        wsMapDefaultInboundLoginModule.this.ssoToken = ssoTokenTemp;
                                    }
                                    if (wsMapDefaultInboundLoginModule.this.ssoToken != null && !wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapDefaultInboundLoginModule.this.ssoToken)) {
                                        wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().add(wsMapDefaultInboundLoginModule.this.ssoToken);
                                    }
                                }
                                if (wsMapDefaultInboundLoginModule.this.authToken != null && !wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapDefaultInboundLoginModule.this.authToken)) {
                                    wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().add(wsMapDefaultInboundLoginModule.this.authToken);
                                }
                                if (wsMapDefaultInboundLoginModule.this.authzToken != null && !wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapDefaultInboundLoginModule.this.authzToken)) {
                                    wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().add(wsMapDefaultInboundLoginModule.this.authzToken);
                                }
                                if (wsMapDefaultInboundLoginModule.this.krbAuthnToken != null && !wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapDefaultInboundLoginModule.this.krbAuthnToken)) {
                                    if (wsMapDefaultInboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                        Tr.debug(tc, "wsMapDefaultInboundLoginModule: KRBAuthnToken is added in commit (phase 2) stage");
                                    }
                                    wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().add(wsMapDefaultInboundLoginModule.this.krbAuthnToken);
                                } else if (wsMapDefaultInboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                    Set<KRBAuthnToken> krbCredentials = wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials(KRBAuthnToken.class);
                                    if (krbCredentials != null && krbCredentials.size() > 0) {
                                        Tr.debug(tc, "wsMapDefaultInboundLoginModule: KRBAuthnToken is already in subject in commit (phase 2) stage");
                                    } else if (wsMapDefaultInboundLoginModule.this.krbAuthnToken == null) {
                                        Tr.debug(tc, "wsMapDefaultInboundLoginModule: KRBAuthnToken is null in commit (phase 2) stage");
                                    }
                                }
                                if ((wsMapDefaultInboundLoginModule.this.authzToken != null || wsMapDefaultInboundLoginModule.this.krbAuthnToken != null) && (hashed_uid = wsMapDefaultInboundLoginModule.this.authzToken.getAttributes("hashed_uid")) == null && (uniqueID = wsMapDefaultInboundLoginModule.this.wsCredMapper.createSubjectUniqueID(wsMapDefaultInboundLoginModule.this.subject)) != null) {
                                    String[] hashed_uid_sso;
                                    if (wsMapDefaultInboundLoginModule.this.authzToken != null) {
                                        wsMapDefaultInboundLoginModule.this.authzToken.addAttribute("hashed_uid", uniqueID);
                                    }
                                    if (wsMapDefaultInboundLoginModule.this.ssoEnabled && wsMapDefaultInboundLoginModule.this.ssoToken != null && (hashed_uid_sso = wsMapDefaultInboundLoginModule.this.ssoToken.getAttributes("hashed_uid")) == null) {
                                        wsMapDefaultInboundLoginModule.this.ssoToken.addAttribute("hashed_uid", uniqueID);
                                    }
                                }
                                if (wsMapDefaultInboundLoginModule.this.authToken != null) {
                                    wsMapDefaultInboundLoginModule.this.authToken.setReadOnly();
                                }
                                if (wsMapDefaultInboundLoginModule.this.authzToken != null) {
                                    wsMapDefaultInboundLoginModule.this.authzToken.setReadOnly();
                                }
                                if (wsMapDefaultInboundLoginModule.this.ssoEnabled && wsMapDefaultInboundLoginModule.this.ssoToken != null) {
                                    wsMapDefaultInboundLoginModule.this.ssoToken.setReadOnly();
                                }
                                if (wsMapDefaultInboundLoginModule.this.krbAuthnToken != null) {
                                    ((AuthenticationToken)((Object)wsMapDefaultInboundLoginModule.this.krbAuthnToken)).setReadOnly();
                                }
                                return null;
                            }
                        });
                        this.setCookieIfEnabled();
                    }
                    catch (PrivilegedActionException e) {
                        WSLoginFailedException ex = null;
                        ex = e.getException() instanceof WSLoginFailedException ? (WSLoginFailedException)e.getException() : new WSLoginFailedException(e.getException().getMessage(), e.getException());
                        FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.commit", "1666", this);
                        ContextManager contextManager = ContextManagerFactory.getInstance();
                        contextManager.setRootException(ex);
                        throw ex;
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.commit", "1676", this);
                    Tr.error(tc, "security.jaas.LoginModuleCommitError", new Object[]{this.getClass().getName(), e.toString()});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            bRet = this.commitSucceeded;
        }
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return bRet;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (!this.isAnyPropagationEnabled()) {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "abort() disabled");
            }
            return true;
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (!this.isAnyPropagationEnabled()) {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "logout() disabled");
            }
            return true;
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        Hashtable customProperties = (Hashtable)this.sharedState.get("com.ibm.wsspi.security.cred.propertiesObject");
        if (!this.isAnyPropagationEnabled() && customProperties == null) {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "cleanup() disabled");
            }
            return;
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing AuthorizationToken and AuthenticationToken from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        final Object[] customPublicObjectsPriv = this.customPublicObjects.toArray();
        final Object[] customPrivateObjectsPriv = this.customPrivateObjects.toArray();
        final Object[] customPrincipalObjectsPriv = this.customPrincipalObjects.toArray();
        final AuthorizationToken authzTokenPriv = this.authzToken;
        final AuthenticationToken authTokenPriv = this.authToken;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    int i;
                    if (authTokenPriv != null && wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().contains(authTokenPriv)) {
                        wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().remove(authTokenPriv);
                    }
                    if (authzTokenPriv != null && wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().contains(authzTokenPriv)) {
                        wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().remove(authzTokenPriv);
                    }
                    if (customPublicObjectsPriv != null) {
                        for (i = 0; i < customPublicObjectsPriv.length; ++i) {
                            if (!wsMapDefaultInboundLoginModule.this.subject.getPublicCredentials().contains(customPublicObjectsPriv[i])) continue;
                            wsMapDefaultInboundLoginModule.this.subject.getPublicCredentials().remove(customPublicObjectsPriv[i]);
                        }
                    }
                    if (customPrivateObjectsPriv != null) {
                        for (i = 0; i < customPrivateObjectsPriv.length; ++i) {
                            if (!wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().contains(customPrivateObjectsPriv[i])) continue;
                            wsMapDefaultInboundLoginModule.this.subject.getPrivateCredentials().remove(customPrivateObjectsPriv[i]);
                        }
                    }
                    if (customPrincipalObjectsPriv != null) {
                        for (i = 0; i < customPrincipalObjectsPriv.length; ++i) {
                            if (!wsMapDefaultInboundLoginModule.this.subject.getPrincipals().contains(customPrincipalObjectsPriv[i])) continue;
                            wsMapDefaultInboundLoginModule.this.subject.getPrincipals().remove(customPrincipalObjectsPriv[i]);
                        }
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.cleanup", "1843", this);
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), e.toString()});
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this.authToken = null;
        this.authzToken = null;
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    private void cleanupSharedState() {
        KRBAuthnToken tempKRBAuthnToken;
        AuthorizationToken tempAuthzToken;
        SingleSignonToken tempSSOToken;
        AuthenticationToken tempAuthToken;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupSharedState()");
        }
        Hashtable customProperties = (Hashtable)this.sharedState.get("com.ibm.wsspi.security.cred.propertiesObject");
        if (!this.isAnyPropagationEnabled() && customProperties == null) {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "cleanupSharedState() disabled");
            }
            return;
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing AuthorizationToken, AuthenticationToken, SingleSignonToken, and KRBAuthnToken from the shared state.");
        }
        if (customProperties != null) {
            this.sharedState.remove("com.ibm.wsspi.security.cred.propertiesObject");
        }
        if ((tempAuthToken = (AuthenticationToken)this.sharedState.get("com.ibm.wsspi.security.token.wsAuthenticationToken")) != null) {
            this.sharedState.remove("com.ibm.wsspi.security.token.wsAuthenticationToken");
        }
        if ((tempSSOToken = (SingleSignonToken)this.sharedState.get("com.ibm.wsspi.security.token.wsSingleSignonToken")) != null) {
            this.sharedState.remove("com.ibm.wsspi.security.token.wsSingleSignonToken");
        }
        if ((tempAuthzToken = (AuthorizationToken)this.sharedState.get("com.ibm.wsspi.security.token.wsAuthorizationToken")) != null) {
            this.sharedState.remove("com.ibm.wsspi.security.token.wsAuthorizationToken");
        }
        if ((tempKRBAuthnToken = (KRBAuthnToken)this.sharedState.get("com.ibm.wsspi.security.token.wsKRBAuthnToken")) != null) {
            this.sharedState.remove("com.ibm.wsspi.security.token.wsKRBAuthnToken");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this.authToken = null;
        this.authzToken = null;
        this.krbAuthnToken = null;
        if (this.sharedState.size() > 0 && (this.debug || tc.isDebugEnabled())) {
            Tr.debug(tc, "Shared State still contains the following: " + this.sharedState);
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupSharedState()");
        }
    }

    private void setCookieIfEnabled() throws WSLoginFailedException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "setCookieIfEnabled(), cookie enabled: " + this.cookie + " ssoEnabled: " + this.ssoEnabled + " , httpreq exist: " + (this.req != null) + " , httpres exist: " + (this.res != null));
        }
        Boolean cookieAdded = Boolean.FALSE;
        if (this.ssoEnabled && this.cookie && this.res != null && this.req != null) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Generate cookie ...");
            }
            try {
                cookieAdded = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws WSLoginFailedException {
                        boolean cookieIssued = false;
                        try {
                            ArrayList cookieList = WebAttributes.createCookiesStatic(wsMapDefaultInboundLoginModule.this.req, wsMapDefaultInboundLoginModule.this.subject);
                            wsMapDefaultInboundLoginModule.this.clearCookie(wsMapDefaultInboundLoginModule.this.req, wsMapDefaultInboundLoginModule.this.res);
                            if (cookieList != null) {
                                WebAttributes.addCookiesToResponse(cookieList, wsMapDefaultInboundLoginModule.this.res);
                                cookieIssued = true;
                            }
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".commit", "1938", this);
                            wsMapDefaultInboundLoginModule.this.res.setStatus(401);
                            Tr.error(tc, "security.jaas.LoginModuleCommitError", new Object[]{this.getClass().getName(), e});
                        }
                        return new Boolean(cookieIssued);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.commit", "1947", this);
                Tr.error(tc, "security.jaas.LoginModuleCommitError", new Object[]{this.getClass().getName(), e.getException()});
                ContextManager contextManager = ContextManagerFactory.getInstance();
                contextManager.setRootException(e.getException());
                this.cleanup();
                if (e.getException() instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)e.getException();
                }
                throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
            }
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "setCookieIfEnabled(), cookie(s) added: " + cookieAdded);
        }
    }

    private boolean isAnyPropagationEnabled() {
        return WSCredentialTokenMapper.isAnyPropagationEnabled();
    }

    private void clearCookie(HttpServletRequest req, HttpServletResponse res) {
        Cookie[] cookies;
        String storedReq;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearCookie");
        }
        if ((storedReq = WebAuthenticator.getCookieValue(cookies = req.getCookies(), "WASReqURL")) != null && storedReq.length() > 0) {
            Cookie c = new Cookie("WASReqURL", "");
            c.setPath("/");
            c.setMaxAge(0);
            res.addCookie(c);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cleared REFERER_URL cookie. Original value was " + storedReq);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearCookie");
        }
    }

    private boolean checkForRefreshIfExpired(Map props, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForRefreshIfExpired");
        }
        boolean refreshIfExpired = false;
        if (props != null && props.containsKey("com.ibm.ws.security.context.renewToken")) {
            if (props.get("com.ibm.ws.security.context.renewToken") instanceof Boolean) {
                refreshIfExpired = (Boolean)props.get("com.ibm.ws.security.context.renewToken");
            } else {
                String refreshString = (String)props.get("com.ibm.ws.security.context.renewToken");
                boolean bl = refreshIfExpired = refreshString != null && (refreshString.equalsIgnoreCase("true") || refreshString.equalsIgnoreCase("yes"));
            }
            if (options.containsKey("com.ibm.ws.security.context.renewToken")) {
                String enableRefresh = (String)options.get("com.ibm.ws.security.context.renewToken");
                boolean bl = refreshIfExpired = refreshIfExpired && "true".equalsIgnoreCase(enableRefresh);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "login", "Is token refresh behavior enabled for asynch logins? " + enableRefresh);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "login", "Is this an asynch login? " + refreshIfExpired);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForRefreshIfExpired");
        }
        return refreshIfExpired;
    }
}

