/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server.lm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.SingleSignonConfig;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.KerberosServiceTicketImpl;
import com.ibm.ws.security.token.KerberosTokenImpl;
import com.ibm.ws.security.token.WSSMarkerObject;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.auth.callback.WSProtocolPolicyCallback;
import com.ibm.wsspi.security.csiv2.CSIv2PerformPolicy;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.KerberosToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ietf.jgss.GSSCredential;

public class wsMapCSIv2OutboundLoginModule
implements LoginModule {
    private SecurityConfig security = null;
    private Subject subject;
    private Subject invocation_subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private TokenHolder opaqueTokenHolder = null;
    private AuthorizationToken authzToken = null;
    private SingleSignonToken ssoToken = null;
    private AuthenticationToken authToken = null;
    private KerberosToken kerberosToken = null;
    boolean spnegoLTPASupport = false;
    private CSIv2PerformPolicy csiv2PerformPolicy = null;
    protected boolean debug = false;
    protected boolean ssoEnabled = false;
    private boolean wssTokenPropagationEnabled = false;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private String OID = null;
    private static final TraceComponent tc = Tr.register(wsMapCSIv2OutboundLoginModule.class, null, "com.ibm.ejs.resources.security");

    public wsMapCSIv2OutboundLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "wsMapCSIv2OutboundLoginModule()");
            Tr.exit(tc, "wsMapCSIv2OutboundLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + sharedState.toString() + "\", options = \"" + options.toString() + "\")");
            }
            this.subject = subject;
            this.callbackHandler = callbackHandler;
            this.sharedState = sharedState;
            this.options = options;
            this.security = SecurityObjectLocator.getSecurityConfig();
            try {
                Boolean enabled = false;
                SingleSignonConfig sso = this.security.getActiveAuthMechanism().getSingleSignon();
                if (enabled != null) {
                    this.ssoEnabled = sso.getBoolean("enabled");
                }
                this.OID = this.security.getActiveAuthMechanism().getString("OID");
                ContextManager contextManager = ContextManagerFactory.getInstance();
                if (contextManager != null) {
                    contextManager.clearRootException();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.initialize", "168", this);
                if (!this.debug && !tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Exception initializing wsMapCSIv2OutboundLoginModule.", new Object[]{e});
            }
        }
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WSLoginModuleImpl initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws LoginException {
        block32: {
            WSSMarkerObject wssMarker;
            if (this.debug || tc.isEntryEnabled()) {
                Tr.entry(tc, "login()");
            }
            if ((wssMarker = this.getWSSMarkerFromSubject(this.subject)) != null && wssMarker.isEnabled()) {
                this.wssTokenPropagationEnabled = true;
            }
            if (!WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() && !this.wssTokenPropagationEnabled) {
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "Attribute propagation disabled locally.");
                }
                this.succeeded = true;
                return this.succeeded;
            }
            this.succeeded = false;
            if (this.commitSucceeded) {
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "The login module is in funny state, cleanup before starting a new login process.");
                }
                this.cleanup();
            }
            final ContextManager contextManager = ContextManagerFactory.getInstance();
            Callback[] callbacks = null;
            if (!this.sharedState.containsKey("Callback")) {
                if (this.callbackHandler == null) {
                    WSLoginFailedException e = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                    contextManager.setRootException(e);
                    throw e;
                }
                callbacks = new Callback[]{new WSProtocolPolicyCallback("Protocol Policy Callback: ")};
                try {
                    this.callbackHandler.handle(callbacks);
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "246", this);
                    Tr.error(tc, "security.jaas.callBackHandlerIOException", new Object[]{this.getClass().getName(), e});
                    contextManager.setRootException(e);
                    this.succeeded = false;
                    throw new WSLoginFailedException("IOException: " + e.getMessage(), e);
                }
                catch (UnsupportedCallbackException uce) {
                    FFDCFilter.processException((Throwable)uce, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "254", this);
                    Tr.error(tc, "security.jaas.callBackHandlerException", new Object[]{this.getClass().getName(), uce.getCallback().toString(), uce});
                    contextManager.setRootException(uce);
                    this.succeeded = false;
                    throw new WSLoginFailedException(uce.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + uce.getMessage(), uce);
                }
                this.sharedState.put("Callback", callbacks);
            } else {
                callbacks = (Callback[])this.sharedState.get("Callback");
            }
            this.csiv2PerformPolicy = (CSIv2PerformPolicy)((WSProtocolPolicyCallback)callbacks[0]).getProtocolPolicy();
            try {
                if (this.wssTokenPropagationEnabled || this.csiv2PerformPolicy.performAuthorizationToken()) {
                    String serviceConfigList = null;
                    if (this.csiv2PerformPolicy != null) {
                        serviceConfigList = this.csiv2PerformPolicy.getServiceCfgList();
                    }
                    WSCredential cred = SubjectHelper.getWSCredentialFromSubject(this.subject);
                    if ((this.wssTokenPropagationEnabled || serviceConfigList != null) && cred != null && cred.isForwardable()) {
                        byte[] wsOpaqueToken;
                        block31: {
                            if (this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "The following ServiceConfiguration list was received: " + serviceConfigList);
                            }
                            if (!cred.isBasicAuth()) {
                                try {
                                    final WSCredential wsCredPriv = cred;
                                    final boolean ssoEnabledPriv = this.ssoEnabled;
                                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                        public Object run() throws WSSecurityException, WSLoginFailedException, CredentialExpiredException {
                                            AuthorizationToken tempAuthzToken = SubjectHelper.getDefaultAuthzTokenFromSubject(wsMapCSIv2OutboundLoginModule.this.subject);
                                            AuthenticationToken tempAuthToken = SubjectHelper.getDefaultAuthTokenFromSubject(wsMapCSIv2OutboundLoginModule.this.subject);
                                            SingleSignonToken tempSSOToken = SubjectHelper.getDefaultSSOTokenFromSubject(wsMapCSIv2OutboundLoginModule.this.subject);
                                            GSSCredential gssCred = null;
                                            KerberosTokenImpl tempKerberosToken = null;
                                            if (wsMapCSIv2OutboundLoginModule.this.spnegoLTPASupport && (gssCred = SubjectHelper.getGSSCredentialFromSubject(wsMapCSIv2OutboundLoginModule.this.subject)) != null) {
                                                tempKerberosToken = new KerberosTokenImpl();
                                                tempKerberosToken.initializeToken(gssCred);
                                            }
                                            if (tempAuthzToken == null) {
                                                if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Creating AuthorizationToken for outbound request.");
                                                }
                                                wsMapCSIv2OutboundLoginModule.this.authzToken = contextManager.getWSCredTokenMapper().createAuthzTokenFromWSCredential(wsCredPriv);
                                            }
                                            if (tempAuthToken == null && wsCredPriv.getCredentialToken() != null) {
                                                if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Creating AuthenticationToken for outbound request.");
                                                }
                                                wsMapCSIv2OutboundLoginModule.this.authToken = contextManager.getWSCredTokenMapper().createAuthTokenFromWSCredential(wsCredPriv);
                                            }
                                            if (tempSSOToken == null && ssoEnabledPriv) {
                                                if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Creating SingleSignonToken for outbound request.");
                                                }
                                                wsMapCSIv2OutboundLoginModule.this.ssoToken = contextManager.getWSCredTokenMapper().createSSOTokenFromWSCredential(wsCredPriv);
                                                String processType = SecurityObjectLocator.getAdminData().getString("com.ibm.ws.security.processType");
                                                if (processType != null && (processType.equals("ManagedProcess") || processType.equals("UnManagedProcess"))) {
                                                    String serverName = SecurityObjectLocator.getAdminData().getString("process.serverName");
                                                    if (serverName != null) {
                                                        wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("process.serverName", serverName);
                                                    } else if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Cannot add serverName to SSO token, config property is null.");
                                                    }
                                                    Properties connectorProps = (Properties)wsMapCSIv2OutboundLoginModule.this.security.getObject("process.jmxConnectorProps");
                                                    if (connectorProps != null) {
                                                        wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("type", (String)connectorProps.get("type"));
                                                        wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("host", (String)connectorProps.get("host"));
                                                        wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("port", (String)connectorProps.get("port"));
                                                    } else if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Cannot add connectorProps to SSO token, config property is null.");
                                                    }
                                                    long expiration = wsCredPriv.getExpiration();
                                                    if (expiration <= 0L) {
                                                        Long expTime = wsMapCSIv2OutboundLoginModule.this.security.getAuthMechanism("LTPA").getLong("timeout");
                                                        long expirationTime = expTime * 60L * 1000L;
                                                        expiration = System.currentTimeMillis() + expirationTime;
                                                    }
                                                    wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("expire", Long.toString(expiration));
                                                    if (tempKerberosToken != null && wsMapCSIv2OutboundLoginModule.this.spnegoLTPASupport) {
                                                        if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                            Tr.debug(tc, "gssCredential exists, mark SSO token");
                                                        }
                                                        wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("security.ltpa.sso.spnego", "true");
                                                    }
                                                } else if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Not adding connector properties to SSO token, process type: " + processType);
                                                }
                                            }
                                            if (wsMapCSIv2OutboundLoginModule.this.authzToken != null && !wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.authzToken)) {
                                                wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().add(wsMapCSIv2OutboundLoginModule.this.authzToken);
                                            }
                                            if (wsMapCSIv2OutboundLoginModule.this.authToken != null && !wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.authToken)) {
                                                wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().add(wsMapCSIv2OutboundLoginModule.this.authToken);
                                            }
                                            if (wsMapCSIv2OutboundLoginModule.this.ssoToken != null && !wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.ssoToken)) {
                                                wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().add(wsMapCSIv2OutboundLoginModule.this.ssoToken);
                                            }
                                            if (tempKerberosToken != null && wsMapCSIv2OutboundLoginModule.this.spnegoLTPASupport) {
                                                KerberosServiceTicketImpl ticket = new KerberosServiceTicketImpl(tempKerberosToken, wsMapCSIv2OutboundLoginModule.this.csiv2PerformPolicy);
                                                wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().remove(tempKerberosToken);
                                                wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().add(ticket);
                                            }
                                            return null;
                                        }
                                    });
                                }
                                catch (PrivilegedActionException e) {
                                    FFDCFilter.processException(e.getException(), "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule", "410");
                                    if (!tc.isDebugEnabled()) break block31;
                                    Tr.debug(tc, "Error creating default authz and auth tokens.", new Object[]{e.getException()});
                                }
                            }
                        }
                        if ((wsOpaqueToken = WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromSubject(this.subject)) != null) {
                            this.opaqueTokenHolder = new TokenHolder(wsOpaqueToken, WSOpaqueTokenHelper.getInstance().getOpaqueTokenName(), WSOpaqueTokenHelper.getInstance().getOpaqueTokenVersion());
                            this.sharedState.put("WSOPAQUE", this.opaqueTokenHolder);
                            if (this.debug || tc.isEntryEnabled()) {
                                Tr.exit(tc, "Opaque token generated, propagating security attributes.");
                            }
                        } else if (this.debug || tc.isEntryEnabled()) {
                            Tr.exit(tc, "Opaque token is null, not propagating security attributes.");
                        }
                        break block32;
                    }
                    if (this.debug || tc.isEntryEnabled()) {
                        Tr.exit(tc, "Not processing the authz token.", new Object[]{serviceConfigList, cred});
                    }
                    break block32;
                }
                if (WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() && !this.csiv2PerformPolicy.performAuthorizationToken() && (this.debug || tc.isDebugEnabled())) {
                    Tr.debug(tc, "Target server does not support authorization token.");
                }
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.login", "443", this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "WSLoginFailedException creating SAP tokens from WSCredential.", new Object[]{e});
                }
                this.succeeded = false;
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.login", "450", this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "Exception creating SAP tokens from WSCredential.", new Object[]{e});
                }
                this.succeeded = false;
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        }
        this.succeeded = true;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "login() succeeded.");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        if (!WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() && !this.wssTokenPropagationEnabled) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute propagation is disabled locally.");
            }
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "commit()");
            }
            this.commitSucceeded = true;
            return this.commitSucceeded;
        }
        if (WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() && !this.csiv2PerformPolicy.performAuthorizationToken() && !this.wssTokenPropagationEnabled) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute propagation is disabled remotely.");
            }
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "commit()");
            }
            this.commitSucceeded = true;
            return this.commitSucceeded;
        }
        boolean bRet = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not commit because of authentication failed.");
            }
            bRet = false;
        } else {
            if (!this.commitSucceeded) {
                if (this.opaqueTokenHolder == null) {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Authorization token is null, returning from commit.");
                    }
                    this.commitSucceeded = true;
                    return this.commitSucceeded;
                }
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws WSLoginFailedException, CredentialDestroyedException, CredentialExpiredException {
                                if (wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder != null && !wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder)) {
                                    wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().add(wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder);
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.commit", "553", this);
                        ContextManager contextManager = ContextManagerFactory.getInstance();
                        contextManager.setRootException(e.getException());
                        throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.commit", "569", this);
                    Tr.error(tc, "security.jaas.LoginModuleCommitError", new Object[]{this.getClass().getName(), e});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            bRet = this.commitSucceeded;
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        this.authToken = null;
        this.authzToken = null;
        this.ssoToken = null;
        return bRet;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (!WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled()) {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "abort()");
            }
            return true;
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (!WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled()) {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "abort()");
            }
            return true;
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        this.wssTokenPropagationEnabled = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing AuthorizationToken from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder != null && wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder)) {
                        wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().remove(wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder);
                    }
                    if (wsMapCSIv2OutboundLoginModule.this.authToken != null && wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.authToken)) {
                        wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().remove(wsMapCSIv2OutboundLoginModule.this.authToken);
                    }
                    if (wsMapCSIv2OutboundLoginModule.this.authzToken != null && wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.authzToken)) {
                        wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().remove(wsMapCSIv2OutboundLoginModule.this.authzToken);
                    }
                    if (wsMapCSIv2OutboundLoginModule.this.ssoToken != null && wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.ssoToken)) {
                        wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().remove(wsMapCSIv2OutboundLoginModule.this.ssoToken);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.cleanup", "735", this);
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), e});
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this.opaqueTokenHolder = null;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    private WSSMarkerObject getWSSMarkerFromSubject(final Subject subject) {
        if (subject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Subject is null, so no WSSMarkerObject returned.");
            }
            return null;
        }
        WSSMarkerObject wssMarker = null;
        try {
            wssMarker = (WSSMarkerObject)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Iterator<WSSMarkerObject> privateCredIterator;
                    Set<WSSMarkerObject> privateCreds = subject.getPrivateCredentials(WSSMarkerObject.class);
                    if (privateCreds != null && privateCreds.size() > 0 && (privateCredIterator = privateCreds.iterator()).hasNext()) {
                        WSSMarkerObject cred = privateCredIterator.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WSSMarkerObject present in Subject.");
                        }
                        return cred;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSSMarkerObject not present in Subject.");
                    }
                    return null;
                }
            });
            return wssMarker;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.getWSSMarkerFromSubject", "800");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting WSSMarkerObject from Subject.", new Object[]{e});
            }
            return null;
        }
    }
}

