/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server.lm;

import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class swamLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private UserRegistryImpl registry = null;
    private WSPrincipal principal;
    private WSCredential credential;
    private WSCredentialTokenMapperInterface wsCredMapper = null;
    protected boolean debug = false;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final TraceComponent tc = Tr.register(swamLoginModule.class, "Security", "com.ibm.ejs.resources.security");

    public swamLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "swamLoginModule()");
            Tr.exit(tc, "swamLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{subject, callbackHandler, sharedState, options});
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WSLoginModuleImpl initialized");
        }
        if (contextManager.isCellSecurityEnabled()) {
            try {
                this.wsCredMapper = WSCredentialTokenMapper.getInstance();
                this.registry = (UserRegistryImpl)SecurityServerImpl.getRegistryImpl(contextManager.getDefaultRealm());
                contextManager.clearRootException();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.swamLoginModule.initialize", "160", this);
                Tr.error(tc, "security.swam.find.registry", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean login() throws LoginException {
        ContextManager contextManager;
        block75: {
            Hashtable customProperties;
            if (this.debug || tc.isEntryEnabled()) {
                Tr.entry(tc, "login");
            }
            if (!(contextManager = ContextManagerFactory.getInstance()).isCellSecurityEnabled()) {
                try {
                    Tr.warning(tc, "security.disabled.during.login");
                    if (tc.isDebugEnabled()) {
                        Thread.dumpStack();
                    }
                    Subject unAuthSubject = SubjectHelper.createUnauthenticatedSubject();
                    this.credential = SubjectHelper.getWSCredentialFromSubject(unAuthSubject);
                    this.principal = SubjectHelper.createPrincipal(this.credential);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception creating principal.", new Object[]{e});
                    }
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.swamLoginModule.login", "206", this);
                    throw new WSLoginFailedException(e.getMessage(), e);
                }
                this.sharedState.put("WSPrincipal", this.principal);
                this.sharedState.put("WSCredential", this.credential);
                this.succeeded = true;
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(security disabled)");
                }
                return this.succeeded;
            }
            this.succeeded = false;
            if (this.commitSucceeded) {
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "The login module is in funny state, cleanup before starting a new login process.");
                }
                this.cleanup();
            }
            if ((customProperties = (Hashtable)this.sharedState.get("com.ibm.wsspi.security.cred.propertiesObject")) == null) {
                try {
                    final Subject subjectPriv = this.subject;
                    customProperties = (Hashtable)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Object[] list_public = subjectPriv.getPublicCredentials().toArray();
                            if (swamLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Looking for custom properties in public cred list.");
                            }
                            for (int i = 0; i < list_public.length; ++i) {
                                if (swamLoginModule.this.debug || tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Object[" + i + "] in public list: " + list_public[i]);
                                }
                                if (!(list_public[i] instanceof Hashtable) || ((Hashtable)list_public[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null && ((Hashtable)list_public[i]).get("com.ibm.wsspi.security.cred.userId") == null) continue;
                                return list_public[i];
                            }
                            Object[] list_private = subjectPriv.getPrivateCredentials().toArray();
                            if (swamLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Looking for custom properties in private cred list.");
                            }
                            for (int i = 0; i < list_private.length; ++i) {
                                if (swamLoginModule.this.debug || tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Object[" + i + "] in private list: " + list_private[i]);
                                }
                                if (!(list_private[i] instanceof Hashtable) || ((Hashtable)list_private[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null && ((Hashtable)list_private[i]).get("com.ibm.wsspi.security.cred.userId") == null) continue;
                                return list_private[i];
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "286", this);
                    contextManager.setRootException(e.getException());
                    throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
                }
            }
            if (this.callbackHandler == null) {
                String msg = "swamLoginModule: No CallbackHandler available to gather authentication information from the user.";
                WSLoginFailedException e = new WSLoginFailedException("swamLoginModule: No CallbackHandler available to gather authentication information from the user.");
                contextManager.setRootException(e);
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "swamLoginModule: No CallbackHandler available to gather authentication information from the user.", e);
                }
                throw e;
            }
            Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSRealmNameCallbackImpl("Realm Name: ", contextManager.getDefaultRealm()), new WSX509CertificateChainCallback("X509Certificate[]: ")};
            String uid = null;
            String realm = null;
            char[] password = null;
            X509Certificate[] certChain = null;
            try {
                this.callbackHandler.handle(callbacks);
                uid = ((NameCallback)callbacks[0]).getName();
                char[] tmp = ((PasswordCallback)callbacks[1]).getPassword();
                if (tmp != null) {
                    password = new char[tmp.length];
                    System.arraycopy(tmp, 0, password, 0, tmp.length);
                    ((PasswordCallback)callbacks[1]).clearPassword();
                }
                realm = ((WSRealmNameCallbackImpl)callbacks[2]).getRealmName();
                certChain = ((WSX509CertificateChainCallback)callbacks[3]).getX509CertificateChain();
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.swamLoginModule.login", "329", this);
                Tr.error(tc, "security.swam.callback.ex", new Object[]{e});
                contextManager.setRootException(e);
                throw new WSLoginFailedException("swamLoginModule IOException: " + e.getMessage(), e);
            }
            catch (UnsupportedCallbackException uce) {
                FFDCFilter.processException((Throwable)uce, "com.ibm.ws.security.server.lm.swamLoginModule.login", "336", this);
                Tr.error(tc, "security.swam.unsupport.callback", new Object[]{uce.getCallback().toString(), uce});
                contextManager.setRootException(uce);
                throw new WSLoginFailedException(uce.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user", uce);
            }
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "uid = " + uid);
                Tr.debug(tc, "X509 cert chain = " + certChain);
                Tr.debug(tc, "realm = " + realm);
                Tr.debug(tc, "password = " + (password == null ? null : "XXXXXXXX"));
            }
            if (certChain == null && uid == null && password == null) {
                WSLoginFailedException e = new WSLoginFailedException("swamLoginModule: No authentication data.");
                contextManager.setRootException(e);
                throw e;
            }
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Successfully gathered authentication information");
            }
            if (customProperties != null && customProperties.get("com.ibm.wsspi.security.cred.uniqueId") != null && customProperties.get("com.ibm.wsspi.security.cred.userId") == null) {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                        Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
                    }
                    sm.checkPermission(MAP_CREDENTIAL);
                }
                try {
                    try {
                        final Hashtable customPropertiesPriv = customProperties;
                        this.credential = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws WSLoginFailedException {
                                return swamLoginModule.this.wsCredMapper.createWSCredentialFromProperties(customPropertiesPriv);
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "400", this);
                        contextManager.setRootException(e.getException());
                        if (this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred during properties login: ", new Object[]{e.getException()});
                        }
                        throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
                    }
                    if (this.credential != null) {
                        this.sharedState.put("WSCredential", this.credential);
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSCredential contains: " + this.credential);
                    }
                    this.principal = contextManager.createPrincipal(this.credential);
                    if (this.principal != null) {
                        this.sharedState.put("WSPrincipal", this.principal);
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSPrincipal contains: " + this.principal);
                    }
                }
                catch (WSLoginFailedException e) {
                    contextManager.setRootException(e);
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "422", this);
                    if (this.debug || tc.isEntryEnabled()) {
                        Tr.exit(tc, "Exception creating SAP tokens.", new Object[]{e});
                    }
                    throw e;
                }
                catch (Exception e) {
                    contextManager.setRootException(e);
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "429", this);
                    if (this.debug || tc.isEntryEnabled()) {
                        Tr.exit(tc, "Exception creating SAP tokens.", new Object[]{e});
                    }
                    throw new WSLoginFailedException(e.getMessage(), e);
                }
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.debug(tc, "Custom login module passing in credential properties.");
                    Tr.exit(tc, "login()");
                }
                this.succeeded = true;
                return this.succeeded;
            }
            if (customProperties != null && customProperties.get("com.ibm.wsspi.security.cred.userId") != null) {
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.debug(tc, "Setting uid and/or password from hashtable.");
                }
                uid = (String)customProperties.get("com.ibm.wsspi.security.cred.userId");
                String temp_password = (String)customProperties.get("com.ibm.wsspi.security.cred.password");
                if (temp_password != null) {
                    password = temp_password.toCharArray();
                }
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "uid = " + uid);
                    Tr.debug(tc, "password = " + (password == null ? "<null>" : "XXXXXXXX"));
                }
            }
            String securityName = null;
            if (uid != null && password != null) {
                if (realm == null || realm.length() == 0) {
                    realm = contextManager.getDefaultRealm();
                }
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using uid and password for authentication");
                    StringBuffer buf = new StringBuffer("Authenticating \"");
                    buf.append(realm).append('/').append(uid).append("\"");
                    Tr.debug(tc, buf.toString());
                }
                try {
                    String passwd = new String(password);
                    securityName = this.registry.checkPassword(uid, passwd);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.swamLoginModule.login", "488", this);
                    contextManager.setRootException(e);
                    throw new WSLoginFailedException(e.getMessage(), e);
                }
                try {
                    String internalServerId = SecurityObjectLocator.getAdminData().getString("com.ibm.ws.security.internalServerId");
                    if (internalServerId != null && contextManager.isInternalServerId(securityName)) {
                        this.credential = contextManager.getServerCredential();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got credential from ContextManager: " + this.credential);
                        }
                        break block75;
                    }
                    final WSCredential wsRegistryCred = this.registry.createCredential(securityName);
                    try {
                        this.credential = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return new WSCredentialImpl(wsRegistryCred, "No OID for this mechanism", RegistryUtil.nullByteArray, false, -1L);
                            }
                        });
                        break block75;
                    }
                    catch (PrivilegedActionException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{e.getException()});
                        }
                        FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.SecurityServerImpl.mapCredential", "522", this);
                        contextManager.setRootException(e.getException());
                        throw e.getException();
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.swamLoginModule.login", "530", this);
                    contextManager.setRootException(e);
                    throw new WSLoginFailedException(e.getMessage(), e);
                }
            }
            if (uid == null && certChain == null) {
                WSLoginFailedException e = new WSLoginFailedException("swamLoginModule: No authentication data");
                contextManager.setRootException(e);
                throw e;
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
                }
                sm.checkPermission(MAP_CREDENTIAL);
            }
            if (certChain != null) {
                final X509Certificate[] cert_chain_final = certChain;
                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (swamLoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Mapping X509Certificate[] to uid.");
                        }
                        return CSIUtil.getInstance().parseCert(cert_chain_final);
                    }
                };
                try {
                    uid = (String)contextManager.runAsSystem(action);
                }
                catch (PrivilegedActionException e) {
                    FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.ltpa.ltpaLoginModule.login", "578", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception parsing client certificate.", new Object[]{e.getException()});
                    }
                    throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
                }
            }
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Using uid to mapCredential.");
                StringBuffer buf = new StringBuffer("Authenticating \"");
                buf.append(realm).append('/').append(uid).append("\"");
                Tr.debug(tc, buf.toString());
            }
            try {
                if (SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getBoolean("com.ibm.websphere.security.registry.UseTAM") && !RegistryUtil.checkValidUserifTAM(uid, this.registry)) {
                    throw new WSLoginFailedException("User is not valid in Access Manager");
                }
                final WSCredential wsRegistryCred = this.registry.createCredential(uid);
                try {
                    this.credential = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return new WSCredentialImpl(wsRegistryCred, "No OID for this mechanism", RegistryUtil.nullByteArray, false, -1L);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{e.getException()});
                    }
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.swamLoginModule.login", "627", this);
                    contextManager.setRootException(e.getException());
                    throw e.getException();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.swamLoginModule.login", "634", this);
                contextManager.setRootException(e);
                if (e instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)e;
                }
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        }
        if (this.credential == null) {
            WSLoginFailedException e = new WSLoginFailedException("swamLoginModule: Credential returned from SAS authentication is null");
            contextManager.setRootException(e);
            throw e;
        }
        try {
            this.principal = contextManager.createPrincipal(this.credential);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating new WS Principal.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.swamLoginModule.login", "664", this);
            contextManager.setRootException(e);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        this.sharedState.put("WSCredential", this.credential);
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WSCredential contains: " + this.credential);
        }
        this.sharedState.put("WSPrincipal", this.principal);
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WSPrincipal contains: " + this.principal);
        }
        this.succeeded = true;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "login", new Boolean(this.succeeded));
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "commit");
        }
        boolean bRet = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not commit because of authentication failed.");
            }
            bRet = false;
        } else {
            if (!this.commitSucceeded) {
                ContextManager contextManager = ContextManagerFactory.getInstance();
                if (this.principal == null) {
                    WSLoginFailedException e = new WSLoginFailedException("swamLoginModule: WSPrincipal is null in commit (phase 2) stage");
                    contextManager.setRootException(e);
                    throw e;
                }
                if (this.credential == null) {
                    WSLoginFailedException e = new WSLoginFailedException("swamLoginModule: WSCredential is null in commit (phase 2) stage");
                    contextManager.setRootException(e);
                    throw e;
                }
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                if (!swamLoginModule.this.subject.getPrincipals().contains(swamLoginModule.this.principal)) {
                                    swamLoginModule.this.subject.getPrincipals().add(swamLoginModule.this.principal);
                                }
                                if (!swamLoginModule.this.subject.getPublicCredentials().contains(swamLoginModule.this.credential)) {
                                    swamLoginModule.this.credential.set("wssecurity.identity_name", "ClientAuthenticationToken");
                                    swamLoginModule.this.credential.set("wssecurity.identity_value", StringBytesConversion.getConvertedBytes(swamLoginModule.this.credential.getRealmSecurityName()));
                                    swamLoginModule.this.subject.getPublicCredentials().add(swamLoginModule.this.credential);
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.lm.swamLoginModule.commit", "771", this);
                        contextManager.setRootException(e.getException());
                        throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.swamLoginModule.commit", "786", this);
                    Tr.error(tc, "security.swam.commit.ex", new Object[]{e});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            bRet = this.commitSucceeded;
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "commit", new Boolean(bRet));
        }
        return bRet;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing WSPrinciapl, WSCredential, and CORBA Credentials from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (swamLoginModule.this.principal != null && swamLoginModule.this.subject.getPrincipals().contains(swamLoginModule.this.principal)) {
                        swamLoginModule.this.subject.getPrincipals().remove(swamLoginModule.this.principal);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.swamLoginModule.run", "917", this);
                    Tr.error(tc, "security.swam.remove.prin.ex", new Object[]{swamLoginModule.this.principal.getName(), e});
                }
                try {
                    if (swamLoginModule.this.credential != null && swamLoginModule.this.subject.getPublicCredentials().contains(swamLoginModule.this.credential)) {
                        swamLoginModule.this.subject.getPublicCredentials().remove(swamLoginModule.this.credential);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.swamLoginModule.run", "929", this);
                    Tr.error(tc, "security.swam.remove.cred.ex", new Object[]{e});
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this.principal = null;
        this.credential = null;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }
}

