/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server;

import com.ibm.ISecurityLocalObjectBaseL13Impl.DomainInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.profileregistry.ProfileRegistry;
import com.ibm.ws.management.profileregistry.ProfileRegistryFactory;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.DistributedMapFactory;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.UserRegistryConfig;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.server.SecurityServer;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.security.util.PasswordUtil;
import com.ibm.wsspi.security.token.TokenHolder;
import java.rmi.RemoteException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;

public class SecurityServerImpl
extends PortableRemoteObject
implements SecurityServer {
    private static final TraceComponent tc = Tr.register(SecurityServerImpl.class, "Security", "com.ibm.ejs.resources.security");
    private static RoleBasedAuthorizer authorizer = null;
    private static UserRegistryImpl appUserRegistryImpl = null;
    private static SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
    private boolean securityEnabled = false;
    private static final String nullString = new String();
    private static final String[] nullStringArray = new String[0];
    private static String remoteReg = null;
    private static byte[] authen_successful = new byte[]{0};
    private static byte[] authen_failure = new byte[]{-1};
    private static UserRegistry registryImpl;
    private static UserRegistry appRegistryImpl;
    private static UserRegistry registry;
    private static UserRegistry appRegistry;

    public SecurityServerImpl() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        SecurityServerImpl.initializeRegistries();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initializeRegistries() {
        block19: {
            UserRegistryConfig regCfg;
            boolean pop;
            block18: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "initializeRegistries");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "<init> getting admin registry");
                }
                pop = false;
                pop = SecurityObjectLocator.pushAdminContext();
                try {
                    try {
                        regCfg = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry();
                        registryImpl = (UserRegistry)regCfg.getUserRegistryImpl();
                        registry = (UserRegistry)regCfg.getUserRegistryStub();
                        DomainInfo.setAdminRealm(regCfg.getString("realm"));
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "<init> unexpected exception getting admin registry impl or stub", e);
                        }
                        Object var3_5 = null;
                        if (pop) {
                            SecurityObjectLocator.popContext();
                        }
                        break block18;
                    }
                    Object var3_4 = null;
                    if (!pop) break block18;
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    if (pop) {
                        SecurityObjectLocator.popContext();
                    }
                    throw throwable;
                }
                SecurityObjectLocator.popContext();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "<init> getting application registry");
            }
            pop = false;
            pop = SecurityObjectLocator.pushAppContext("");
            try {
                try {
                    regCfg = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry();
                    appRegistryImpl = (UserRegistry)regCfg.getUserRegistryImpl();
                    appRegistry = (UserRegistry)regCfg.getUserRegistryStub();
                    DomainInfo.setAppRealm(regCfg.getString("realm"));
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "<init> unexpected exception getting domain registry impl or stub", e);
                    }
                    Object var5_9 = null;
                    if (pop) {
                        SecurityObjectLocator.popContext();
                    }
                    break block19;
                }
                Object var5_8 = null;
                if (!pop) break block19;
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                if (pop) {
                    SecurityObjectLocator.popContext();
                }
                throw throwable;
            }
            SecurityObjectLocator.popContext();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeRegistries");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean simple_authenticate(BasicAuthData ba) throws WSLoginFailedException, RemoteException {
        block61: {
            String resourceName;
            block57: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "simple_authenticate", ba);
                }
                resourceName = null;
                if (ba.getRealm() == null || ba.getRealm().equals("")) {
                    ba.setRealm(DomainInfo.getAdminRealm());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "simple_authenticate setting ba realm to admin realm: " + ba.getRealm());
                    }
                } else {
                    List profileList;
                    block56: {
                        try {
                            if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                                try {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "In admin agent, looking for profile.");
                                    }
                                    final ProfileRegistry pr = ProfileRegistryFactory.getRegistry();
                                    PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                                        public Object run() throws Exception {
                                            return pr.getRemoteProfileKeys();
                                        }
                                    };
                                    profileList = (List)ContextManagerFactory.getInstance().runAsSystem(action);
                                    if (profileList != null) {
                                        break block56;
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "There are no profiles returned from the profile registry.");
                                    }
                                    break block57;
                                }
                                catch (Throwable e) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Exception getting profile registry or profile for realm.", new Object[]{e});
                                    }
                                    break block57;
                                }
                            }
                            resourceName = ba.getRealm().equalsIgnoreCase(DomainInfo.getAdminRealm()) ? "admin" : "application";
                            break block57;
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) throw new WSLoginFailedException(e.getMessage(), e);
                            Tr.debug(tc, "simple_authenticate unexpected Exception occurred.", new Object[]{e});
                            throw new WSLoginFailedException(e.getMessage(), e);
                        }
                    }
                    for (int i = 0; i < profileList.size(); ++i) {
                        Object var11_23;
                        boolean pop = false;
                        String profileName = (String)profileList.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for realm of profile UUID: " + profileName);
                        }
                        pop = AdminContext.push(profileName);
                        try {
                            try {
                                String realm = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getString("realm");
                                if (realm != null && realm.equals(ba.getRealm())) {
                                    resourceName = (String)profileList.get(i);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found first profile that owns realm name \"" + ba.getRealm() + "\".");
                                    }
                                    var11_23 = null;
                                    if (!pop) break;
                                    AdminContext.pop();
                                    break;
                                }
                                var11_23 = null;
                                if (!pop) continue;
                            }
                            catch (Exception e) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception looking for realm in simple_authenticate.", new Object[]{e});
                                }
                                var11_23 = null;
                                if (!pop) continue;
                                AdminContext.pop();
                                continue;
                            }
                            AdminContext.pop();
                            continue;
                        }
                        catch (Throwable throwable) {
                            var11_23 = null;
                            if (!pop) throw throwable;
                            AdminContext.pop();
                            throw throwable;
                        }
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pushing resourceName: " + resourceName);
            }
            boolean pop = false;
            if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                if (resourceName != null && resourceName.equals("admin")) {
                    resourceName = null;
                }
                pop = AdminContext.push(resourceName);
            } else {
                if (resourceName == null) {
                    resourceName = "admin";
                }
                pop = SecurityObjectLocator.pushContext("", resourceName);
            }
            try {
                block59: {
                    try {
                        ContextManager contextManager = ContextManagerFactory.getInstance();
                        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                        String remoteReg = security2.getProperty("WAS_UseRemoteRegistry");
                        if (remoteReg != null && (remoteReg.equalsIgnoreCase("node") || remoteReg.equalsIgnoreCase("cell"))) {
                            UserRegistry registry = (UserRegistry)security2.getActiveUserRegistry().getUserRegistryStub();
                            if (registry != null) {
                                block58: {
                                    boolean bl;
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "simple_authenticate using remote registry to authenticate.");
                                        }
                                        String rmiLoginConfig = security2.getProperty("com.ibm.CSI.rmiInboundLoginConfig");
                                        String decoded_password = PasswordUtil.passwordDecode(ba.getPassword());
                                        Subject subject = contextManager.login(ba.getRealm(), ba.getUserid(), decoded_password, rmiLoginConfig, null, null, null, null);
                                        if (subject == null) break block58;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "simple_authenticate found subject from login, returning true for simple_authenticate.");
                                        }
                                        bl = true;
                                    }
                                    catch (Exception e) {
                                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.SecurityServerImpl.simple_authenticate", "311", this);
                                        if (!tc.isDebugEnabled()) throw new WSLoginFailedException(e.getMessage(), e);
                                        Tr.debug(tc, "The following exception occurred in SecurityServerImpl: ", new Object[]{e});
                                        throw new WSLoginFailedException(e.getMessage(), e);
                                    }
                                    Object var13_30 = null;
                                    if (!pop) return bl;
                                    if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                                        AdminContext.pop();
                                        return bl;
                                    }
                                    SecurityObjectLocator.popContext();
                                    return bl;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "simple_authenticate subject is null after login, returning false for simple_authenticate.");
                                }
                                boolean bl = false;
                                Object var13_31 = null;
                                if (!pop) return bl;
                                if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                                    AdminContext.pop();
                                    return bl;
                                }
                                SecurityObjectLocator.popContext();
                                return bl;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "simple_authenticate in bootstrap mode");
                            }
                            break block59;
                        }
                        if (security2.getActiveUserRegistry().getUserRegistryImpl() != null) {
                            block60: {
                                boolean bl;
                                try {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "simple_authenticate using local registry to authenticate.");
                                    }
                                    String rmiLoginConfig = security2.getProperty("com.ibm.CSI.rmiInboundLoginConfig");
                                    String decoded_password = PasswordUtil.passwordDecode(ba.getPassword());
                                    Subject subject = contextManager.login(ba.getRealm(), ba.getUserid(), decoded_password, rmiLoginConfig, null, null, null, null);
                                    if (subject == null) break block60;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "simple_authenticate found subject from login, returning true for simple_authenticate.");
                                    }
                                    bl = true;
                                }
                                catch (Exception e) {
                                    boolean propagateExceptionToClient;
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.SecurityServerImpl.simple_authenticate", "345", this);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "The following exception occurred in SecurityServerImpl: ", new Object[]{e});
                                    }
                                    if (!(propagateExceptionToClient = security2.getPropertyBool("com.ibm.websphere.security.registry.propagateExceptionsToClient"))) throw new WSLoginFailedException("Authentication Failed.  \nNote: The propagation of native registry error information is disabled by default. You may enable it by setting the property \"com.ibm.websphere.security.registry.propagateExceptionsToClient=true\" using the server's administration console at Security -> Global Security -> Custom Properties.\n");
                                    throw new WSLoginFailedException(e.getMessage(), e);
                                }
                                Object var13_32 = null;
                                if (!pop) return bl;
                                if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                                    AdminContext.pop();
                                    return bl;
                                }
                                SecurityObjectLocator.popContext();
                                return bl;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "simple_authenticate subject is null after login, returning false for simple_authenticate.");
                            }
                            boolean bl = false;
                            Object var13_33 = null;
                            if (!pop) return bl;
                            if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                                AdminContext.pop();
                                return bl;
                            }
                            SecurityObjectLocator.popContext();
                            return bl;
                        }
                        if (!tc.isDebugEnabled()) break block59;
                        Tr.debug(tc, "simple_authenticate in bootstrap mode");
                    }
                    catch (WSLoginFailedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) throw new WSLoginFailedException("Exception in simple_authenticate: " + e.getMessage(), e);
                        Tr.debug(tc, "simple_authenticate unexpected exception", e);
                        throw new WSLoginFailedException("Exception in simple_authenticate: " + e.getMessage(), e);
                    }
                }
                Object var13_34 = null;
                if (!pop) break block61;
                if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                    AdminContext.pop();
                } else {
                    SecurityObjectLocator.popContext();
                }
            }
            catch (Throwable throwable) {
                Object var13_35 = null;
                if (!pop) throw throwable;
                if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                    AdminContext.pop();
                    throw throwable;
                }
                SecurityObjectLocator.popContext();
                throw throwable;
            }
        }
        if (!tc.isEntryEnabled()) return true;
        Tr.exit(tc, "simple_authenticate returning true");
        return true;
    }

    public byte[] token_authenticate(BasicAuthData ba) throws WSLoginFailedException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "token_authenticate", ba);
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        Subject subject = null;
        try {
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            String rmiLoginConfig = security2.getProperty("com.ibm.CSI.rmiInboundLoginConfig");
            if (ba.getRealm() == null || ba.getRealm().equals("")) {
                ba.setRealm(DomainInfo.getDefaultRealm());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "token_authenticate setting ba realm: " + ba.getRealm());
                }
            }
            String decoded_password = PasswordUtil.passwordDecode(ba.getPassword());
            subject = contextManager.login(ba.getRealm(), ba.getUserid(), decoded_password, rmiLoginConfig, null, null, null, null);
        }
        catch (NullPointerException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "token_authenticate login NullPointerException: ", e.getMessage());
            }
            throw new WSLoginFailedException(e.getMessage());
        }
        byte[] token = authen_failure;
        try {
            WSCredential credential;
            if (subject != null && (token = (credential = (WSCredential)subject.getPublicCredentials(Class.forName("com.ibm.websphere.security.cred.WSCredential")).iterator().next()).getCredentialToken()) == null) {
                token = authen_successful;
            }
        }
        catch (ClassNotFoundException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "token_authenticate login ClassNotFoundException: ", e.getMessage());
            }
            throw new WSLoginFailedException(e.getMessage());
        }
        catch (CredentialDestroyedException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "token_authenticate login CredentialDestroyedException: ", e.getMessage());
            }
            throw new WSLoginFailedException(e.getMessage());
        }
        catch (CredentialExpiredException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "token_authenticate login CredentialDestroyedException: ", e.getMessage());
            }
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "token_authenticate success");
        }
        return token;
    }

    public byte[] token_authenticate(String realm, byte[] token_in) throws WSLoginFailedException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "token_authenticate (1) ");
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        Subject subject = null;
        try {
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            String rmiLoginConfig = security2.getProperty("com.ibm.CSI.rmiInboundLoginConfig");
            subject = contextManager.login(realm, token_in, rmiLoginConfig, null, null, null, null);
        }
        catch (NullPointerException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "token_authenticate (1) login NullPointerException: ", e.getMessage());
            }
            throw new WSLoginFailedException(e.getMessage());
        }
        byte[] token = authen_failure;
        if (subject != null) {
            token = token_in;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "token_authenticate (1) success");
        }
        return token;
    }

    public TokenHolder getOpaqueToken(ByteArray ssoToken) throws WSLoginFailedException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOpaqueToken");
        }
        byte[] opaqueToken = null;
        TokenHolder th = null;
        try {
            DistributedMap dm = DistributedMapFactory.getMap("WSSecureMap");
            if (dm != null) {
                opaqueToken = (byte[])dm.get((Object)ssoToken);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.SecurityServerImpl.getOpaqueToken", "506", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueToken exception getting opaque token from distributed map.", new Object[]{e});
            }
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        if (opaqueToken == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueToken returns null.");
            }
        } else {
            th = new TokenHolder(opaqueToken, "WS_OPAQUE", 1);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueToken returns opaque token.", th);
            }
        }
        return th;
    }

    public UserRegistry getRegistry() throws RemoteException {
        return this.getRegistry(null);
    }

    public UserRegistry getRegistry(String realm) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRegistry " + realm);
        }
        if (registry == null || appRegistry == null) {
            SecurityServerImpl.initializeRegistries();
        }
        UserRegistry reg = null;
        if (realm != null && realm.length() > 0) {
            if (DomainInfo.isAppRealmDefined() && realm.equalsIgnoreCase(DomainInfo.getAppRealm())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getRegistry returning app registry");
                }
                reg = appRegistry;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getRegistry returning admin registry");
                }
                reg = registry;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getRegistry null realm, returning thread context registry");
            }
            reg = (UserRegistry)SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getUserRegistryStub();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRegistry " + reg);
        }
        return reg;
    }

    public static UserRegistry getRegistryImpl() {
        return SecurityServerImpl.getRegistryImpl(null);
    }

    public static UserRegistry getRegistryImpl(String realm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRegistryImpl " + realm);
        }
        if (registryImpl == null || appRegistryImpl == null) {
            SecurityServerImpl.initializeRegistries();
        }
        UserRegistry reg = null;
        if (realm != null && realm.length() > 0) {
            if (DomainInfo.isAppRealmDefined() && realm != null && realm.equalsIgnoreCase(DomainInfo.getAppRealm())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getRegistryImpl returning app registry impl");
                }
                reg = appRegistryImpl;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getRegistryImpl returning admin registry impl");
                }
                reg = registryImpl;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getRegistryImpl null realm, returning thread context registry impl");
            }
            reg = (UserRegistry)SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getUserRegistryImpl();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRegistryImpl " + reg);
        }
        return reg;
    }

    public static UserRegistry getAppRegistryImpl(String realm) {
        if (registry == null || appRegistry == null) {
            SecurityServerImpl.initializeRegistries();
        }
        return appUserRegistryImpl;
    }

    public List getRealms() {
        ArrayList<String> realms = new ArrayList<String>();
        String realm = null;
        try {
            realm = this.getRegistry(null).getRealm();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.SecurityServerImpl.getRealms", "643", this);
            Tr.error(tc, "security.secsrv.get.realm", new Object[]{e});
        }
        realms.add(realm);
        return realms;
    }

    protected void setConfigurator(RoleBasedConfigurator rbc) {
        if (authorizer == null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setConfigurator getting RoleBasedConfigurator");
                }
                RoleBasedConfigurator configurator = rbc;
                authorizer = rbc.getRoleBasedAuthorizer("admin-authz", "domain");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setConfigurator got RoleBasedAuthorizer");
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.server.SecurityServerImpl.setConfigurator", "668", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setConfigurator exception caught retrieving RoleBasedAuthorizer");
                }
                Tr.error(tc, "security.secsrv.get.RoleBasedAuthorizer", new Object[]{ex});
            }
            UserRegistryImpl regimpl = (UserRegistryImpl)SecurityServerImpl.getRegistryImpl(null);
            if (regimpl != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setConfigurator setting configurator for registry");
                }
                regimpl.setConfigurator(rbc);
            }
        }
    }
}

