/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.securitydomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.security.securitydomain.SecurityDomainChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;

public class SecurityDomainCheckerPlugin {
    private static TraceComponent tc = Tr.register(SecurityDomainCheckerPlugin.class, "security", "com.ibm.ws.security.securitydomain");
    private static SecurityDomainCheckerPlugin checkerPlugin = new SecurityDomainCheckerPlugin();
    private static boolean extensionsLoaded = false;
    private static String validationExtensionID = "com.ibm.wsspi.extension.security-domain-validation";
    Map extensionsMap = null;
    List extensionsList = null;

    private SecurityDomainCheckerPlugin() {
    }

    public static SecurityDomainCheckerPlugin getPlugin() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPlugin");
        }
        if (!extensionsLoaded) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "about to load SecurityDomainChecker plugin extensions");
            }
            checkerPlugin.loadCheckerExtensions();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loaded the SecurityDomainChecker plugin extensions");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPlugin");
        }
        return checkerPlugin;
    }

    public void loadCheckerExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCheckerExtensions");
        }
        this.extensionsMap = new HashMap();
        try {
            validationExtensionID = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".security-domain-validation";
            IExtensionRegistry reg = ExtensionRegistryFactory.instance().getExtensionRegistry();
            IExtensionPoint extPoint = reg.getExtensionPoint(validationExtensionID);
            if (extPoint != null) {
                IConfigurationElement[] elements = extPoint.getConfigurationElements();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found " + elements.length + " security domain checker extensions");
                }
                for (int i = 0; i < elements.length; ++i) {
                    String className = elements[i].getAttribute("class");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "class = " + elements[i].getAttribute("class"));
                    }
                    if (elements[i].getAttribute("class") != null) {
                        try {
                            SecurityDomainChecker checkerObj = (SecurityDomainChecker)elements[i].createExecutableExtension("class");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "After SecurityDomainChecker creation");
                            }
                            this.extensionsMap.put(elements[i].getAttribute("class"), checkerObj);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Added validation checker for class: " + elements[i].getAttribute("class"));
                        }
                        catch (Throwable t) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "caught exception attempting to create an extensin class for: " + elements[i].getAttribute("class") + " Exception msg: " + t.getMessage());
                        }
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No class attribute defined for this extension element");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No security domain checker extensions were found.");
            }
            this.extensionsList = new ArrayList();
            Iterator iterate = this.extensionsMap.keySet().iterator();
            while (iterate.hasNext()) {
                this.extensionsList.add(this.extensionsMap.get((String)iterate.next()));
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "exception caught during loadCheckerFilterExtensions: " + e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCheckerFilterExtensions");
        }
    }

    public List getExtensionsList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCheckerExtensions");
        }
        return this.extensionsList;
    }
}

