/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.role.DescriptorParseException;
import com.ibm.ws.security.role.Queue;
import com.ibm.ws.security.role.RoleBasedModule;
import com.ibm.ws.security.role.StandardDescriptorFieldName;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class RolePermissionDescriptorLoader
extends DefaultHandler
implements StandardDescriptorFieldName {
    private static TraceComponent tc = Tr.register(RolePermissionDescriptorLoader.class, null, "com.ibm.ejs.resources.security");
    private Queue currentElement = new Queue();
    private Locator locator = null;
    private Map roleMap = new HashMap(6);
    private HashSet roleSet = new HashSet(6);
    private Map resourceMap = new HashMap(10);
    private RoleBasedModule rbMod = null;
    private String moduleName = null;
    private boolean processingCharacters = false;
    private ArrayList method_permissions = new ArrayList(10);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RoleBasedModule loadDescriptor(String fileName, String module_name, Object self) throws DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadDescriptor", fileName);
        }
        this.moduleName = module_name != null ? module_name : fileName;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadDescriptor: process module: ", this.moduleName);
        }
        try {
            try {
                XMLReader parser2 = this.getXMLReader();
                parser2.setFeature("http://xml.org/sax/features/namespaces", true);
                parser2.setFeature("http://xml.org/sax/features/validation", true);
                parser2.setEntityResolver(this);
                parser2.setContentHandler(this);
                parser2.setErrorHandler(this);
                InputStream inStream = this.getClass().getResourceAsStream(fileName);
                if (inStream == null) {
                    ClassLoader cl = self.getClass().getClassLoader();
                    inStream = cl.getResourceAsStream(fileName);
                }
                if (inStream == null) {
                    throw new DescriptorParseException(fileName + " not found");
                }
                InputSource source = new InputSource(inStream);
                source.setSystemId(fileName);
                parser2.parse(source);
                RoleBasedModule roleBasedModule = this.rbMod;
                Object var9_12 = null;
                this.locator = null;
                this.currentElement = null;
                this.roleMap = null;
                this.roleSet = null;
                return roleBasedModule;
            }
            catch (DescriptorParseException ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.loadDescriptor", "125", this);
                throw ex;
            }
            catch (SAXException ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.loadDescriptor", "128", this);
                if (!tc.isEventEnabled()) throw new DescriptorParseException(ex.toString());
                Tr.event(tc, "Unable to parse xml descriptor file");
                throw new DescriptorParseException(ex.toString());
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.loadDescriptor", "133", this);
                String msg = "unable to parse " + fileName;
                throw new DescriptorParseException(ex.toString() + msg);
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.locator = null;
            this.currentElement = null;
            this.roleMap = null;
            this.roleSet = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RoleBasedModule loadDescriptor(InputSource source, String module_name, Object self) throws DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadDescriptor");
        }
        this.moduleName = module_name;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadDescriptor: process module: ", this.moduleName);
        }
        try {
            try {
                XMLReader parser2 = this.getXMLReader();
                parser2.setFeature("http://xml.org/sax/features/namespaces", true);
                parser2.setFeature("http://xml.org/sax/features/validation", true);
                parser2.setEntityResolver(this);
                parser2.setContentHandler(this);
                parser2.setErrorHandler(this);
                source.setSystemId(this.moduleName);
                parser2.parse(source);
                RoleBasedModule roleBasedModule = this.rbMod;
                Object var7_9 = null;
                this.locator = null;
                this.currentElement = null;
                this.roleMap = null;
                this.roleSet = null;
                return roleBasedModule;
            }
            catch (SAXException ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.loadDescriptor", "128", this);
                if (!tc.isEventEnabled()) throw new DescriptorParseException(ex.toString());
                Tr.event(tc, "Unable to parse xml descriptor file");
                throw new DescriptorParseException(ex.toString());
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.loadDescriptor", "133", this);
                String msg = "unable to parse " + this.moduleName;
                throw new DescriptorParseException(ex.toString() + msg);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.locator = null;
            this.currentElement = null;
            this.roleMap = null;
            this.roleSet = null;
            throw throwable;
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveEntity", systemId);
        }
        InputSource inputSource = null;
        try {
            if (systemId.endsWith("RolePermissionDescriptor.dtd")) {
                systemId = "xml/RolePermissionDescriptor.dtd";
                InputStream in = this.getClass().getResourceAsStream(systemId);
                inputSource = new InputSource(in);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.resolveEntity", "161", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to load dtd file", ex);
            }
            throw new SAXException("unable to load dtd", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resovleEntity", inputSource);
        }
        return inputSource;
    }

    public void error(SAXParseException exception) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "error", exception);
        }
        throw new SAXException(exception);
    }

    public void startDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startDocument");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startDocument");
        }
    }

    public void endDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "endDocument");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "endDocument");
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        this.currentElement.enqueue(localName);
        this.processingCharacters = false;
        if (localName.equals("role-permission")) {
            this.parseRolePermission(attrs);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (localName.equals("method-permission")) {
                this.processMethodPermission();
            } else if (localName.equals("security-role")) {
                this.processSecurityRole();
            } else if (localName.equals("resource")) {
                this.processResource();
            } else if (localName.equals("role-permission")) {
                this.processRolePermission();
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.endElement", "219", this);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String next_token;
        block3: {
            next_token = null;
            if (start == 0 && !this.currentElement.empty()) {
                try {
                    next_token = this.processingCharacters ? (String)this.currentElement.undo() + new String(ch, start, length) : new String(ch, start, length);
                    this.currentElement.enqueue(next_token);
                    return;
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.characters", "235", this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Unexpected exception caught");
                }
            }
        }
        next_token = new String(ch, start, length);
        this.currentElement.enqueue(next_token);
        this.processingCharacters = true;
    }

    private void parseRolePermission(Attributes attrs) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseRolePermission", attrs);
        }
        this.currentElement.dequeue();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseRolePermission");
        }
    }

    private void processMethodPermission() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processMethodPermission");
        }
        method_permission mp = new method_permission();
        method m = null;
        while (!this.currentElement.empty()) {
            String next_token = this.currentElement.dequeue().toString();
            if (next_token.equals("role-name")) {
                next_token = this.currentElement.dequeue().toString();
                mp.roles.add(next_token);
                continue;
            }
            if (next_token.equals("method")) {
                if (m != null) {
                    mp.methods.add(m);
                }
                m = new method();
                while (!this.currentElement.empty()) {
                    next_token = this.currentElement.dequeue().toString();
                    if (next_token.equals("resource-name")) {
                        next_token = this.currentElement.dequeue().toString();
                        m.resource_name = next_token;
                        continue;
                    }
                    if (next_token.equals("method-name")) {
                        next_token = this.currentElement.dequeue().toString();
                        m.method_name = next_token;
                        continue;
                    }
                    if (next_token.equals("method-params")) {
                        while (!this.currentElement.empty()) {
                            next_token = this.currentElement.dequeue().toString();
                            if (!next_token.equals("method-param")) continue;
                            next_token = this.currentElement.dequeue().toString();
                            m.params.add(next_token);
                        }
                        continue;
                    }
                    if (next_token.equals("description")) {
                        next_token = this.currentElement.dequeue().toString();
                        continue;
                    }
                    if (!next_token.equals("method")) continue;
                    if (m != null) {
                        mp.methods.add(m);
                    }
                    m = new method();
                }
                continue;
            }
            if (!next_token.equals("description")) continue;
            next_token = this.currentElement.dequeue().toString();
        }
        if (m != null) {
            mp.methods.add(m);
        }
        this.method_permissions.add(mp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processMethodPermission");
        }
    }

    private void processSecurityRole() {
        Set s2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSecurityRole");
        }
        String security_role = null;
        while (!this.currentElement.empty()) {
            String next_token = this.currentElement.dequeue().toString();
            if (next_token.equals("security-role")) {
                next_token = this.currentElement.dequeue().toString();
                next_token = this.currentElement.dequeue().toString();
                security_role = this.currentElement.dequeue().toString();
                this.roleSet.add(security_role);
                continue;
            }
            if (!next_token.equals("imply")) continue;
            while (!this.currentElement.empty()) {
                HashSet hs;
                next_token = this.currentElement.dequeue().toString();
                next_token = this.currentElement.dequeue().toString();
                if (this.roleMap.containsKey(next_token)) {
                    hs = (HashSet)this.roleMap.get(next_token);
                    hs.add(security_role);
                    this.roleMap.put(next_token, hs);
                    continue;
                }
                hs = new HashSet(6);
                hs.add(security_role);
                this.roleMap.put(next_token, hs);
            }
        }
        Set s = this.roleMap.keySet();
        for (String str : s) {
            s2 = (Set)this.roleMap.get(str);
            Iterator iter2 = s2.iterator();
            while (iter2.hasNext()) {
                Object obj = iter2.next();
                if (!this.roleMap.containsKey(obj)) continue;
                Set s3 = (Set)this.roleMap.get(obj);
                for (Object o : s3) {
                    if (s2.contains(o)) continue;
                    s2.add(o);
                    this.roleMap.put(str, s2);
                    iter2 = s2.iterator();
                }
            }
        }
        s = this.roleMap.keySet();
        for (String str : s) {
            s2 = (Set)this.roleMap.get(str);
            s2.add(str);
            this.roleMap.put(str, s2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSecurityRole");
        }
    }

    private void processResource() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processResource");
        }
        String next_token = this.currentElement.dequeue().toString();
        String resource_name = null;
        String class_name = null;
        while (!this.currentElement.empty()) {
            next_token = this.currentElement.dequeue().toString();
            if (next_token.equals("resource-name")) {
                resource_name = this.currentElement.dequeue().toString();
                continue;
            }
            if (!next_token.equals("class-name")) continue;
            class_name = this.currentElement.dequeue().toString();
        }
        this.resourceMap.put(resource_name, class_name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processResource");
        }
    }

    private void processRolePermission() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRolePermission");
        }
        this.rbMod = new RoleBasedModule(this.moduleName);
        int i = this.method_permissions.size();
        for (int j = 0; j < i; ++j) {
            method_permission mp = (method_permission)this.method_permissions.get(j);
            Iterator iter3 = mp.roles.iterator();
            HashSet<String> mp_roles = new HashSet<String>();
            while (iter3.hasNext()) {
                String roleName = (String)iter3.next();
                if (this.roleMap.containsKey(roleName)) {
                    mp_roles.addAll((HashSet)this.roleMap.get(roleName));
                    continue;
                }
                mp_roles.add(roleName);
            }
            iter3 = mp.methods.iterator();
            StringBuffer methodId = null;
            while (iter3.hasNext()) {
                method m = (method)iter3.next();
                methodId = new StringBuffer(m.resource_name + ":");
                methodId.append(m.method_name);
                int k = m.params.size();
                for (int l = 0; l < k; ++l) {
                    methodId.append(":" + (String)m.params.get(l));
                }
                if (mp_roles.size() <= 0) continue;
                this.rbMod.add(methodId.toString(), mp_roles);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processRolePermission");
        }
    }

    private XMLReader getXMLReader() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXMLReader");
        }
        XMLReader parser2 = null;
        try {
            parser2 = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getXMLReader ParserConfigurationException getting parser from SAXParserFactory.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.getXMLReader", "512", this);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getXMLReader exception getting parser from SAXParserFactory.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.getXMLReader", "517", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXMLReader");
        }
        return parser2;
    }

    class method_permission {
        private HashSet roles = new HashSet(4);
        private ArrayList methods = new ArrayList(15);

        method_permission() {
        }
    }

    class method {
        private String resource_name;
        private String method_name;
        private ArrayList params = new ArrayList();

        method() {
        }
    }
}

