/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.zOS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.zOS.SAFRegistryException;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.RegExp;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public final class SAFRegistryImpl
implements UserRegistry {
    private static final TraceComponent tc = Tr.register(SAFRegistryImpl.class, "Security", "com.ibm.ejs.resources.security");
    private static final String TOKEN_DELIMETER = "::";
    private String realm = null;
    private boolean ignoreCase = true;
    private boolean disableGroupLoad = false;
    private boolean disablePrincipalCasePreservation = false;
    private boolean forceCredCreationForValidation = false;
    private boolean useSimpleAuthentication = false;
    private boolean mixedCasePasswordsEnabled = false;
    private PlatformCredentialManager pcManager = PlatformCredentialManager.instance();

    public SAFRegistryImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void initialize(Properties props) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.mixedCasePasswordsEnabled = SAFRegistryImpl.ntv_isMixedCasePWEnabled();
        this.realm = SAFRegistryImpl.ntv_getRealm();
        String configProp = props.getProperty("com.ibm.websphere.security.zos.disableGroupAcquisition");
        this.disableGroupLoad = "true".equalsIgnoreCase(configProp);
        configProp = props.getProperty("com.ibm.websphere.security.SimpleAuthentication");
        this.useSimpleAuthentication = Boolean.valueOf(configProp);
        configProp = props.getProperty("force.credential.creation.for.validation");
        this.forceCredCreationForValidation = "true".equalsIgnoreCase(configProp);
        configProp = props.getProperty("disable.principal.case.preservation");
        this.disablePrincipalCasePreservation = "true".equalsIgnoreCase(configProp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this);
        }
    }

    public String checkPassword(String userId, String password) throws PasswordCheckFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkPassword", new Object[]{userId, password == null ? null : "****"});
        }
        String user = this.normalizeUserId(userId);
        String pwd = this.normalizePassword(password);
        String securityName = null;
        try {
            if (this.useSimpleAuthentication) {
                securityName = this.disablePrincipalCasePreservation ? SAFRegistryImpl.ntv_checkPassword(user, pwd) : ((securityName = SAFRegistryImpl.ntv_checkPassword(user, pwd)) != null ? userId : null);
            } else {
                PlatformCredential pc = this.pcManager.createPasswordCredential(user, pwd);
                String credKey = this.pcManager.getKeyFromCredential(pc);
                securityName = this.disablePrincipalCasePreservation ? credKey + TOKEN_DELIMETER + user : credKey + TOKEN_DELIMETER + userId;
            }
            if (securityName == null) {
                String msg = "Authentication failed for user: " + userId;
                throw new PasswordCheckFailedException(msg);
            }
        }
        catch (PasswordCheckFailedException ex) {
            Tr.error(tc, "security.authn.failed.foruser", new Object[]{userId});
            throw ex;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.checkPassword", "298", this);
            Tr.error(tc, "security.authn.error", new Object[]{userId, t});
            throw new CustomRegistryException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkPassword", securityName);
        }
        return securityName;
    }

    public String mapCertificate(X509Certificate[] cert) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificate", cert);
        }
        String securityName = null;
        try {
            if (this.useSimpleAuthentication) {
                byte[] encodedCert = cert[0].getEncoded();
                securityName = SAFRegistryImpl.ntv_mapCertificate(encodedCert, encodedCert.length);
            } else {
                PlatformCredential pc = this.pcManager.createCertificateCredential(cert);
                String credKey = this.pcManager.getKeyFromCredential(pc);
                securityName = credKey + TOKEN_DELIMETER + pc.getUserId();
            }
            if (securityName == null) {
                String msg = "Certificate could not be mapped to a valid SAF user ID";
                throw new CertificateMapFailedException("Certificate could not be mapped to a valid SAF user ID");
            }
        }
        catch (CertificateMapFailedException ex) {
            Tr.error(tc, "security.registry.mapcertificate.failed");
            throw ex;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.mapCertificate", "358", this);
            Tr.error(tc, "security.registry.mapcertificate.failed");
            throw new CustomRegistryException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificate", securityName);
        }
        return securityName;
    }

    public String getRealm() {
        String realm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm");
        }
        String string = realm = this.realm == null ? SAFRegistryImpl.ntv_getRealm() : this.realm;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm", realm);
        }
        return realm;
    }

    public Result getUsers(String pattern, int limit) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers", new Object[]{pattern, new Integer(limit)});
        }
        Result result = new Result();
        ArrayList users = this.getUsers(pattern);
        if (limit > 0 && users.size() > limit) {
            users = new ArrayList(users.subList(0, limit - 1));
            result.setHasMore();
        }
        result.setList(users);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers", result);
        }
        return result;
    }

    public String getUserDisplayName(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserDisplayName", securityName);
        }
        try {
            if (!this.isValidUser(securityName)) {
                String msg = "Display name not found in registry";
                throw new EntryNotFoundException("Display name not found in registry");
            }
            if (this.disablePrincipalCasePreservation) {
                securityName = this.normalizeUserId(securityName);
            }
        }
        catch (EntryNotFoundException enfe) {
            Tr.error(tc, "security.registry.userdisplayname.notfound", new Object[]{securityName});
            throw enfe;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUserDisplayName", "493", this);
            Tr.error(tc, "security.registry.userdisplayname.error", new Object[]{securityName, t});
            throw new EntryNotFoundException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserDisplayName", securityName);
        }
        return securityName;
    }

    public String getUniqueUserId(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueUserId", securityName);
        }
        try {
            if (!this.isValidUser(securityName)) {
                String msg = "User " + securityName + " not found";
                throw new EntryNotFoundException(msg);
            }
            if (this.disablePrincipalCasePreservation) {
                securityName = this.normalizeUserId(securityName);
            }
        }
        catch (EntryNotFoundException enfe) {
            FFDCFilter.processException((Throwable)enfe, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUniqueUserId", "538", this);
            Tr.error(tc, "security.registry.uniqueusrid.notfound", new Object[]{securityName});
            throw enfe;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUniqueUserId", "544", this);
            Tr.error(tc, "security.registry.uniqueusrid.error", new Object[]{securityName, t});
            throw new EntryNotFoundException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueUserId", securityName);
        }
        return securityName;
    }

    public String getUserSecurityName(String uniqueUserId) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserSecurityName", uniqueUserId);
        }
        if (!this.isValidUser(uniqueUserId)) {
            Tr.error(tc, "security.registry.usersecurityname.notfound", new Object[]{uniqueUserId});
            String msg = "User " + uniqueUserId + " not found";
            throw new EntryNotFoundException(msg);
        }
        if (this.disablePrincipalCasePreservation) {
            uniqueUserId = this.normalizeUserId(uniqueUserId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserSecurityName", uniqueUserId);
        }
        return uniqueUserId;
    }

    public boolean isValidUser(String securityName) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidUser", securityName);
        }
        boolean isValid = false;
        try {
            securityName = this.normalizeUserId(securityName);
            if (this.forceCredCreationForValidation) {
                PlatformCredential pc = this.pcManager.createCredential(securityName);
                String key = this.pcManager.getKeyFromCredential(pc);
                isValid = key != null;
            } else {
                String username = null;
                StringTokenizer st = new StringTokenizer(securityName, TOKEN_DELIMETER);
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                username = st.hasMoreTokens() ? st.nextToken() : securityName;
                isValid = SAFRegistryImpl.ntv_isValidUser(username);
            }
        }
        catch (SAFRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.isValidUser", "627", this);
            Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{securityName, ex});
            throw new CustomRegistryException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidUser", new Boolean(isValid));
        }
        return isValid;
    }

    public Result getGroups(String pattern, int limit) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", new Object[]{pattern, new Integer(limit)});
        }
        Result result = new Result();
        ArrayList groups = this.getGroups(pattern);
        if (limit > 0 && groups.size() > limit) {
            groups = new ArrayList(groups.subList(0, limit - 1));
            result.setHasMore();
        }
        result.setList(groups);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups", result);
        }
        return result;
    }

    public String getGroupDisplayName(String groupSecurityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupDisplayName", groupSecurityName);
        }
        try {
            if (!this.isValidGroup(groupSecurityName)) {
                throw new EntryNotFoundException("Group entry not found");
            }
        }
        catch (EntryNotFoundException enfe) {
            FFDCFilter.processException((Throwable)enfe, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupDisplayName", "715", this);
            Tr.error(tc, "security.registry.groupdisplayname.notfound", new Object[]{groupSecurityName});
            throw enfe;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupDisplayName", "721", this);
            Tr.error(tc, "security.registry.groupdisplayname.error", new Object[]{groupSecurityName, t});
            throw new CustomRegistryException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupDisplayName", groupSecurityName);
        }
        return groupSecurityName;
    }

    public String getUniqueGroupId(String groupSecurityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupId", groupSecurityName);
        }
        try {
            if (!this.isValidGroup(groupSecurityName)) {
                throw new EntryNotFoundException("Group entry not found");
            }
        }
        catch (EntryNotFoundException enfe) {
            FFDCFilter.processException((Throwable)enfe, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUniqueGroupId", "760", this);
            Tr.error(tc, "security.registry.uniquegrpid.notfound", new Object[]{groupSecurityName});
            throw enfe;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUniqueGroupId", "766", this);
            Tr.error(tc, "security.registry.uniquegrpid.error", new Object[]{groupSecurityName, t});
            throw new CustomRegistryException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupId", groupSecurityName);
        }
        return groupSecurityName;
    }

    public List getUniqueGroupIds(String uniqueUserId) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupIds", uniqueUserId);
        }
        List groups = this.getGroupsForUser(uniqueUserId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupIds", groups);
        }
        return groups;
    }

    public String getGroupSecurityName(String uniqueGroupId) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupSecurityName", uniqueGroupId);
        }
        if (!this.isValidGroup(uniqueGroupId)) {
            Tr.error(tc, "security.registry.groupsecurityname.notfound", new Object[]{uniqueGroupId});
            String msg = "Group " + uniqueGroupId + " not found";
            throw new EntryNotFoundException(msg);
        }
        String securityName = uniqueGroupId;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupSecurityName", securityName);
        }
        return securityName;
    }

    public boolean isValidGroup(String groupSecurityName) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidGroup", groupSecurityName);
        }
        boolean isValid = false;
        try {
            groupSecurityName = this.normalizeGroupName(groupSecurityName);
            isValid = SAFRegistryImpl.ntv_isValidGroup(groupSecurityName);
        }
        catch (SAFRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.isValidGroup", "860", this);
            Tr.error(tc, "security.registry.isvalidgroup.error", new Object[]{groupSecurityName, ex});
            throw new CustomRegistryException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidGroup", new Boolean(isValid));
        }
        return isValid;
    }

    public List getGroupsForUser(String userSecurityName) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser", userSecurityName);
        }
        List groupList = null;
        try {
            String userName = this.normalizeUserId(userSecurityName);
            groupList = SAFRegistryImpl.ntv_getGroupsForUser(userName, new ArrayList());
            List list = groupList = groupList == null ? new ArrayList() : groupList;
            if (groupList.size() == 0 && !this.isValidUser(userSecurityName)) {
                String msg = "User " + userSecurityName + " not found";
                throw new EntryNotFoundException(msg);
            }
        }
        catch (EntryNotFoundException enfe) {
            FFDCFilter.processException((Throwable)enfe, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", "908", this);
            Tr.error(tc, "security.registry.getgrpsforuser.notfound", new Object[]{userSecurityName});
            throw enfe;
        }
        catch (SAFRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", "914", this);
            Tr.error(tc, "security.registry.getgrpsforuser.notfound", new Object[]{userSecurityName});
            String msg = "User " + userSecurityName + " not found";
            throw new EntryNotFoundException(msg);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", "921", this);
            Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{userSecurityName, t});
            throw new CustomRegistryException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser", groupList);
        }
        return groupList;
    }

    public Result getUsersForGroup(String groupName, int limit) throws EntryNotFoundException, CustomRegistryException {
        ArrayList users;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsersForGroup", new Object[]{groupName, new Integer(limit)});
        }
        Result result = new Result();
        try {
            String group = this.normalizeGroupName(groupName);
            users = SAFRegistryImpl.ntv_getUsersForGroup(group, new ArrayList());
            ArrayList arrayList = users = users == null ? new ArrayList() : users;
            if (users.size() == 0 && !this.isValidGroup(groupName)) {
                String msg = "Group " + groupName + " not found";
                throw new EntryNotFoundException(msg);
            }
        }
        catch (EntryNotFoundException enfe) {
            FFDCFilter.processException((Throwable)enfe, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", "992", this);
            Tr.error(tc, "security.registry.uniquegrpid.notfound", new Object[]{groupName});
            throw enfe;
        }
        catch (SAFRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", "998", this);
            Tr.error(tc, "security.registry.getusrsforgrp.error", new Object[]{groupName, ex});
            String msg = "Group " + groupName + " not found";
            throw new EntryNotFoundException(msg);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", "1005", this);
            Tr.error(tc, "security.registry.getusrsforgrp.error", new Object[]{groupName, t});
            throw new CustomRegistryException(t);
        }
        if (limit > 0 && users.size() > limit) {
            users = new ArrayList(users.subList(0, limit - 1));
            result.setHasMore();
        }
        result.setList(users);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsersForGroup", result);
        }
        return result;
    }

    public WSCredential createCredential(String credName) throws CustomRegistryException, NotImplementedException, EntryNotFoundException {
        String[] token;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCredential", credName);
        }
        String credTokenKey = (token = credName.split(TOKEN_DELIMETER, 2)).length > 1 ? token[0] : null;
        String name = credTokenKey == null ? credName : token[1];
        final String securityName = this.disablePrincipalCasePreservation ? this.normalizeUserId(name) : name;
        WSCredential cred = null;
        try {
            List grpList;
            final String realm = this.getRealm();
            final ArrayList<String> groupList = new ArrayList<String>();
            if (!this.disableGroupLoad && (grpList = this.getUniqueGroupIds(securityName)) != null) {
                String[] groupIds = grpList.toArray(new String[grpList.size()]);
                for (int i = 0; i < groupIds.length; ++i) {
                    groupList.add(RegistryUtil.appendRealm("group", groupIds[i], realm));
                }
            }
            final String accessId = RegistryUtil.appendRealm("user", securityName, realm);
            final String primaryGroupId = groupList.size() > 0 ? (String)groupList.get(0) : RegistryUtil.nullString;
            cred = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new WSCredentialImpl(realm, securityName, securityName, primaryGroupId, accessId, null, groupList);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.registry.UserRegistryImpl.createCredential", "1070", this);
            throw new CustomRegistryException(e.getMessage(), e);
        }
        catch (EntryNotFoundException enfe) {
            throw enfe;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.registry.UserRegistryImpl.createCredential", "1079", this);
            Tr.error(tc, "security.registry.createcredential.error", new Object[]{securityName, e});
            throw new CustomRegistryException(e.getMessage(), e);
        }
        try {
            PlatformCredential pc = null;
            if (credTokenKey != null) {
                pc = this.pcManager.getCredentialFromKey(credTokenKey);
            }
            if (pc == null && !this.useSimpleAuthentication) {
                pc = this.pcManager.createCredential(securityName);
            }
            if (pc != null) {
                final PlatformCredential platformCred = pc;
                final WSCredential wsCred = cred;
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        wsCred.set("com.ibm.ws.security.zos.PlatformCredential", platformCred);
                        return null;
                    }
                });
            }
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.SAFRegistryImpl", "1112", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception setting PlatformCredential", e.getException());
            }
            throw new CustomRegistryException(e.getException().getMessage());
        }
        catch (Exception e2) {
            FFDCFilter.processException((Throwable)e2, "com.ibm.ws.security.SAFRegistryImpl", "1118", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception setting PlatformCredential", e2);
            }
            throw new CustomRegistryException(e2.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredential", cred);
        }
        return cred;
    }

    List getGroups() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups");
        }
        List groups = this.getGroups("*");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups", groups);
        }
        return groups;
    }

    List getGroups(String pattern) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", pattern);
        }
        List groups = null;
        try {
            groups = SAFRegistryImpl.ntv_getGroups(new ArrayList());
            groups = groups == null ? new ArrayList() : groups;
            groups = this.filterList(groups, pattern);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroups", "1163", this);
            Tr.error(tc, "security.registry.getgroups.error", new Object[]{"*", t});
            throw new CustomRegistryException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups", groups);
        }
        return groups;
    }

    private List getUsers(String pattern) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers", pattern);
        }
        List users = null;
        try {
            users = SAFRegistryImpl.ntv_getUsers(new ArrayList());
            users = users == null ? new ArrayList() : users;
            users = this.filterList(users, pattern);
        }
        catch (SAFRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUsers", "1190", this);
            Tr.error(tc, "security.registry.getusers.error", new Object[]{pattern, ex});
            throw new CustomRegistryException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers", users);
        }
        return users;
    }

    private List filterList(List inList, String pattern) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterArray", new Object[]{inList, pattern});
        }
        RegExp filter = new RegExp(pattern.toUpperCase());
        Iterator iter = inList.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            if (!filter.match(element)) continue;
            list.add(element);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterArray", list);
        }
        return list;
    }

    private String normalizeUserId(String safUserId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normailzeUserId", safUserId);
        }
        String string = safUserId = this.ignoreCase ? safUserId.toUpperCase().trim() : safUserId.trim();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "normalizeUserId", safUserId);
        }
        return safUserId;
    }

    private String normalizePassword(String password) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normalizePassword");
        }
        if (!this.mixedCasePasswordsEnabled) {
            password = password.toUpperCase().trim();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "normalizePassword");
        }
        return password;
    }

    private String normalizeGroupName(String group) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normalizeGroupName", group);
        }
        String string = group = this.ignoreCase ? group.toUpperCase().trim() : group.trim();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nomralizeGroupName", group);
        }
        return group;
    }

    public String toString() {
        return super.toString() + "[realm=" + this.realm + ";ignoreCase=" + this.ignoreCase + ";disableGroupLoad=" + this.disableGroupLoad + ";useSimpleAuthentication=" + this.useSimpleAuthentication + ";mixedCasePasswordsEnabled=" + this.mixedCasePasswordsEnabled + "]";
    }

    private static synchronized native List ntv_getUsers(List var0) throws SAFRegistryException;

    private static synchronized native List ntv_getGroups(List var0) throws SAFRegistryException;

    private static native List ntv_getGroupsForUser(String var0, List var1) throws SAFRegistryException;

    private static native List ntv_getUsersForGroup(String var0, List var1) throws SAFRegistryException;

    private static native boolean ntv_isValidGroup(String var0) throws SAFRegistryException;

    private static native boolean ntv_isValidUser(String var0) throws SAFRegistryException;

    private static native String ntv_checkPassword(String var0, String var1) throws SAFRegistryException;

    private static native String ntv_mapCertificate(byte[] var0, int var1) throws SAFRegistryException;

    private static native boolean ntv_isMixedCasePWEnabled();

    private static native String ntv_getRealm();
}

