/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.unix;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.registry.unix.UnixRegistryException;
import com.ibm.ws.security.util.RegExp;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class UnixRegistryImpl
implements UserRegistry {
    private static TraceComponent tc;
    private String realm;
    int maxUidSize = -1;
    int maxPWSize = -1;

    private native int ntv_basicAuthenticate(String var1, String var2) throws UnixRegistryException;

    private native String[] ntv_getUsers() throws UnixRegistryException;

    private native String[] ntv_getGroups() throws UnixRegistryException;

    private native String[] ntv_getGroupsForUser(String var1) throws UnixRegistryException;

    private native String ntv_getGroupRealName(String var1) throws UnixRegistryException;

    private native String ntv_getUserRealName(String var1) throws UnixRegistryException;

    private native String ntv_getGroupSecurityName(long var1) throws UnixRegistryException;

    private native String ntv_getUserSecurityName(long var1) throws UnixRegistryException;

    private native long ntv_getGID(String var1) throws UnixRegistryException;

    private native long ntv_getUID(String var1) throws UnixRegistryException;

    private native int ntv_isValidGroup(String var1) throws UnixRegistryException;

    private native int ntv_isValidUser(String var1) throws UnixRegistryException;

    public String checkPassword(String userId, String password) throws PasswordCheckFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate");
        }
        if (userId.length() > this.getMaxUidSize() || password.length() > this.getMaxPWSize()) {
            Tr.error(tc, "security.registry.checkpass.failed", new Object[]{userId});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword");
            }
            throw new PasswordCheckFailedException("checkPassword failed due to userid length (" + userId.length() + ") and/or password length " + password.length() + ") too large.");
        }
        try {
            if (this.ntv_basicAuthenticate(userId, password) == 0) {
                PasswordCheckFailedException ex = new PasswordCheckFailedException("Authentication failed for user: " + userId);
                Tr.error(tc, "security.authn.failed.foruser", new Object[]{userId});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "authenticate", ex);
                }
                throw ex;
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.checkPassword", "125", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "authenticate", ex);
            }
            Tr.error(tc, "security.authn.error", new Object[]{userId, ex});
            throw new CustomRegistryException(ex.getMessage(), ex);
        }
        return userId;
    }

    public String mapCertificate(X509Certificate[] cert) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificate");
        }
        CertificateMapNotSupportedException ex = new CertificateMapNotSupportedException("");
        Tr.error(tc, "security.registry.mapcertificate.notsupported");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificate", ex);
        }
        throw ex;
    }

    public String getGroupDisplayName(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupDisplayName");
        }
        String displayName = "";
        try {
            displayName = this.ntv_getGroupRealName(securityName);
        }
        catch (UnixRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.getGroupDisplayName", "214", this);
            this.logErrorCode(ex);
            Tr.error(tc, "security.registry.groupdisplayname.error", new Object[]{securityName, ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupDisplayName", ex);
            }
            this.throwException(ex, securityName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupDisplayName");
        }
        return displayName;
    }

    public String getUniqueGroupId(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupId", securityName);
        }
        long gid = 0L;
        try {
            gid = this.ntv_getGID(securityName);
        }
        catch (UnixRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.getUniqueGroupId", "243", this);
            this.logErrorCode(ex);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupPrivilegeAttributeId", ex);
            }
            Tr.error(tc, "security.registry.uniquegrpid.error", new Object[]{securityName, ex});
            this.throwException(ex, securityName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupId", String.valueOf(gid));
        }
        return String.valueOf(gid);
    }

    public Enumeration getGroups() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups");
        }
        String[] groups = null;
        try {
            groups = this.ntv_getGroups();
        }
        catch (UnixRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.getGroups", "268", this);
            this.logErrorCode(ex);
            Tr.error(tc, "security.registry.getgroups.error", new Object[]{"*", ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", ex);
            }
            throw new CustomRegistryException(ex.getMessage(), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups");
        }
        return this.arrayToEnumeration(groups);
    }

    public Result getGroups(String pattern, int limit) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", new StringBuffer(pattern).append(":").append(limit).toString());
        }
        int count = 0;
        Result result = new Result();
        if (limit < 0) {
            ArrayList noGroups = new ArrayList(0);
            result.setList(noGroups);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", new StringBuffer(pattern).append(":").append(limit).toString());
            }
            return result;
        }
        Enumeration e = this.getGroups(pattern);
        if (e == null) {
            ArrayList noGroups = new ArrayList(0);
            result.setList(noGroups);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no groups found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", new StringBuffer(pattern).append(":").append(limit).toString());
            }
            return result;
        }
        ArrayList groups = new ArrayList();
        if (limit != 0) {
            groups = new ArrayList(limit);
        }
        while (e.hasMoreElements()) {
            groups.add(e.nextElement());
            if (limit == 0 || ++count != limit) continue;
        }
        result.setList(groups);
        if (e.hasMoreElements()) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups", new StringBuffer(pattern).append(":").append(limit).toString());
        }
        return result;
    }

    public Enumeration getGroups(String pattern) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups");
        }
        String[] groups = null;
        try {
            groups = this.ntv_getGroups();
            this.filterArray(groups, pattern);
        }
        catch (UnixRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.getGroups", "312", this);
            this.logErrorCode(ex);
            Tr.error(tc, "security.registry.getgroups.error", new Object[]{pattern, ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", ex);
            }
            throw new CustomRegistryException(ex.getMessage(), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups");
        }
        return this.arrayToEnumeration(groups);
    }

    public List getGroupsForUser(String securityName) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser", securityName);
        }
        String[] groups = null;
        try {
            groups = this.ntv_getGroupsForUser(securityName);
        }
        catch (UnixRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.getGroupsForUser", "341", this);
            this.logErrorCode(ex);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupsForUser", ex);
            }
            Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{securityName, ex});
            this.throwException(ex, securityName);
        }
        if (groups.length == 1 && groups[0].trim().equals("*NONE")) {
            return new ArrayList(0);
        }
        ArrayList<String> grps = new ArrayList<String>(groups.length);
        for (int i = 0; i < groups.length; ++i) {
            grps.add(groups[i]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of groups returned = " + grps.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser");
        }
        return grps;
    }

    public List getGroupsForUser(String userName, int limit) throws EntryNotFoundException, CustomRegistryException {
        int count = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser");
        }
        String[] groups = null;
        try {
            groups = this.ntv_getGroupsForUser(userName);
        }
        catch (UnixRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.getGroupsForUser", "373", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupsForUser", ex);
            }
            Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{userName, ex});
            this.throwException(ex, userName);
        }
        if (groups == null || groups.length == 0 || groups.length == 1 && groups[0].trim().equals("*NONE")) {
            return new ArrayList(0);
        }
        ArrayList<String> grpList = new ArrayList<String>(limit);
        for (int i = 0; i < groups.length; ++i) {
            grpList.add(groups[i]);
            if (count++ >= limit) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser");
        }
        return grpList;
    }

    public Result getUsersForGroup(String groupName, int limit) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsersForGroup", groupName);
        }
        int count = 0;
        Result result = new Result();
        if (limit < 0) {
            ArrayList noUsers = new ArrayList(0);
            result.setList(noUsers);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups searched for users as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup");
            }
            return result;
        }
        ArrayList<String> users = new ArrayList<String>();
        if (limit != 0 && limit < Integer.MAX_VALUE) {
            users = new ArrayList(limit + 1);
        } else if (limit == Integer.MAX_VALUE) {
            users = new ArrayList(limit);
        }
        Enumeration eUsers = this.getUsers();
        block0: while (eUsers.hasMoreElements()) {
            String user = (String)eUsers.nextElement();
            List groups = this.getGroupsForUser(user);
            if (groups == null || groups.size() <= 0) continue;
            for (int i = 0; i < groups.size(); ++i) {
                String grpName = (String)groups.get(i);
                if (!grpName.equals(groupName)) continue;
                users.add(user);
                if (limit >= Integer.MAX_VALUE || limit == 0 || ++count != limit + 1) continue;
                result.setHasMore();
                users.remove(user);
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsersForGroup");
        }
        result.setList(users);
        return result;
    }

    public String getGroupSecurityName(String privilegeAttributeId) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupSecurityName", privilegeAttributeId);
        }
        String securityName = "";
        try {
            securityName = this.ntv_getGroupSecurityName(Long.valueOf(privilegeAttributeId));
        }
        catch (UnixRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.getGroupSecurityName", "484", this);
            this.logErrorCode(ex);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupSecurityName", ex);
            }
            this.throwException(ex, privilegeAttributeId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupSecurityName");
        }
        return securityName;
    }

    public String getUserDisplayName(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserDisplayName", securityName);
        }
        String displayName = "";
        try {
            displayName = this.ntv_getUserRealName(securityName);
        }
        catch (UnixRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.getUserDisplayName", "515", this);
            this.logErrorCode(ex);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUserDisplayName", ex);
            }
            this.throwException(ex, securityName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserDisplayName");
        }
        return displayName;
    }

    public String getUniqueUserId(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueUserId", securityName);
        }
        long uid = 0L;
        try {
            uid = this.ntv_getUID(securityName);
        }
        catch (UnixRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.getUniqueUserId", "541", this);
            this.logErrorCode(ex);
            Tr.error(tc, "security.registry.uniqueusrid.error", new Object[]{securityName, ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUniqueUserId", ex);
            }
            this.throwException(ex, securityName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueUserId");
        }
        return String.valueOf(uid);
    }

    public Enumeration getUsers() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers");
        }
        String[] users = null;
        try {
            users = this.ntv_getUsers();
        }
        catch (UnixRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.getUsers", "567", this);
            this.logErrorCode(ex);
            Tr.error(tc, "security.registry.getusers.error", new Object[]{"*", ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers", ex);
            }
            throw new CustomRegistryException(ex.getMessage(), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers");
        }
        return this.arrayToEnumeration(users);
    }

    public Result getUsers(String pattern, int limit) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers", new StringBuffer(pattern).append(":").append(limit).toString());
        }
        int count = 0;
        Result result = new Result();
        if (limit < 0) {
            ArrayList noUsers = new ArrayList(0);
            result.setList(noUsers);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No users searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers", new StringBuffer(pattern).append(":").append(limit).toString());
            }
            return result;
        }
        Enumeration e = this.getUsers(pattern);
        if (e == null) {
            ArrayList noUsers = new ArrayList(0);
            result.setList(noUsers);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No users found.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers", new StringBuffer(pattern).append(":").append(limit).toString());
            }
            return result;
        }
        ArrayList users = new ArrayList();
        if (limit != 0) {
            users = new ArrayList(limit);
        }
        while (e.hasMoreElements()) {
            users.add(e.nextElement());
            if (limit == 0 || ++count != limit) continue;
        }
        result.setList(users);
        if (e.hasMoreElements()) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers", new StringBuffer(pattern).append(":").append(limit).toString());
        }
        return result;
    }

    public Enumeration getUsers(String pattern) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers");
        }
        String[] users = null;
        try {
            users = this.ntv_getUsers();
            this.filterArray(users, pattern);
        }
        catch (UnixRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.getUsers", "610", this);
            this.logErrorCode(ex);
            Tr.error(tc, "security.registry.getusers.error", new Object[]{pattern, ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers", ex);
            }
            throw new CustomRegistryException(ex.getMessage(), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers");
        }
        return this.arrayToEnumeration(users);
    }

    public String getUserSecurityName(String privilegeAttributeId) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserSecurityName", privilegeAttributeId);
        }
        String securityName = "";
        try {
            securityName = this.ntv_getUserSecurityName(Long.valueOf(privilegeAttributeId));
        }
        catch (UnixRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.getUserSecurityName", "640", this);
            this.logErrorCode(ex);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUserSecurityName", ex);
            }
            Tr.error(tc, "security.registry.usersecurityname.error", new Object[]{privilegeAttributeId, ex});
            this.throwException(ex, privilegeAttributeId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserSecurityName");
        }
        return securityName;
    }

    public void initialize(Properties props) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        try {
            this.realm = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.initialize", "673", this);
            this.realm = "";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public boolean isValidGroup(String securityName) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidGroup");
        }
        int rc = 0;
        try {
            rc = this.ntv_isValidGroup(securityName);
        }
        catch (UnixRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.isValidGroup", "696", this);
            this.logErrorCode(ex);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidGroup", ex);
            }
            Tr.error(tc, "security.registry.isvalidgroup.error", new Object[]{securityName, ex});
            throw new CustomRegistryException(ex.getMessage(), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidGroup");
        }
        return rc == 1;
    }

    public boolean isValidUser(String securityName) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidUser");
        }
        int rc = 0;
        try {
            rc = this.ntv_isValidUser(securityName);
        }
        catch (UnixRegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.isValidUser", "722", this);
            this.logErrorCode(ex);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidUser", ex);
            }
            Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{securityName, ex});
            throw new CustomRegistryException(ex.getMessage(), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidUser");
        }
        return rc == 1;
    }

    public WSCredential createCredential(String name) throws CustomRegistryException, NotImplementedException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCredential", name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredential", name);
        }
        return null;
    }

    public String getRealm() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm", this.realm);
        }
        return this.realm;
    }

    public List getUniqueGroupIds(String uniqueUserId) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupIds", uniqueUserId);
        }
        ArrayList<String> groupIds = new ArrayList<String>();
        String name = this.getUserSecurityName(uniqueUserId);
        List grpIds = this.getGroupsForUser(name);
        if (grpIds != null && grpIds.size() > 0) {
            for (int i = 0; i < grpIds.size(); ++i) {
                groupIds.add(this.getUniqueGroupId((String)grpIds.get(i)));
            }
        } else {
            groupIds = new ArrayList(0);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupIds", String.valueOf(groupIds.size()));
        }
        return groupIds;
    }

    private Enumeration arrayToEnumeration(String[] array) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            v.addElement(array[i]);
        }
        return v.elements();
    }

    private void filterArray(String[] array, String pattern) {
        RegExp filter;
        try {
            filter = new RegExp(pattern);
        }
        catch (IllegalArgumentException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.unix.UnixRegistryImpl.filterArray", "840", this);
            for (int i = 0; i < array.length; ++i) {
                array[i] = null;
            }
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            if (filter.match(array[i])) continue;
            array[i] = null;
        }
    }

    private void throwException(UnixRegistryException ex, String name) throws CustomRegistryException, EntryNotFoundException {
        if (ex.getErrorCode() == 0) {
            throw new CustomRegistryException(ex.getMessage());
        }
        throw new EntryNotFoundException(name);
    }

    private int getMaxUidSize() {
        if (this.maxUidSize == -1) {
            String maxUidString = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.websphere.security.registry.maxUseridSize");
            this.maxUidSize = maxUidString != null ? Integer.parseInt(maxUidString) : Integer.parseInt("256");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getMaxUidSize: " + this.maxUidSize);
            }
        }
        return this.maxUidSize;
    }

    private int getMaxPWSize() {
        if (this.maxPWSize == -1) {
            String maxPWString = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.websphere.security.registry.maxPasswordSize");
            this.maxPWSize = maxPWString != null ? Integer.parseInt(maxPWString) : Integer.parseInt("256");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getMaxPWSize: " + this.maxPWSize);
            }
        }
        return this.maxPWSize;
    }

    private void logErrorCode(UnixRegistryException ure) {
        StringBuffer sb = new StringBuffer("Native error code = ");
        sb.append(ure.getErrorCode());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, sb.toString());
        }
    }

    static {
        System.loadLibrary("UnixRegistryImpl");
        tc = Tr.register(UnixRegistryImpl.class, null, "com.ibm.ejs.resources.security");
    }
}

