/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.FFDC_OMIT;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.SetLdapConfig;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.ldap.Filter;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class LdapConfig
extends Properties {
    private static final TraceComponent tc = Tr.register(LdapConfig.class, null, "com.ibm.ejs.resources.security");
    @FFDC_OMIT
    private static Properties defaults;
    public static final String LDAP_BASEDN = "ldap.basedn";
    public static final String LDAP_TYPE = "dirType";
    public static final String ROOT_DSE = "root.dse";
    public static final String SUN_LDAP_SPI = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String SSL = "ssl";
    public static final String SSL_ENABLED = "sslEnabled";
    public static final String SSL_CONFIG = "sslConfig";
    public static final String INITIAL_CTX_FACTORY = "java.naming.factory.initial";

    public LdapConfig() {
    }

    public LdapConfig(Properties overrides) {
        this.put(INITIAL_CTX_FACTORY, SUN_LDAP_SPI);
        this.put("com.ibm.websphere.security.ldap.recursiveSearch", "false");
        Boolean sslEnabled = this.getSSLEnabled();
        this.put("com.sun.jndi.ldap.connect.timeout", "60000");
        Enumeration<Object> e = overrides.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (key.equals("java.naming.security.credentials")) {
                String pwd = null;
                String passwd = (String)overrides.get(key);
                try {
                    pwd = PasswordUtil.decode(passwd);
                }
                catch (InvalidPasswordDecodingException ipde) {
                    pwd = passwd;
                }
                catch (Exception ge) {
                    pwd = passwd;
                }
                this.put(key, pwd);
                continue;
            }
            if (key.equals(LDAP_BASEDN)) {
                String LDAPBaseDN = (String)overrides.get(key);
                if (LDAPBaseDN != null && LDAPBaseDN.length() > 2) {
                    LDAPBaseDN = RegistryUtil.removeDNSpace(LDAPBaseDN, 0);
                }
                this.put(key, LDAPBaseDN);
                continue;
            }
            this.put(key, overrides.get(key));
        }
        this.configureSSL();
        String dirUrl = this.getDirectoryUrl();
        if (dirUrl != null) {
            String prefix = "://";
            int index = dirUrl.lastIndexOf(prefix);
            index += prefix.length();
            index = dirUrl.indexOf(47, index);
            String baseDn = "";
            if (index != -1) {
                baseDn = dirUrl.substring(index + 1);
                dirUrl = dirUrl.substring(0, index + 1);
            }
        }
        if (dirUrl != null && (dirUrl.endsWith(":0") || dirUrl.endsWith(":0/"))) {
            int j = dirUrl.lastIndexOf(":0");
            dirUrl = dirUrl.substring(0, j);
        }
        this.put("java.naming.provider.url", dirUrl);
        this.setAuthenticationCredentials(this.getAuthenticationCredentials());
    }

    private void configureSSL() {
        Boolean sslEnabled = this.getSSLEnabled();
        if (sslEnabled != null && sslEnabled.booleanValue()) {
            this.remove("com.sun.jndi.ldap.connect.timeout");
            String validate = this.getProperty("LDAP.validation");
            if (validate != null && validate.equalsIgnoreCase("true")) {
                SetLdapConfig tempConf = new SetLdapConfig();
                tempConf.setLdapProperties(this);
                this.put("java.naming.ldap.factory.socket", "com.ibm.ws.security.registry.ldap.ValidateLdapSSLSocketFactory");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "set ValidateLdapSSLSocketFactory for validation task");
                }
            } else {
                this.put("java.naming.ldap.factory.socket", "com.ibm.ws.security.registry.ldap.LdapSSLSocketFactory");
            }
            this.put("java.naming.security.protocol", SSL);
        }
    }

    public synchronized Object get(Object key) {
        Object val = super.get(key);
        return val == null && defaults != null ? defaults.get(key) : val;
    }

    public synchronized Object put(Object key, Object value) {
        if (value != null) {
            return super.put(key, value);
        }
        Object oldVal = this.get(key);
        this.remove(key);
        return oldVal;
    }

    public String getDirectoryUrl() {
        return this.getProperty("java.naming.provider.url");
    }

    public void setDirectoryUrl(String url) {
        if (url != null) {
            this.put("java.naming.provider.url", url);
        }
    }

    public String getBaseDn() {
        String bDN = this.getProperty(LDAP_BASEDN);
        if (bDN != null) {
            return bDN;
        }
        return "";
    }

    public String getAuthenticationPrincipal() {
        return this.getProperty("java.naming.security.principal");
    }

    public Boolean getSSLEnabled() {
        Boolean enabled = (Boolean)this.get(SSL_ENABLED);
        return enabled;
    }

    public Properties getSSLConfig() {
        Properties ssl2 = (Properties)this.get(SSL_CONFIG);
        return ssl2;
    }

    public void setAuthenticationPrincipal(String principal) {
        if (principal != null) {
            this.put("java.naming.security.principal", principal);
        } else {
            this.remove("java.naming.security.principal");
            this.setAuthenticationCredentials(null);
        }
    }

    public String getAuthenticationCredentials() {
        return this.getProperty("java.naming.security.credentials");
    }

    public void setAuthenticationCredentials(String credentials) {
        if (credentials != null) {
            this.put("java.naming.security.authentication", "simple");
            this.put("java.naming.security.credentials", credentials);
        } else {
            this.put("java.naming.security.authentication", "none");
            this.remove("java.naming.security.credentials");
        }
    }

    public String getDirectoryType() {
        return this.getProperty(LDAP_TYPE);
    }

    public void setDirectoryType(String type) {
        this.put(LDAP_TYPE, type);
    }

    public String getDirectoryFactory() {
        return this.getProperty(INITIAL_CTX_FACTORY);
    }

    public boolean isRecursiveSearchEnabled() {
        String recursive = this.getProperty("com.ibm.websphere.security.ldap.recursiveSearch");
        return recursive != null && recursive.equalsIgnoreCase("true");
    }

    public void setDirectoryFactory(String fctry) {
        this.put(INITIAL_CTX_FACTORY, fctry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirContext getRootDSE() throws NamingException {
        InitialDirContext idc = (InitialDirContext)this.get(ROOT_DSE);
        if (idc == null) {
            LdapConfig ldapConfig = this;
            synchronized (ldapConfig) {
                if (idc == null) {
                    idc = new InitialDirContext(this);
                    this.setRootDSE(idc);
                }
            }
        }
        return idc;
    }

    private synchronized void setRootDSE(DirContext newIDC) {
        DirContext oldIDC = (DirContext)(newIDC != null ? this.put(ROOT_DSE, newIDC) : this.remove(ROOT_DSE));
        if (oldIDC != null) {
            try {
                oldIDC.close();
            }
            catch (NamingException ne) {
                FFDCFilter.processException((Throwable)ne, "com.ibm.ws.security.registry.ldap.LdapConfig.setRootDSE", "251", this);
            }
        }
    }

    public void disconnect() {
        this.setRootDSE(null);
    }

    public Filter getFilter(String filterName) {
        Object obj = this.get(filterName);
        Filter f = null;
        if (obj instanceof Filter) {
            f = (Filter)obj;
        } else {
            String s = this.getProperty(filterName);
            if (s != null) {
                f = new Filter(s);
            }
            if (f != null) {
                this.put(filterName, f);
            }
        }
        return f;
    }

    public String getLogicRealm() {
        String lr = this.getProperty("com.ibm.websphere.security.ldap.logicRealm");
        if (lr != null && lr.length() > 0) {
            return lr;
        }
        return null;
    }

    public int getMaxConcurrentSearchNumberPerConnection() {
        int count;
        block5: {
            String cnt = this.getProperty("com.ibm.websphere.security.ldap.maxConcurrentSearchPerConnection");
            count = 5;
            if (cnt != null && cnt.length() > 0) {
                try {
                    count = new Integer(cnt);
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "maximum number of 6 concurrent search for a connection is set to default.");
                }
            }
        }
        if (count < 5) {
            count = 5;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "maximum number of concurrent search for a connection is set to " + count);
        }
        return count;
    }

    public int getSizeOfIdleContextPool() {
        int count;
        block6: {
            String cnt = this.getProperty("com.ibm.websphere.security.ldap.maxIdleContextPool");
            count = 30;
            if (cnt != null && cnt.length() > 0) {
                try {
                    count = new Integer(cnt);
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "Mximum 30 idle Context instances may be maintianed by default.");
                }
            }
        }
        if (count < 6) {
            count = 6;
        }
        if (count < this.getMaxConcurrentSearchNumberPerConnection()) {
            count = this.getMaxConcurrentSearchNumberPerConnection() + 1;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "maximum number of idle context instances is " + count);
        }
        return count;
    }

    public String getGroupBaseDn() {
        String gDN = this.getProperty("com.ibm.websphere.security.ldap.groupBaseDn");
        if (gDN != null && gDN.length() > 0) {
            return gDN;
        }
        return this.getBaseDn();
    }

    public boolean isIgnoreBaseDn() {
        String iDN = this.getProperty("com.ibm.websphere.security.ldap.ignoreBaseDn");
        return iDN != null && iDN.equalsIgnoreCase("true");
    }

    public boolean isRetryBind() {
        String retry = this.getProperty("com.ibm.websphere.security.ldap.retryBind");
        return retry == null || !retry.equalsIgnoreCase("false") && !retry.equalsIgnoreCase("no");
    }

    public String getGroupDnSearchFilter() {
        String filter = this.getProperty("com.ibm.websphere.security.ldap.groupDnSearchFilter");
        if (filter != null && filter.length() > 0) {
            return filter;
        }
        return null;
    }

    public String getUserDnSearchFilter() {
        String filter = this.getProperty("com.ibm.websphere.security.ldap.userDnSearchFilter");
        if (filter != null && filter.length() > 0) {
            return filter;
        }
        return null;
    }

    public boolean performIdMap() {
        String idMap = this.getProperty("com.ibm.websphere.security.registry.ldap.performIdMap");
        boolean ret = false;
        if (idMap != null && (idMap.equalsIgnoreCase("true") || idMap.equalsIgnoreCase("yes"))) {
            ret = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LDAP Property: com.ibm.websphere.security.registry.ldap.performIdMap: " + ret);
        }
        return ret;
    }

    public boolean getPreserveTaiUsername() {
        String preserveTaiUsername = this.getProperty("com.ibm.websphere.security.ldap.registry.preserveTaiUsername");
        return preserveTaiUsername != null && (preserveTaiUsername.equalsIgnoreCase("true") || preserveTaiUsername.equalsIgnoreCase("yes"));
    }
}

