/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;

public final class RegistryUtil {
    private static TraceComponent tc = Tr.register(RegistryUtil.class, "Security", "com.ibm.ejs.resources.security");
    public static final String NONE = "";
    public static final String USERTYPE = "user";
    public static final String GROUPTYPE = "group";
    public static final String ROLETYPE = "role";
    public static final String SERVERTYPE = "server";
    public static final String nullString = new String("");
    public static final String[] nullStringArray = new String[0];
    public static final byte[] nullByteArray = new byte[0];
    public static final String realmSeparator = "/";
    public static final String typeSeparator = ":";

    protected static String getRealmWithSep(String realm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealmWithSep", realm);
        }
        String realmWithSep = NONE;
        if (realm != null) {
            realmWithSep = typeSeparator + realm + realmSeparator;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmWithSep", realmWithSep);
        }
        return realmWithSep;
    }

    public static String appendRealm(String type, String name, String realm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appendRealm", new Object[]{type, name, realm});
        }
        if (name != null && name.length() > 0) {
            name = type.equals(NONE) ? realm + realmSeparator + name : type + RegistryUtil.getRealmWithSep(realm) + name;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appendRealm", name);
        }
        return name;
    }

    public static String[] appendRealm(String type, String[] names, String realm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appendRealm", new Object[]{type, names, realm});
        }
        if (names != null && names.length > 0) {
            StringBuffer sb = new StringBuffer(type);
            if (type.equals(NONE)) {
                sb.append(realm + realmSeparator);
            } else {
                sb.append(RegistryUtil.getRealmWithSep(realm));
            }
            int len = sb.length();
            for (int i = 0; i < names.length; ++i) {
                sb.setLength(len);
                names[i] = sb.append(names[i]).toString();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appendRealm", names);
        }
        return names;
    }

    public static ArrayList appendRealm(String type, List namesList, String realm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appendRealm", new Object[]{type, namesList, realm});
        }
        String[] names = namesList.toArray(new String[namesList.size()]);
        names = RegistryUtil.appendRealm(type, names, realm);
        ArrayList<String> list = new ArrayList<String>(namesList.size());
        for (int i = 0; i < names.length; ++i) {
            list.add(names[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appendRealm", list);
        }
        return list;
    }

    public static String removeDNSpace(String str, int startIndex) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.indexOf(" ") == -1 || str.indexOf("=") == -1) {
            return str;
        }
        int idx = startIndex;
        if (idx == -1) {
            idx = str.indexOf(47);
        }
        if (idx < 0 || str.length() < idx + 2) {
            return str;
        }
        boolean removeSpace = false;
        boolean quote = false;
        StringBuffer sbf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c;
            if (i > idx + 1 && str.charAt(i - 2) != '\\' && str.charAt(i - 1) == ',' && str.charAt(i) == ' ') {
                removeSpace = true;
            }
            if (i > idx + 1 && str.charAt(i - 1) == '=' && str.charAt(i) == ' ') {
                removeSpace = true;
            }
            if (i > idx + 1 && str.charAt(i - 1) != '\\' && str.charAt(i) == '\"') {
                quote = !quote;
            }
            if ((c = str.charAt(i)) == ' ' && removeSpace && !quote) continue;
            removeSpace = false;
            sbf.append(c);
        }
        int len = sbf.length();
        for (int i = len - 2; i > idx; --i) {
            if (sbf.charAt(i) != ' ' || sbf.charAt(i - 1) == '\\' || sbf.charAt(i + 1) != ',' && sbf.charAt(i + 1) != '=') continue;
            sbf.deleteCharAt(i);
        }
        return sbf.toString();
    }

    public static boolean checkValidUserifTAM(final String uid, final UserRegistry registry) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkValidUserifTAM", new Object[]{uid, registry});
        }
        Boolean isValid = Boolean.FALSE;
        try {
            isValid = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Boolean(registry.isValidUser(uid));
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception from isValidUser", e);
            }
            throw pae.getException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkValidUserifTAM", isValid);
        }
        return isValid;
    }
}

