/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.crypto.KeyPair;
import com.ibm.websphere.crypto.KeyPairGenerator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.ltpa.LTPADigSignature;
import com.ibm.ws.security.ltpa.LTPAKeyPair;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import java.security.Key;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;

public class LTPAKeyPairGenerator
implements KeyPairGenerator {
    private static final TraceComponent tc = Tr.register(LTPAKeyPairGenerator.class, null, "com.ibm.ejs.resources.security");
    private Properties customProperties = null;

    public void init(Properties customProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{customProps});
        }
        this.customProperties = customProps;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public KeyPair generateKeyPair() throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKeyPair");
        }
        try {
            LTPAKeyPair ltpaPair = LTPADigSignature.generateLTPAKeyPair();
            if (ltpaPair != null) {
                LTPAPrivateKey privKey = ltpaPair.getPrivate();
                LTPAPublicKey pubKey = ltpaPair.getPublic();
                SecretKeySpec publicKeyAsSecretKey = new SecretKeySpec(pubKey.getEncoded(), "LTPA_RSA_PUBLIC");
                SecretKeySpec privateKeyAsSecretKey = new SecretKeySpec(privKey.getEncoded(), "LTPA_RSA_PRIVATE");
                KeyPair pair = new KeyPair(publicKeyAsSecretKey, (Key)privateKeyAsSecretKey);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "generateKeyPair");
                }
                return pair;
            }
            throw new KeyException("Key pair could not be generated.");
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAKeyPairGenerator.generateKeyPair", "108", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error generating key pair.", new Object[]{e});
            }
            if (e instanceof KeyException) {
                throw (KeyException)e;
            }
            throw new KeyException(e.getMessage(), e);
        }
    }
}

