/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.security.ltpa.AuthzPropToken;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.ltpa.TokenFactory;
import java.util.Map;

public class AuthzPropTokenFactory
implements TokenFactory {
    private Long _expirationLimit = null;
    private byte[] _sharedKey = null;
    private LTPAPublicKey _publicKey = null;
    private LTPAPrivateKey _privateKey = null;

    public void initialize(Map tokenFactoryMap) {
        this._expirationLimit = (Long)tokenFactoryMap.get("com.ibm.wsspi.security.ltpa.expiration");
        this._sharedKey = (byte[])tokenFactoryMap.get("com.ibm.wsspi.security.ltpa.ltpa_shared_key");
        this._publicKey = (LTPAPublicKey)tokenFactoryMap.get("com.ibm.wsspi.security.ltpa.ltpa_public_key");
        this._privateKey = (LTPAPrivateKey)tokenFactoryMap.get("com.ibm.wsspi.security.ltpa.ltpa_private_key");
    }

    public Token validateTokenBytes(byte[] _token_data) throws InvalidTokenException, TokenExpiredException {
        return new AuthzPropToken(_token_data, this._sharedKey, this._privateKey, this._publicKey);
    }

    public Token createToken(Map tokenMap) throws TokenCreationFailedException {
        String userUniqueId = (String)tokenMap.get("com.ibm.wsspi.security.cred.uniqueId");
        if (userUniqueId == null || userUniqueId.length() == 0) {
            throw new TokenCreationFailedException("UniqueID is null.");
        }
        return new AuthzPropToken(userUniqueId, this._expirationLimit, this._sharedKey, this._privateKey, this._publicKey);
    }
}

