/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ejb;

import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.models.base.extensions.ejbext.SecurityIdentity;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CollaboratorCookie;
import com.ibm.ws.security.core.WSAccessManager;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;

public class SecurityBeanCookie
implements CollaboratorCookie {
    private static TraceComponent tc = Tr.register(SecurityBeanCookie.class, null, "com.ibm.ejs.resources.security");
    protected EJBJar ejbJar;
    protected EList roleRefList;
    protected String beanName;
    protected String appName;
    protected String moduleName;
    protected String appModuleName;
    protected String fullBeanName;
    protected boolean isAdminApp;
    protected EList runAsSettings;

    public SecurityBeanCookie(String beanName, String appName, String moduleName) {
        this.beanName = beanName;
        this.appName = appName;
        this.moduleName = moduleName;
        this.appModuleName = appName + ":" + moduleName;
        this.fullBeanName = appName + ":" + moduleName + ":" + beanName;
        this.isAdminApp = WSAccessManager.checkIfAdminApp(appName);
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getAppModName() {
        return this.appModuleName;
    }

    public String getFullBeanName() {
        return this.fullBeanName;
    }

    public boolean isAdminApp() {
        return this.isAdminApp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(" beanName=[").append(this.beanName).append("], appName=[").append(this.appName).append("], moduleName=[").append(this.moduleName).append("] ");
        return sb.toString();
    }

    public EJBJar getEjbJar() {
        return this.ejbJar;
    }

    public void setEjbJar(EJBJar ejbJar) {
        this.ejbJar = ejbJar;
    }

    public EList getRoleRefList() {
        return this.roleRefList;
    }

    public void setRoleRefList(String beanName, EJBJar ejbJar) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRoleRefList()  beanName= " + beanName);
        }
        if (ejbJar == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setRoleRefList : EJB Jar is null");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setRoleRefList");
            }
            return;
        }
        EList beanList = ejbJar.getEnterpriseBeans();
        if (beanList != null) {
            EnterpriseBean[] beans = beanList.toArray(new EnterpriseBean[0]);
            for (int i = 0; i < beans.length; ++i) {
                if (!beans[i].getName().equals(beanName)) continue;
                this.roleRefList = beans[i].getSecurityRoleRefs();
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, " role-ref to role-link list for " + beans[i].getName());
                SecurityRoleRef[] rf = this.roleRefList.toArray(new SecurityRoleRef[0]);
                for (int j = 0; j < rf.length; ++j) {
                    Tr.debug(tc, "role-ref = " + rf[j].getName() + " role-link = " + rf[j].getLink());
                }
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRoleRefList");
        }
    }

    public EList getRunAsSettings() {
        return this.runAsSettings;
    }

    public void setRunAsSettings(EnterpriseBeanExtension bean) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRunAsSettings");
        }
        if (bean != null) {
            this.runAsSettings = bean.getRunAsSettings();
        }
        if (this.runAsSettings != null) {
            int SIZE = this.runAsSettings.size();
            for (int i = 0; i < SIZE; ++i) {
                SecurityIdentity secIdentity = (SecurityIdentity)this.runAsSettings.get(i);
                EList methodElements = secIdentity.getMethodElements();
                if (methodElements == null || methodElements.size() == 0) continue;
                MethodElement[] me = methodElements.toArray(new MethodElement[0]);
                for (int j = 0; j < me.length; ++j) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "method name " + me[j].getName());
                    }
                    if (me[j].getEnterpriseBean() == null) continue;
                    String beanName = me[j].getEnterpriseBean().getName();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "bean name " + beanName);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRunAsSettings");
        }
    }
}

