/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ISecurityLocalObjectBaseL13Impl.DomainInfo;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.Group;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.SpecialSubject;
import com.ibm.ejs.models.base.bindings.applicationbnd.User;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.UserRegistryConfig;
import com.ibm.ws.security.core.AccessContext;
import com.ibm.ws.security.core.AccessException;
import com.ibm.ws.security.core.AccessManager;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.PermissionRoleMap;
import com.ibm.ws.security.core.WSPrincipal;
import com.ibm.ws.security.ejb.BeanAccessContext;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.role.PluggableAuthorizationTableProxy;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.Constants;
import com.ibm.ws.security.util.WCCMHelper;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.SecurityRole;

public abstract class WSAccessManager
implements AccessManager {
    public static final String USER = "user";
    public static final String GROUP = "group";
    public static final String ADMINAPP = "Server Administration Application";
    private static final TraceComponent tc = Tr.register(WSAccessManager.class, "Security", "com.ibm.ejs.resources.security");
    private static Hashtable authzTableMap = new Hashtable(10);
    private static Hashtable contextIDTable = new Hashtable(10);
    private static AuthorizationTable adminAppAuthTable = null;
    private String serverId = null;
    private User userSub = null;
    private Group groupSub = null;
    private static boolean filledAccessIDs = false;
    protected AdminAuthorizer adminAuthorizer = null;
    protected static List adminapps = null;

    public WSAccessManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "admin applications", adminapps);
        }
        this.serverId = this.getServerId();
        if (this.serverId == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Failed to form serverId in WSAccessManager(), most likely in bootstrap mode, and therefore not an error");
        }
        this.groupSub = WCCMHelper.createGroup(GROUP, GROUP);
        this.userSub = WCCMHelper.createUser(USER, USER);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public static void setAccessIdsFilled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAccessIdsFilled");
        }
        filledAccessIDs = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAccessIdsFilled");
        }
    }

    public static AuthorizationTable getAdminAppAuthorizationTable() {
        return adminAppAuthTable;
    }

    public static Enumeration getAuthorizationTables() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthorizationTables");
        }
        Enumeration tables = authzTableMap.elements();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthorizationTables", tables);
        }
        return tables;
    }

    public static AuthorizationTable getAuthorizationTable(String appName) {
        return (AuthorizationTable)authzTableMap.get(appName);
    }

    public static void removeAuthorizationTable(String appName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAuthorizationTable", appName);
        }
        authzTableMap.remove(appName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAuthorizationTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAuthorizationTable(String enterpriseAppName, AuthorizationTable tbl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addAuthorizationTable", new Object[]{enterpriseAppName, tbl});
        }
        Hashtable hashtable = authzTableMap;
        synchronized (hashtable) {
            int to_index = enterpriseAppName.lastIndexOf("_");
            String appName = null;
            appName = to_index != -1 ? enterpriseAppName.substring(0, to_index) : enterpriseAppName;
            if (tbl != null) {
                if (appName.equals(ADMINAPP)) {
                    adminAppAuthTable = tbl;
                }
                authzTableMap.put(enterpriseAppName, tbl);
                WSAccessManager.fillMissingAccessIds(tbl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addAuthorizationTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeContextID(String appName, String contextID) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "storeContextID", new Object[]{appName, contextID});
        }
        Hashtable hashtable = contextIDTable;
        synchronized (hashtable) {
            if (contextID != null) {
                contextIDTable.put(appName, contextID);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "storeContextID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContextID(String appName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeContextID", appName);
        }
        Hashtable hashtable = contextIDTable;
        synchronized (hashtable) {
            contextIDTable.remove(appName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeContextID");
        }
    }

    public static String getContextID(String appName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextID", appName);
        }
        String ctxId = (String)contextIDTable.get(appName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextID", ctxId);
        }
        return ctxId;
    }

    public static boolean checkIfAdminApp(String appName) {
        return adminapps != null && adminapps.contains(appName);
    }

    public abstract SecurityRole[] getRequiredRoles(AccessContext var1, String var2, String var3);

    public abstract boolean allowIfNoRequiredRoles();

    public abstract boolean isExcluded(AccessContext var1, String var2, String var3);

    public void checkAccess(AccessContext ctx, Object resource, Object action, Subject subject) throws AccessException {
        String denyReply;
        PermissionRoleMap beanPermissionRoleMap;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", new Object[]{ctx, resource, action, subject});
        }
        String resourceName = (String)resource;
        String methodName = (String)action;
        SecurityRole[] roles = null;
        if (ctx instanceof BeanAccessContext && ((BeanAccessContext)ctx).getEJBSecurityPolicy() != null && (beanPermissionRoleMap = ((BeanAccessContext)ctx).getPermissionRoleMap()) != null) {
            roles = beanPermissionRoleMap.getRequiredRoles(ctx, null, null);
        }
        if (roles == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling getRequiredRoles old path");
            }
            roles = this.getRequiredRoles(ctx, resourceName, methodName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Required Roles", roles);
        }
        if (roles == null) {
            throw new AccessException("Null required roles");
        }
        if (this.isExcluded(ctx, resourceName, methodName)) {
            denyReply = resourceName + ":" + methodName + " is excluded";
            throw new AccessException(denyReply);
        }
        if (roles == PermissionRoleMap.EMPTY_REQUIRED_ROLES) {
            denyReply = "Empty required roles list defined in Authorization Constraint";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Empty required roles list defined in Authorization Constraint for the web applicaiton in the DD");
            }
            throw new AccessException("Empty required roles list defined in Authorization Constraint");
        }
        if (roles == PermissionRoleMap.NO_REQUIRED_ROLES) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no required roles declared in the DD");
            }
            if (!this.allowIfNoRequiredRoles()) {
                throw new AccessException("No required roles defined");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAccess");
            }
            return;
        }
        if (ctx != null && WSAccessManager.checkIfAdminApp(ctx.getEnterpriseAppName())) {
            String[] requiredRoles = this.getNamesFromRoles(roles);
            if (this.getAdminAuthorizer() == null || this.adminAuthorizer.isGrantedRole(requiredRoles, subject)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess");
                }
                return;
            }
        } else {
            if (this.isEveryoneGranted(ctx, roles)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess");
                }
                return;
            }
            if (this.isGrantedAnyRole(ctx, roles, subject)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess");
                }
                return;
            }
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append(subject.toString());
        sb.append(" is not granted any of the required roles: ");
        int ROLES_SIZE = roles.length;
        for (int i = 0; i < ROLES_SIZE; ++i) {
            sb.append(roles[i].getRoleName()).append(" ");
        }
        String denyMesg = sb.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, denyMesg);
        }
        throw new AccessException(denyMesg);
    }

    public boolean isGrantedRole(AccessContext ctx, SecurityRole specifiedRole, Principal principal) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedRole", new Object[]{ctx, specifiedRole, principal});
        }
        Subject subject = principal != null ? ((WSPrincipal)principal).getSubject() : null;
        String appName = ctx != null ? ctx.getEnterpriseAppName() : null;
        boolean isAdminApp = ctx != null ? WSAccessManager.checkIfAdminApp(appName) : false;
        boolean isGranted = false;
        if (isAdminApp) {
            String[] adminRole = new String[]{specifiedRole.getRoleName()};
            isGranted = this.getAdminAuthorizer() == null ? true : this.adminAuthorizer.isGrantedRole(adminRole, subject);
        } else {
            isGranted = this.isGrantedRole(ctx, WSAccessManager.getAuthorizationTable(appName), specifiedRole, subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedRole", new Boolean(isGranted));
        }
        return isGranted;
    }

    protected boolean isGrantedRole(AccessContext ctx, AuthorizationTable tbl, SecurityRole specifiedRole, Subject rSubject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedRole", new Object[]{ctx, tbl, specifiedRole, WSAccessManager.subjectToString(rSubject)});
        }
        boolean isGranted = false;
        PluggableAuthorizationTableProxy pluggableAuthTable = PluggableAuthorizationTableProxy.getAuthorizationTableProxy();
        if (pluggableAuthTable != null) {
            isGranted = pluggableAuthTable.isGrantedRole(ctx, specifiedRole, rSubject);
        } else if (tbl != null) {
            SecurityRole[] roles = new SecurityRole[]{specifiedRole};
            if (this.isEveryoneGranted(ctx, roles)) {
                isGranted = true;
            } else if (this.isGrantedAnyRole(ctx, roles, rSubject)) {
                isGranted = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedRole", new Boolean(isGranted));
        }
        return isGranted;
    }

    public boolean isEveryoneGranted(AccessContext ctx, SecurityRole[] reqRoles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEveryoneGranted", new Object[]{ctx, reqRoles});
        }
        boolean isGranted = false;
        PluggableAuthorizationTableProxy pluggableAuthTable = PluggableAuthorizationTableProxy.getAuthorizationTableProxy();
        if (reqRoles == PermissionRoleMap.EMPTY_REQUIRED_ROLES) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Empty required roles list from web application DD");
            }
        } else if (pluggableAuthTable != null) {
            isGranted = pluggableAuthTable.isEveryoneGranted(ctx, reqRoles);
        } else {
            AuthorizationTable tbl = WSAccessManager.getAuthorizationTable(ctx.getEnterpriseAppName());
            isGranted = this.isSpecialSubjectGrantedAnyRole(tbl, reqRoles, Constants.EVERYONE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEveryoneGranted", new Boolean(isGranted));
        }
        return isGranted;
    }

    private boolean isServerId(String accessId) {
        return accessId != null && accessId.equalsIgnoreCase(this.serverId);
    }

    public boolean isGrantedAnyRole(AccessContext ctx, SecurityRole[] reqRoles, Subject rSubject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedAnyRole", new Object[]{ctx, reqRoles, WSAccessManager.subjectToString(rSubject)});
        }
        String appName = ctx != null ? ctx.getEnterpriseAppName() : null;
        boolean isAdminApp = ctx != null ? WSAccessManager.checkIfAdminApp(appName) : false;
        boolean isGranted = false;
        PluggableAuthorizationTableProxy pluggableAuthTable = PluggableAuthorizationTableProxy.getAuthorizationTableProxy();
        if (reqRoles == PermissionRoleMap.EMPTY_REQUIRED_ROLES) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Empty required roles list from web application DD");
            }
        } else if (isAdminApp) {
            String[] requiredRoles = this.getNamesFromRoles(reqRoles);
            isGranted = this.getAdminAuthorizer() == null ? true : this.adminAuthorizer.isGrantedRole(requiredRoles, rSubject);
        } else if (pluggableAuthTable != null) {
            isGranted = pluggableAuthTable.isGrantedAnyRole(ctx, reqRoles, rSubject);
        } else {
            AuthorizationTable tbl = WSAccessManager.getAuthorizationTable(appName);
            isGranted = this.isGrantedAnyRole(tbl, reqRoles, rSubject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedAnyRole", new Boolean(isGranted));
        }
        return isGranted;
    }

    private boolean isGrantedAnyRole(AuthorizationTable tbl, SecurityRole[] reqRoles, Subject rSubject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedAnyRole", new Object[]{tbl, reqRoles, WSAccessManager.subjectToString(rSubject)});
        }
        boolean isGranted = false;
        Subject subject = this.getAuthenticatedSubject(rSubject);
        if (subject != null) {
            String subjectRealm = null;
            try {
                subjectRealm = SubjectHelper.getWSCredentialFromSubject(subject).getRealmName();
            }
            catch (Exception ex) {
                subjectRealm = "unknown";
            }
            String thisRealm = null;
            UserRegistryConfig urc = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry();
            thisRealm = urc.getString("realm");
            if (!DomainInfo.isAppRealmDefined() || thisRealm == null) {
                thisRealm = DomainInfo.getAdminRealm();
            }
            if (!thisRealm.equalsIgnoreCase(subjectRealm)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking authorization for a foreign user in realm: " + subjectRealm + ": this realm is: " + thisRealm);
                }
                if (this.isSpecialSubjectGrantedAnyRole(tbl, reqRoles, Constants.ALL_AUTHENTICATED_USERS_IN_TRUSTED_REALMS)) {
                    isGranted = true;
                } else {
                    WSCredential creds = SubjectHelper.getWSCredentialFromSubject(subject);
                    if (this.isGrantedAnyRole(tbl, reqRoles, creds)) {
                        isGranted = true;
                    }
                }
            } else if (this.isSpecialSubjectGrantedAnyRole(tbl, reqRoles, Constants.ALL_AUTHENTICATED_USERS)) {
                isGranted = true;
            } else {
                WSCredential creds = SubjectHelper.getWSCredentialFromSubject(subject);
                String accessId = this.getAccessId(creds);
                if (this.isServerId(accessId) && this.isSpecialSubjectGrantedAnyRole(tbl, reqRoles, Constants.SERVER)) {
                    isGranted = true;
                } else if (this.isGrantedAnyRole(tbl, reqRoles, creds)) {
                    isGranted = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedAnyRole", new Boolean(isGranted));
        }
        return isGranted;
    }

    private boolean isSpecialSubjectGrantedAnyRole(AuthorizationTable tbl, SecurityRole[] reqRoles, SpecialSubject specialSubject) {
        List grantedRoles;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSpecialSubjectGrantedAnyRole", new Object[]{tbl, reqRoles, specialSubject});
        }
        boolean isGranted = false;
        if (tbl != null && (grantedRoles = tbl.getRolesForSubject(specialSubject)) != null) {
            for (int i = 0; i < reqRoles.length; ++i) {
                if (!grantedRoles.contains(reqRoles[i])) continue;
                isGranted = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSpecialSubjectGrantedAnyRole", new Boolean(isGranted));
        }
        return isGranted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGrantedAnyRole(AuthorizationTable tbl, SecurityRole[] reqRoles, WSCredential creds) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedAnyRole", new Object[]{tbl, reqRoles, creds});
        }
        boolean isGranted = false;
        if (tbl != null) {
            String accessId = this.getAccessId(creds);
            List grantedRoles = null;
            User user = this.userSub;
            synchronized (user) {
                this.userSub.setAccessId(accessId);
                this.userSub.setName(accessId);
                grantedRoles = tbl.getRolesForSubject(this.userSub);
            }
            if (grantedRoles != null) {
                for (int i = 0; i < grantedRoles.size(); ++i) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "user-grantedRoles for List entry: " + i + " are :" + grantedRoles.get(i));
                }
            }
            for (int i = 0; grantedRoles != null && i < reqRoles.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "reqRoles " + reqRoles[i]);
                }
                if (!grantedRoles.contains(reqRoles[i])) continue;
                isGranted = true;
                break;
            }
            if (!isGranted) {
                String[] groupIds = this.getGroupIds(creds);
                Group group = this.groupSub;
                synchronized (group) {
                    block8: for (int i = 0; groupIds != null && i < groupIds.length && !isGranted; ++i) {
                        this.groupSub.setAccessId(groupIds[i]);
                        this.groupSub.setName(groupIds[i]);
                        grantedRoles = tbl.getRolesForSubject(this.groupSub);
                        for (int j = 0; grantedRoles != null && j < reqRoles.length; ++j) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "reqRoles " + reqRoles[j]);
                            }
                            if (!grantedRoles.contains(reqRoles[j])) continue;
                            isGranted = true;
                            continue block8;
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedAnyRole", new Boolean(isGranted));
        }
        return isGranted;
    }

    private Subject getAuthenticatedSubject(Subject rSubject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthenticatedSubject", WSAccessManager.subjectToString(rSubject));
        }
        Subject subject = null;
        final WSCredential rCreds = SubjectHelper.getWSCredentialFromSubject(rSubject);
        if (rCreds == null || rCreds.isUnauthenticated()) {
            subject = null;
        } else if (rCreds.isBasicAuth()) {
            try {
                final ContextManager contextManager = ContextManagerFactory.getInstance();
                subject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws WSLoginFailedException {
                        return contextManager.login(rCreds);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                FFDCFilter.processException((Throwable)pae, "com.ibm.ws.security.core.WSAccessManager.getAuthenticatedSubject", "849", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "authentication failed:" + pae.getException());
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.WSAccessManager.getAuthenticatedSubject", "854", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "authentication failed:" + e);
                }
                subject = null;
            }
        } else {
            subject = rSubject;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthenticatedSubject", WSAccessManager.subjectToString(subject));
        }
        return subject;
    }

    private String[] getNamesFromRoles(SecurityRole[] roles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamesFromRoles", roles);
        }
        String[] names = new String[roles == null ? 0 : roles.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = roles[i].getRoleName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamesFromRoles", names);
        }
        return names;
    }

    protected static synchronized void fillAccessIds() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fillAccessIds");
        }
        Collection tables = authzTableMap.values();
        for (AuthorizationTable table : tables) {
            WSAccessManager.fillMissingAccessIds(table);
        }
        WSAccessManager.setAccessIdsFilled();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fillAccessIds");
        }
    }

    protected static void fillMissingAccessIds(AuthorizationTable table) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fillMissingAccessIds", table);
        }
        UserRegistry registry = null;
        try {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            if (contextManager == null) {
                return;
            }
            registry = contextManager.getRegistry(null);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.core.WSAccessManager.fillMissingAccessIds", "933");
            Tr.error(tc, "security.wsaccessmanage.get.reg", new Object[]{e});
        }
        UserRegistryConfig urc = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry();
        boolean ignoreCase = urc.getBoolean("ignoreCase");
        boolean isLDAPRegistry = false;
        if (urc.getType().equals("LDAP")) {
            isLDAPRegistry = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "User registry type is LDAP");
            }
        }
        for (RoleAssignment ras : table.getAuthorizations()) {
            String accessId;
            EList specialSubjectList = ras.getSpecialSubjects();
            int subjectSize = specialSubjectList.size();
            for (int w = 0; w < subjectSize; ++w) {
                SpecialSubject u = (SpecialSubject)specialSubjectList.get(w);
                String userName = u.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SpecialSubject " + userName);
                }
                if ((accessId = u.getAccessId()) != null && accessId.length() != 0) continue;
                u.setAccessId(userName);
            }
            for (User user : ras.getUsers()) {
                String accessId2 = user.getAccessId();
                if (accessId2 != null && isLDAPRegistry) {
                    accessId2 = RegistryUtil.removeDNSpace(accessId2, -1);
                }
                if (accessId2 == null || accessId2.length() == 0 || !accessId2.startsWith("user:")) {
                    try {
                        String uName = user.getName();
                        int uIndex = uName.lastIndexOf("@");
                        if (uIndex != -1) {
                            uName = uName.substring(0, uIndex);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "user name is: " + uName);
                        }
                        accessId2 = registry.getUniqueUserId(uName);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException(e, "com.ibm.ws.security.core.WSAccessManager.fillMissingAccessIds", "982");
                    }
                }
                if (accessId2 != null && ignoreCase) {
                    accessId2 = accessId2.toLowerCase();
                }
                if (accessId2 != null && accessId2.length() > 0) {
                    user.setAccessId(accessId2);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "user accessId=" + accessId2);
            }
            for (Group group : ras.getGroups()) {
                accessId = group.getAccessId();
                if (accessId != null && isLDAPRegistry) {
                    accessId = RegistryUtil.removeDNSpace(accessId, -1);
                }
                if (accessId == null || accessId.length() == 0 || !accessId.startsWith("group:")) {
                    try {
                        String gName = group.getName();
                        int gIndex = gName.lastIndexOf("@");
                        if (gIndex != -1) {
                            gName = gName.substring(0, gIndex);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "group name is: " + gName);
                        }
                        accessId = registry.getUniqueGroupId(gName);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException(e, "com.ibm.ws.security.core.WSAccessManager.fillMissingAccessIds", "1018");
                    }
                }
                if (accessId != null && ignoreCase) {
                    accessId = accessId.toLowerCase();
                }
                if (accessId != null && accessId.length() > 0) {
                    group.setAccessId(accessId);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "group accessId=" + accessId);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fillMissingAccessIds");
        }
    }

    private String getAccessId(WSCredential creds) {
        UserRegistryConfig urc;
        boolean ignoreCase;
        String accessId;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAccessId");
            }
            accessId = null;
            if (creds == null) {
                return accessId;
            }
            try {
                accessId = creds.getAccessId();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.WSAccessManager.getAccessId", "1057", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "getAccessId raised exception", e);
            }
        }
        if (accessId != null && accessId.length() > 0 && (ignoreCase = (urc = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry()).getBoolean("ignoreCase"))) {
            accessId = accessId.toLowerCase();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAccessId", accessId);
        }
        return accessId;
    }

    private String[] getGroupIds(WSCredential creds) {
        String[] groupIds;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getGroupsIds", creds);
            }
            groupIds = null;
            try {
                ArrayList list = creds.getGroupIds();
                groupIds = list.toArray(new String[list.size()]);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.WSAccessManager.getGroupIds", "1090", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "getAccessId raised exception", e);
            }
        }
        UserRegistryConfig urc = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry();
        boolean ignoreCase = urc.getBoolean("ignoreCase");
        if (ignoreCase) {
            int len = groupIds == null ? 0 : groupIds.length;
            for (int i = 0; i < len; ++i) {
                groupIds[i] = groupIds[i].toLowerCase();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsIds", groupIds);
        }
        return groupIds;
    }

    private static String subjectToString(Subject subject) {
        String rtn = null;
        final Subject finalSubject = subject;
        if (subject != null) {
            try {
                rtn = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws WSLoginFailedException {
                        return finalSubject.toString();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rtn;
    }

    private AdminAuthorizer getAdminAuthorizer() {
        if (this.adminAuthorizer == null || AdminContext.peek() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getting adminAuthorizer");
            }
            this.adminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer();
        }
        return this.adminAuthorizer;
    }

    private String getServerId() {
        String methodName;
        String serverId;
        block4: {
            serverId = null;
            methodName = "getServerId";
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, methodName);
            }
            try {
                WSCredential serverCreds = ContextManagerFactory.getInstance().getServerCredential();
                serverId = serverCreds != null ? this.getAccessId(serverCreds) : null;
            }
            catch (WSSecurityException wsEX) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "WSSecurityException caught in WSAccessManager.getServerId() when trying to form serverId");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverId is set to: " + serverId);
            Tr.exit(tc, methodName);
        }
        return serverId;
    }
}

