/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigRefreshHelper;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityAdmin;
import com.ibm.ws.ssl.core.SSLAdmin;
import com.ibm.ws.ssl.utils.CertificateExpirationMonitor;
import com.ibm.wsspi.management.agent.AdminSubsystemExtensionHandler;
import javax.management.ObjectName;

public class SecurityAdminAgentHandler
extends AdminSubsystemExtensionHandler {
    private static final TraceComponent tc = Tr.register(SecurityAdminAgentHandler.class, "Security", "com.ibm.ejs.resources.security");

    public void changeState(String state) {
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "changeState: " + state);
            }
            if ("initialize".equals(state)) {
                this.activateMBeans();
            } else {
                if ("start".equals(state)) {
                    block18: {
                        block17: {
                            try {
                                ContextManagerFactory.getInstance().initialize(null);
                            }
                            catch (Exception e) {
                                if (!tc.isDebugEnabled()) break block17;
                                Tr.debug(tc, "Exception occurred initializing ContextManager for profile during registration.", new Object[]{e});
                            }
                        }
                        try {
                            this.activateMBeans();
                        }
                        catch (Exception ae) {
                            if (!tc.isDebugEnabled()) break block18;
                            Tr.debug(tc, "Error activating SecurityAdmin and SSLAdmin MBeans on subsystem start");
                        }
                    }
                    try {
                        this.startCertificateExpirationMonitor();
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred: ", new Object[]{e});
                        }
                        break block19;
                    }
                }
                if ("stop".equals(state)) {
                    this.deactivateMBeans();
                    this.stopCertificateExpirationMonitor();
                    try {
                        SecurityConfigRefreshHelper.clearCachesOnAdminAgentSubsystemStop();
                    }
                    catch (Exception e) {
                        Tr.error(tc, "Error during release of config data");
                    }
                } else if ("destroy".equals(state)) {
                    // empty if block
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeState");
        }
    }

    private void activateMBeans() {
        block9: {
            String cause;
            ObjectName objectName;
            DefaultRuntimeCollaborator collab;
            MBeanFactory factory;
            block8: {
                String uuid = AdminContext.peek();
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "activateMBeans: " + uuid);
                }
                try {
                    SSLAdmin sslAdmin = new SSLAdmin();
                    factory = AdminServiceFactory.getMBeanFactory();
                    collab = new DefaultRuntimeCollaborator(sslAdmin, "SSLAdmin");
                    objectName = factory.activateMBean("SSLAdmin", collab, factory.getConfigId("SSLAdmin"), "com/ibm/ws/management/descriptor/xml/SSLAdmin.xml");
                }
                catch (Exception e) {
                    cause = e.getCause().toString();
                    if (cause.contains("javax.management.InstanceAlreadyExistsException")) break block8;
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdminAgentHandler.activateMBeans", "112", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error activating MBeans.", e);
                    }
                    Tr.error(tc, "ssl.init.mbeanerror.CWPKI0006E", new Object[]{"SSLAdmin", e});
                }
            }
            try {
                SecurityAdmin securityAdmin = new SecurityAdmin();
                factory = AdminServiceFactory.getMBeanFactory();
                collab = new DefaultRuntimeCollaborator(securityAdmin, "SecurityAdmin");
                objectName = factory.activateMBean("SecurityAdmin", collab, factory.getConfigId("SecurityAdmin"), "com/ibm/ws/management/descriptor/xml/SecurityAdmin.xml");
            }
            catch (Exception e) {
                cause = e.getCause().toString();
                if (cause.contains("javax.management.InstanceAlreadyExistsException")) break block9;
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdminAgentHandler.activateMBeans", "133", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error activating MBeans.", e);
                }
                Tr.error(tc, "security.init.mbeanerror", new Object[]{"SecurityAdmin", e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "activateMBeans");
        }
    }

    private void deactivateMBeans() {
        block4: {
            String uuid = AdminContext.peek();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deactivateMBeans: " + uuid);
            }
            MBeanFactory factory = null;
            try {
                factory = AdminServiceFactory.getMBeanFactory();
                factory.deactivateMBean("SecurityAdmin");
                factory.deactivateMBean("SSLAdmin");
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.core.SecurityAdminAgentHandler.deactivateMBeans", "154", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error deactivating MBeans.", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deactivateMBeans");
        }
    }

    private void startCertificateExpirationMonitor() {
        block5: {
            String uuid = AdminContext.peek();
            if (uuid == null) {
                uuid = "admin";
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "startCertificateExpirationMonitor: " + uuid);
            }
            try {
                SecurityConfigObject sc = SecurityObjectLocator.getSecurityConfig().getSCO();
                CertificateExpirationMonitor.getInstance(sc.getObject("wsCertificateExpirationMonitor"));
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdminAgentHandler.startCertificateExpirationMonitor", "178", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Error starting the certificate expiration monitor.", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startCertificateExpirationMonitor");
        }
    }

    private void stopCertificateExpirationMonitor() {
        block5: {
            String uuid = AdminContext.peek();
            if (uuid == null) {
                uuid = "admin";
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "startCertificateExpirationMonitor: " + uuid);
            }
            try {
                SecurityConfigObject sc = SecurityObjectLocator.getSecurityConfig().getSCO();
                CertificateExpirationMonitor certMonitor = CertificateExpirationMonitor.getInstance(sc.getObject("wsCertificateExpirationMonitor"));
                certMonitor.getScheduler().cancelAlarm("CertExpMonitor_" + uuid);
                CertificateExpirationMonitor.releaseInstance();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdminAgentHandler.stopCertificateExpirationMonitor", "204", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Error stopping the certificate expiration monitor.", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopCertificateExpirationMonitor");
        }
    }
}

