/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.core.AccessContext;
import com.ibm.ws.security.core.AccessPermission;
import com.ibm.ws.security.util.LRUCache;
import org.eclipse.jst.j2ee.common.SecurityRole;

public abstract class PermissionRoleMap {
    LRUCache prMap;
    int cacheSize = 600;
    public static final String pr_HASH_SIZE = "com.ibm.websphere.security.core.prhashsize";
    private static final TraceComponent tc = Tr.register(PermissionRoleMap.class, null, null);
    public static final SecurityRole[] NO_REQUIRED_ROLES = new SecurityRole[0];
    public static final SecurityRole[] EMPTY_REQUIRED_ROLES = new SecurityRole[0];

    protected PermissionRoleMap() {
        int i;
        String hashSize = System.getProperty(pr_HASH_SIZE);
        if (hashSize != null && (i = new Integer(hashSize).intValue()) > 0) {
            this.cacheSize = i;
        }
        this.prMap = new LRUCache(this.cacheSize);
    }

    public SecurityRole[] getRequiredRoles(AccessContext ctx, AccessPermission accessPerm) {
        SecurityRole[] requiredRoles = null;
        LRUCache appCache = (LRUCache)this.prMap.get(ctx.getEnterpriseAppName());
        if (appCache == null) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "No app permission cache found for " + ctx.getEnterpriseAppName());
            }
            appCache = new LRUCache(this.cacheSize);
            this.prMap.put(ctx.getEnterpriseAppName(), appCache);
        } else {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "App permission cache found for " + ctx.getEnterpriseAppName());
            }
            requiredRoles = (SecurityRole[])appCache.get(accessPerm);
        }
        if (requiredRoles == null) {
            SecurityRole[] reqRoles;
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "No permissions found for " + accessPerm.getResourceName() + ":" + accessPerm.getMethodName());
            }
            if ((reqRoles = this.getRequiredRoles(ctx, accessPerm.getResourceName(), accessPerm.getMethodName())) == null) {
                appCache.put(accessPerm, NO_REQUIRED_ROLES);
                reqRoles = NO_REQUIRED_ROLES;
            } else {
                appCache.put(accessPerm, reqRoles);
            }
            requiredRoles = reqRoles;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer st = new StringBuffer(ctx.getEnterpriseAppName());
            st.append(", ");
            st.append(accessPerm.getResourceName());
            st.append(":");
            st.append(accessPerm.getMethodName());
            st.append(" required roles are ");
            if (requiredRoles == NO_REQUIRED_ROLES) {
                st.append("none");
            } else {
                for (int n = 0; n < requiredRoles.length; ++n) {
                    st.append(requiredRoles[n]);
                    if (n >= requiredRoles.length - 1) continue;
                    st.append(", ");
                }
            }
            Tr.debug(tc, st.toString());
        }
        return requiredRoles;
    }

    protected abstract SecurityRole[] getRequiredRoles(AccessContext var1, String var2, String var3);
}

