/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIAccessException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CollaboratorCookie;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.EJBConfigData;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.SecurityConfigResource;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.SecurityCollaborator;
import com.ibm.ws.security.core.SecurityCookieImpl;
import com.ibm.ws.security.delegation.DelegationFactory;
import com.ibm.ws.security.ejb.SecurityBeanCookie;
import com.ibm.ws.security.stat.impl.SecurityAuthorizationModuleImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.ServerIdentityHelper;
import com.ibm.ws.security.zOS.threadid.ThreadIdentityManager;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.sm.smf.SmfContainerInfo;
import com.ibm.ws390.sm.smf.SmfJActivity;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import javax.security.auth.Subject;

public class EJSSecurityCollaborator
extends SecurityCollaborator {
    private static final TraceComponent tc = Tr.register(EJSSecurityCollaborator.class, "Security", "com.ibm.ejs.resources.security");
    private static HashSet<String> UNPROTECTED = new HashSet();
    private final ThreadIdentityManager threadIdManager;
    private final boolean isZOS;
    private static EJSSecurityCollaborator securityCollaboratorInstance;
    private SecurityAuthorizationModuleImpl authModule;

    public static EJSSecurityCollaborator getInstance() {
        return securityCollaboratorInstance;
    }

    public EJSSecurityCollaborator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.initializeUnprotected();
        this.isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
        this.threadIdManager = this.isZOS ? ThreadIdentityManager.getThreadIdentityManager() : null;
        securityCollaboratorInstance = this;
        if (StatsFactory.isPMIEnabled()) {
            this.authModule = SecurityAuthorizationModuleImpl.getInstance("Security Authorization");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public CollaboratorCookie preInvoke(EJBKey ejbKey, EJBMethodInfo methodInfo, CollaboratorCookie beanCookie) throws CSIException {
        throw new CSIException("old preInvoke called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollaboratorCookie preInvoke(EJBKey ejbKey, EJBMethodInfo methodInfo, CollaboratorCookie beanCookie, Object bean, Object[] methodParameters) throws CSIException {
        Subject invokeSubject;
        Subject[] savSubjects;
        boolean pushedResource;
        long endTime;
        long startTime;
        block45: {
            block44: {
                boolean isAdminApp;
                block43: {
                    CollaboratorCookie collaboratorCookie;
                    startTime = 0L;
                    endTime = 0L;
                    pushedResource = false;
                    try {
                        if (StatsFactory.isPMIEnabled()) {
                            startTime = System.currentTimeMillis();
                        }
                        if (securityEnabled) break block43;
                        collaboratorCookie = null;
                        Object var32_11 = null;
                    }
                    catch (Throwable throwable) {
                        block46: {
                            Object var32_14 = null;
                            if (!StatsFactory.isPMIEnabled()) break block46;
                            endTime = System.currentTimeMillis();
                            this.authModule.onEJBAuthTime(endTime - startTime);
                        }
                        throw throwable;
                    }
                    if (StatsFactory.isPMIEnabled()) {
                        endTime = System.currentTimeMillis();
                        this.authModule.onEJBAuthTime(endTime - startTime);
                    }
                    return collaboratorCookie;
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "preInvoke", new Object[]{ejbKey, methodInfo, beanCookie, bean, methodParameters});
                }
                if (!(isAdminApp = ((SecurityBeanCookie)beanCookie).isAdminApp())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "preInvoke pushing app name " + ((SecurityBeanCookie)beanCookie).getAppName());
                    }
                    pushedResource = SecurityObjectLocator.pushAppContext("Application");
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "preInvoke pushing Admin");
                    }
                    pushedResource = SecurityObjectLocator.pushAdminContext();
                }
                boolean isAppSecurityOn = WSSecurityHelper.isServerSecurityEnabled();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "preInvoke", "app_name=" + ((SecurityBeanCookie)beanCookie).getAppName() + " isAdminApp=" + isAdminApp + " isAppSecurityOn=" + isAppSecurityOn);
                }
                if (isAppSecurityOn || isAdminApp) break block44;
                if (pushedResource) {
                    SecurityObjectLocator.popContext();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "preInvoke", "Skip authorization for non-system apps when app security is disabled.");
                }
                CollaboratorCookie collaboratorCookie = null;
                Object var32_12 = null;
                if (StatsFactory.isPMIEnabled()) {
                    endTime = System.currentTimeMillis();
                    this.authModule.onEJBAuthTime(endTime - startTime);
                }
                return collaboratorCookie;
            }
            Subject receivedSubject = null;
            Subject invokedSubject = null;
            Subject ownSubject = null;
            try {
                receivedSubject = contextManager.getCallerSubject();
                invokedSubject = contextManager.getInvocationSubject();
                ownSubject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws WSSecurityException {
                        return SecurityCollaborator.contextManager.getServerSubject();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.EJSSecurityCollaborator.preInvoke", "224", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error getting subjects", e);
                }
                throw new CSIAccessException(e.getMessage(), (Throwable)e);
            }
            catch (WSSecurityException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.EJSSecurityCollaborator.preInvoke", "229", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error getting subjects", e);
                }
                throw new CSIAccessException(e.getMessage(), (Throwable)e);
            }
            savSubjects = new Subject[3];
            savSubjects[0] = receivedSubject != null ? receivedSubject : null;
            savSubjects[1] = invokedSubject;
            this.SetUnauthenticatedSubjectIfNeeded(invokedSubject, receivedSubject);
            String methodName = methodInfo.getMethodSignature() + ":" + methodInfo.getInterfaceType().getValue();
            Subject retSubject = this.performAuthorization(ejbKey, methodInfo, ownSubject, receivedSubject, invokedSubject, (SecurityBeanCookie)beanCookie, bean, methodParameters, methodName);
            if (retSubject != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "performAuthorization returned non null retSubjects");
                }
                receivedSubject = retSubject;
            }
            invokeSubject = receivedSubject;
            final EJBKey ejb_key = ejbKey;
            final EJBMethodInfo method_info = methodInfo;
            final CollaboratorCookie bean_cookie = beanCookie;
            final Subject own_subject = ownSubject;
            final Subject received_subject = receivedSubject;
            final String method_name = methodName;
            if (!this.isUnprotected(((SecurityBeanCookie)beanCookie).getBeanName())) {
                try {
                    invokeSubject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws CSIException {
                            return DelegationFactory.getDelegation().delegate(ejb_key, method_info, own_subject, received_subject, (SecurityBeanCookie)bean_cookie, method_name);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    CSIException e = (CSIException)((Object)pae.getException());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error getting delegatedSubject");
                    }
                    if (e instanceof CSIAccessException) {
                        throw (CSIAccessException)e;
                    }
                    throw new CSIAccessException(e.getMessage());
                }
            }
            this.setSubjects(receivedSubject, invokeSubject);
            if (this.isZOS && SmfContainerInfo.isSmf120St9Enabled()) {
                try {
                    String receivedUser = SubjectHelper.getWSCredentialFromSubject(receivedSubject).getSecurityName();
                    String invokeUser = SubjectHelper.getWSCredentialFromSubject(invokeSubject).getSecurityName();
                    String ownUser = SubjectHelper.getWSCredentialFromSubject(ownSubject).getSecurityName();
                    SmfJActivity.setSmfSecurityIdentities(ownUser, receivedUser, invokeUser);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "preInvoke", "Called SmfJActivity.setSmfSecurityIdentities(" + ownUser + "," + receivedUser + "," + invokeUser + ")");
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block45;
                    Tr.debug(tc, "preInvoke", "Call to SmfJActivity.setSmfSecurityIdentities did not occur due to the following exception " + e);
                }
            }
        }
        boolean appSync = false;
        boolean oldSync = false;
        if (this.isZOS) {
            EJBComponentMetaData md2 = methodInfo.getEJBComponentMetaData();
            appSync = md2.isApplicationSyncToOSThreadEnabled();
            oldSync = this.threadIdManager.isThreadLocalApplicationSyncEnabled();
        }
        Object syncToThreadToken = null;
        if (appSync) {
            try {
                final Subject privInvokeSubject = invokeSubject;
                syncToThreadToken = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return EJSSecurityCollaborator.this.threadIdManager.setLocalOSThreadID(privInvokeSubject);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Thread identity synchronization error", e);
                }
                throw new CSIException(e.getMessage(), (Throwable)e);
            }
        }
        if (oldSync) {
            try {
                ServerIdentityHelper helper = ServerIdentityHelper.getServerIdentityHelper();
                syncToThreadToken = helper.push();
            }
            catch (Exception e) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Thread identity synchronization error", e);
                }
                throw new CSIException(e.getMessage(), (Throwable)e);
            }
        }
        if (this.isZOS) {
            this.threadIdManager.setThreadLocalApplicationSyncEnabled(appSync);
        }
        CollaboratorCookie cookie = (CollaboratorCookie)EJSSecurityCollaborator.getCookie(savSubjects, syncToThreadToken, oldSync, pushedResource);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preInvoke", cookie);
        }
        CollaboratorCookie collaboratorCookie = cookie;
        Object var32_13 = null;
        if (StatsFactory.isPMIEnabled()) {
            endTime = System.currentTimeMillis();
            this.authModule.onEJBAuthTime(endTime - startTime);
        }
        return collaboratorCookie;
    }

    public void ejbMethodParameterChange(EJBKey ejbKey, EJBMethodInfo methodInfo, CollaboratorCookie beanCookie, Object bean, Object[] methodParameters) throws CSIException {
    }

    private final void initializeUnprotected() {
        UNPROTECTED.add("RemoteSRP");
        UNPROTECTED.add("RemoteSRPHome");
        UNPROTECTED.add("SrdSrvltCtxHome");
        UNPROTECTED.add("SessionBMP");
        UNPROTECTED.add("UPManager");
        UNPROTECTED.add("UP_ReadOnly");
        UNPROTECTED.add("UP_ReadWrite");
    }

    protected boolean isUnprotected(String beanName) {
        return UNPROTECTED.contains(beanName);
    }

    public void postInvoke(EJBKey ejbKey, EJBMethodInfo methodInfo, CollaboratorCookie securityCookie, CollaboratorCookie beanCookie) throws CSIException {
        SecurityCookieImpl cookieImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postInvoke", new Object[]{ejbKey, methodInfo, securityCookie, beanCookie});
        }
        if ((cookieImpl = (SecurityCookieImpl)securityCookie) != null) {
            super.postInvokeCommon(ejbKey, methodInfo, cookieImpl, beanCookie);
            if (cookieImpl.pushedResource) {
                SecurityConfigResource res = SecurityObjectLocator.popContext();
                if (tc.isDebugEnabled()) {
                    if (res != null) {
                        Tr.debug(tc, "postInvoke popped resource " + res.getName() + " of type " + res.getType());
                    } else {
                        Tr.debug(tc, "postInvoke popped null");
                    }
                }
            }
            if (this.isZOS) {
                Object syncToThreadToken = cookieImpl.syncToThreadToken;
                if (syncToThreadToken != null) {
                    try {
                        final Object privsyncToThreadToken = syncToThreadToken;
                        syncToThreadToken = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                EJSSecurityCollaborator.this.threadIdManager.restoreLocalOSThreadID(privsyncToThreadToken);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Unable to restore thread identity", e);
                        }
                        throw new CSIException(e.getMessage(), (Throwable)e);
                    }
                }
                this.threadIdManager.setThreadLocalApplicationSyncEnabled(cookieImpl.appSyncToOSThread);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke");
        }
    }

    public CollaboratorCookie beanInstalled(EJBConfigData beanConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beanInstalled", beanConfig);
        }
        CollaboratorCookie cookie = this.installBean(beanConfig);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beanInstalled", cookie);
        }
        return cookie;
    }

    public void beanUninstalled(CollaboratorCookie beanCookie) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beanUninstalled", beanCookie);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beanUninstalled");
        }
    }
}

