/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.SASPropFile;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class CSIClientProperties {
    private static final TraceComponent tc = Tr.register(CSIClientProperties.class);
    private static final String CONFIG_URL_PROPERTY_NAME = "com.ibm.CORBA.ConfigURL";
    private static final String[] CLIENT_AUTHN_TYPE_KEYS = new String[]{"com.ibm.CSI.performClientAuthenticationtype", "com.ibm.CSI.performClientAuthenticationType", "com.ibm.CORBA.authenticationTarget"};
    private static final String[] LOGIN_USERID_KEYS = new String[]{"com.ibm.CSI.Rem.Userid", "com.ibm.CORBA.loginUserid"};
    private static final String[] LOGIN_PASSWORD_KEYS = new String[]{"com.ibm.CSI.Rem.Password", "com.ibm.CORBA.loginPassword"};
    private static final String[] SSL_KEYRING_KEYS = new String[]{"com.ibm.CSI.performSSL.Keyring"};
    private static final int TRANSPORT_AUTHN_REQUIRED_MASK = 1;
    private static final int TRANSPORT_AUTHN_SUPPORTED_MASK = 2;
    private static final int SSL_REQUIRED_MASK = 4;
    private static final int SSL_SUPPORTED_MASK = 8;
    private static final int CLIENT_AUTHN_REQUIRED_MASK = 16;
    private static final int CLIENT_AUTHN_SUPPORTED_MASK = 32;
    private static final int CONFIDENTIALITY_REQUIRED_MASK = 64;
    private static final int CONFIDENTIALITY_SUPPORTED_MASK = 128;

    private CSIClientProperties() {
    }

    public static String[] getCSIProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCSIProperties");
        }
        Properties props = CSIClientProperties.getCSIClientProps();
        int performPolicyMask = 0;
        boolean policyMaskIndex = false;
        boolean clientAuthTypeIndex = true;
        int keyringNameIndex = 2;
        int useridIndex = 3;
        int passwordIndex = 4;
        String[] theProps = new String[5];
        String sslRequired = CSIClientProperties.getProperty("com.ibm.CSI.performTransportAssocSSLTLSRequired", props, "false");
        String sslSupported = CSIClientProperties.getProperty("com.ibm.CSI.performTransportAssocSSLTLSSupported", props, "true");
        if (Boolean.valueOf(sslRequired) == Boolean.TRUE) {
            performPolicyMask |= 0xC;
        }
        if (Boolean.valueOf(sslSupported) == Boolean.TRUE) {
            performPolicyMask |= 8;
        }
        String transportAuthnRequired = CSIClientProperties.getProperty("com.ibm.CSI.performTLClientAuthenticationRequired", props, "false");
        String transportAuthnSupported = CSIClientProperties.getProperty("com.ibm.CSI.performTLClientAuthenticationSupported", props, "true");
        if (Boolean.valueOf(transportAuthnRequired) == Boolean.TRUE) {
            performPolicyMask |= 3;
        }
        if (Boolean.valueOf(transportAuthnSupported) == Boolean.TRUE) {
            performPolicyMask |= 2;
        }
        String confRequired = CSIClientProperties.getProperty("com.ibm.CSI.performMessageConfidentialityRequired", props, "true");
        String confSupported = CSIClientProperties.getProperty("com.ibm.CSI.performMessageConfidentialitySupported", props, "true");
        if (Boolean.valueOf(confRequired) == Boolean.TRUE) {
            performPolicyMask |= 0xC0;
        }
        if (Boolean.valueOf(confSupported) == Boolean.TRUE) {
            performPolicyMask |= 0x80;
        }
        String clientAuthnRequired = CSIClientProperties.getProperty("com.ibm.CSI.performClientAuthenticationRequired", props, "false");
        String clientAuthnSupported = CSIClientProperties.getProperty("com.ibm.CSI.performClientAuthenticationSupported", props, "true");
        if (Boolean.valueOf(clientAuthnRequired) == Boolean.TRUE) {
            performPolicyMask |= 0x30;
        }
        if (Boolean.valueOf(clientAuthnSupported) == Boolean.TRUE) {
            performPolicyMask |= 0x20;
        }
        theProps[0] = Integer.toString(performPolicyMask);
        theProps[1] = CSIClientProperties.getProperty(CLIENT_AUTHN_TYPE_KEYS, props, "BasicAuth");
        theProps[3] = CSIClientProperties.getLoginUserID();
        theProps[4] = CSIClientProperties.getLoginPassword();
        theProps[2] = CSIClientProperties.getProperty(SSL_KEYRING_KEYS, props, "");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCSIProperties", new Object[]{theProps[0], theProps[1], theProps[2], theProps[3], theProps[4] != null ? "xxxxx" : null});
        }
        return theProps;
    }

    public static Properties getCSIClientProps() {
        Properties clientProps;
        block10: {
            block9: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getCSIClientProps");
                }
                String configLocator = System.getProperty(CONFIG_URL_PROPERTY_NAME);
                clientProps = new Properties();
                if (configLocator != null) {
                    try {
                        InputStream is = new URL(configLocator).openStream();
                        clientProps.load(is);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "read properties", clientProps);
                        }
                    }
                    catch (IOException ioe) {
                        if (!tc.isEventEnabled()) break block9;
                        Tr.event(tc, "Unable to load properties", ioe);
                    }
                }
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "decoding property file passwords");
                }
                SASPropFile.decodePropPasswords(clientProps);
            }
            catch (InvalidPasswordDecodingException ipde) {
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "Unable to decode passwords", (Object)ipde);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCSIClientProps", clientProps);
        }
        return clientProps;
    }

    public static String getLoginUserID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLoginUserID");
        }
        Properties props = CSIClientProperties.getCSIClientProps();
        String userID = CSIClientProperties.getProperty(LOGIN_USERID_KEYS, props, "");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLoginUserID", userID == null ? null : userID);
        }
        return userID;
    }

    public static String getLoginPassword() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLoginPassword");
        }
        Properties props = CSIClientProperties.getCSIClientProps();
        String pw = CSIClientProperties.getProperty(LOGIN_PASSWORD_KEYS, props, "");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLoginPassword", pw == null ? null : "****");
        }
        return pw;
    }

    private static String getProperty(String[] names, Properties props, String defaultValue) {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty", new Object[]{names, props, defaultValue});
        }
        String value = null;
        for (i = 0; i < names.length && value == null; ++i) {
            value = System.getProperty(names[i]);
        }
        for (i = 0; i < names.length && value == null; ++i) {
            value = props.getProperty(names[i]);
        }
        if (value == null || value.equals("")) {
            value = defaultValue;
        }
        if (tc.isEntryEnabled()) {
            boolean isPw = false;
            if (names != null && names.length > 0 && names[0] != null) {
                if (names[0].indexOf("word") != -1) {
                    isPw = true;
                } else if (names[0].indexOf("Pass") != -1) {
                    isPw = true;
                } else if (names[0].indexOf("pass") != -1) {
                    isPw = true;
                } else if (names[0].indexOf("pw") != -1) {
                    isPw = true;
                } else if (names[0].indexOf("PW") != -1) {
                    isPw = true;
                }
            }
            Tr.exit(tc, "getProperty", !isPw ? value : "****");
        }
        return value;
    }

    private static String getProperty(String name, Properties props, String defaultValue) {
        return CSIClientProperties.getProperty(new String[]{name}, props, defaultValue);
    }
}

